// ۼ : ̻  (Hitel: ָڰ  nownuri: azrael99)
//
//   ȿ(SMgal) Ƽ̵ Ÿ̸  
// VCLȭ ״.

//   1.01̴...
unit MMTimer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMSystem;

const
  USR_TIMER_ELAPSED = WM_USER + 100;

  Invalid_Timer_ID = 0;
  Null_Interval = 0;

type
  EMMTimerInvalidID    = class( Exception );
  EMMTimerInvalidParam = class( Exception );
  EMMTimerNoCanDo      = class( Exception );

  TMMTimer = class(TComponent)
  private
    FHandle: HWND;
    FInterval: Cardinal;
    FEnabled : Boolean;
    FTimerID : UINT;

    FOnTimer: TNotifyEvent;

    procedure SetEnabled(Value: Boolean);
    procedure SetInterval(Value: Cardinal);
    procedure SetOnTimer(Value: TNotifyEvent);
    procedure WndProc(var Msg: TMessage);
    function  SetTimer( aInterval: Cardinal ): Cardinal;
    procedure ResetTimer( aInterval: Cardinal );
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Enabled: Boolean read FEnabled write SetEnabled default True;
    property Interval: Cardinal read FInterval write SetInterval default 1000;
    property OnTimer: TNotifyEvent read FOnTimer write SetOnTimer;
  end;

procedure Register;

implementation

var
  Passed: Boolean;

procedure Register;
begin
  RegisterComponents('System', [TMMTimer]);
end;

procedure TimerProc(uTimer, uMessage : UInt; dwUser, dw1, dw2 :  DWORD); stdcall;
begin
  PostMessage(dwUser,USR_TIMER_ELAPSED,0,0);
  Passed := True;
   // Ƽ̵ Ÿ̸ ݹ Լ κ API  Ұϴ.
   // ׷Ƿ ٽ ޽  ޽ ƾ  Ѵ.
end;

{ TMMTimer }

constructor TMMTimer.Create(AOwner: TComponent);
begin
  inherited Create( AOwner );
    // Ŭ   
    //  Ÿӿ Ƽ̵ Ÿ̸Ӱ ۵ϴ° ´.
  FEnabled := True;
  FInterval := 1000;
  FHandle := AllocateHWnd( WndProc );// ޽ ó  ü 쵵 Ҵش.
  if not ( csDesigning in ComponentState ) and ( FInterval <> Null_Interval ) and FEnabled then
    FInterval := SetTimer( FInterval );
end;

destructor TMMTimer.Destroy;
begin
  SetEnabled( False );
  DeallocateHWnd( FHandle );
  inherited Destroy;
end;

// Ÿ̸ Ѵ.
function TMMTimer.SetTimer( aInterval: Cardinal ): Cardinal;
var
  mmrValue: MMRESULT;
  TimeCaps: TTimeCaps;
begin
  if aInterval = Null_Interval then
    Exit;

  if timeGetDevCaps( @TimeCaps, sizeof(TimeCaps)) <> TIMERR_NOERROR then
    raise EMMTimerInvalidID.Create('<timeGetDevCaps> Error !!');
   // Ÿ̸ ̽    ´.

   if aInterval < TimeCaps.wPeriodMin then
      aInterval := TimeCaps.wPeriodMin; //   ȣ ֱ⺸ 
   if aInterval > TimeCaps.wPeriodMax then
      aInterval := TimeCaps.wPeriodMax; //   ȣ ֱ⺸ ũ

   mmrValue := timeBeginPeriod( aInterval ); // Ÿ̸ ֱ⸦ Ѵ.

   case mmrValue of
     TIMERR_NOCANDO : begin
       timeEndPeriod( aInterval );
       Result := Null_Interval;
       raise EMMTimerNoCanDo.Create( 'Specified timer event does not exist.' );
     end;
     else if mmrValue <> TIMERR_NOERROR then begin
       Result := Null_Interval;
       raise EMMTimerInvalidID.Create('<timeBeginPeriod> Error !!');
     end;
   end;
   FTimerID := timeSetEvent( aInterval, aInterval, @TimerProc, FHandle,
                            TIME_PERIODIC);
      // Ÿ̸Ӹ Ѵ. ݹ Լ ϰ, TIME_PERIODIC Ͽ
      // ֱ  ȣǰ .

   if FTimerID = Invalid_Timer_ID then begin
     timeEndPeriod( Interval );    //  ó ƾ
     Result := Null_Interval;
     raise EMMTimerInvalidID.Create('<timeSetEvent> Error !!');
   end;
   Result := aInterval;
end;

// Ÿ̸ .
procedure TMMTimer.ResetTimer( aInterval: Cardinal );
var
  mmrValue: MMRESULT;
begin
  if ( aInterval <> Null_Interval ) and ( FTimerID <> Invalid_Timer_ID ) then begin
    mmrValue := timeKillEvent(FTimerID);// Ÿ̸Ӹ Ѵ.
    case mmrValue of                    // ó..
      MMSYSERR_INVALPARAM: begin
        timeEndPeriod( aInterval );
        raise EMMTimerInvalidParam.Create( 'Specified timer event does not exist.' );
      end;
      TIMERR_NoCanDo: begin
        timeEndPeriod( aInterval );
        raise EMMTimerInvalidParam.Create( 'Resolution specified in uPeriod is out of range.' );
      end;
    end;
    mmrValue := timeEndPeriod( aInterval ); // Ÿ̸ ֱ⸦ Ѵ.
    case mmrValue of                // ó..
      TIMERR_NoCanDo:
        raise EMMTimerInvalidParam.Create( 'Resolution specified in uPeriod is out of range.' );
    end;
  end;
end;

procedure TMMTimer.SetEnabled(Value: Boolean);
begin
  if not ( csDesigning in ComponentState ) then begin
    if Value then begin
      if not FEnabled then begin
        FInterval := SetTimer( FInterval );
      end
    end else begin
      if FEnabled then begin
        ResetTimer( FInterval );
      end
    end;
  end;
  FEnabled := Value;
end;

procedure TMMTimer.SetInterval(Value: Cardinal);
begin
  if not ( csDesigning in ComponentState ) and FEnabled then begin
    if ( FInterval <> Value ) then begin
      ResetTimer( FInterval );
      FInterval := Value;
      SetTimer( FInterval );
    end
  end else
    FInterval := Value;
end;

procedure TMMTimer.SetOnTimer(Value: TNotifyEvent);
begin
  FOnTimer := Value;
end;

procedure TMMTimer.WndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = USR_TIMER_ELAPSED then
      try
        if Assigned( FOnTimer ) then  //  Ÿ̸ ̺Ʈ..
          if Passed then begin //   Message ó ȵǸ ׳ ǳʶٰ ߴ.
            FOnTimer( Self );
            Passed := False;
          end;
      except
        Application.HandleException(Self);
      end
    else
      Result := DefWindowProc( FHandle, Msg, wParam, lParam );//  ޽ Ʈó..
end;

initialization
  Passed := False;

end.
