unit Unit1;

interface      

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMTimer, StdCtrls, ExtCtrls, ComCtrls, Buttons, GIFImage;

type
  TForm1 = class(TForm)
    LblTest: TLabel;
    BtnPauseReplay: TButton;
    LblIntervalLabel: TLabel;
    LblInterval: TLabel;
    BtnClose: TButton;
    trbInterval: TTrackBar;
    BtnDecrease: TBitBtn;
    BtnIncrease: TBitBtn;
    Image1: TImage;
    PaintBox1: TPaintBox;
    MMTimer1: TMMTimer;
    Label1: TLabel;
    procedure MMTimer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnPauseReplayClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure trbIntervalChange(Sender: TObject);
    procedure BtnDecreaseClick(Sender: TObject);
    procedure BtnIncreaseClick(Sender: TObject);
  private
    FCounter: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.MMTimer1Timer(Sender: TObject);
begin
  LblTest.Caption := IntToStr( FCounter );
  PaintBox1.Canvas.Draw( FCounter mod 20, 20-(FCounter mod 20), Image1.Picture.Graphic );
  Inc( FCounter );
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FCounter := 0;
  TrbIntervalChange( TrbInterval )
end;

procedure TForm1.BtnPauseReplayClick(Sender: TObject);
begin
  MMTimer1.Enabled := not MMTimer1.Enabled;
  if not MMTimer1.Enabled then
    BtnPauseReplay.Caption := ''
  else BtnPauseReplay.Caption := '';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MMTimer1.Interval := 1000;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  MMTimer1.Interval := 10;
end;

procedure TForm1.BtnCloseClick(Sender: TObject);
begin
  Close
end;

procedure TForm1.trbIntervalChange(Sender: TObject);
begin
  MMTimer1.Interval := TrbInterval.Position;
  LblInterval.Caption := IntToStr( MMTimer1.Interval )
end;

procedure TForm1.BtnDecreaseClick(Sender: TObject);
begin
  TrbInterval.Position := TrbInterval.Position - 1;
end;

procedure TForm1.BtnIncreaseClick(Sender: TObject);
begin
  TrbInterval.Position := TrbInterval.Position + 1;
end;

end.
