/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  Basic DirectX + MFC game project template                              //
//  by Petr Stejskal (06/1998)                                             //
//  http://www.theWaterCooler.com/Tool                                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Basic.h"
#include "BasicWnd.h"
#include "Game.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBasicApp

BEGIN_MESSAGE_MAP(CBasicApp, CWinApp)
	//{{AFX_MSG_MAP(CBasicApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBasicApp construction

CBasicApp::CBasicApp()
{
  m_bIsActive = TRUE;
  m_bShutDown = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBasicApp object

CBasicApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBasicApp initialization

BOOL CBasicApp::InitInstance()
{
  CBasicWnd* pWnd = new CBasicWnd();    // main window (filled with black brush)
  if(pWnd->Create() == FALSE)
    return FALSE;                       // could not create the main window

  // Game initialization ==============
  m_pGame = new CGame();
  m_bShutDown = !(m_pGame->Init());     // quit when the initialization fails
  //===================================

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////

int CBasicApp::ExitInstance() 
{
  // Exit the game ====================
  m_pGame->Finish();
  delete m_pGame;
  //===================================
	
	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////

int CBasicApp::Run() 
{
  MSG msg;

  while(1)
  {
    if(m_bShutDown == TRUE)
    {
      ExitInstance();
      return 0;
    }

    if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
    {
      if(GetMessage(&msg, NULL, 0, 0) == FALSE)
      {
        ExitInstance();
        return msg.wParam;    // WM_QUIT
      }
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    else
    {
      if(m_bIsActive == TRUE)
      {
        if(m_bRedrawScreen)
        {
          m_bRedrawScreen = FALSE;

          //===========================
          m_pGame->Activate();          // called OnActivate (to redraw whole screen)
          //===========================

        }

        //=============================
        if(m_pGame->UpdateFrame());    // called until it returns true
        //  AfxGetMainWnd()->PostMessage(WM_CLOSE, 0, 0);
        //=============================

      }
      else
        WaitMessage();
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
