// PageWnd.cpp : implementation file
//

#include "stdafx.h"
#include "Basic.h"
#include "BasicWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBasicWnd

CBasicWnd::CBasicWnd()
{
  m_pApp = (CBasicApp*)AfxGetApp();
}

CBasicWnd::~CBasicWnd()
{
}

BEGIN_MESSAGE_MAP(CBasicWnd, CWnd)
	//{{AFX_MSG_MAP(CBasicWnd)
	ON_WM_ACTIVATEAPP()
	ON_WM_SETCURSOR()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBasicWnd message handlers

BOOL CBasicWnd::Create() 
{
  CRect rect(0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));

  LPCSTR strClass = AfxRegisterWndClass(CS_DBLCLKS,
                                     ::LoadCursor(NULL, IDC_ARROW),
                                     (HBRUSH)GetStockObject(BLACK_BRUSH),  // black color
                                     AfxGetApp()->LoadIcon(IDR_MAINFRAME));

  if(CreateEx(WS_EX_APPWINDOW, strClass, AfxGetAppName(), WS_SYSMENU | WS_POPUP | WS_VISIBLE,
     0, 0, rect.right, rect.bottom, NULL, NULL, 0) == FALSE)
    return FALSE;

  UpdateWindow();
  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////

void CBasicWnd::PostNcDestroy() 
{
  CWnd::PostNcDestroy();
  m_pApp->ShutDown(); 
  delete this;
}

/////////////////////////////////////////////////////////////////////////////

void CBasicWnd::OnActivateApp(BOOL bActive, HTASK hTask) 
{
  CWnd::OnActivateApp(bActive, hTask);
  m_pApp->SetActive(bActive);
}

/////////////////////////////////////////////////////////////////////////////

BOOL CBasicWnd::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
  ::SetCursor(NULL);
  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////

void CBasicWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  switch(nChar)
  {
    case VK_ESCAPE:
      PostMessage(WM_CLOSE, 0, 0);
      break;
  }

	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

/////////////////////////////////////////////////////////////////////////////
