#include <stdio.h>
#include <ddraw.h>

#define SAFE_RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }
#define SAFE_DELETE(x) if(x != NULL) { delete x; x = NULL; }

#define CDXCREATE_FULLSCREEN   0x00000001L



//////////////////////////////////////////////////////////////////////////////////
// CDX_Screen Class
//////////////////////////////////////////////////////////////////////////////////

class CDX_Screen
{
public:
	CDX_Screen();
	~CDX_Screen();

	HRESULT Create(HWND hwnd, DWORD width, DWORD height, DWORD bpp, DWORD flags);
	HRESULT Restore(void);
	HRESULT Flip(void);

	LPDIRECTDRAW4 GetDD(void) { return m_DirectDraw; }
	
	LPDIRECTDRAWSURFACE  GetFront() { return m_FrontBuffer; }
	LPDIRECTDRAWSURFACE  GetBack()  { return m_BackBuffer; }
	LPDIRECTDRAWSURFACE  GetDepth() { return m_DepthBuffer; }

	int GetWidth(void) { return m_Width; }
	int GetHeight(void) { return m_Height; }
	int GetBpp(void) { return m_Bpp; }

public:
	void Initialise();
	void Finalise();

	HRESULT CreateDirectDraw(void);
	HRESULT CreateBuffers(void);
	
	LPDIRECTDRAW4 m_DirectDraw;
	
	D3DDEVICEDESC m_DeviceDesc;
	DDPIXELFORMAT m_PixelFormat;
	DWORD m_MemoryType;

	LPDIRECTDRAWSURFACE  m_FrontBuffer;
	LPDIRECTDRAWSURFACE  m_BackBuffer;
	
	HWND  m_Hwnd;
	DWORD m_Width;
	DWORD m_Height;
	DWORD m_Bpp;
	RECT  m_ScreenRect;
	BOOL  m_IsFullScreen;
	
};

