//////////////////////////////////////////////////////////
//
// Volume Class (CVolume.cpp)
// 
// 1999.4.19
//
//////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
// Auxiliary Output Control
//////////////////////////////////////////////////////////

CVolume::CVolume()
{
}


CVolume::~CVolume()
{
}



//  ̽  
void CVolume::GetVolume(int DeviceID)
{
	::auxGetVolume(DeviceID, &this->m_auxvolume);

	this->m_leftvolume  = LOWORD(this->m_auxvolume);
	this->m_rightvolume = HIWORD(this->m_auxvolume);
}


//  
void CVolume::SetVolume(int DeviceID, int mode)
{
	this->m_muteswitch = FALSE;

	GetVolume(DeviceID);

	switch(mode)
	{
	case ID_ADD_VOLUME:
		this->m_leftvolume  += 0x1000;
		this->m_rightvolume += 0x1000;
		break;

	case ID_SUB_VOLUME:
		this->m_leftvolume  -= 0x1000;
		this->m_rightvolume -= 0x1000;
		break;
	}

	if(this->m_leftvolume  < 0x1fff) this->m_leftvolume  = 0x1fff;	
	if(this->m_leftvolume  > 0xffff) this->m_leftvolume  = 0xffff;	
	if(this->m_rightvolume < 0x1fff) this->m_rightvolume = 0x1fff;	
	if(this->m_rightvolume > 0xffff) this->m_rightvolume = 0xffff;	

	this->m_auxvolume = this->m_rightvolume;
	this->m_auxvolume = this->m_auxvolume << 16;
	this->m_auxvolume = this->m_auxvolume + this->m_leftvolume;

	::auxSetVolume(DeviceID, this->m_auxvolume);
}


// Ҹ ON/OFF
void CVolume::MuteVolume(int DeviceID)
{
	this->m_muteswitch = !this->m_muteswitch;

	switch(this->m_muteswitch)
	{
	case TRUE:
		GetVolume(DeviceID);
		::auxSetVolume(DeviceID, 0x1fff1fff);	
		break;

	case FALSE:
		this->m_auxvolume = this->m_rightvolume;
		this->m_auxvolume = this->m_auxvolume << 16;
		this->m_auxvolume = this->m_auxvolume + this->m_leftvolume;
		::auxSetVolume(DeviceID, this->m_auxvolume);	
		break;
	}
}





