/////////////////////////////	Direct 3D α׷	  ///////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
#define  STRICT
#define	 D3D_OVERLOADS
#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <d3d.h>
#include <ddraw.h>
#include "resource.h"

/////////////////////////////////    /////////////////////////////////////
HINSTANCE	Main_Inst;
HWND		Main_Windows;

///////////// ̷Ʈ 3D ο ̽     //////////////////////
static LPDIRECTDRAW				DD_DD1				= NULL;
static LPDIRECTDRAW4			DD_DD4				= NULL;
static LPDIRECTDRAWSURFACE4		DDS_Primary			= NULL;
static LPDIRECTDRAWSURFACE4     DDS_BackBuffer		= NULL;
static LPDIRECTDRAWSURFACE4     DDS_ZBuffer			= NULL;
static LPDIRECT3D3				D3D_D3d				= NULL;
static LPDIRECT3DDEVICE3		D3DD_Device			= NULL;
static LPDIRECT3DVIEWPORT3      D3DV_Viewport		= NULL;
static RECT						Screen_Rect,Viewport_Rect;

////////////////////////////// α׷    ///////////////////////////
D3DLVERTEX	Vertex_Main[24];	//  迭
DWORD		Vertex_Number;		//   
DWORD		Vertex_Color = 0x00ffffff; //  
WORD		Index_arry[48];		// ε 迭
DWORD		Index_Number;		// ε 	
float		V_x=0,V_y=0,V_z=0;

/////////////////////////////////  ȣ Լ /////////////////////////////////////
//  ʱȭ Լ
BOOL Init_Window(HINSTANCE ,int );
//   ޽ ݺԼ
LRESULT CALLBACK WndProc(HWND Hwnd,UINT uMsg,WPARAM Wparam,LPARAM Lparam);

////////////////////////////// 3D  ȣ Լ /////////////////////////////////////
// D3D ʿ  ڵ  
HRESULT CreateAllFormats(HWND Hwnd);
//    ٽ ʱȭ
BOOL ReleaseALL(void);
// 3D ġ ʱȭѴ
HRESULT Initialize3D(HWND Hwnd,GUID* DriverGuid,const GUID* DeviceGuid);
// Z ȼ ãԼ
static HRESULT WINAPI EnumZBufferCallback(DDPIXELFORMAT* DDP_Format ,VOID* DDP_Desired);
//  ȣ Լ
HRESULT RenderMain(void);
// ǥ  Լ
HRESULT RestoreSurfaces(void);
// Ʈ Լ
BOOL ViewPort_Set(LPDIRECT3DDEVICE3,LPDIRECT3DVIEWPORT3,float,RECT);
//   Լ
void VertexSetting(void);

////////////////////////  ޽ ݺ Լ ȣ Լ  //////////////////////////////
//  ׸
HRESULT Show_Object(void);
//  簢 ̱
VOID OnMove(INT x, INT y);

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////  Լ //////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE New_Inst,HINSTANCE ,LPSTR Cmd_Line,int Cmd_Show)
{
	MSG		msg;

	if( !Init_Window(New_Inst,Cmd_Show) ) //  ʱȭ ȣ
	{
		return FALSE;
	}
	Main_Inst = New_Inst;

	// Dircet 3D ʿ  ʱȭ Ѵ.
	if( FAILED(CreateAllFormats(Main_Windows)) )
		return FALSE;

	RenderMain();	// 

	while(GetMessage(&msg,NULL,0,0))  // ޽ ݺ
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return(msg.wParam);
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////  ʱȭ Լ /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
BOOL Init_Window(HINSTANCE Inst_F,int Int_F)
{
	WNDCLASS	wc; //  Ŭ ü 

	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = sizeof(DWORD);
	wc.hInstance = Inst_F;
	wc.hIcon = LoadIcon(Inst_F,"ICON");
	wc.hCursor = LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = "MENU";
	wc.lpszClassName = TEXT("3D");
	if(!RegisterClass(&wc))
		return	FALSE;
	//   
	Main_Windows = CreateWindow("3D","LineList ε ",WS_OVERLAPPEDWINDOW,
							  0,0,400,400,NULL,NULL,Inst_F,NULL);
	if(!Main_Windows)
		return FALSE;
	//   ׸
	ShowWindow(Main_Windows,SW_SHOWNORMAL);
	UpdateWindow(Main_Windows);

	return	TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////  ޽ ݺ Լ ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WndProc(HWND Hwnd,UINT uMsg,WPARAM Wparam,LPARAM Lparam)
{
	switch( uMsg )
	{
	case WM_PAINT:
		{
			Show_Object();
			break;
		}
	case WM_MOVE:
		{
			OnMove((SHORT)LOWORD(Lparam),(SHORT)HIWORD(Lparam));
			RenderMain();
			break;
		}
	case WM_SIZE: 
		{
			if(SIZE_MAXHIDE != Wparam || SIZE_MINIMIZED != Wparam)
			{
				if(FAILED(CreateAllFormats(Hwnd))) //  ٽ 
					DestroyWindow(Hwnd);
			}
			RenderMain();
			break;
		}
	case WM_CLOSE:
		{
			DestroyWindow(Hwnd);
			break;
		}
	case WM_DESTROY:
		{
			ReleaseALL();
			PostQuitMessage(0);
			break;
		}
	case WM_COMMAND:
		{
			switch(Wparam)
			{
			case ID_EXIT: //  
				{
					DestroyWindow(Hwnd);
					return 0;
				}
			case ID_COLOR1: //  
				{
					Vertex_Color = 0x00ff0000;
					RenderMain();
					break;
				}
			case ID_COLOR2: // Ķ 
				{
					Vertex_Color = 0x000000ff;
					RenderMain();
					break;
				}
			case ID_COLOR3: //  
				{
					Vertex_Color = 0x0000ff00;
					RenderMain();
					break;
				}
			case ID_COLOR4: //  
				{
					Vertex_Color = 0x00ffffff;
					RenderMain();
					break;
				}
			default :
					return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
			}
			break;
		}
	
	case WM_KEYDOWN:
		{
			switch((int)Wparam)
			{
				//////////////////////  ̵  ȸ /////////////////////
				case VK_LEFT:
					{
						V_x = V_x - 1;
						RenderMain();
						break;
					}
				case VK_RIGHT:
					{
						V_x = V_x + 1;
						RenderMain();
						break;
					}
				case VK_UP:
					{
						V_y = V_y - 1;
						RenderMain();
						break;
					}
				case VK_DOWN:
					{
						V_y = V_y + 1;
						RenderMain();
						break;
					}
				case VK_HOME:
					{
						V_z = V_z + 0.1f;
						RenderMain();
						break;
					}
				case VK_END:
					{
						V_z = V_z - 0.1f;
						RenderMain();
						break;
					}
				default :
					return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
			}
			break;
		}
	default:
		return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
	}
	return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
}

//////////////////////////////////////////////////////////////////////////////////////
////////////////////////// D3D ʿ  ڵ  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT CreateAllFormats(HWND Hwnd)
{
	//   ʱȭ Ѵ.
	if(!ReleaseALL())
		return E_FAIL;
	// 3D ġ ʱȭѴ.
	if(SUCCEEDED(Initialize3D(Hwnd,NULL,&IID_IDirect3DRGBDevice)))
		return S_OK;
	return E_FAIL;

}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////    ٽ ʱȭ ////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
BOOL ReleaseALL(void)
{
	//     ٽ ʱȭ Ѵ.

	// ο, 3D  .
	//   ٽ ʱȭ Ѵ.
	if(D3DV_Viewport)
	{
		D3DV_Viewport->Release();
		D3DV_Viewport		= NULL;
	}
	if(DDS_ZBuffer)
	{
		DDS_ZBuffer->Release();
		DDS_ZBuffer			= NULL;
	}
	if(D3D_D3d)
	{
		D3D_D3d->Release();
		D3D_D3d				= NULL;
	}
	if(DDS_BackBuffer)
	{
		DDS_BackBuffer->Release();
		DDS_BackBuffer		= NULL;
	}
	if(DDS_Primary)
	{
		DDS_Primary->Release();
		DDS_Primary			= NULL;
	}
	if(DD_DD4)
	{
		DD_DD4->Release();
		DD_DD4				= NULL;
	}
	if(D3DD_Device)
	{
		if(0 < D3DD_Device->Release())
			return 0;
		D3DD_Device			= NULL;
	}
	if(DD_DD1)
	{
		if(0 < DD_DD1->Release())
			return 0;
		DD_DD1				= NULL;
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////  3D ġ ʱȭѴ  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT Initialize3D(HWND Hwnd,GUID* DriverGuid,const GUID* DeviceGuid)
{
	HRESULT Hr;
	DDSURFACEDESC2 ddsd;
	DDPIXELFORMAT  DDPF_Zbuffer;
	// ̷Ʈ ο(DD) 
	if(FAILED(DirectDrawCreate(DriverGuid,&DD_DD1,NULL)))
		return E_FAIL;
	// DD4 DD Ų.
	if(FAILED(DD_DD1->QueryInterface( IID_IDirectDraw4 , (VOID**)&DD_DD4 )))
		return E_FAIL;
	//  ڵ  ܰ踦 Ѵ.
	if(FAILED(DD_DD4->SetCooperativeLevel(Hwnd,DDSCL_NORMAL)))
		return E_FAIL;

	// ο ǥ  ü ʱȭ (ǥ ) 
	ZeroMemory(&ddsd,sizeof(DDSURFACEDESC2));
	ddsd.dwSize=sizeof(DDSURFACEDESC2);
	ddsd.dwFlags = DDSD_CAPS ;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE ;
	// ǥ 
	if(FAILED(DD_DD4->CreateSurface(&ddsd,&DDS_Primary,NULL)))
		return E_FAIL;

	// ο ǥ  ü ʱȭ (ĸ ) 
	ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE ;
	GetClientRect(Hwnd,&Screen_Rect);
	GetClientRect(Hwnd,&Viewport_Rect);
	ClientToScreen(Hwnd,(POINT*)&Screen_Rect.left);  // 簢 
	ClientToScreen(Hwnd,(POINT*)&Screen_Rect.right);
	ddsd.dwWidth = Screen_Rect.right - Screen_Rect.left;  //  ũ 
	ddsd.dwHeight =Screen_Rect.bottom - Screen_Rect.top;

	// ĸ   
	if(FAILED(DD_DD4->CreateSurface(&ddsd,&DDS_BackBuffer,NULL)))
		return E_FAIL;

	// Ŭ  ,  ø忡 ʿ 
	LPDIRECTDRAWCLIPPER  DDClipper;
	if(FAILED(DD_DD4->CreateClipper(0,&DDClipper,NULL)))
		return E_FAIL;
	DDClipper->SetHWnd(0,Hwnd);
	DDClipper->Release();

	// 3D DD 
	if(FAILED(DD_DD4->QueryInterface(IID_IDirect3D3,(VOID**)&D3D_D3d)))
		return E_FAIL;

	//// Z۸  ȼ ˰ 
	// 3D ġκ Z  ´.
	D3D_D3d->EnumZBufferFormats(*DeviceGuid,EnumZBufferCallback,(VOID*)&DDPF_Zbuffer);
	if( sizeof(DDPIXELFORMAT) != DDPF_Zbuffer.dwSize)// ȼ  Ȯ 
		return E_FAIL;
	//  Ÿ  Z   Z۸  ǥ desc Ѵ.
	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
	ddsd.dwWidth = Screen_Rect.right - Screen_Rect.left;  //  ũ Z 
	ddsd.dwHeight = Screen_Rect.bottom - Screen_Rect.top;
	memcpy(&ddsd.ddpfPixelFormat,&DDPF_Zbuffer,sizeof(DDPIXELFORMAT));// ã Z 
	//  ޸  
	if(IsEqualIID(*DeviceGuid,IID_IDirect3DHALDevice))
		ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;
	// ǥ  ̿Ͽ Z۸  Ų.
	if(FAILED(Hr = DD_DD4->CreateSurface(&ddsd,&DDS_ZBuffer,NULL)))
		return Hr;
	// Z۸ ĸ ۿ ̱
	if(FAILED(Hr = DDS_BackBuffer->AddAttachedSurface(DDS_ZBuffer)))
		return Hr;

	// ̽  ÷ ķƮ üũ
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	DD_DD4->GetDisplayMode(&ddsd);  // ÷  .
	if( ddsd.ddpfPixelFormat.dwRGBBitCount <= 8 ) // 16bit ÷ ̻  üũ
		return DDERR_INVALIDMODE;

	// 3D ̿Ͽ ĸ۸  3D ̽ .  
	if(FAILED(Hr = D3D_D3d->CreateDevice( *DeviceGuid,DDS_BackBuffer,&D3DD_Device,NULL)))
		return Hr;

	// 3D ̿Ͽ Ʈ 
	if(FAILED(Hr = D3D_D3d->CreateViewport(&D3DV_Viewport,NULL)))
		return Hr;
	// 3D ̽ Ʈ ߰
	D3DD_Device->AddViewport(D3DV_Viewport);
	// Ʈ Լ 
	ViewPort_Set(D3DD_Device,D3DV_Viewport,20.0f,Screen_Rect);

	//   
	return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////// Ʈ Լ //////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
BOOL ViewPort_Set(LPDIRECT3DDEVICE3 VS_3dd,LPDIRECT3DVIEWPORT3 VS_3dv,float VP_Scale,RECT VS_Rect)
{
	// Ʈ  Ķ 
	D3DVIEWPORT2 VPdata;
	ZeroMemory(&VPdata,sizeof(D3DVIEWPORT2));
	VPdata.dwSize   = sizeof(D3DVIEWPORT2);
	VPdata.dwWidth	= VS_Rect.right - VS_Rect.left;
	VPdata.dwHeight	= VS_Rect.bottom - VS_Rect.top;
	VPdata.dvClipX	= -VP_Scale;
	VPdata.dvClipY	= VP_Scale;
	VPdata.dvClipWidth	= VP_Scale*2;
	VPdata.dvClipHeight	= VP_Scale*2;
	VPdata.dvMaxZ	= VP_Scale;
	VPdata.dvMinZ	= -VP_Scale;
	// Ʈ Ķ  
	VS_3dv->SetViewport2(&VPdata);
	// ̽  Ʈ  Ѵ.
	VS_3dd->SetCurrentViewport(VS_3dv);
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////// Z ȼ ãԼ  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
static HRESULT WINAPI EnumZBufferCallback(DDPIXELFORMAT* DDP_Format ,VOID* DDP_Desired)
{
	// ٽ ۴ Ѵ. Z  üũѴ.
	if(DDP_Format->dwFlags == DDPF_ZBUFFER)
	{
		memcpy( DDP_Desired, DDP_Format,sizeof(DDPIXELFORMAT) );
		return D3DENUMRET_CANCEL;
	}
	return D3DENUMRET_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////     ////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT RenderMain(void)
{
	D3DRECT		ViewPort;
	// Ʈ  Z ʱȭ
	ViewPort.x1 = Viewport_Rect.left;
	ViewPort.y1 = Viewport_Rect.top;
	ViewPort.x2 = Viewport_Rect.right;
	ViewPort.y2 = Viewport_Rect.bottom;

	D3DV_Viewport->Clear2(1UL,&ViewPort,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,0x00000000,1.0f,0L);
	//  ǥ Է Լ
	VertexSetting();
	//   ׸ 
	if( FAILED( D3DD_Device->BeginScene() ) )
		return E_FAIL;
	// ׸
	D3DD_Device->DrawIndexedPrimitive(D3DPT_LINELIST ,D3DFVF_LVERTEX,Vertex_Main,Vertex_Number,Index_arry,Index_Number,D3DDP_DONOTLIGHT);
	// ׸ 
	D3DD_Device->EndScene();

	//  ׸  ϸ ǥ 
	if( DDERR_SURFACELOST == Show_Object() )
		RestoreSurfaces();
	return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////  ǥ   //////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT RestoreSurfaces(void)
{
	// ǥ  üũ
	if(DDS_Primary)
		if(DDS_Primary->IsLost())
			DDS_Primary->Restore();
	// ĸ  üũ 
	if(DDS_BackBuffer)
		if(DDS_BackBuffer->IsLost())
			DDS_BackBuffer->Restore();
	// Z   üũ
	if(DDS_ZBuffer)
		if(DDS_ZBuffer->IsLost())
			DDS_ZBuffer->Restore();
	return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////  Ʈ ޽ Լ //////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT Show_Object(void)
{
	if(NULL == DDS_Primary)
		return E_FAIL;
	return DDS_Primary->Blt(&Screen_Rect,DDS_BackBuffer,&Viewport_Rect,DDBLT_WAIT,NULL);
} 

//////////////////////////////////////////////////////////////////////////////////////
///////////////////  3D  ũ 簢 ̵  /////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
VOID OnMove(INT x, INT y)
{
	DWORD dwWidth = Screen_Rect.right - Screen_Rect.left;
	DWORD dwHeight = Screen_Rect.bottom - Screen_Rect.top;
	SetRect(&Screen_Rect,x,y,x+dwWidth,y+dwHeight);//  ũ 
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////    Ѵ. /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
void VertexSetting()
{
	//  ǥ 
	Vertex_Number = 24;
	for(int i=0 ; i<24 ; i++)
		Vertex_Main[i] = D3DLVERTEX(D3DVECTOR(V_x+10*(float)cos(i*3.141592/12),V_y+10*(float)sin(i*3.141592/12),V_z),Vertex_Color,0,0,0);
	// ε 
	Index_Number=36;
	for( i=0 ; i<24 ; i++)
		Index_arry[i]=(WORD)i;
	for( i=24 ; i<36 ; i++)
	{
		if( 0==(i%2) )
			Index_arry[i]=(WORD)i-24;
		else
			Index_arry[i]=(WORD)i-13;
	}
}