#define STRICT
#include <tchar.h>
#include <stdio.h>
#include "texture.h"

//////////////////////// ؽó ü  //////////////////////////////////////
struct TextureStruct
{
    HBITMAP              HBitmap;     // Ʈ ڵ
    LPDIRECTDRAWSURFACE4 Surface4;    // ؽó ǥ 
    LPDIRECT3DTEXTURE2   Texture2;    // Direct3D ؽó
    TCHAR                MapName[80]; // Ʈ  ̸
    DWORD                Stage_DW;    // ؽó ȿ
	DWORD                Flags_DW;	  // ÷

    // ü Ʈ , ü 
	TextureStruct     *TS_Prev, *TS_Next; 

    ~TextureStruct();
};
// ؽó ü Ʈ 
static TextureStruct* TS_List = NULL;    
#define FOR_ALL_TEXTURE(For_TS) for( TextureStruct* For_TS=TS_List; NULL!=For_TS; For_TS=For_TS->TS_Next )

///////////////////////// ؽó  ã ü  ////////////////////////////////
struct TEXTUREFORMAT
{
	DWORD BPP_DW; // ؽó  ã 
	BOOL  Alpha_B;
	BOOL  Palette_B;
	BOOL  FourCC_B;
	BOOL  Found_B;

	DDPIXELFORMAT* Pix_Format; // ã  
};

// DDSURFACEDESC2 ü ʱȭ Լ
VOID SurfaceDesc_Init( DDSURFACEDESC2& T_DDSD2, DWORD dwFlags,DWORD dwCaps )
{
    ZeroMemory( &T_DDSD2, sizeof(DDSURFACEDESC2) );
    T_DDSD2.dwSize                 = sizeof(DDSURFACEDESC2);
    T_DDSD2.dwFlags                = dwFlags;
    T_DDSD2.ddsCaps.dwCaps         = dwCaps;
    T_DDSD2.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);
}

// ̽  ο ̽  Լ.
LPDIRECTDRAW4 Get_DirectDraw4( LPDIRECT3DDEVICE3 Device_3D )
{
	LPDIRECTDRAW4        DD4_Texture = NULL;
	LPDIRECTDRAWSURFACE4 Render_Surface;

    if( Device_3D )
	{
	    //   Ÿ ´.
		if( SUCCEEDED( Device_3D->GetRenderTarget( &Render_Surface ) ) )
		{
		    // ο ̽ ´.
			Render_Surface->GetDDInterface( (VOID**)&DD4_Texture );
			Render_Surface->Release();
		}
	}
	return DD4_Texture;
}

// ȼ  ã ݺԼ
static HRESULT CALLBACK PixelFormatCallback( DDPIXELFORMAT* Pixel_Format, VOID* Struct_Pixel )
{
	//  Ȯ 
    if( NULL==Pixel_Format || NULL==Struct_Pixel )
        return DDENUMRET_OK;
	// ؽó  ü   
	TEXTUREFORMAT* TF_Pixel = (TEXTUREFORMAT*)Struct_Pixel;

    //  ɼ Ȯ 
    if( Pixel_Format->dwFlags & (DDPF_LUMINANCE|DDPF_BUMPLUMINANCE|DDPF_BUMPDUDV) )
        return DDENUMRET_OK;

	//////////////////////////   䱸 ȼ  Ȯι   ///////////////////////
	// ã ȼ  8Ʈ  ٽ ˻ 
	if( Pixel_Format->dwRGBBitCount < 16 )
		return DDENUMRET_OK;
	//  ü FourCC   Ȯ 
    if( TF_Pixel->FourCC_B )
	{
		// ã ȼ FourCC 뿩 Ȯ 
		if( Pixel_Format->dwFourCC == 0 )
		    return DDENUMRET_OK;

		return DDENUMRET_CANCEL;
	}
	// FourCC   Ȯ 
	if( Pixel_Format->dwFourCC != 0 )
		return DDENUMRET_OK;
	// ã  ü Alpha  Ȯ 
	if( (TF_Pixel->Alpha_B==TRUE) && !(Pixel_Format->dwFlags&DDPF_ALPHAPIXELS) )
		return DDENUMRET_OK;
	if( (TF_Pixel->Alpha_B==FALSE) && (Pixel_Format->dwFlags&DDPF_ALPHAPIXELS) )
		return DDENUMRET_OK;

	///////////////////////    ȼ 幮   ///////////////////////////
	// ȷƮ 䱸 Ȯ 
	if( TF_Pixel->Palette_B )
	{
		// ÷  ȷƮ Ȯ 
		if( !( Pixel_Format->dwFlags & DDPF_PALETTEINDEXED8 ) )
			return DDENUMRET_OK;

		// 8 Ʈ ȷƮ ȼ  
        memcpy( TF_Pixel->Pix_Format, Pixel_Format, sizeof(DDPIXELFORMAT) );
		// ü  Ϸ 
		TF_Pixel->Found_B = TRUE;
        return DDENUMRET_CANCEL;
    }
    // ã ȼ Ʈ ü Ʈ   Ȯ 
    if( Pixel_Format->dwRGBBitCount == TF_Pixel->BPP_DW )
    {
		// ã ȼ  
        memcpy( TF_Pixel->Pix_Format, Pixel_Format, sizeof(DDPIXELFORMAT) );
		TF_Pixel->Found_B = TRUE;
        return DDENUMRET_CANCEL;
    }

    return DDENUMRET_OK;
}

// ؽó ü ı 
TextureStruct::~TextureStruct()
{
    SAFE_DELETE( TS_Next );
    SAFE_RELEASE( Texture2 );
    SAFE_RELEASE( Surface4 );
    DeleteObject( HBitmap );
}


// ؽó ü ã Լ
static TextureStruct* FindTextureStruct( TCHAR* Texture_ST_Name )
{
    FOR_ALL_TEXTURE( Texture_Find )
    {
        if( !lstrcmpi( Texture_ST_Name, Texture_Find->MapName ) )
            return Texture_Find;
    }
    return NULL;
}


// Ʈ  ε
static HRESULT Load_Bmp( TextureStruct* Texture_Load )
{
    TCHAR* Filename = Texture_Load->MapName;

	Texture_Load->HBitmap = (HBITMAP)LoadImage( NULL, Filename,IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE|LR_CREATEDIBSECTION );

    return (Texture_Load->HBitmap) ? DD_OK : DDERR_NOTFOUND;

}

// Ʈ ǥ鿡 
static HRESULT Surface_Bmp( LPDIRECTDRAWSURFACE4 T_Surfce_bmp, HBITMAP T_HBitmap_bmp )
{
    // ο ǥ Ͽ ο ü  
    LPDIRECTDRAW4 SB_DD;
    T_Surfce_bmp->GetDDInterface( (VOID**)&SB_DD );
    SB_DD->Release();

    // Ʈ ڵ鿡 Ʈ  ü  
    BITMAP T_Bitmap_bmp;
    GetObject( T_HBitmap_bmp, sizeof(BITMAP), &T_Bitmap_bmp );

    // ӽ ؽó ǥ  ǥ 
    DDSURFACEDESC2 SB_SurfDesc;
    SurfaceDesc_Init( SB_SurfDesc ,0,0);
    T_Surfce_bmp->GetSurfaceDesc( &SB_SurfDesc );
    SB_SurfDesc.dwFlags          = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|DDSD_PIXELFORMAT|
									DDSD_TEXTURESTAGE;
    SB_SurfDesc.ddsCaps.dwCaps   = DDSCAPS_TEXTURE|DDSCAPS_SYSTEMMEMORY;
    SB_SurfDesc.ddsCaps.dwCaps2  = 0L;
    SB_SurfDesc.dwWidth          = T_Bitmap_bmp.bmWidth;
    SB_SurfDesc.dwHeight         = T_Bitmap_bmp.bmHeight;

    // ؽó ӽ ǥ 
    LPDIRECTDRAWSURFACE4 Temp_Surface_bmp;
    if( FAILED( SB_DD->CreateSurface( &SB_SurfDesc, &Temp_Surface_bmp, NULL ) ) )
        return NULL;

    // Ʈ  ̽ ؽƮ   
    HDC Hdc_Bitmap = CreateCompatibleDC( NULL );
    if( NULL == Hdc_Bitmap )
    {
        Temp_Surface_bmp->Release();
        return NULL;
    }
    SelectObject( Hdc_Bitmap, T_HBitmap_bmp );

    // ؽó ӽ ǥ鿡 Ʈ 
    HDC Hdc_Surface;
    if( SUCCEEDED( Temp_Surface_bmp->GetDC( &Hdc_Surface ) ) )
    {
        BitBlt( Hdc_Surface,0,0, T_Bitmap_bmp.bmWidth, T_Bitmap_bmp.bmHeight, Hdc_Bitmap,0,0,SRCCOPY);
        Temp_Surface_bmp->ReleaseDC( Hdc_Surface );
    }
    DeleteDC( Hdc_Bitmap );

    // ӽ ؽó ǥ ؽó ǥ鿡  
    T_Surfce_bmp->Blt( NULL, Temp_Surface_bmp, NULL, DDBLT_WAIT, NULL );
    Temp_Surface_bmp->Release();
	// Լ Ϸ
    return S_OK;
}

// Ʈ ǥ  
LPDIRECTDRAWSURFACE4 Texture_GetSurface( TCHAR* FileName )
{
    TextureStruct* Texture_Get = FindTextureStruct( FileName );

    return Texture_Get ? Texture_Get->Surface4 : NULL;
}

// Ʈ ؽó 
LPDIRECT3DTEXTURE2 Texture_GetTexture( TCHAR* FileName )
{
    TextureStruct* Texture_Get = FindTextureStruct( FileName );

    return Texture_Get ? Texture_Get->Texture2: NULL;
}


// ؽó 
HRESULT Texture_Create( TCHAR* FileName, DWORD dwStage, DWORD dwFlags )
{
    //  ؽó ߺ Ȯ
    if( NULL != FindTextureStruct( FileName ) )
        return S_OK;

    // ο ؽó ü Ҵ
    TextureStruct* Texture_Create = new TextureStruct();
    if( NULL == Texture_Create )
        return E_OUTOFMEMORY;
    ZeroMemory( Texture_Create, sizeof(TextureStruct) );
    lstrcpy( Texture_Create->MapName, FileName );
    Texture_Create->Stage_DW = dwStage;
    Texture_Create->Flags_DW = dwFlags;

    // ü Ʈ ε
    if( FAILED( Load_Bmp( Texture_Create ) ) )
	{
		delete Texture_Create;
        return E_FAIL;
	}

    // ο ü Ʈ 
    if( TS_List )
        TS_List->TS_Prev = Texture_Create;
    Texture_Create->TS_Next = TS_List;
    TS_List  = Texture_Create;

    return S_OK;
}

// ؽó ü 
static HRESULT Restore_Texture(TextureStruct* R_TextureStruct, LPDIRECT3DDEVICE3 R_Device3 )
{
    // ̽ ̿Ͽ DirectDraw ü ´ 
    LPDIRECTDRAW4 R_DD;
    if( NULL == ( R_DD = Get_DirectDraw4( R_Device3 ) ) )
        return E_FAIL;
    R_DD->Release();

    // ̽  ´.
    D3DDEVICEDESC HwDesc, SwDesc;
    DWORD         Device_Caps;
    HwDesc.dwSize = sizeof(D3DDEVICEDESC);
    SwDesc.dwSize = sizeof(D3DDEVICEDESC);
    if( FAILED( R_Device3->GetCaps( &HwDesc, &SwDesc ) ) )
        return E_FAIL;
    if( HwDesc.dwFlags )
		Device_Caps = HwDesc.dpcTriCaps.dwTextureCaps;
    else
		Device_Caps = SwDesc.dpcTriCaps.dwTextureCaps;

	// Ʈ ü ´.
    BITMAP R_Bitmap;
    HBITMAP R_HBitmap = R_TextureStruct->HBitmap;
    GetObject( R_HBitmap, sizeof(BITMAP), &R_Bitmap );
    DWORD dwWidth  = (DWORD)R_Bitmap.bmWidth;  // Ʈ 
    DWORD dwHeight = (DWORD)R_Bitmap.bmHeight; // Ʈ 

    //  ǥ ǥ  Ѵ.
    DDSURFACEDESC2 R_SurfDesc;
    SurfaceDesc_Init( R_SurfDesc ,0,0);
    R_SurfDesc.dwFlags         = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|
                           DDSD_PIXELFORMAT|DDSD_TEXTURESTAGE;
    R_SurfDesc.ddsCaps.dwCaps  = DDSCAPS_TEXTURE;
    R_SurfDesc.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    R_SurfDesc.dwTextureStage  = R_TextureStruct->Stage_DW;
    R_SurfDesc.dwWidth         = dwWidth;
    R_SurfDesc.dwHeight        = dwHeight;

    // (Ʈ ũ ̿)̹ Ŀ  ũ 
    if( Device_Caps & D3DPTEXTURECAPS_POW2 )
    {
        for( R_SurfDesc.dwWidth=1;  dwWidth>R_SurfDesc.dwWidth;   R_SurfDesc.dwWidth<<=1 );
        for( R_SurfDesc.dwHeight=1; dwHeight>R_SurfDesc.dwHeight; R_SurfDesc.dwHeight<<=1 );
    }
    if( Device_Caps & D3DPTEXTURECAPS_SQUAREONLY )
    {
        if( R_SurfDesc.dwWidth > R_SurfDesc.dwHeight )
			R_SurfDesc.dwHeight = R_SurfDesc.dwWidth;
        else
			R_SurfDesc.dwWidth  = R_SurfDesc.dwHeight;
    }
	// ȷƮ 뿩 Ȯ 
	BOOL Palette_B = ( R_Bitmap.bmBitsPixel <= 8 );
	// İ   
	BOOL Alpha_B   = FALSE;
	
	//  ã ü ʱȭ 
	TEXTUREFORMAT Texture_Format;
	Texture_Format.Pix_Format     = &R_SurfDesc.ddpfPixelFormat;
	Texture_Format.Alpha_B        = Alpha_B;
	Texture_Format.Palette_B      = Palette_B;
	Texture_Format.FourCC_B       = ( R_SurfDesc.ddpfPixelFormat.dwFlags & DDPF_FOURCC );
	Texture_Format.BPP_DW		  = 16;
	Texture_Format.Found_B		  = FALSE;

	//  ü   ã
    R_Device3->EnumTextureFormats( PixelFormatCallback, &Texture_Format );
	
    // ؽó  ǥ  
    if( FAILED( R_DD->CreateSurface( &R_SurfDesc, &R_TextureStruct->Surface4, NULL ) ) )
        return E_FAIL;

    //  ǥ ̿Ͽ ؽó 
    if( FAILED( R_TextureStruct->Surface4->QueryInterface( IID_IDirect3DTexture2,
                                         (VOID**)&R_TextureStruct->Texture2 ) ) )
        return E_FAIL;

	// ؽó ǥ鿡 Ʈ  
    return Surface_Bmp( R_TextureStruct->Surface4, R_HBitmap );

}
// Ʈ ڵ   ؽó ȯ 
LPDIRECT3DTEXTURE2 Texture_Auto_Create( LPDIRECT3DDEVICE3 Device_3D, TCHAR* FileName, DWORD dwStage, DWORD dwFlags)
{
	if(S_OK != Texture_Create( FileName, dwStage, dwFlags ))
		return NULL;
	if(S_OK != Texture_Restore( FileName, Device_3D ))
		return NULL;
    return Texture_GetTexture( FileName );
}

// ؽó 
HRESULT Texture_Restore( TCHAR* FileName, LPDIRECT3DDEVICE3 Device_3D )
{
	// ؽó ü ã
    TextureStruct* Texture_Rest = FindTextureStruct( FileName );
    if( NULL == Texture_Rest )
        return DDERR_NOTFOUND;
    // ʱȭ
    SAFE_RELEASE( Texture_Rest->Texture2 );
    SAFE_RELEASE( Texture_Rest->Surface4 );

	//  Լ ȣ   ȯ
	return Restore_Texture( Texture_Rest, Device_3D );
}	
	
//  ؽó  
HRESULT Texture_All_Textures( LPDIRECT3DDEVICE3 Device_3D )
{
    FOR_ALL_TEXTURE( Texture_All )
    {
        Texture_Restore( Texture_All->MapName, Device_3D );
    }

    return DD_OK;
}

//  ؽó ȿȭ
HRESULT Texture_Invalidate( TCHAR* FileName )
{
	// ̸ ̿Ͽ ؽó ü ã
    TextureStruct* Texture_Inv = FindTextureStruct( FileName );
    if( NULL == Texture_Inv )
        return DDERR_NOTFOUND;

    SAFE_RELEASE( Texture_Inv->Texture2 );
    SAFE_RELEASE( Texture_Inv->Surface4 );

    return DD_OK;
}

//  ؽ ȿȭѴ 
HRESULT Texture_All_Invalidate()
{
    FOR_ALL_TEXTURE( Struct_List )
    {
        SAFE_RELEASE( Struct_List->Texture2 );
        SAFE_RELEASE( Struct_List->Surface4 );
    }

    return DD_OK;
}

// Ʈ ü  
HRESULT Texture_Destroy_List( TCHAR* FileName )
{
	// ؽó ü ã´.
    TextureStruct* Texture_S = FindTextureStruct( FileName );
	// ü   ޽ 
    if( NULL == Texture_S )
        return DDERR_NOTFOUND;
	// ü Ʈ  
    if( Texture_S->TS_Prev )
        Texture_S->TS_Prev->TS_Next = Texture_S->TS_Next;
    else
        TS_List = Texture_S->TS_Next;
    Texture_S->TS_Next = NULL;

    SAFE_DELETE( Texture_S );

    return DD_OK;
}
