/////////////////////////////  Direct 3D α׷     ///////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
#define  STRICT
#define	D3D_OVERLOADS
#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <d3d.h>
#include <ddraw.h>
#include "texture.h"
#include "resource.h"
#include "file3d.h"

/////////////////////////////////    /////////////////////////////////////
HINSTANCE	Main_Inst;
HWND		Main_Windows;

///////////// ̷Ʈ 3D ο ̽     //////////////////////
static LPDIRECTDRAW				DD_DD1				= NULL;
static LPDIRECTDRAW4			DD_DD4				= NULL;
static LPDIRECTDRAWSURFACE4		DDS_Primary			= NULL;
static LPDIRECTDRAWSURFACE4     DDS_BackBuffer		= NULL;
static LPDIRECTDRAWSURFACE4     DDS_ZBuffer			= NULL;
static LPDIRECT3D3				D3D_D3d				= NULL;
static LPDIRECT3DDEVICE3		D3DD_Device			= NULL;
static LPDIRECT3DVIEWPORT3      D3DV_Viewport		= NULL;
static LPDIRECT3DLIGHT			D3DL_Light			= NULL;
static LPDIRECT3DMATERIAL3		D3DM_Material		= NULL;
static RECT						Screen_Rect,Viewport_Rect;

////////////////////////////// α׷    /////////////////////////// 
RenderingObjectBuffer	R_Ob;	// ü  
D3DMATRIX	Matrix_3D;			//   
D3DMATRIX	Matrix_View;		// þ  
D3DVECTOR	View_Center,View_Z,View_Y;	//   
D3DVECTOR	Light_Pos,Light_Dir;

/////////////////////////////////  ȣ Լ /////////////////////////////////////
//  ʱȭ Լ
BOOL Init_Window(HINSTANCE ,int );
//   ޽ ݺԼ
LRESULT CALLBACK WndProc(HWND Hwnd,UINT uMsg,WPARAM Wparam,LPARAM Lparam);

////////////////////////////// 3D  ȣ Լ /////////////////////////////////////
// D3D ʿ  ڵ  
HRESULT CreateAllFormats(HWND Hwnd);
//    ٽ ʱȭ
BOOL ReleaseALL(void);
// 3D ġ ʱȭѴ
HRESULT Initialize3D(HWND Hwnd,GUID* DriverGuid,const GUID* DeviceGuid);
// Z ȼ ãԼ
static HRESULT WINAPI EnumZBufferCallback(DDPIXELFORMAT* DDP_Format ,VOID* DDP_Desired);
//  ȣ Լ
HRESULT RenderMain(void);
// ǥ  Լ
HRESULT RestoreSurfaces(void);
// Ʈ Լ
BOOL ViewPort_Set(LPDIRECT3DDEVICE3,LPDIRECT3DVIEWPORT3,float,RECT);
//   Լ
void VertexSetting(void);
//   
void SetWorld_Transform(LPDIRECT3DDEVICE3 W_device,D3DMATRIX& m);
// þ  
void SetView_Transform(LPDIRECT3DDEVICE3 W_device,D3DMATRIX& m);
// ǥ  Լ   
BOOL Situation_Eye(D3DMATRIX& m,D3DVECTOR& eye_sit,D3DVECTOR& eye_Z,D3DVECTOR& eye_Y);
//    
void SetProjection_Transform(LPDIRECT3DDEVICE3 W_device);

//////////////////////////////     Լ  /////////////////////////////////
//   Լ
HRESULT Light_Setting(LPDIRECT3DLIGHT LS_Device,D3DVECTOR& L_Pos,D3DVECTOR& L_Dir);
//   Լ
HRESULT Material_Setting(LPDIRECT3DMATERIAL3 MS_Material );
// , 
HRESULT Light_Material_Create(LPDIRECT3DDEVICE3 LM_Device,LPDIRECT3DVIEWPORT3 LM_Viewport);

//////////////////////////////    Լ  //////////////////////////////////////
//  
void  Identity_Matrix( D3DMATRIX& m);
// Ȯ  
void Scale_Matrix(D3DMATRIX& m, float Sx, float Sy, float Sz);
// ̵  
D3DMATRIX Translate(D3DVECTOR& Vect);
// İ      (M_c = M_a * M_b)
void Matrix_Multiply(D3DMATRIX& M_c,D3DMATRIX& M_a,D3DMATRIX& M_b);
// İ  
BOOL Vertex_Matrix_Multiply(D3DVERTEX& Vert,D3DMATRIX& m);
// İ   
BOOL Vector_Matrix_Multiply(D3DVECTOR& Vect,D3DMATRIX& m);
// ȸ   Լ
void Rotate_Matrix(D3DMATRIX& m, float Angl, int XYZType);
//  Ϳ  ȸ  Լ  
void Rotate_Matrix( D3DMATRIX& mat, float Angl, D3DVECTOR& vDir);

////////////////////////  ޽ ݺ Լ ȣ Լ  //////////////////////////////
//  ׸
HRESULT Show_Object(void);
//  簢 ̱
VOID OnMove(INT x, INT y);

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////  Լ //////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE New_Inst,HINSTANCE ,LPSTR Cmd_Line,int Cmd_Show)
{
	MSG		msg;

	if( !Init_Window(New_Inst,Cmd_Show) ) //  ʱȭ ȣ
	{
		return FALSE;
	}
	Main_Inst = New_Inst;

	// Dircet 3D ʿ  ʱȭ Ѵ.
	if( FAILED(CreateAllFormats(Main_Windows)) )
		return FALSE;

	RenderMain();	// 

	while(GetMessage(&msg,NULL,0,0))  // ޽ ݺ
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return(msg.wParam);
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////  ʱȭ Լ /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
BOOL Init_Window(HINSTANCE Inst_F,int Int_F)
{
	WNDCLASS	wc; //  Ŭ ü 

	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = sizeof(DWORD);
	wc.hInstance = Inst_F;
	wc.hIcon = LoadIcon(Inst_F,"ICON");
	wc.hCursor = LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = "MENU";
	wc.lpszClassName = TEXT("3D");
	if(!RegisterClass(&wc))
		return	FALSE;
	//   
	Main_Windows = CreateWindow("3D","ü  ",WS_OVERLAPPEDWINDOW,
							  0,0,400,400,NULL,NULL,Inst_F,NULL);
	if(!Main_Windows)
		return FALSE;
	//   ׸
	ShowWindow(Main_Windows,SW_SHOWNORMAL);
	UpdateWindow(Main_Windows);

	return	TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////  ޽ ݺ Լ ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WndProc(HWND Hwnd,UINT uMsg,WPARAM Wparam,LPARAM Lparam)
{
	//  ̸ 迭
	static char szFileName[MAX_PATH];  
	static char szFileTitle[MAX_PATH];
	//  ̸ ü
	OPENFILENAME ofn;

	switch( uMsg )
	{
	case WM_PAINT:
		{
			Show_Object();
			break;
		}
	case WM_MOVE:
		{
			OnMove((SHORT)LOWORD(Lparam),(SHORT)HIWORD(Lparam));
			RenderMain();
			break;
		}
	case WM_SIZE: 
		{
			if(SIZE_MAXHIDE != Wparam || SIZE_MINIMIZED != Wparam)
			{
				if(FAILED(CreateAllFormats(Hwnd))) //  ٽ 
					DestroyWindow(Hwnd);
			}
			RenderMain();
			break;
		}
	case WM_CLOSE:
		{
			DestroyWindow(Hwnd);
			break;
		}
	case WM_DESTROY:
		{
			ReleaseALL();
			PostQuitMessage(0);
			break;
		}
	case WM_COMMAND:
		{
			switch(Wparam)
			{
			case ID_FILEOPEN:
				{
					//  б Լ ȣ
					memset( &ofn, 0, sizeof( OPENFILENAME ) );
                    ofn.lStructSize  = sizeof( OPENFILENAME );
                    ofn.hwndOwner    = Hwnd;
					//  Ȯ 
                    ofn.lpstrFilter  = " 3D {*.u3d}\0*.u3d\0All files {*.*}\0*.*\0\0";
                    //  ̸ 
					ofn.lpstrFile    = szFileName;
                    ofn.nMaxFile     = MAX_PATH;
                    ofn.Flags        = OFN_FILEMUSTEXIST;
                    ofn.lpstrDefExt  = "u3d";
					//   ȭ ȣ
                    if ( GetOpenFileName( &ofn ) )
					{
						//  б
						File_Load_Struct(szFileName,&R_Ob,D3D_D3d,1);
						// ؽó 
						R_Ob.R_Texture = Texture_Auto_Create(D3DD_Device,R_Ob.Texter_Name,0,0);
					}
			
					RenderMain();
					break;
				}
			case ID_FILESAVE:
				{
					//   Լ ȣ
					memset( &ofn, 0, sizeof( OPENFILENAME ) );
                    ofn.lStructSize  = sizeof( OPENFILENAME );
                    ofn.hwndOwner    = Hwnd;
					//  Ȯ 
                    ofn.lpstrFilter  = " 3D {*.u3d}\0*.u3d\0All files {*.*}\0*.*\0\0";
                    //  ̸ 
					ofn.lpstrFile    = szFileName;
                    ofn.nMaxFile     = MAX_PATH;
					ofn.lpstrFileTitle = szFileTitle;
					ofn.nMaxFileTitle = MAX_PATH;
                    ofn.Flags        = OFN_PATHMUSTEXIST;
                    ofn.lpstrDefExt  = "u3d";
					//   ȭ ȣ
                    if ( GetSaveFileName( &ofn ) )
					{
						//  
						File_Load_Struct(szFileName,&R_Ob,D3D_D3d,0);
					}
					RenderMain();
					break;
				}
			case ID_EXIT: //  
				{
					DestroyWindow(Hwnd);
					return 0;
				}
			default :
					return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
			}
			break;
		}
	
	case WM_KEYDOWN:
		{
			switch((int)Wparam)
			{
			//////////////////////  ̵  ȸ /////////////////////
			case VK_LEFT:
				{
					//  ǥ Y  - ȸ
					Rotate_Matrix(Matrix_View,-10,View_Y);
					Vector_Matrix_Multiply(View_Z,Matrix_View);
					Situation_Eye(Matrix_View,View_Center,View_Z,View_Y);
					SetView_Transform(D3DD_Device,Matrix_View);
					RenderMain();
					break;
				}
			case VK_RIGHT:
				{
					//  ǥ Y  + ȸ
					Rotate_Matrix(Matrix_View,10,View_Y);
					Vector_Matrix_Multiply(View_Z,Matrix_View);
					Situation_Eye(Matrix_View,View_Center,View_Z,View_Y);
					SetView_Transform(D3DD_Device,Matrix_View);
					RenderMain();
					break;
				}
			case VK_UP:
				{
					//    ̵
					View_Center = View_Center + View_Z*(float)0.2;
					Situation_Eye(Matrix_View,View_Center,View_Z,View_Y);
					SetView_Transform(D3DD_Device,Matrix_View);
					RenderMain();
					break;
				}
			case VK_DOWN:
				{
					//  Ĺ  ̵
					View_Center = View_Center - View_Z*(float)0.2;
					Situation_Eye(Matrix_View,View_Center,View_Z,View_Y);
					SetView_Transform(D3DD_Device,Matrix_View);
					RenderMain();
					break;
				}
			default :
				return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
			}
			break;
		}

	default:
		return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
	}
	return DefWindowProc(Hwnd,uMsg,Wparam,Lparam);
}

//////////////////////////////////////////////////////////////////////////////////////
////////////////////////// D3D ʿ  ڵ  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT CreateAllFormats(HWND Hwnd)
{
	//   ʱȭ Ѵ.
	if(!ReleaseALL())
		return E_FAIL;
	// 3D ġ ʱȭѴ.
	if(SUCCEEDED(Initialize3D(Hwnd,NULL,&IID_IDirect3DRGBDevice)))
		return S_OK;
	return E_FAIL;

}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////    ٽ ʱȭ ////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
BOOL ReleaseALL(void)
{
	//     ٽ ʱȭ Ѵ.

	// ο, 3D  .
	//   ٽ ʱȭ Ѵ.
	// Ż   
	if(D3DM_Material)
	{
		D3DM_Material->Release();
		D3DM_Material = NULL;
	}
	if(D3DL_Light)
	{
		D3DL_Light->Release();
		D3DL_Light = NULL;
	}
	if(D3DV_Viewport)
	{
		D3DV_Viewport->Release();
		D3DV_Viewport		= NULL;
	}
	if(DDS_ZBuffer)
	{
		DDS_ZBuffer->Release();
		DDS_ZBuffer			= NULL;
	}
	if(D3D_D3d)
	{
		D3D_D3d->Release();
		D3D_D3d				= NULL;
	}
	if(DDS_BackBuffer)
	{
		DDS_BackBuffer->Release();
		DDS_BackBuffer		= NULL;
	}
	if(DDS_Primary)
	{
		DDS_Primary->Release();
		DDS_Primary			= NULL;
	}
	if(DD_DD4)
	{
		DD_DD4->Release();
		DD_DD4				= NULL;
	}
	if(D3DD_Device)
	{
		if(0 < D3DD_Device->Release())
			return 0;
		D3DD_Device			= NULL;
	}
	if(DD_DD1)
	{
		if(0 < DD_DD1->Release())
			return 0;
		DD_DD1				= NULL;
	}
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////  3D ġ ʱȭѴ  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT Initialize3D(HWND Hwnd,GUID* DriverGuid,const GUID* DeviceGuid)
{
	HRESULT Hr;
	DDSURFACEDESC2 ddsd;
	DDPIXELFORMAT  DDPF_Zbuffer;
	// ̷Ʈ ο(DD) 
	if(FAILED(DirectDrawCreate(DriverGuid,&DD_DD1,NULL)))
		return E_FAIL;
	// DD4 DD Ų.
	if(FAILED(DD_DD1->QueryInterface( IID_IDirectDraw4 , (VOID**)&DD_DD4 )))
		return E_FAIL;
	//  ڵ  ܰ踦 Ѵ.
	if(FAILED(DD_DD4->SetCooperativeLevel(Hwnd,DDSCL_NORMAL)))
		return E_FAIL;

	// ο ǥ  ü ʱȭ (ǥ ) 
	ZeroMemory(&ddsd,sizeof(DDSURFACEDESC2));
	ddsd.dwSize=sizeof(DDSURFACEDESC2);
	ddsd.dwFlags = DDSD_CAPS ;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE ;
	// ǥ 
	if(FAILED(DD_DD4->CreateSurface(&ddsd,&DDS_Primary,NULL)))
		return E_FAIL;

	// ο ǥ  ü ʱȭ (ĸ ) 
	ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE ;
	GetClientRect(Hwnd,&Screen_Rect);
	GetClientRect(Hwnd,&Viewport_Rect);
	ClientToScreen(Hwnd,(POINT*)&Screen_Rect.left);  // 簢 
	ClientToScreen(Hwnd,(POINT*)&Screen_Rect.right);
	ddsd.dwWidth = Screen_Rect.right - Screen_Rect.left;  //  ũ 
	ddsd.dwHeight =Screen_Rect.bottom - Screen_Rect.top;

	// ĸ   
	if(FAILED(DD_DD4->CreateSurface(&ddsd,&DDS_BackBuffer,NULL)))
		return E_FAIL;

	// Ŭ  ,  ø忡 ʿ 
	LPDIRECTDRAWCLIPPER  DDClipper;
	if(FAILED(DD_DD4->CreateClipper(0,&DDClipper,NULL)))
		return E_FAIL;
	DDClipper->SetHWnd(0,Hwnd);
	DDClipper->Release();

	// 3D DD 
	if(FAILED(DD_DD4->QueryInterface(IID_IDirect3D3,(VOID**)&D3D_D3d)))
		return E_FAIL;

	//// Z۸  ȼ ˰ 
	// 3D ġκ Z  ´.
	D3D_D3d->EnumZBufferFormats(*DeviceGuid,EnumZBufferCallback,(VOID*)&DDPF_Zbuffer);
	if( sizeof(DDPIXELFORMAT) != DDPF_Zbuffer.dwSize)// ȼ  Ȯ 
		return E_FAIL;
	//  Ÿ  Z   Z۸  ǥ desc Ѵ.
	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
	ddsd.dwWidth = Screen_Rect.right - Screen_Rect.left;  //  ũ Z 
	ddsd.dwHeight = Screen_Rect.bottom - Screen_Rect.top;
	memcpy(&ddsd.ddpfPixelFormat,&DDPF_Zbuffer,sizeof(DDPIXELFORMAT));// ã Z 
	//  ޸  
	if(IsEqualIID(*DeviceGuid,IID_IDirect3DHALDevice))
		ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;
	// ǥ  ̿Ͽ Z۸  Ų.
	if(FAILED(Hr = DD_DD4->CreateSurface(&ddsd,&DDS_ZBuffer,NULL)))
		return Hr;
	// Z۸ ĸ ۿ ̱
	if(FAILED(Hr = DDS_BackBuffer->AddAttachedSurface(DDS_ZBuffer)))
		return Hr;

	// ̽  ÷ ķƮ üũ
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	DD_DD4->GetDisplayMode(&ddsd);  // ÷  .
	if( ddsd.ddpfPixelFormat.dwRGBBitCount <= 8 ) // 16bit ÷ ̻  üũ
		return DDERR_INVALIDMODE;

	// 3D ̿Ͽ ĸ۸  3D ̽ .  
	if(FAILED(Hr = D3D_D3d->CreateDevice( *DeviceGuid,DDS_BackBuffer,&D3DD_Device,NULL)))
		return Hr;

	// 3D ̿Ͽ Ʈ 
	if(FAILED(Hr = D3D_D3d->CreateViewport(&D3DV_Viewport,NULL)))
		return Hr;
	// 3D ̽ Ʈ ߰
	D3DD_Device->AddViewport(D3DV_Viewport);
	// Ʈ Լ 
	ViewPort_Set(D3DD_Device,D3DV_Viewport,1.0f,Screen_Rect);
	//  
	Light_Material_Create(D3DD_Device,D3DV_Viewport);
	//   
	VertexSetting();
	
	return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////// Ʈ Լ //////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
BOOL ViewPort_Set(LPDIRECT3DDEVICE3 VS_3dd,LPDIRECT3DVIEWPORT3 VS_3dv,float VP_Scale,RECT VS_Rect)
{
	// Ʈ  Ķ 
	D3DVIEWPORT2 VPdata;
	ZeroMemory(&VPdata,sizeof(D3DVIEWPORT2));
	VPdata.dwSize   = sizeof(D3DVIEWPORT2);
	VPdata.dwWidth	= VS_Rect.right - VS_Rect.left;
	VPdata.dwHeight	= VS_Rect.bottom - VS_Rect.top;
	VPdata.dvClipX	= -VP_Scale;
	VPdata.dvClipY	= VP_Scale;
	VPdata.dvClipWidth	= VP_Scale*2;
	VPdata.dvClipHeight	= VP_Scale*2;
	VPdata.dvMaxZ	= VP_Scale;
	VPdata.dvMinZ	= -VP_Scale;
	// Ʈ Ķ  
	VS_3dv->SetViewport2(&VPdata);
	// ̽  Ʈ  Ѵ.
	VS_3dd->SetCurrentViewport(VS_3dv);
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////              ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
void SetWorld_Transform(LPDIRECT3DDEVICE3 W_device,D3DMATRIX& m)
{
	W_device->SetTransform(D3DTRANSFORMSTATE_WORLD,&m);
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////      þ        ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
void SetView_Transform(LPDIRECT3DDEVICE3 W_device,D3DMATRIX& m)
{
	W_device->SetTransform(D3DTRANSFORMSTATE_VIEW,&m);
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////              ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
void SetProjection_Transform(LPDIRECT3DDEVICE3 W_device)
{
	D3DMATRIX m;
	Identity_Matrix(m);
	m._11 = m._22 =1.000001327f;
	m._33 = 1000/(1000-1);
	m._34 = 1.0f;
	m._43 =-1000/(1000-1);
	m._44 = 0.0f;
	W_device->SetTransform(D3DTRANSFORMSTATE_PROJECTION,&m);
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////// Z ȼ ãԼ  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
static HRESULT WINAPI EnumZBufferCallback(DDPIXELFORMAT* DDP_Format ,VOID* DDP_Desired)
{
	// ٽ ۴ Ѵ. Z  üũѴ.
	if(DDP_Format->dwFlags == DDPF_ZBUFFER)
	{
		memcpy( DDP_Desired, DDP_Format,sizeof(DDPIXELFORMAT) );
		return D3DENUMRET_CANCEL;
	}
	return D3DENUMRET_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////     ////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT RenderMain(void)
{
	D3DRECT		ViewPort;
	D3DMATRIX	Ren_World,Ren_Trans,Ren_Rot,Ren_Scal;
	// Ʈ  Z ʱȭ
	ViewPort.x1 = Viewport_Rect.left;
	ViewPort.y1 = Viewport_Rect.top;
	ViewPort.x2 = Viewport_Rect.right;
	ViewPort.y2 = Viewport_Rect.bottom;

	D3DV_Viewport->Clear2(1UL,&ViewPort,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,0x00000000,1.0f,0L);

	//   ׸ 
	if( FAILED( D3DD_Device->BeginScene() ) )
		return E_FAIL;
	//  ׸
	Identity_Matrix(Ren_World);
	SetWorld_Transform( D3DD_Device,Ren_World); //  ǥ 
	if(R_Ob.Vertex != NULL)
	{
		D3DD_Device->SetTexture(0,R_Ob.R_Texture);
		D3DD_Device->DrawPrimitiveVB(D3DPT_TRIANGLELIST,R_Ob.Vertex,0,R_Ob.Vertex_Number,0);
	}
	// ׸ 
	D3DD_Device->EndScene();

	//  ׸  ϸ ǥ 
	if( DDERR_SURFACELOST == Show_Object() )
		RestoreSurfaces();
	return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////  ǥ   //////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT RestoreSurfaces(void)
{
	// ǥ  üũ
	if(DDS_Primary)
		if(DDS_Primary->IsLost())
			DDS_Primary->Restore();
	// ĸ  üũ 
	if(DDS_BackBuffer)
		if(DDS_BackBuffer->IsLost())
			DDS_BackBuffer->Restore();
	// Z   üũ
	if(DDS_ZBuffer)
		if(DDS_ZBuffer->IsLost())
			DDS_ZBuffer->Restore();
	return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////  Ʈ ޽ Լ //////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
HRESULT Show_Object(void)
{
	if(NULL == DDS_Primary)
		return E_FAIL;
	return DDS_Primary->Blt(&Screen_Rect,DDS_BackBuffer,&Viewport_Rect,DDBLT_WAIT,NULL);
} 

//////////////////////////////////////////////////////////////////////////////////////
///////////////////  3D  ũ 簢 ̵  /////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
VOID OnMove(INT x, INT y)
{
	DWORD dwWidth = Screen_Rect.right - Screen_Rect.left;
	DWORD dwHeight = Screen_Rect.bottom - Screen_Rect.top;
	SetRect(&Screen_Rect,x,y,x+dwWidth,y+dwHeight);//  ũ 
}

//////////////////////////////////////////////////////////////////////////////////////
///////////////////////////    Ѵ. /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
void VertexSetting()
{
	//  ǥ ʱȭ
	Light_Pos = D3DVECTOR(0.0f,5.0f,-5.0f);
	Light_Dir = D3DVECTOR(0.0f,0.0f,-1.0f);
	//  ǥ ʱȭ
	View_Center = D3DVECTOR(0.0f,0.0f,-2.0f);
	View_Z = D3DVECTOR(0.0f,0.0f,1.0f);
	View_Y = D3DVECTOR(0.0f,1.0f,0.0f);

	// ü ʱȭ 
	RestoreStruct(&R_Ob);
//	R_Ob.Vertex_Number = 0; //    
//	R_Ob.Vertex = NULL;
}

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////      Լ    /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
void  Identity_Matrix( D3DMATRIX& m)
{
	//  1  
	m._11 = m._22 = m._33 = m._44 = 1.0f;
	//  0  
	m._12 = m._13 = m._14 = 0.0f;
	m._21 = m._23 = m._24 = 0.0f;
	m._31 = m._32 = m._34 = 0.0f;
	m._41 = m._42 = m._43 = 0.0f;
}

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////      Ȯ  Լ          /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
void Scale_Matrix(D3DMATRIX& m, float Sx, float Sy, float Sz)
{
	Identity_Matrix(m);
	m._11 = Sx;
	m._22 = Sx;
	m._33 = Sx;
}

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////   ̵  ۼ Լ    /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
D3DMATRIX Translate(D3DVECTOR& Vect)
{
	D3DMATRIX ret;
	//  ķ ȯ 
	Identity_Matrix(ret);
	// ̵  ۼ
	ret._41 = Vect.x;
	ret._42 = Vect.y;
	ret._43 = Vect.z;
	// ̵  ȯ
	return ret;
}

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////    İ  Լ    /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
BOOL Vertex_Matrix_Multiply(D3DVERTEX& Vert,D3DMATRIX& m)
{
	// ӽ  
	float temp_x,temp_y,temp_z,temp_w;
	
	//   
	temp_x = m._11*Vert.x + m._21*Vert.y + m._31*Vert.z + m._41;
	temp_y = m._12*Vert.x + m._22*Vert.y + m._32*Vert.z + m._42;
	temp_z = m._13*Vert.x + m._23*Vert.y + m._33*Vert.z + m._43;
	temp_w = m._14*Vert.x + m._24*Vert.y + m._34*Vert.z + m._44;
	
	// и 0 ٻ Ȯ 
	if(fabs(temp_w)<0.00001)
		return FALSE;

	//   ȯ
	Vert.x = temp_x/temp_w;
	Vert.y = temp_y/temp_w;
	Vert.z = temp_z/temp_w;

	return TRUE;
}
//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////    İ  Լ    /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
void Matrix_Multiply(D3DMATRIX& M_c,D3DMATRIX& M_a,D3DMATRIX& M_b)
{
	D3DMATRIX M_r;
	// 1  
	M_r._11 = M_a._11*M_b._11 + M_a._12*M_b._21 + M_a._13*M_b._31 + M_a._14*M_b._41;
	M_r._21 = M_a._21*M_b._11 + M_a._22*M_b._21 + M_a._23*M_b._31 + M_a._24*M_b._41;
	M_r._31 = M_a._31*M_b._11 + M_a._32*M_b._21 + M_a._33*M_b._31 + M_a._34*M_b._41;
	M_r._41 = M_a._41*M_b._11 + M_a._42*M_b._21 + M_a._43*M_b._31 + M_a._44*M_b._41;
	// 2  
	M_r._12 = M_a._11*M_b._12 + M_a._12*M_b._22 + M_a._13*M_b._32 + M_a._14*M_b._42;
	M_r._22 = M_a._21*M_b._12 + M_a._22*M_b._22 + M_a._23*M_b._32 + M_a._24*M_b._42;
	M_r._32 = M_a._31*M_b._12 + M_a._32*M_b._22 + M_a._33*M_b._32 + M_a._34*M_b._42;
	M_r._42 = M_a._41*M_b._12 + M_a._42*M_b._22 + M_a._43*M_b._32 + M_a._44*M_b._42;
	// 3  
	M_r._13 = M_a._11*M_b._13 + M_a._12*M_b._23 + M_a._13*M_b._33 + M_a._14*M_b._43;
	M_r._23 = M_a._21*M_b._13 + M_a._22*M_b._23 + M_a._23*M_b._33 + M_a._24*M_b._43;
	M_r._33 = M_a._31*M_b._13 + M_a._32*M_b._23 + M_a._33*M_b._33 + M_a._34*M_b._43;
	M_r._43 = M_a._41*M_b._13 + M_a._42*M_b._23 + M_a._43*M_b._33 + M_a._44*M_b._43;
	// 4  
	M_r._14 = M_a._11*M_b._14 + M_a._12*M_b._24 + M_a._13*M_b._34 + M_a._14*M_b._44;
	M_r._24 = M_a._21*M_b._14 + M_a._22*M_b._24 + M_a._23*M_b._34 + M_a._24*M_b._44;
	M_r._34 = M_a._31*M_b._14 + M_a._32*M_b._24 + M_a._33*M_b._34 + M_a._34*M_b._44;
	M_r._44 = M_a._41*M_b._14 + M_a._42*M_b._24 + M_a._43*M_b._34 + M_a._44*M_b._44;
	M_c = M_r;
}
//////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////    İ  Լ    /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
BOOL Vector_Matrix_Multiply(D3DVECTOR& Vect,D3DMATRIX& m)
{
	// ӽ  
	float temp_x,temp_y,temp_z,temp_w;
	
	//   
	temp_x = m._11*Vect.x + m._21*Vect.y + m._31*Vect.z + m._41;
	temp_y = m._12*Vect.x + m._22*Vect.y + m._32*Vect.z + m._42;
	temp_z = m._13*Vect.x + m._23*Vect.y + m._33*Vect.z + m._43;
	temp_w = m._14*Vect.x + m._24*Vect.y + m._34*Vect.z + m._44;
	
	// и 0 ٻ Ȯ 
	if(fabs(temp_w)<0.00001)
		return FALSE;

	//   ȯ
	Vect.x = temp_x/temp_w;
	Vect.y = temp_y/temp_w;
	Vect.z = temp_z/temp_w;

	return TRUE;
}
//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////    ǥ  ȸ Լ   /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
void Rotate_Matrix(D3DMATRIX& m, float Angl, int XYZType)
{
	float temp_sin,temp_cos;
	temp_sin = (float)sin(3.141592/180*Angl);
	temp_cos = (float)cos(3.141592/180*Angl);
	Identity_Matrix(m);
	if(XYZType == 0)
	{
		// X ȸ
		m._22 = temp_cos;
		m._23 = temp_sin;
		m._32 =-temp_sin;
		m._33 = temp_cos;
	}
	else if(XYZType == 1)
	{
		// Y ȸ
		m._11 = temp_cos;
		m._13 =-temp_sin;
		m._31 = temp_sin;
		m._33 = temp_cos;
	}
	else
	{
		// Z ȸ
		m._11 = temp_cos;
		m._12 = temp_sin;
		m._21 =-temp_sin;
		m._22 = temp_cos;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////  Ϳ  ȸ  Լ  //////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
void Rotate_Matrix( D3DMATRIX& mat, float Angl, D3DVECTOR& vDir)
{
    FLOAT     Temp_Cos = (FLOAT)cos( 3.141592/180*Angl );
    FLOAT     Temp_Sin = (FLOAT)sin( 3.141592/180*Angl );
    D3DVECTOR v    = Normalize( vDir );
    // X ǥ ȯ
    mat._11 = ( v.x * v.x ) * ( 1.0f - Temp_Cos ) + Temp_Cos;
    mat._21 = ( v.x * v.y ) * ( 1.0f - Temp_Cos ) - (v.z * Temp_Sin);
    mat._31 = ( v.x * v.z ) * ( 1.0f - Temp_Cos ) + (v.y * Temp_Sin);
    // Y ǥ ȯ
    mat._12 = ( v.y * v.x ) * ( 1.0f - Temp_Cos ) + (v.z * Temp_Sin);
    mat._22 = ( v.y * v.y ) * ( 1.0f - Temp_Cos ) + Temp_Cos ;
    mat._32 = ( v.y * v.z ) * ( 1.0f - Temp_Cos ) - (v.x * Temp_Sin);
    // Z ǥ ȯ
    mat._13 = ( v.z * v.x ) * ( 1.0f - Temp_Cos ) - (v.y * Temp_Sin);
    mat._23 = ( v.z * v.y ) * ( 1.0f - Temp_Cos ) + (v.x * Temp_Sin);
    mat._33 = ( v.z * v.z ) * ( 1.0f - Temp_Cos ) + Temp_Cos;
    
    mat._14 = mat._24 = mat._34 = 0.0f;
    mat._41 = mat._42 = mat._43 = 0.0f;
    mat._44 = 1.0f;
} 
//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////      ǥ  Լ        /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
BOOL Situation_Eye(D3DMATRIX& m,D3DVECTOR& eye_sit,D3DVECTOR& eye_Z,D3DVECTOR& eye_Y)
{
	//  ǥ X 
	D3DVECTOR eye_X = CrossProduct(eye_Y,eye_Z);
	//  ǥ ȯ  
	Identity_Matrix(m);
	m._11 = eye_X.x;	m._21 = eye_X.y;	m._31 = eye_X.z; 
	m._12 = eye_Y.x;	m._22 = eye_Y.y;	m._32 = eye_Y.z;
	m._13 = eye_Z.x;	m._23 = eye_Z.y;	m._33 = eye_Z.z;
	//  ġ   ( ǥ࿡ )
	m._41 = -DotProduct(eye_sit,eye_X);
	m._42 = -DotProduct(eye_sit,eye_Y);
	m._43 = -DotProduct(eye_sit,eye_Z);
	return TRUE;
}
//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////        Լ      /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
HRESULT Light_Setting(LPDIRECT3DLIGHT LS_Light,D3DVECTOR& L_Pos,D3DVECTOR& L_Dir)
{
	D3DLIGHT2			light;   // ü
	
	// ü ʱȭ
	ZeroMemory(&light,sizeof(D3DLIGHT2)); 
	light.dwSize	= sizeof(D3DLIGHT2);

	LS_Light->GetLight((LPD3DLIGHT)&light);
	//  
	light.dltType	= D3DLIGHT_PARALLELPOINT;
	//  
	light.dcvColor.r	= 1.0f;
	light.dcvColor.g	= 1.0f;
	light.dcvColor.b	= 1.0f;
	//  ġ  
	light.dvPosition = L_Pos;
	light.dvDirection = L_Dir;
	//  
	light.dvAttenuation0 = 1.0f;
	light.dvAttenuation1 = 1.0f;
	light.dvAttenuation2 = 1.0f;
	//  Ÿ (Directional parallel-Point  )
//	light.dvRange = 1.0f;
	// Ʈ Ʈ  
//	light.dvFalloff = 100.0f;
	// Ʈ Ʈ  
//	light.dvTheta = (float)3.141592/180*30;
//	light.dvPhi = (float)3.141592/180*50;

	LS_Light->SetLight((LPD3DLIGHT)&light); // ü ֱ 

	return S_OK;
}
//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////       Լ     ///////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
HRESULT Material_Setting(LPDIRECT3DMATERIAL3 MS_Material )
{
	D3DMATERIAL				Mater_C;	

	ZeroMemory(&Mater_C,sizeof(D3DMATERIAL));
	Mater_C.dwSize	= sizeof(D3DMATERIAL);
	MS_Material->GetMaterial(&Mater_C);
	//
	Mater_C.dcvDiffuse.r = 1.0f;
	Mater_C.dcvDiffuse.g = 1.0f;
	Mater_C.dcvDiffuse.b = 1.0f;
	Mater_C.dcvDiffuse.a = 1.0f;
	//
	Mater_C.dcvAmbient.r = 1.0f;
	Mater_C.dcvAmbient.g = 1.0f;
	Mater_C.dcvAmbient.b = 1.0f;
	Mater_C.dcvAmbient.a = 1.0f;
	//
	Mater_C.dcvSpecular.r = 0.0f;
	Mater_C.dcvSpecular.g = 1.0f;
	Mater_C.dcvSpecular.b = 0.0f;
	Mater_C.dcvSpecular.a = 1.0f;
	// 
	D3DM_Material->SetMaterial(&Mater_C); // Ż ü Է

	return S_OK;
}
//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////      ʱ Լ  //////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
HRESULT Light_Material_Create(LPDIRECT3DDEVICE3 LM_Device,LPDIRECT3DVIEWPORT3 LM_Viewport)
{
	LPDIRECT3D3				LM_D3D;
	D3DMATERIAL				Mater;	
	D3DMATERIALHANDLE		HMater;
	D3DLIGHT2 light;   // ü

	if( FAILED(LM_Device->GetDirect3D(&LM_D3D) ))  // 3D  ´.
		return E_FAIL;
	LM_D3D->Release();
	if( FAILED(LM_D3D->CreateMaterial(&D3DM_Material,NULL)) ) // Ż Ų.
		return E_FAIL;
	// Ż ü 
	ZeroMemory(&Mater,sizeof(D3DMATERIAL));
	Mater.dwSize	= sizeof(D3DMATERIAL);
	Mater.dcvDiffuse.r=1.0f;
	Mater.dcvDiffuse.g=1.0f;
	Mater.dcvDiffuse.b=1.0f;
	Mater.dcvAmbient.r=1.0f;
	Mater.dcvAmbient.g=1.0f;
	Mater.dcvAmbient.b=1.0f;
	Mater.dcvSpecular.r = 0.0f;
	Mater.dcvSpecular.g = 1.0f;
	Mater.dcvSpecular.b = 0.0f;
	Mater.power = 40.0f;
	D3DM_Material->SetMaterial(&Mater); // Ż ü Է
	D3DM_Material->GetHandle(LM_Device,&HMater);	// Ż ڵ ´.
	LM_Device->SetLightState(D3DLIGHTSTATE_MATERIAL,HMater); 
	LM_Device->SetLightState(D3DLIGHTSTATE_AMBIENT ,0x20202020); 

	//   
	LM_Device->SetRenderState(D3DRENDERSTATE_ZENABLE,TRUE); // Z 밡
	LM_Device->SetRenderState(D3DRENDERSTATE_TEXTUREPERSPECTIVE,TRUE); // ؽó  
	LM_Device->SetRenderState(D3DRENDERSTATE_DITHERENABLE,TRUE);       //  밡
	LM_Device->SetRenderState(D3DRENDERSTATE_SPECULARENABLE,FALSE);    // ť 
	LM_Device->SetRenderState(D3DRENDERSTATE_TEXTUREADDRESS, D3DTADDRESS_CLAMP );
	// ؽó  
    LM_Device->SetTextureStageState(0,D3DTSS_COLORARG1,D3DTA_TEXTURE );
    LM_Device->SetTextureStageState(0,D3DTSS_COLORARG2,D3DTA_DIFFUSE );
    LM_Device->SetTextureStageState(0,D3DTSS_COLOROP,D3DTOP_MODULATE );
	LM_Device->SetTextureStageState(0,D3DTSS_ALPHAARG1,D3DTA_TEXTURE);
	LM_Device->SetTextureStageState(0,D3DTSS_ALPHAOP,D3DTOP_SELECTARG1);
	LM_Device->SetTextureStageState(0,D3DTSS_TEXCOORDINDEX,0); 

	LM_Device->SetTextureStageState(0,D3DTSS_MINFILTER,D3DTFN_LINEAR);// ؽ 
	LM_Device->SetTextureStageState(0,D3DTSS_MAGFILTER,D3DTFG_LINEAR);

	//   
	D3DMATRIX World_Mat;
	Identity_Matrix( World_Mat);
	SetWorld_Transform(LM_Device,World_Mat);
	// þ  
	Situation_Eye(Matrix_View,View_Center,View_Z,View_Y);
	SetView_Transform(LM_Device,Matrix_View);
	//   
	SetProjection_Transform(LM_Device);

	//  
	if(FAILED(LM_D3D->CreateLight(&D3DL_Light,NULL))) //  
		return E_FAIL;
	ZeroMemory(&light,sizeof(D3DLIGHT)); // ü ʱȭ
	light.dwSize	= sizeof(D3DLIGHT);
	light.dltType	= D3DLIGHT_PARALLELPOINT;
	light.dcvColor.r	= 1.0f;
	light.dcvColor.g	= 1.0f;
	light.dcvColor.b	= 1.0f;
	//  ġ  
	light.dvPosition = Light_Pos;
	light.dvDirection = Light_Dir;
	//  
	light.dvAttenuation0 = 1.0f;
	light.dvAttenuation1 = 1.0f;
	light.dvAttenuation2 = 1.0f;
	//  Ÿ (Directional parallel-Point  )
//	light.dvRange = 1.0f;
	// Ʈ Ʈ  
//	light.dvFalloff = 100.0f;
	// Ʈ Ʈ  
//	light.dvTheta = (float)3.141592/180*30;
//	light.dvPhi = (float)3.141592/180*50;

	D3DL_Light->SetLight((LPD3DLIGHT)&light); // ü ֱ 
	LM_Viewport->AddLight(D3DL_Light); //  Ʈ ߰Ѵ.

	return S_OK;
}