#define	STRICT
#define	D3D_OVERLOADS
#include <windows.h>
#include <math.h>
#include <d3d.h>
#include "File_3DS.h"

////////////////////   ε   ////////////////////
const unsigned short	HEADER_3DS				= 0x4d4d;
const unsigned short	VERSION_3DS				= 0x0002;
const unsigned short	MODEL_3DS				= 0x3d3d;
const unsigned short	MESH_VERSION			= 0x3d3e;
const unsigned short	MATERIAL_OJ				= 0xafff;
const unsigned short	OJ_SCALE				= 0x0100;
const unsigned short	OJ_DATA					= 0x4000;
const unsigned short	MATERIAL_NAME			= 0xa000;
const unsigned short	MATERIAL_AMBIENT		= 0xa010;
const unsigned short	MATERIAL_DIFFUSE		= 0xa020;
const unsigned short	MATERIAL_SPECULAR		= 0xa030;
const unsigned short	MATERIAL_SHININESS		= 0xa040;
const unsigned short	MATERIAL_TRANSPARENCY	= 0xa050;
const unsigned short	MATERIAL_SHADING		= 0xa100;
const unsigned short    MATERIAL_BMP			= 0xa200;
const unsigned short    MATERIAL_BMPNAME		= 0xa300;
const unsigned short	OBJECT_DATA				= 0x4100;
const unsigned short	OBJECT_POINT			= 0x4110;
const unsigned short	OBJECT_INDEX			= 0x4120;
const unsigned short	OBJECT_MAT				= 0x4130;
const unsigned short	OBJECT_POINT_UV			= 0x4140;
const unsigned short	MESH_MATRIX				= 0x4160;
const unsigned short	COLOR_BYTE				= 0x0011;
const unsigned short	COLOR_BYTE_R3			= 0x0012;
const unsigned short	COLOR_FLOAT				= 0x0010;
const unsigned short	COLOR_FLOAT_R3			= 0x0013;
const unsigned short	PERCENTAGE_INT			= 0x0030;
const unsigned short	PERCENTAGE_FLOAT		= 0x0031;

/////////////////////    ////////////////////////////
extern	ObjectSturct	Oj_St;		// 3DS  ü
extern	ObjectMaterial	Oj_Mt[40];	// 3DS  ü
DWORD	FileLocal;					//  ġ
BOOL	FileEndBool;				//   Ȯ 
extern int	Mt_Number;				//  
///////////////////  Լ  //////////////////////////
BOOL Header_3DS(HANDLE File_3DS);
BOOL Version_3DS(HANDLE File_3DS);
BOOL Model_3DS(HANDLE File_3DS);
BOOL Version_Mesh(HANDLE File_3DS);
BOOL Material_3DS(HANDLE File_3DS,DWORD Len);
BOOL Scale_3DS(HANDLE File_3DS);
BOOL Object_3DS(HANDLE File_3DS);
BOOL Object_Data(HANDLE File_3DS);
BOOL StringLoad_Object(HANDLE File_3DS,char* Object_Name);
BOOL AutoNormal_Create(void);

/////////////////////////////////////////////////////////////
///////////////////// 3DS  б Լ ////////////////////
/////////////////////////////////////////////////////////////
BOOL FileOpen_3DS(LPTSTR F_name)
{
	HANDLE			File_3ds;
	DWORD			F_Size;
	FileLocal = 0;
	//  
	File_3ds = CreateFile(F_name,GENERIC_READ,0,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(INVALID_HANDLE_VALUE != File_3ds)
	{
		//  ü ũ 
		F_Size=GetFileSize(File_3ds,NULL);
		// б 
		if(!Header_3DS(File_3ds))
		{
			CloseHandle(File_3ds);
			return FALSE;
		}
		//  Ȯ
		if(!Version_3DS(File_3ds))
		{
			CloseHandle(File_3ds);
			return FALSE;
		}
		//   б 
		if(!Model_3DS(File_3ds))
		{
			CloseHandle(File_3ds);
			return FALSE;
		}
	}
	CloseHandle(File_3ds);
	return TRUE;
}
/////////////////////////////////////////////////////////////
///////////////////// 3DS  б Լ ////////////////////
/////////////////////////////////////////////////////////////
BOOL Header_3DS(HANDLE File_3DS)
{
	unsigned short	He;			// ε Ȯ 
	DWORD			Len,TempF;  // ûũ ũ, ӽ  

	//  б 
	ReadFile(File_3DS,&He,2,&TempF,NULL);
	ReadFile(File_3DS,&Len,4,&TempF,NULL);
	if(He == HEADER_3DS)
	{
		FileLocal=FileLocal+6;
		return TRUE;
	}
	return FALSE;
}
/////////////////////////////////////////////////////////////
/////////////////////   б Լ ///////////////////
/////////////////////////////////////////////////////////////
BOOL Version_3DS(HANDLE File_3DS)
{
	unsigned short	He;			// ε Ȯ 
	DWORD			Len,TempF;  // ûũ ũ, ӽ  

	//  б
	ReadFile(File_3DS,&He,2,&TempF,NULL);
	ReadFile(File_3DS,&Len,4,&TempF,NULL);
	if(He == VERSION_3DS)
	{
		ReadFile(File_3DS,&Oj_St.D_Version,4,&TempF,NULL);
		FileLocal=FileLocal+10;
		return TRUE;
	}
	return FALSE;
}
/////////////////////////////////////////////////////////////
//////////////////   б Լ  ///////////////////
/////////////////////////////////////////////////////////////
BOOL Model_3DS(HANDLE File_3DS)
{
	unsigned short	He;			// ε Ȯ 
	DWORD			Len,TempF;  // ûũ ũ, ӽ  

	//   ʱȭ
	Mt_Number = 0;

	//  б
	ReadFile(File_3DS,&He,2,&TempF,NULL);
	ReadFile(File_3DS,&Len,4,&TempF,NULL);
	//   ġ 
	FileLocal=FileLocal+6;
	// ûũ Ȯ
	if(He == MODEL_3DS)
	{
		FileEndBool=TRUE;
		while(FileEndBool)
		{
			//   б
			ReadFile(File_3DS,&He,2,&TempF,NULL);
			ReadFile(File_3DS,&Len,4,&TempF,NULL);
			//   ġ 
			FileLocal=FileLocal+6;
			// ûũ Ȯ  б
			switch(He)
			{
			case MESH_VERSION:// ޽  б 
				{
					// ޽  б
					if(!Version_Mesh(File_3DS))
						return FALSE;
					break;
				}
			case MATERIAL_OJ://  ûũ Ȯ 
				{
					//   
					Mt_Number=Mt_Number+1;
					//   б
					if(!Material_3DS(File_3DS,Len))
						return FALSE;
					break;
				}
			case OJ_SCALE:	//  ũ ûũ Ȯ
				{
					//  б Լ ȣ
					if(!Scale_3DS(File_3DS))
						return FALSE;
					break;
				}
			case OJ_DATA:	//   ûũ Ȯ
				{
					//   б Լ
					if(!Object_3DS(File_3DS))
						return FALSE;
					break;
				}
			default :
				break;		
			}
		}
		return TRUE;
	}
	return FALSE;
}
/////////////////////////////////////////////////////////////
////////////////// ޽  б  //////////////////////////
/////////////////////////////////////////////////////////////
BOOL Version_Mesh(HANDLE File_3DS)
{
	DWORD		TempF; // ӽ  
	// ޽  б
	if(ReadFile(File_3DS,&Oj_St.M_Version,4,&TempF,NULL))
	{
		//   ġ 
		FileLocal=FileLocal+4;
		return TRUE;
	}
	return FALSE;
}
/////////////////////////////////////////////////////////////
//////////////////  ûũ б  //////////////////////////
/////////////////////////////////////////////////////////////
BOOL Material_3DS(HANDLE File_3DS,DWORD Len)
{
	unsigned short	He;	// ε Ȯ 
	DWORD			TempF;	// ӽ 
	// ݺ Ȯ 
	DWORD			Mat_Loof;

	//  ûũ    
	Mat_Loof = FileLocal+Len-6;

	// ݺ Ȯ
	while(Mat_Loof > FileLocal)
	{
		// ûũ  б
		ReadFile(File_3DS,&He,2,&TempF,NULL);  
		ReadFile(File_3DS,&Len,4,&TempF,NULL);
		//    
		FileLocal=FileLocal+6;
		// ûũ Ȯ 
		switch(He)
		{
		case MATERIAL_NAME: //  ̸ б
			{
				//  ̸ б
				ReadFile(File_3DS,Oj_Mt[Mt_Number-1].Mat_Name,Len-6,&TempF,NULL);
				//    
				FileLocal=FileLocal+Len-6;
				break;
			}
		case MATERIAL_AMBIENT: // Ambient б
			{
				// ûũ  б
				ReadFile(File_3DS,&He,2,&TempF,NULL);
				ReadFile(File_3DS,&Len,4,&TempF,NULL);
				//    
				FileLocal=FileLocal+9;
				if(He == COLOR_BYTE) //  Ȯ 
					ReadFile(File_3DS,Oj_Mt[Mt_Number-1].Am,3,&TempF,NULL);
				else
					return FALSE;
				break;
			}
		case MATERIAL_DIFFUSE: // Diffuse б
			{
				// ûũ  б
				ReadFile(File_3DS,&He,2,&TempF,NULL);
				ReadFile(File_3DS,&Len,4,&TempF,NULL);
				//    
				FileLocal=FileLocal+9;
				if(He == COLOR_BYTE) //  Ȯ 
					ReadFile(File_3DS,Oj_Mt[Mt_Number-1].Di,3,&TempF,NULL);
				else
					return FALSE;
				break;
			}
		case MATERIAL_SPECULAR: // Speculer б
			{
				// ûũ  б
				ReadFile(File_3DS,&He,2,&TempF,NULL);
				ReadFile(File_3DS,&Len,4,&TempF,NULL);
				//    
				FileLocal=FileLocal+9;
				if(He == COLOR_BYTE) //  Ȯ 
					ReadFile(File_3DS,Oj_Mt[Mt_Number-1].Sp,3,&TempF,NULL);
				else
					return FALSE;
				break;
			}
		case MATERIAL_SHININESS: // shininess б
			{
				// ûũ  б
				ReadFile(File_3DS,&He,2,&TempF,NULL);
				ReadFile(File_3DS,&Len,4,&TempF,NULL);
				//    
				FileLocal=FileLocal+8;
				if(He == PERCENTAGE_INT) //  Ȯ 
					ReadFile(File_3DS,&Oj_Mt[Mt_Number-1].Shi,2,&TempF,NULL);
				else
					return FALSE;
				break;
			}
		case MATERIAL_TRANSPARENCY: // Transparency б
			{
				ReadFile(File_3DS,&He,2,&TempF,NULL);
				ReadFile(File_3DS,&Len,4,&TempF,NULL);
				FileLocal=FileLocal+8;
				if(He == PERCENTAGE_INT) //  Ȯ 
					ReadFile(File_3DS,&Oj_Mt[Mt_Number-1].Tra,2,&TempF,NULL);
				else
					return FALSE;
				break;
			}
		case MATERIAL_SHADING: // Shading б
			{
				ReadFile(File_3DS,&Oj_Mt[Mt_Number-1].Sha,2,&TempF,NULL);
				FileLocal=FileLocal+2;
				break;
			}
		case MATERIAL_BMP:	// Ʈ б
			{
				SetFilePointer(File_3DS,8,NULL,FILE_CURRENT);
				FileLocal=FileLocal+8;
				// ûũ  б
				ReadFile(File_3DS,&He,2,&TempF,NULL);
				ReadFile(File_3DS,&Len,4,&TempF,NULL);
				FileLocal=FileLocal+6;
				// ε Ȯ 
				if(He != MATERIAL_BMPNAME)
					return FALSE;
				StringLoad_Object(File_3DS,Oj_Mt[Mt_Number-1].Bmp_Name);
				//  ʴ  
				SetFilePointer(File_3DS,18,NULL,FILE_CURRENT);
				FileLocal=FileLocal+18;
				break;
			}
		default : 
			{
				if(Len>6)
				{
					SetFilePointer(File_3DS,Len-6,NULL,FILE_CURRENT);
					FileLocal=FileLocal+Len-6;
				}
				break;
			}
		}
	
	}
	return TRUE;
}
/////////////////////////////////////////////////////////////
//////////////////  ûũ б  ////////////////////////
/////////////////////////////////////////////////////////////
BOOL Scale_3DS(HANDLE File_3DS)
{
	DWORD		TempF; // ӽ 

	//  б
	if(ReadFile(File_3DS,&Oj_St.Scale_F_Mast,4,&TempF,NULL))
	{
		FileLocal=FileLocal+4;
		return TRUE;
	}
	return FALSE;
}
/////////////////////////////////////////////////////////////
////////////////////  ûũ б ///////////////////////
/////////////////////////////////////////////////////////////
BOOL Object_3DS(HANDLE File_3DS)
{
	//  ̸ б
	if(!StringLoad_Object(File_3DS,Oj_St.Object_Name))
		return FALSE;
	//   б
	if(!Object_Data(File_3DS))
		return FALSE; //  ȣ
	return TRUE;
}
/////////////////////////////////////////////////////////////
//////////////////// ڿ б Լ ///////////////////////
/////////////////////////////////////////////////////////////
BOOL StringLoad_Object(HANDLE File_3DS,char* Object_Name)
{
	DWORD		TempF; // ӽ 
	int			i=0;
	// ڿ б
	while(ReadFile(File_3DS,&Object_Name[i],1,&TempF,NULL))
	{
		FileLocal=FileLocal+1;
		if( Object_Name[i] == 0x00 )
			break;
		i=i+1;
	}
	return TRUE;
}
/////////////////////////////////////////////////////////////
////////////////////  б Լ ///////////////////////
/////////////////////////////////////////////////////////////
BOOL Object_Data(HANDLE File_3DS)
{
	unsigned short He;	// ε Ȯ 
	DWORD		Len,TempF; // ûũ ũ, ӽ 
	DWORD		Data_Loof; // ݺ  
    WORD		Index_Temp,Number_Mat=0;
	char		Mat_Group_Name[32];


	// OBJECT_DATA б 
	ReadFile(File_3DS,&He,2,&TempF,NULL);
	ReadFile(File_3DS,&Len,4,&TempF,NULL);
	// OBJECT_DATA ûũ  
	Data_Loof = FileLocal + Len;
	//   
	FileLocal = FileLocal + 6;
	if(He == OBJECT_DATA) // ID Ȯ 0x4100
	{
		//  б ݺ
		while( FileLocal < Data_Loof)
		{
			// ûũ  б
			ReadFile(File_3DS,&He,2,&TempF,NULL);
			ReadFile(File_3DS,&Len,4,&TempF,NULL);
			FileLocal = FileLocal + 6;
			switch(He)
			{
			case OBJECT_POINT:// OBJECT_POINT б  0x4110
				{
					//   б 
					ReadFile(File_3DS,&Oj_St.Point_Number,2,&TempF,NULL);
					FileLocal = FileLocal + 2;
					//  ǥ б 
					for(int i =0 ; i < Oj_St.Point_Number; i++)
					{
						ReadFile(File_3DS,Oj_St.Point_Array[i],12,&TempF,NULL);
						FileLocal = FileLocal + 12;
					}
					break;
				}
			case OBJECT_INDEX: // OBJECT_INDEX б   0x4120
				{
					// ε  б 
					ReadFile(File_3DS,&Oj_St.Index_Number,2,&TempF,NULL);
					FileLocal = FileLocal + 2;
					int ii=0;
					for(int i =0 ; i < Oj_St.Index_Number*4; i++)// ǥ б 
					{
						if(3 == i%4)//  U ؽ Wrap 
							ReadFile(File_3DS,&Index_Temp,2,&TempF,NULL);
						else
						{ // 3 ε 
							ReadFile(File_3DS,&Oj_St.Index_Array[ii],2,&TempF,NULL);
							ii=ii+1;
						}
						FileLocal = FileLocal + 2;
					}
					break;
				}
			case OBJECT_MAT:	// OBJECT_MAT б 0x4130  
				{  
					// ޽  ׷ ̸
					if(!StringLoad_Object(File_3DS,Mat_Group_Name))
						return FALSE;
					for(int ii = 0 ; ii < Mt_Number ; ii ++)
					{ // Ż ȣ ã 
						if( 2  == CompareString(LOCALE_SYSTEM_DEFAULT ,SORT_STRINGSORT,Mat_Group_Name,-1,Oj_Mt[ii].Mat_Name,-1) )
							Number_Mat = ii;
					}
					//  face  б
					ReadFile(File_3DS,&Oj_Mt[Number_Mat].Mat_Number,2,&TempF,NULL);
					FileLocal = FileLocal + 2;
					for(int i =0 ; i < Oj_Mt[Number_Mat].Mat_Number; i++)
					{
						// face ȣ  
						ReadFile(File_3DS,&Oj_Mt[Number_Mat].Mat_Array[i],2,&TempF,NULL); 
						FileLocal = FileLocal + 2;
					}
					// 迭 б
					break;
				}
			case OBJECT_POINT_UV:  // UV б 0x4140
				{
					//  б 
					ReadFile(File_3DS,&Oj_St.UV_Number,2,&TempF,NULL);
					FileLocal = FileLocal + 2;
					// ؽó ǥ б 
					for(int i =0 ; i < Oj_St.UV_Number; i++)
					{
						ReadFile(File_3DS,&Oj_St.UV_Point_Array[i][0],4,&TempF,NULL);
						ReadFile(File_3DS,&Oj_St.UV_Point_Array[i][1],4,&TempF,NULL);
						FileLocal = FileLocal + 8;
					}
					break;
				}
			case MESH_MATRIX:  //   б
				{
					float TempMatrix;
					for(int m=0;m<12;m++)
					{
						ReadFile(File_3DS,&TempMatrix,4,&TempF,NULL);
						FileLocal=FileLocal+4;
					}
					break;
				}
			default:
				{
					if(Len>6)
					{
						SetFilePointer(File_3DS,Len-6,NULL,FILE_CURRENT);
						FileLocal=FileLocal+Len-6;
					}
					break;
				}
			}
		}
		// Vertex Normal ڵ  
		AutoNormal_Create(); 
		FileEndBool = FALSE;
		return TRUE;
	}
	return FALSE;
}
/////////////////////////////////////////////////////////////
//////////////////   Normal ڵ   //////////////////////
/////////////////////////////////////////////////////////////
BOOL AutoNormal_Create(void)
{
	D3DVECTOR	TempFace1,TempFace2;
	//    
	D3DVECTOR	*FaceNormal;
	FaceNormal = (D3DVECTOR*)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,sizeof(D3DVECTOR)*Oj_St.Index_Number);
	//     
	for(int i=0; i< Oj_St.Index_Number; i++)
	{
		//  1 2  1 
		TempFace1 = D3DVECTOR(Oj_St.Point_Array[Oj_St.Index_Array[i*3+1]][0],Oj_St.Point_Array[Oj_St.Index_Array[i*3+1]][1],Oj_St.Point_Array[Oj_St.Index_Array[i*3+1]][2])
			- D3DVECTOR(Oj_St.Point_Array[Oj_St.Index_Array[i*3]][0],Oj_St.Point_Array[Oj_St.Index_Array[i*3]][1],Oj_St.Point_Array[Oj_St.Index_Array[i*3]][2]);
		//  1 3  2 
		TempFace2 = D3DVECTOR(Oj_St.Point_Array[Oj_St.Index_Array[i*3+2]][0],Oj_St.Point_Array[Oj_St.Index_Array[i*3+2]][1],Oj_St.Point_Array[Oj_St.Index_Array[i*3+2]][2])
			- D3DVECTOR(Oj_St.Point_Array[Oj_St.Index_Array[i*3]][0],Oj_St.Point_Array[Oj_St.Index_Array[i*3]][1],Oj_St.Point_Array[Oj_St.Index_Array[i*3]][2]);
		//  1 2  ﰢ   
		FaceNormal[i] = Normalize(CrossProduct(TempFace1,TempFace2));
	}
	//    
	for(int j=0 ; j < Oj_St.Point_Number ; j++)
	{
		//    
		int Temp_Number = 0;
		//    ȣ ϴ 迭
		int Point_NN[10];
		for (int n=0; n < Oj_St.Index_Number*3 ; n++)
		{
			//  ȣ  ε  
			if( (j==(int)Oj_St.Index_Array[n])&&(Temp_Number<10))
			{
				//   
				Temp_Number = Temp_Number + 1;
				//  ȣ 
				Point_NN[Temp_Number-1] = n/3;
			}
		}
		//    
		Oj_St.Normal_Array[j] = D3DVECTOR(0.0f,0.0f,0.0f);
		for(int k=0; k<Temp_Number; k++ )
		{
			Oj_St.Normal_Array[j] = Normalize(Oj_St.Normal_Array[j] + FaceNormal[Point_NN[k]]);
		}
	}
	return TRUE;
}