#include <afxwin.h>
#include <afxcmn.h>			// MFC support for Windows Common Controls

//////////////////////////////////////////////////////////////////////////
#include 	<io.h>
#include 	<direct.h>

#define APP_TITLE	"Transparency -> Zero index"

long TotalCount;
long CurrentCount;
CString MessageString;

#define MAKE_DIR	"bmp\\"
struct _finddata_t ffblk;
long   hFile;

void InitMake();
int  Make();
//////////////////////////////////////////////////////////////////////////
void InitMake()
{
/*	_mkdir( MAKE_DIR );*/

	CurrentCount=0;
	TotalCount=0;

    if( (hFile = _findfirst( "*.bmp", &ffblk )) != -1L )
	{
		do{ 
			TotalCount++; 
		}while( _findnext( hFile, &ffblk ) == 0 );	 
	};
    _findclose( hFile );

	hFile = _findfirst( "*.bmp", &ffblk );
};

void MakeZeroColor( CString infilename, CString outputname );
int Make()
{
	CString filename;
	CString outfilename;

	filename = ffblk.name;
	outfilename = MAKE_DIR + filename;
	MessageString = filename;
	/////////////////////////////////////////////////

	//MakeZeroColor( filename, outfilename );
	MakeZeroColor( filename, filename );

	/////////////////////////////////////////////////
	CurrentCount++;
	if( _findnext( hFile, &ffblk ) != 0 )
	{
	    _findclose( hFile );
		return 0;
	};
	return 1;
};

/////////////////////////////////////////////////////////////////////////////
#ifndef _MAIN_CPP
#define _MAIN_CPP

class CMainApp : public CWinApp
{
public:
	CMainApp(){};

// Overrides
	//{{AFX_VIRTUAL(CMainApp)
	public:
	virtual BOOL InitInstance();
	virtual int	 Run();
	//}}AFX_VIRTUAL
};

class CMainFrame : public CFrameWnd
{
public:
	DECLARE_DYNCREATE(CMainFrame)

	CMainFrame();
	virtual ~CMainFrame();

	CProgressCtrl	m_Progress;

protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only CMainApp object
CMainApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMainApp initialization

BOOL CMainApp::InitInstance()
{
	InitMake();

	m_pMainWnd = new CMainFrame;
	if( m_pMainWnd==NULL ) return FALSE;
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}
//////////////////////////////////////////////////////////////////
static CString Run_MessageString;
int CMainApp::Run() 
{
	BOOL bDoingBackgroundProcessing=TRUE;
	int  make_result;

	while ( bDoingBackgroundProcessing ) 
	{ 
		MSG msg;
		
		LONG lIdle = 0;
		while ( OnIdle(lIdle++ ) );  

		while ( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) 
		{ 
			if ( !PumpMessage( ) ) 
			{ 
				bDoingBackgroundProcessing = FALSE; 
				::PostQuitMessage(0); 
				break; 
			} 
		} 
    // let MFC do its idle processing
		make_result = Make();
		if( CurrentCount<=1 || Run_MessageString!=MessageString )
		{
			m_pMainWnd->Invalidate();
			m_pMainWnd->UpdateWindow();
		};
		((CMainFrame*)m_pMainWnd)->m_Progress.SetRange( 0, TotalCount );
		((CMainFrame*)m_pMainWnd)->m_Progress.SetPos( CurrentCount );
		Run_MessageString = MessageString;

		if( make_result==0 )
		{
			AfxMessageBox( "  Ǿϴ. " );
			bDoingBackgroundProcessing = FALSE; 
			::PostQuitMessage(0);			
		}
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)
BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CMainFrame::CMainFrame()
{
	int SW	= GetSystemMetrics(SM_CXSCREEN);
	int SH	= GetSystemMetrics(SM_CYSCREEN);
	int SX	= (SW-480)/2;
	int SY	= (SH-100)/2;

	CRect rect(SX,SY,SX+480,SY+100);
	CFrameWnd::Create( NULL,APP_TITLE, WS_OVERLAPPED, rect, NULL );

	rect.left = 5;
	rect.top = 30;
	rect.right = 460;
	rect.bottom = rect.top + 20;
	m_Progress.Create( WS_CHILD|WS_VISIBLE|WS_BORDER, rect, this, 0 );

	Invalidate();
	UpdateWindow();
}

CMainFrame::~CMainFrame()
{	
}
/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnPaint() 
{
	CRect Client;
	GetClientRect( &Client );
	Client.top = 5;
	Client.left = 5;
	Client.bottom = 26;

	CPaintDC dc(this); // device context for painting
	dc.SetBkMode( TRANSPARENT );
	dc.SetTextColor( 0 );
	dc.DrawText( MessageString, &Client, DT_BOTTOM );
}

