#include	<afxwin.h>
#include	<afxcmn.h>// MFC support for Windows Common Controls
#include	<stdio.h>
#include	<math.h>

#ifndef _DGTYPE_H
#define _DGTYPE_H

/***********************************************
	Type
************************************************/
#define dgNULL	0L

#define dgTRUE	1
#define dgFALSE	0
typedef short int dgBOOL;

typedef signed char	S8;
typedef signed short int S16;
typedef signed long	S32;

typedef unsigned char	U8;
typedef unsigned short int U16;
typedef unsigned long	U32;

#endif

#ifndef IMGFILE_H
#define IMGFILE_H

/*/////////////////////////////////////////////////////*/
#define TRUE	1
#define FALSE	0
#define BOOL	int

#define LONG	long
#define BYTE	unsigned char
#define WORD	unsigned short
#define DWORD	unsigned long

#define BI_RGB        0L

#include <stdlib.h>
#include <string.h>

/*	For BMP file
//////////////////////////////////////////////////////*/
typedef struct tag_dgImage_BITMAPFILEHEADER {
		WORD    bfType; 
        DWORD   bfSize;
		WORD    bfReserved1; 
        WORD    bfReserved2;
		DWORD   bfOffBits; 
} _dgImage_BITMAPFILEHEADER;  

typedef struct tag_dgImage_BITMAPINFOHEADER{
   DWORD  biSize; 
   LONG   biWidth; 
   LONG   biHeight; 
   WORD   biPlanes; 
   WORD   biBitCount;
   DWORD  biCompression; 
   DWORD  biSizeImage; 
   LONG   biXPelsPerMeter; 
   LONG   biYPelsPerMeter; 
   DWORD  biClrUsed; 
   DWORD  biClrImportant; 
} _dgImage_BITMAPINFOHEADER; 

typedef struct tag_dgImage_RGBQUAD {
	BYTE    rgbBlue;
	BYTE    rgbGreen; 
    BYTE    rgbRed;
	BYTE    rgbReserved;
} _dgImage_RGBQUAD; 

typedef struct tag_dgImage_PALETTEENTRY {
	BYTE peRed;     
	BYTE peGreen; 
    BYTE peBlue;     
	BYTE peFlags; 
} _dgImage_PALETTEENTRY; 

/*	For PCX file
//////////////////////////////////////////////////////////////*/
typedef struct tag_dgImage_PCXHEADER {
   char maker,version,code,bpp ;
   short int x1,y1,x2,y2,hres,vres   ;
   char index[16][3],vmode,nplanes ;
   short int bpl,palinfo,shres,svres ;
   char dumy[54] ;
} _dgImage_PCXHEADER;

/*	For Gif file
//////////////////////////////////////////////////////////////*/
#define MAX_CODES     4096

extern S32 _dgImage_curr_size;
extern S16 _dgImage_clear;
extern S16 _dgImage_ending;
extern S16 _dgImage_newcodes;
extern S16 _dgImage_top_slot;
extern S16 _dgImage_slot;
extern S16 _dgImage_navail_bytes;
extern S16 _dgImage_nbits_left;
extern U8 *_dgImage_stack;
extern U8 *_dgImage_suffix;
extern U16 *_dgImage_prefix;
S16 _dgImage_get_next_code( U8 **filememptr, U32 cursize );

/**/
#define ChangeWordorder(a)	(((((U16)(a)&0xff)<<8))|(((U16)(a))>>8))
#define ChangeDWordorder(a)	( (((U32)(a)&0xff)<<24) | (((U32)(a)&0xff00)<<8) | (((U32)(a)&0xff0000)>>8) | (((U32)(a))>>24) )
void _BMPFILE_ChangeByteorder( _dgImage_BITMAPFILEHEADER *bmpfh, _dgImage_BITMAPINFOHEADER *bmpinfo );
void _PCXFILE_ChangeByteorder( _dgImage_PCXHEADER *pcx );

void _Dither8bppTo16bpp( U8 *src, U16 *dest, U8 *pal, U32 size, U32 widthshft );
void _NonDither8bppTo16bpp( U8 *src, U16 *dest, U8 *pal, U32 size );

extern long _dgImage_TextureMemoryPartitionNumber;

#endif

#include <stdio.h>

void MakeZeroColor( CString filename, CString outputname )
{
	_dgImage_BITMAPFILEHEADER bmpfh;
	_dgImage_BITMAPINFOHEADER bmpinfo;
	_dgImage_RGBQUAD pal[256];
	
	long i,j;
	long datasize;
	FILE *fp;
	U8 keyindex;

	// 8bpp non-compressed windows bitmap loading...
	{
		fp = fopen( filename , "rb");
		if( fp==NULL ) return ; 
		fseek( fp, 0, SEEK_END );
		datasize = ftell( fp );
		fseek( fp, 0, SEEK_SET );

		fread((void *)(&bmpfh.bfType),2, 1, fp );
		fread((void *)(&bmpfh.bfSize),12, 1, fp );
		fread((void *)(&bmpinfo),sizeof(_dgImage_BITMAPINFOHEADER), 1, fp );
		if (bmpfh.bfType != *((WORD*) "BM")) goto errorloop;
		if (bmpinfo.biCompression != BI_RGB ) goto errorloop;
		if (bmpinfo.biBitCount != 8 ) goto errorloop;
		fread((void *)pal,sizeof(_dgImage_RGBQUAD)*256, 1, fp );

		fseek( fp, bmpfh.bfOffBits ,SEEK_SET );
		datasize -= ftell( fp );

		{
			long width;
			if( (bmpinfo.biWidth%4)==0 ) width = bmpinfo.biWidth;
			else width = ((bmpinfo.biWidth>>2)<<2) + 4;
			fseek( fp, width*(bmpinfo.biHeight-1) ,SEEK_CUR );		
			fread( &keyindex,1,1,fp );
		}
		fclose( fp );
	}

	// color change
	{
		_dgImage_RGBQUAD temppal;

		temppal.rgbRed   = pal[keyindex].rgbRed;
		temppal.rgbGreen = pal[keyindex].rgbGreen;
		temppal.rgbBlue  = pal[keyindex].rgbBlue;
		temppal.rgbReserved  = pal[keyindex].rgbReserved;

		pal[keyindex].rgbRed   = pal[0].rgbRed;
		pal[keyindex].rgbGreen = pal[0].rgbGreen;
		pal[keyindex].rgbBlue  = pal[0].rgbBlue;
		pal[keyindex].rgbReserved  = pal[0].rgbReserved;

		pal[0].rgbRed   = temppal.rgbRed;
		pal[0].rgbGreen = temppal.rgbGreen;
		pal[0].rgbBlue  = temppal.rgbBlue;
		pal[0].rgbReserved  = temppal.rgbReserved;
	}

	// save bitmap
    {
		fp = fopen( outputname , "r+b");
		if( fp==NULL ) goto errorloop;

		fseek( fp, 2+12+sizeof(_dgImage_BITMAPINFOHEADER) ,SEEK_SET );
		fwrite((void *)pal,sizeof(_dgImage_RGBQUAD)*256, 1, fp );
		fseek( fp, bmpfh.bfOffBits ,SEEK_SET );
		{
			#define BUFFER_SIZE	1024
			static U8	data[BUFFER_SIZE];
			long datalen,current_filepos;
			for( i=0; i<datasize; i+=BUFFER_SIZE )
			{
				datalen = BUFFER_SIZE;
				if( i+datalen > datasize ) datalen = datasize-i;
				current_filepos = ftell( fp );
				fread( data,datalen,1,fp );				
				fseek( fp, current_filepos, SEEK_SET );
				for( j=0; j<datalen; j++ )
				{
					if( data[j]==0 ) data[j] = keyindex;
					else if( data[j]==keyindex ) data[j] = 0;
				}
				fwrite( data,datalen,1,fp );
				fseek( fp, current_filepos+datalen, SEEK_SET );				
			}
		}
    }

errorloop:
	fclose( fp );
	return;
}
