unit DGC3D;

interface
// things to Tommorrow
// 1. Create Frames List
// 2. Textures
// 3. FullScreen Mode
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DDUTIL,d3dtypes, Trace,Ddraw,d3d,dxtools,DsgnIntf, d3dcaps, d3drm, d3drmdef, d3drmobj, d3drmwin,DGC;

type
  TLightTypes =(Ambient,Point,Spot,Directional,ParallelPoint);
  TRotateDirection = (RotateLeft,RotateRight,RotateUp,RotateDown);
  TShadeType =(Wireframe,UnlitFlat,Flat,Gouraud,Phong);
  TColorMode = (RAMP,RGB);
  TWrapStyles = (CYLINDER,SPHERICAL,FLATWRAP,CHROME);
  TPXFmt = (non,bits1,bits2,bits4,bits8,bits15,bits16,bits24,bits32);
  // Create a class for Light RGB values Delphi
  // will then expand any var of this type in the
  // property editor
  TSetColorRGBCallback = procedure(r,g,b: TD3DValue) of object;
  TSet3DValuesCallback = procedure(X,Y,Z: TD3DValue) of object;


  //Direct 3D Draw Canvas
  //==================
  TDGC3DCanvas = class( TCanvas )
  private
    { Private declarations }
    FSurface: IDirectDrawSurface;
    FDeviceContext: HDC ;
  protected
    { Protected declarations }
    procedure CreateHandle ; override ;
  public
    { Public declarations }
    constructor Create(ASurface : IDirectDrawSurface);
    destructor Destroy ; override ;
    procedure Release ;
    function  DrawingAllowed : boolean ;
  end;

  TDeviceDriver = class(TObject)
  public
    GUID : TGUID;
    D3D : IDirect3D;
    DriverName,Driverdesc : string;
    Colormode : TColormode;
    Software : boolean;
    PixelDepth : set of TPxFmt;
    ZBufferDepth :set of TPxFmt;
 end;

 TDeviceDriverList = class(TList)
 private
    FD3D : IDirect3D;
    HasHardwaredevice:Boolean;
    function GetItem(index: integer) : TDeviceDriver;
 public
    property Items[index: integer] : TDeviceDriver read GetItem;
    constructor Create(D3D:IDirect3D);
    // enumerate the device drivers and fill list
    function Enumerate : boolean;
    destructor Destroy; override;
  end;


  TLightColor = class(TPersistent)
  private
    SetcolorRgb:TsetColorRGBCallBack;
    FLightColor:TD3DColorValue;
    procedure SetLightColor(Index: integer; Value: TD3DValue); virtual;
  public
    constructor Create;
  published
    Property Red : TD3DValue index 0 read FLightColor.R write SetLightColor;
    Property Green : TD3DValue index 1 read FLightColor.G write SetLightColor;
    Property Blue : TD3DValue index 2 read FLightColor.B write SetLightColor;
  end;

  TDGC3DVALUES = class(TPersistent)
  private
    SetDGCValues:Tset3dValuesCallBack;
    F3DVALUE:TD3DVECTOR;
    procedure SetVALUE(Index: integer; Value: TD3DValue); virtual;
  public
    constructor Create;
  published
    property X : TD3DValue index 0 read F3Dvalue.X write SetVALUE;
    property Y : TD3DValue index 1 read F3Dvalue.Y write SetVALUE;
    property Z : TD3DValue index 2 read F3Dvalue.Z write SetVALUE;
  end;

  TDGCRMFrameItem = Class(TcollectionItem)
  private
         // master frame
         Meshbuilder : IDirect3DRMMeshbuilder;
         FD3DDevice:IDirect3DRMDevice;
         FD3DRM:IDirect3DRM;
         FScene:IDirect3DRMFrame;
         FFrame:IDirect3DRMFrame;
         FViewPort:IDirect3DRMViewport;
         FColor:TLightColor;
         FShadeType:TShadeType;
         FRMShadeValue:TD3DRMRenderQuality;
         FName:string;
         FTextureFilename:String;
         FTexture:IDirect3drmtexture;
         FFileName:string;
         FX,FY,FZ,FAngle:TD3DValue;
         FScalefactor:TDGC3dValues;
         FDirection:TRotateDirection;
         FWrapstyle:TWrapStyles;
  public
        // over ride so we can create the image
        Constructor Create(ACollection:TCollection);override;
        Destructor Destroy;override;
        procedure Init(Direct3DRM:IDirect3DRM;Scene:IDirect3DRMFrame;var ViewPort:IDirect3DRMViewport;D3Ddevice:IDirect3dRMdevice);
        procedure LoadFrame;
        procedure Loadtexture;
        procedure Update;
        procedure Rotate;
        procedure SetPosition(Index:integer;Value:TD3DValue);
        procedure Setangle(Value:TD3DValue);
        procedure SetShadeType(Value:TShadeType);
        procedure Move(X,Y,Z:Double);
  published
        Property Name:string read Fname write Fname;
        Property FileName:string read FFilename write FFileName;
        Property X:TD3DValue Index 0 read FX write SetPosition ;
        Property Y:TD3DValue Index 1 read FY write SetPosition ;
        Property Z:TD3DValue Index 2 read FZ write SetPosition ;
        Property Angle:TD3DValue  read FAngle write SetAngle;
        property Direction:TRotateDirection read FDirection write FDirection;
        Property Color:TLightColor read FColor write FColor;
        Property ShadeType:TShadetype read FShadeType write SetShadeType;
        property Texture:string read FTextureFilename write FTexturefilename;
        property TextureWrapStyle:TWrapStyles read FWrapStyle write FWrapstyle;
        property ScaleFactor:TDGC3DValues read FScalefactor write FScalefactor;
  end;

  TDGCRMFrameCollection = class(Tcollection)
  private
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGCRMFrameItem;
         procedure SetItem(Index:Integer;Value:TDGCRMFrameItem);
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        property Items[Index:integer]:TDGCRMFrameItem read GetItem write SetItem;
  end;


  // Light collection Items
  // Light objects are created as frames this allows for them to be manipulated
  TDGCRMLightItem = class(TCollectionItem)
  private
         FD3DRM:IDirect3DRM;
         FScene:IDirect3DRMFrame;
         FFrame:IDirect3DRMFrame;
         FViewPort:IDirect3DRMViewport;
         FLight:IDirect3dRmLight;
         FLightColor:TLightColor;
         FLightType:TLightTypes;
         FEnabled:Boolean;
         FPenumbra:TD3DVALUE;
         FUmbra:TD3DVALUE;
         Frange:TD3DVALUE;
         Fname:string;
         FX,FY,FZ,FAngle:TD3DValue;
         FDirection:TRotateDirection;
  protected
        // enable or Disable a light
        procedure setenabled(Value:Boolean);
        function GetPenumbra:TD3DVALUE;
        function GetUmbra:TD3DVALUE;
        function getRange:TD3DValue;
        procedure SetPenUmbra(Value:TD3DVALUE);
        procedure SetUmBra(Value:TD3DVALUE);
        procedure SetRange(Value:TD3DVALUE);
        procedure SetPosition(Index:integer;Value:TD3DValue);
        procedure Setangle(Value:TD3DValue);
  Public
        // over ride so we can create the image
        Constructor Create(ACollection:TCollection);override;
        Destructor Destroy;override;
        procedure Init(Direct3DRM:IDirect3DRM;Scene:IDirect3DRMFrame;var ViewPort:IDirect3DRMViewport);
        procedure Rotate;
        procedure Move(X,Y,Z:Double);
        property Frame:IDirect3DRMFrame read FFrame;
  published
        Property LightColor:TLightColor read FLightColor write FLightColor;
        Property LightType:TLightTypes read FLightType write FLightType;
        Property Name:string read FName write Fname;
        Property Enabled:Boolean read FEnabled write SetEnabled;
        Property PenUmBra:TD3DVALUE read FPenUmbra write SetPenUmbra;
        Property Umbra:TD3DVALUE read FUmbra write SetUmbra;
        property Range:TD3DVALUE read FRange write SetRange;
        Property X:TD3DValue Index 0 read FX write SetPosition;
        Property Y:TD3DValue Index 1 read FY write SetPosition;
        Property Z:TD3DValue Index 2 read FZ write SetPosition;
        property Orientation:TD3DValue  read FAngle write SetAngle;
        property Direction:TRotateDirection read FDirection write FDirection;
  end;

  TDGCRMLightCollection = class(Tcollection)
  private
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGCRMLightItem;
         procedure SetItem(Index:Integer;Value:TDGCRMLightItem);
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        property Items[Index:integer]:TDGCRMLightItem read GetItem write SetItem;
  end;

  TXFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TTextureFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;


  TDGCD3D = class(TComponent)
  private
    { Private declarations }
    FShadeType:TShadeType;
    FRenderSurface:IDirectDrawSurface2;
    //FScreen:TDGCScreen;
    Fcanvas:TDGC3DCanvas;
    FRMShadeValue:TD3DRMRenderQuality;
    FD3D:IDirect3D;
    FDirectDraw:IdirectDraw;
    FDirectdraw2:IdirectDraw2;
    FD3DRM:IDirect3DRM;
    FD3DDevice:IDirect3DRMDevice;
    FViewPort:IDirect3DRMViewport;
    FFullscreen:Boolean;
    FFlippingEnabled : Boolean;
    FOnPaint: TNotifyEvent;
    FOnFlip: TNotifyEvent;
    FOnInitialize: TNotifyEvent;
    FOnCleanUp: TNotifyEvent;
    frmOnActivate: TNotifyEvent;
    // Field of Vision
    FFOV:TD3DValue;
    // Frames
    FScene:IDirect3DRMFrame;
    FCameraFrame:IDirect3DRMFrame;
    // Lights
    FLights:TDGCRMLightCollection;
    FFrames:TDGCRMFramecollection;
    FD3dDevice3:IDirect3ddevice3;
    FFrontClipping:TD3Dvalue;
    FBackClipping:TD3DValue;
    Fprimarysurface  : IDirectDrawSurface;
    FBackSurface   : IDirectDrawSurface;
    FZBufferSurface: IDirectDrawSurface;
    FAmbientLight  : IDirect3DRMLight;
    FbackgroundImage:TPicture;
    FFileName:string;
    FDisplayMode: TDisplayMode;
    closingdown:Boolean;
  protected
    { Protected declarations }
    w,h,bpp:integer;
    Procedure Dodisplaymode;
    procedure SetFov(Value: TD3DValue);
    procedure SetFrontClipping(Value: TD3DValue);
    procedure SetBackClipping(Value: TD3DValue);
    procedure SetbackgroundImage(Picture:TPicture);
    procedure SetShadeType(Value:TShadeType);
    procedure SetDisplayMode(Value:TDisplayMode);
    procedure StartTimer;
    procedure StopTimer;
    procedure DoOnActivate(Sender: TObject);
    procedure SetFlippingEnabled(b: Boolean);

  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent);override;
    procedure InitDirect3D;
    procedure CleanUpDirect3D;
    destructor Destroy;override;
    procedure Dorenderstate;
    // render the scene
    procedure Render;
    procedure Flip;
    { Protected declarations }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure LoadXFile(Filename: string);
    procedure Rotate(Direction:TRotateDirection;angle:TD3DValue);
    procedure Createfullscreeninterface;
//    procedure Createwindowedinterface;
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure AppMessage(var Msg: TMsg; var Handled : boolean ) ;
    Procedure Surfaceerase(Fsurface:Idirectdrawsurface;Color:Byte);
    property Canvas: TDGC3DCanvas read FCanvas;
 {   procedure CreateDirectDrawinterface;}
  published
    { Published declarations }
    //property DGCScreen: TDGCScreen read FScreen write FScreen;
    Property D3D:Idirect3D read FD3D;
    property D3DDevice:IDirect3DRMDevice read FD3DDevice;
    property ViewPort:IDirect3DRMViewPort read FViewPort;
    property FOV:TD3DValue read FFOV write SetFOV;
    property FrontClipping : TD3DValue read FFrontClipping write SetFrontClipping;
    property BackClipping : TD3DValue read FBackClipping write SetBackClipping;
    property Lights:TDGCRMLightCollection read FLights write FLights;
    property Frames:TDGCRMFrameCollection read FFrames write FFrames;
    property FileName:string read FFileName write FFileName;
    property ShadeType:TShadetype read FShadeType write SetShadeType;
    property BackgroundImage:TPicture read FbackgroundImage write SetBackgroundImage;
    property Surface: IDirectDrawSurface2 read FRenderSurface;
    property DisplayMode:TDisplayMode read FDisplayMode write SetDisplayMode;
    Property Fullscreen:Boolean read FFullscreen write FFullscreen;
    property FlippingEnabled:Boolean read FFlippingEnabled write SetFlippingEnabled;
    property OnPaint:TNotifyEvent read FOnPaint write FOnPaint;
    property OnFlip:TNotifyEvent read FOnFlip write FOnFlip;
    property OnInitialize:TNotifyEvent read FOnInitialize write FOnInitialize;
    property OnCleanUp:TNotifyEvent read FOnCleanUp write FOnCleanUp;
  end;

procedure Register;

implementation

procedure TXFilenameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.create(Application);
  try
    FileOpen.Options:=[ofHideReadOnly,ofEnableSizing,ofPathMustExist,ofFileMustexist];
    FileOpen.DefaultExt:='.X';
    Fileopen.Filter:='3D Mesh Files | *.X';
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TXFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TTextureFilenameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.create(Application);
  try
    FileOpen.Options:=[ofHideReadOnly,ofEnableSizing,ofPathMustExist,ofFileMustexist];
    FileOpen.DefaultExt:='.bmp';
    Fileopen.Filter:='Texture Files | *.bmp;*.ppm';
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TTextureFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

// TDGCFrameCollection
// ==========================
constructor TDGCRMFrameCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGCRMFrameItem);
     Fowner:=Aowner;
end;

// must be overidden for streaming to work properly
function TDGCRMFramecollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGCRMFrameCollection.SetItem(Index:integer;Value:TDGCRMFrameitem);
begin
     inherited setitem(Index,Value);
end;

function TDGCRMFrameCollection.GetItem(Index:integer):TDGCRMFrameitem;
begin
     Result:=TDGCRMFrameitem(inherited GetItem(Index));
end;

// Tframe items Object methods
// =======================
Constructor TDGCRMFrameItem.Create(ACollection:TCollection);
begin
     inherited Create(Acollection);
     FScene:=nil;
     FFrame:=nil;
     FtextureFilename:='';
     Ftexture:=nil;
     FName:='';
     FFileName:='';
     FX:=0.0;
     FY:=0.0;
     FZ:=0.0;
     Fangle:=0.0;
     FColor:=TLightColor.Create;
     FColor.Red:=0.1;
     FColor.Blue:=0.1;
     FColor.Green:=0.1;
     Fscalefactor:=TDGC3DValues.Create;
     FScalefactor.X:=0;
     Fscalefactor.Y:=0;
     Fscalefactor.Z:=0;
end;

// create and initialize the Direct 3d Light Source
procedure TDGCRMFrameItem.Init(Direct3DRM:IDirect3DRM;Scene:IDirect3DRMFrame;var ViewPort:IDirect3DRMViewport;D3DDevice:IDirect3DRMDevice);
begin
     if Scene <> nil then
     begin
          FD3DRM:=Direct3DRM;
          FViewport:=Viewport;
          FD3DDevice:=D3DDevice;
          FScene:=Scene;
          DXCheck(Direct3DRM.CreateFrame(Fscene,FFrame));
          DXCheck(FFrame.SetPosition(FScene,-X,-Y,-Z));
          Rotate;
     end;
end;

procedure TDGCRMFrameItem.Update;
begin
     if FScene <> nil then
     begin
          Rotate;
          DXCheck(FFrame.SetColorRGB(FColor.Red,FColor.Green,Fcolor.BLue));
     end;
end;

procedure TDGCRMFrameitem.SetPosition(Index:integer;Value:TD3DValue);
begin
     case Index of
          0:FX:=Value;
          1:FY:=Value;
          2:FZ:=Value;
     end;
     if Assigned(FFrame) then
     begin
           Move(FX,FY,FZ)
     end;
end;

procedure TDGCRMFrameitem.Setangle(Value:TD3DValue);
begin
     Fangle:=Value;
     if Assigned(FFrame) then
     begin
        Rotate;
     end;
end;

procedure TDGCRMFrameItem.Rotate;
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  DXCheck( FScene.GetPosition(Fframe,p) );
  DXCheck( Fframe.SetPosition(FScene,0,0,0) );
  DXangle:=Fangle;
  case Ord(Direction) of
       0:begin
              dxAngle := -dxAngle;
              DXCheck( Fframe.SetOrientation(Fframe,sin(dxAngle),0,cos(dxAngle),0,1,0) );
         end;
       1:DXCheck( Fframe.SetOrientation(Fframe,sin(dxAngle),0,cos(dxAngle),0,1,0) );
       3:begin
              dxAngle := -dxAngle;
              DXCheck( Fframe.SetOrientation(Fframe,0,sin(dxAngle),cos(dxAngle),0,cos(dxAngle),sin(dxAngle)) );
         end;
       2:DXCheck( Fframe.SetOrientation(Fframe,0,sin(dxAngle),cos(dxAngle),0,cos(dxAngle),sin(dxAngle)) );
  end;
  DXCheck( Fframe.SetPosition(FScene,-x,-y,-z) );
end;



procedure TDGCRMFrameItem.SetShadeType(Value:TShadetype);
begin
     FShadeType:=Value;
     case FshadeType of
         Wireframe :FRMShadeValue := D3DRMRENDER_WIREFRAME;
         UnlitFlat :FRMShadeValue := D3DRMRENDER_UNLITFLAT;
         Flat      :FRMShadeValue := D3DRMRENDER_FLAT;
         Gouraud   :FRMShadeValue := D3DRMRENDER_GOURAUD;
         Phong     :FRMShadeValue := D3DRMRENDER_PHONG;
     end;
     if Assigned(FD3DDevice) then
     begin
          DXCheck(FD3DDevice.SetQuality(FRMShadeValue));
          DXCheck(FD3DDevice.SetShades(64));
          DXCheck(FD3DRM.SetDefaultTextureShades(128));
          DXCheck(FD3DRM.SetDefaultTextureColors(64));
          DXCheck(FD3DDevice.SetDither(False));
     end;
end;


procedure TDGCRMFrameItem.LoadFrame;
var
  Visualarray : IDirect3DRMVisualArray;
  Visual  : IDirect3DRMVisual;
  PFilename : PChar;
  i : integer;
  Hres : HResult;
  mat:IDIrect3DRMMATERIAL;
  mesh:IDirect3DRMmesh;
  wrap:IDirect3DRMwrap;
  tempframe:IDirect3drmframe;
  wrapstyle:TD3DRMWRAPTYPE;
  box:TD3DRMBOX;
  miny, maxy:TD3DValue;
  Height:TD3DValue;
begin
  if Filename = '' then exit;
  DXCheck( FD3DRM.CreateMeshBuilder(Meshbuilder) );
  PFilename := StrAlloc(Length(FFilename)+1);
  StrPCopy(PFilename,FFilename);
  Hres:= Meshbuilder.Load(PFilename,nil,D3DRMLOAD_FROMFILE,nil,nil);
  // see if file was not loaded
  if (Hres = D3DRMERR_FILENOTFOUND) or (Hres = D3DRMERR_BADFILE) then
  begin
     if assigned(PFilename) then
        StrDispose(PFilename);
     Exit;
  end;
  DXCheck(Hres);
  DXCheck(meshbuilder.scale(Scalefactor.X,ScaleFactor.Y,Scalefactor.Z));
  DXCheck(FD3DRM.CreateMaterial(10.0, mat));
  DXCheck(meshbuilder.SetMaterial(mat));
  DXCheck(meshbuilder.SetQuality(FRMShadeValue));
  if Texture <> '' then
  begin
       DXCheck(meshbuilder.SetColorRGB(FColor.Red,FColor.Green,Fcolor.BLue));
       Loadtexture;
//       DXCheck(meshbuilder.Generatenormals);
       DXCheck(meshbuilder.CreateMesh(mesh));
       DXCheck(meshbuilder.GetBox(box));
       maxy := box.max.y;
       miny := box.min.y;
       height := maxy - miny;
       case FWrapStyle of
            FlatWrap : wrapstyle := D3DRMWRAP_FLAT;
            spherical : wrapstyle := D3DRMWRAP_SPHERE;
            CYLINDER:wrapstyle :=D3DRMWRAP_CYLINDER;
            Chrome:wrapstyle :=D3DRMWRAP_CHROME;
       end;
       DXCheck(FD3DRM.CreateWrap(wrapstyle, Nil, 0.0,
                              0.0, 0.0, 0.0,
                              1.0, 0.0, 0.0,
                              0.0, 1.0, 0.0,
                              D3DDivide(miny, height), 1.0,
                              D3DDivide(-1.0, height), wrap));
       DXCheck(wrap.Apply(mesh));
       DXCheck(Fframe.AddVisual(Mesh) );
       DXCheck(Fframe.SetPosition(FScene,-x,-y,-z) );
       //Meshbuilder.Scale(7,7,7);
  end
  else
      Dxcheck(FFrame.addVisual(meshbuilder));
  Releasecom(wrap);
  Releasecom(mesh);
  Releasecom(mat);
  Releasecom(Tempframe);
 // if assigned(PFilename) then
 //    StrDispose(PFilename);}


end;

procedure TDGCRMFrameItem.Loadtexture;
var
   pfilename:PChar;
   hres:Hresult;
begin
     if Texture <> '' then
     begin
       PFilename := StrAlloc(Length(FtextureFilename)+1);
       StrPCopy(PFilename,FtextureFilename);
       hres:=FD3drm.Loadtexture(PFilename,Ftexture);
       if (Hres = D3DRMERR_FILENOTFOUND) or (Hres = D3DRMERR_BADFILE) then
       begin
            if assigned(PFilename) then
               StrDispose(PFilename);
            Exit;
       end;
       meshbuilder.SetTexture(Ftexture);
       FFrame.Settexture(FTexture);
     end;
     if assigned(PFilename) then
         StrDispose(PFilename);
end;

procedure TDGCRMFrameItem.Move(X,Y,Z:Double);
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(FFrame.GetPosition(Fscene, p1));
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+(D3DMultiply(D3DVAL(y), p2.w));
     p2.z:=p2.Z+Z;
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FFrame.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;


Destructor TDGCRMFrameItem.Destroy;
begin
     Releasecom(meshbuilder);
     Releasecom(Ftexture);
     Releasecom(FFrame);
     inherited Destroy;
end;


// TDGCLightCollection
// ==========================
constructor TDGCRMLightCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGCRMLightItem);
     Fowner:=Aowner;
end;



// must be overidden for streaming to work properly
function TDGCRMLightcollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGCRMLightCollection.SetItem(Index:integer;Value:TDGCRMLightitem);
begin
     inherited setitem(Index,Value);
end;

function TDGCRMLightCollection.GetItem(Index:integer):TDGCRMLightitem;
begin
     Result:=TDGCRMLightitem(inherited GetItem(Index));
end;

// TLight Object methods
// =======================
Constructor TDGCRMLightItem.Create(ACollection:TCollection);
begin
     inherited Create(Acollection);
     Flight:=nil;
     FLightType:=Ambient;
     FLightColor:=TLightColor.Create;
     FLightColor.Red:=0.1;
     FLightColor.Blue:=0.1;
     FLightColor.Green:=0.1;
     FFrame:=nil;
     FEnabled:=False;
     FPenumbra:=0.2;
     FUmbra:=0.4;
     FRange:=255;
     FX:=0.0;
     FY:=0.0;
     FZ:=0.0;
     Fangle:=0.0;
end;


procedure TDGCRMLightitem.SetPosition(Index:integer;Value:TD3DValue);
begin
     case Index of
          0:FX:=Value;
          1:FY:=Value;
          2:FZ:=Value;
     end;
     if Assigned(FFrame) then
     begin
           Move(FX,FY,FZ)
     end;
end;

procedure TDGCRMLightItem.Move(X,Y,Z:Double);
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(FFrame.GetPosition(Fscene, p1));
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+(D3DMultiply(D3DVAL(y), p2.w));
     p2.z:=p2.Z+Z;
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FFrame.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;


procedure TDGCRMLightitem.Setangle(Value:TD3DValue);
begin
     Fangle:=Value;
     if Assigned(FFrame) then
     begin
        Rotate;
     end;
end;

procedure TDGCRMLightItem.Rotate;
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  DXCheck( FScene.GetPosition(Fframe,p) );
  DXCheck( Fframe.SetPosition(FScene,0,0,0) );
  DXangle:=Fangle;
  case Ord(Direction) of
       0:begin
              dxAngle := -dxAngle;
              DXCheck( Fframe.SetOrientation(Fframe,sin(dxAngle),0,cos(dxAngle),0,1,0) );
         end;
       1:DXCheck( Fframe.SetOrientation(Fframe,sin(dxAngle),0,cos(dxAngle),0,1,0) );
       3:begin
              dxAngle := -dxAngle;
              DXCheck( Fframe.SetOrientation(Fframe,0,sin(dxAngle),cos(dxAngle),0,cos(dxAngle),sin(dxAngle)) );
         end;
       2:DXCheck( Fframe.SetOrientation(Fframe,0,sin(dxAngle),cos(dxAngle),0,cos(dxAngle),sin(dxAngle)) );
  end;
  DXCheck( Fframe.SetPosition(FScene,-x,-y,-z) );
end;

// create and initialize the Direct 3d Light Source
// Note Lights are created as inividual frames this allows the direction and orientation
// to be manipulated
procedure TDGCRMLightItem.Init(Direct3DRM:IDirect3DRM;Scene:IDirect3DRMFrame;var ViewPort:IDirect3DRMViewport);
begin
     if Direct3DRM <> nil then
     begin
          FD3DRM:=Direct3DRM;
          Fscene:=Scene;
          FViewport:=Viewport;
          DXCheck(Direct3DRM.CreateLightRGB(TD3DRMLightType(Ord(FLightType)),FLightcolor.Red,
             FLightColor.Green,FLightColor.Blue,Flight));
          DXCheck(Direct3DRM.CreateFrame(Fscene,FFrame));
          DXCheck(FFrame.SetPosition(FScene,-FX,-FY,-FZ));
          DXCheck(FFrame.SetOrientation(Fscene, D3DVAL(-1.0), D3DVAL(-1.0), D3DVAL(1.0), D3DVAL(0.0), D3DVAL(5.0), D3DVAL(0.0)));
          DXCheck(FFrame.AddLight(Flight));
     end;
end;

Destructor TDGCRMLightItem.Destroy;
begin
     if Assigned(fframe) then
        fframe:=nil;
     if Assigned(fscene) then
        fscene:=nil;
     if Assigned(fd3drm) then
        fd3drm:=nil;

     inherited Destroy;
end;

procedure TDGCRMLightItem.setenabled(Value:Boolean);
begin
     Fenabled:=Value;
end;

// get outer cone
function TDGCRMLightItem.GetPenumbra:TD3DVALUE;
begin
     if Flight <> nil then
        Result:=Flight.GetPenumbra;
end;

// get inner cone note in radiuns
function TDGCRMLightItem.GetUmbra:TD3DVALUE;
begin
     if Flight <> nil then
        Result:=Flight.Getumbra;
end;

// get the distance at which objects will be effected by light
function TDGCRMLightItem.getRange:TD3DValue;
begin
     Result:=Flight.Getrange;
end;

// set inner portion of the light cone
procedure TDGCRMLightItem.SetPenUmbra(Value:TD3DVALUE);
begin
     if Value <> FpenUmbra then
        FPenUmbra:=Value;
     if Flight <> nil then
        DXCheck(Flight.SetPenUmbra(Value));
end;

// set the outer portion of light cone
procedure TDGCRMLightItem.SetUmBra(Value:TD3DVALUE);
begin
     if Value <> FUmbra then
        FUmbra:=Value;
     if Flight <> nil then
        DXCheck(Flight.SetUmbra(Value));
end;

// set range at which objects are effected by this light
procedure TDGCRMLightItem.SetRange(Value:TD3DVALUE);
begin
     if Value <> FRange then
        Frange:=Value;
     if Flight <> nil then
        DXCheck(Flight.SetRange(Value));
end;

// light color object
constructor TlightColor.Create;
begin
     inherited Create;
     FLightColor.A := 1.0;
end;

// light color object
procedure TLightColor.SetLightColor(Index: integer; Value: TD3DValue);
begin
  if Value < 0.0 then
     Value := 0.0;
  case Index of
    0 : FLightColor.R := Value;
    1 : FLightColor.G := Value;
    2 : FLightColor.B := Value;
  end;
  if assigned(SetColorRGB) then
     SetColorRGB(Red,Green,Blue);
end;

// light color object
constructor TDGC3DValues.Create;
begin
     inherited Create;
end;

// light color object
procedure TDGC3DValues.SetValue(Index: integer; Value: TD3DValue);
begin
  case Index of
    0 : F3dvalue.X := Value;
    1 : F3dvalue.Y := Value;
    2 : F3dvalue.Z := Value;
  end;
  if assigned(SetDGCvalues) then
     SetDGCValues(X,Y,Z);
end;



// TDGC 3D RM Component
Constructor TDGCD3D.Create(Aowner:Tcomponent);
begin
     inherited Create(Aowner);
     FbackgroundImage:=TPicture.Create;
     FFullscreen:=true;
     //Fscreen:=nil;
     FD3DDevice:=nil;
     FViewport:=nil;
     FD3D:=nil;
     FScene:=nil;
     FShadetype:=Gouraud;
     FRMShadeValue:=D3DRMRENDER_GOURAUD;
     FFOV:=0.5;
     FFrontClipping:=1.0;
     FBackClipping:=1000.0;
     Lights:=TDGCRMLightCollection.Create(Aowner);
     Frames:=TDGCRMFrameCollection.Create(AOwner);
     if not (csDesigning in ComponentState) then
     begin
          frmOnActivate := TForm(Owner).OnActivate;
          TForm(Owner).OnActivate := DoOnActivate;
     end;
end;

destructor TDGCD3D.Destroy;
begin
     if Assigned(FBackgroundImage) then
     begin
        FbackgroundImage.Free;
        FbackgroundImage:=nil;
     end;
     if Assigned(Fcanvas) then
        Fcanvas.Destroy;
     if Assigned(Frendersurface) then
        Frendersurface:=nil;
     if Assigned(Frames) then
        Frames.Destroy;
     if Assigned(Lights) then
        Lights.Destroy;
     CleanUpDirect3D;
     inherited Destroy;
end;

procedure TDGCD3D.SetShadeType(Value:TShadetype);
begin
     FShadeType:=Value;
     case FshadeType of
         Wireframe :FRMShadeValue := D3DRMRENDER_WIREFRAME;
         UnlitFlat :FRMShadeValue := D3DRMRENDER_UNLITFLAT;
         Flat      :FRMShadeValue := D3DRMRENDER_FLAT;
         Gouraud   :FRMShadeValue := D3DRMRENDER_GOURAUD;
         Phong     :FRMShadeValue := D3DRMRENDER_PHONG;
     end;
     if Assigned(FD3DDevice) then
     begin
          DXCheck(FD3DDevice.SetQuality(FRMShadeValue));
          DXCheck( FD3DDevice.SetShades(32) );
          DXCheck( FD3DRM.SetDefaultTextureShades(64) );
          DXCheck( FD3DRM.SetDefaultTextureColors(32) );
          DXCheck( FD3DDevice.SetDither(True));
     end;
end;

procedure TDGCD3D.SetbackgroundImage(Picture:TPicture);
begin
     FbackgroundImage.Assign(Picture);
end;

Procedure TDGCD3D.Dodisplaymode;
begin
     case DisplayMode of
          dm640x480x8:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=8;
                      end;
          dm640x480x16:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=16;
                      end;
          dm640x480x24:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=24;
                      end;
          dm640x480x32:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=32;
                      end;
          dm320x200x8:
                      begin
                           w := 320;
                           h := 200;
                           bpp:=8;
                      end;
          dm800x600x8:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=8;
                      end;
          dm800x600x16:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=16;
                      end;
          dm800x600x24:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=24;
                      end;
          dm800x600x32:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=32;
                      end;
          dm1024x768x8:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=8;
                       end;
          dm1024x768x16:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=16;
                       end;
          dm1024x768x24:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=24;
                       end;
          dm1024x768x32:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=32;
                       end;
          dm640x400x8:
                      begin
                           w:= 640;
                           h := 400;
                           bpp:=8;
                      end;
          dm320x240x8:
                      begin
                           w := 320;
                           h := 240;
                           bpp:=8;
                      end;
     else
        w := 640;
        h := 480;
        bpp:=16;
     end;

end;

procedure TDGCD3D.SetDisplayMode(Value:TdisplayMode);
var
   w,h,bpp:Integer;
begin
     if Value <> FdisplayMode then
     begin
        FdisplayMode:=Value;
        Dodisplaymode;
     end;
end;

procedure TDGCD3D.LoadXFile(Filename: string);
var
  Meshbuilder : IDirect3DRMMeshbuilder3;
  Visualarray : IDirect3DRMVisualArray;
  Visual  : IDirect3DRMVisual;
  PFilename : PChar;
  i : integer;
  Hres : HResult;
  Framebox : TD3DRMBox;
  x,y,z : TD3DValue;
begin
end;

// note angle in radiuns
procedure TDGCD3D.Rotate(Direction:TRotateDirection;angle:TD3DValue);
var
  p : TD3DVector;
begin
  DXCheck( FScene.GetPosition(FCameraframe,p) );
  DXCheck( FCameraframe.SetPosition(FScene,0,0,0) );
  case Ord(Direction) of
       0:begin
              Angle := -Angle;
              DXCheck( FCameraframe.SetOrientation(FCameraframe,sin(Angle),0,cos(Angle),0,1,0) );
         end;
       1:DXCheck( FCameraframe.SetOrientation(FCameraframe,sin(Angle),0,cos(Angle),0,1,0) );
       3:begin
              Angle := -Angle;
              DXCheck( FCameraframe.SetOrientation(FCameraframe,0,sin(Angle),cos(Angle),0,cos(Angle),sin(Angle)) );
         end;
       2:DXCheck( FCameraframe.SetOrientation(FCameraframe,0,sin(Angle),cos(Angle),0,cos(Angle),sin(Angle)) );
  end;
  DXCheck( FCameraframe.SetPosition(FCameraframe,-p.x,-p.y,-p.z) );
end;

procedure TDGCD3D.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  //if (Operation = opRemove) and not (csDestroying in ComponentState) then
  //begin
  //     if FScreen = AComponent then
  //        FScreen := nil;
  //end;
end;

function EnumDevicesCallback(lpGuid: pGUID;
      lpDeviceDescription: lpstr; lpDeviceName: lpstr;
      var lpHWDesc: TD3DDeviceDesc;
      var lpHELDesc: TD3DDeviceDesc;
      lpUserArg: Pointer) : HResult; stdcall;
var
  Devicedrv : TDevicedriver;
  desc : TD3DDeviceDesc;
  i:Integer;
begin
  with TObject(lpUserArg) as TDeviceDriverList do
  begin
    for i:=1 to 2 do
    begin
         if i = 1 then
            desc := lpHELDesc
         else
             desc := lpHWDesc;
         if desc.dcmColorModel <> 0 then
         begin
              Devicedrv := TDeviceDriver.Create;
              Devicedrv.D3D := FD3D;
              Devicedrv.GUID := lpGUID^;
              Devicedrv.DriverName := lpDeviceName;
              Devicedrv.DriverDesc := lpDeviceDescription;
              with Devicedrv do
              begin
                   case desc.dcmColorModel of
                        D3DCOLOR_MONO : Colormode := Ramp;
                        D3DCOLOR_RGB  : Colormode := RGB;
                   end;
                   if i = 1 then
                      Software := true
                   else
                       Software := False;
                   Pixeldepth := [];
                   if longbool(desc.dwDeviceRenderBitDepth and DDBD_8) then
                      Include(Pixeldepth,bits8);
                   if longbool(desc.dwDeviceRenderBitDepth and DDBD_16) then
                      Include(Pixeldepth,bits16);
                   if longbool(desc.dwDeviceRenderBitDepth and DDBD_24) then
                      Include(Pixeldepth,bits24);
                   if longbool(desc.dwDeviceRenderBitDepth and DDBD_32) then
                      Include(Pixeldepth,bits32);
                   ZBufferDepth := [];
                   if longbool(desc.dwDeviceZBufferBitDepth and DDBD_16) then
                      Include(ZBufferdepth,bits16);
                   if longbool(desc.dwDeviceZBufferBitDepth and DDBD_24) then
                      Include(ZBufferdepth,bits24);
                   if longbool(desc.dwDeviceZBufferBitDepth and DDBD_32) then
                      Include(ZBufferdepth,bits32);
              end;
              Add(Devicedrv);
         end;
    end;
  end;
  result := DDENUMRET_OK;
end;

constructor TDeviceDriverlist.Create;
begin
  inherited Create;
  FD3D:=nil;
  if assigned(D3D) then
     FD3D := D3D;
end;

function TDeviceDriverList.GetItem(index: integer) : TDeviceDriver;
begin
  Result := TDeviceDriver(TList(self).Items[index]);
end;

function TDeviceDriverList.Enumerate : boolean;
var
  i : integer;
  res : HResult;
begin
  // clear the list
  for i := 0 to Count-1 do
      Items[i].Free;
  res:=FD3D.EnumDevices(EnumDevicesCallback, Self);
  Result := (Res = D3D_OK);
  // if there is an error then report it
  DXCheck(res);
end;


destructor TDeviceDriverList.Destroy;
var
  i : integer;
begin
{  for i := 0 to Count-1 do
      Items[i].Free;}
  inherited Destroy;
end;

procedure TDGCD3D.Surfaceerase(Fsurface:Idirectdrawsurface;color:byte);
var
  BltFx: TDDBLTFX;
  r: HResult;
  caps:Tddscaps;
  arect:trect;
begin
     ZeroMemory ( @BltFx, sizeof(BltFx));
     BltFx.dwSize := sizeof(BltFx);
     BltFx.dwFillColor := Color;
     arect:=rect(0,0,w,h);
     r := FSurface.Blt(@arect, nil, @arect, DDBLT_COLORFILL + DDBLT_WAIT, @BltFx);
end;

// Initialize Direct 3D Interface
procedure TDGCD3D.InitDirect3D;
begin
     closingdown:=False;
     if Ffullscreen then
        Createfullscreeninterface;
     Application.OnMessage := AppMessage;
end;

Var
   pxformat:TDDPixelFormat;

Function EnumZBufferCallback(var ppfd:TDDPIXELFORMAT;pddpfDesired:pointer ):Hresult;stdcall;
begin
    // If this is ANY type of depth-buffer, stop.
    if( ppfd.dwFlags = DDPF_ZBUFFER ) then
    begin

        pxformat:=ppfd;

        // Return with D3DENUMRET_CANCEL to end the search.
        Result:=D3DENUMRET_CANCEL;
    end;

    // Return with D3DENUMRET_OK to continue the search.
    Result:=D3DENUMRET_OK;
end;

procedure TDGCD3D.CreateFullScreeninterface;
var
   Desc:TDDSurfacedesc;
   Caps : TDDSCaps;
   D3DRM:Idirect3DRM;
   F3DDevicedrivers:TDeviceDriverList;
   FIMDevice:IDirect3dDevice3;
   i:integer;
begin
     DXCheck( DirectDrawCreate(nil,FDirectDraw,nil) );
     DXCheck(Fdirectdraw.queryinterface(IID_IDirectdraw2,FDirectdraw2));
     DDCheck( FDirectDraw2.SetCooperativelevel(Application.Handle,
      DDSCL_FULLSCREEN + DDSCL_EXCLUSIVE) );
     DXCheck( FDirectDraw2.QueryInterface(IID_IDirect3D,FD3D) );
     F3DDeviceDrivers := TDeviceDriverList.Create(FD3D);
     F3DDeviceDrivers.Enumerate;
     i:=0;
     // see if we have a hardwaredevice available
     // if not use softwaredevice
     while (F3DDevicedrivers.Items[i].software) and (i < F3DDevicedrivers.count) do
          inc(i);
     DXCheck(FdirectDraw2.setdisplaymode(w,h,bpp,0,0));
     fillchar(Desc,sizeof(Desc),0);
     with Desc do
     begin
         dwsize:=SizeOf(Desc);
         dwFlags := DDSD_CAPS + DDSD_BACKBUFFERCOUNT;
         dwBackBufferCount := 1;
         ddsCaps.dwCaps := DDSCAPS_PRIMARYSURFACE + DDSCAPS_3DDEVICE
                       + DDSCAPS_FLIP + DDSCAPS_COMPLEX;
    end;
    DDCheck( FDirectDraw2.CreateSurface(Desc,FPrimarySurface,nil) );
    Caps.dwCaps := DDSCAPS_BACKBUFFER;
    FBackSurface := nil;
    DDCheck( Fprimarysurface.GetAttachedSurface(Caps,FBackSurface) );
    fillchar(Desc,sizeof(Desc),0);
    with Desc do
    begin
         dwsize:=SizeOf(Desc);
         dwFlags := DDSD_WIDTH + DDSD_HEIGHT + DDSD_CAPS + DDSD_ZBUFFERBITDEPTH;
         dwWidth := w;
         dwHeight := h;
         dwZBufferBitDepth := 16;
         //if F3DDevicedrivers.Items[i].software then
            ddscaps.dwcaps:=DDSCAPS_ZBUFFER + DDSCAPS_SYSTEMMEMORY
         //else
         //    ddscaps.dwcaps:=DDSCAPS_ZBUFFER + DDSCAPS_VIDEOMEMORY;
    end;
    DDCheck( FDirectDraw2.CreateSurface(Desc,FZBufferSurface,nil) );

    DDCheck( FBackSurface.AddAttachedSurface(FZBufferSurface));
    DDCheck(Direct3DRMcreate(FD3DRM));
    DXCheck( FD3DRM.CreateDeviceFromsurface(@F3DDeviceDrivers.Items[0].GUID,FDirectDraw,FBacksurface,FD3DDevice));
    DXCheck( FD3DRM.CreateFrame(nil,FScene) );
    DXCheck( FD3DRM.CreateFrame(FScene,FCameraframe) );
    DXCheck( FCameraframe.SetOrientation(FScene,0,0,1,0,1,0) );
    DXCheck( FCameraframe.SetPosition(FScene,0,0,-50) );
    // Create The viewport
    D3DCheck( FD3DRM.CreateViewport(FD3DDevice,Fcameraframe,0,0,
              FD3DDevice.GetWidth,FD3DDevice.GetHeight,FViewport));
    D3DCheck( FViewport.SetField(FFOV) );
    D3DCheck( FViewport.SetFront(FFrontClipping));
    D3DCheck( FViewport.SetBack(FbackClipping));
    // set shading type
    //DXCheck(FD3DDevice.GetDirect3DDevice(FIMDevice));
    //DXCheck(FIMdevice.GetrenderTarget(FRendersurface));
    FCanvas := TDGC3DCanvas.Create(FBackSurface);
(*    //D3DCheck(FD3DDevice.SetRenderMode(D3DRMRENDERMODE_BLENDEDTRANSPARENCY or
    //                      D3DRMRENDERMODE_SORTEDTRANSPARENCY));*)
    D3DCheck(FD3DDevice.SetTextureQuality(D3DRMTEXTURE_LINEAR));
    D3DCheck(FD3DDevice.SetQuality(FRMShadeValue));
    // initialize the lights
    if Assigned(FLights) then
    Begin
         if Flights.Count > 0 then
         begin
              for i:=0 to Flights.Count -1 do
                  FLights.Items[i].Init(FD3DRM,FScene,FViewport);
         end;
     end;

     // initilize all frames
     if Assigned(FFrames) then
     Begin
          if FFrames.Count > 0 then
          begin
               for i:=0 to FFrames.Count -1 do
               begin

                    FFrames.Items[i].Init(FD3DRM,FScene,FViewport,FD3DDevice);
                    FFrames.Items[i].LoadFrame;
               end;
          end;
    end;
end;

procedure TDGCD3D.DoRenderstate;
begin
    { FD3DDevice3.SetRenderState(D3DRENDERSTATE_SHADEMODE, ord(D3DSHADE_GOURAUD));
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_TEXTUREPERSPECTIVE,0);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_ZENABLE, 1);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, 1);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_ZFUNC, ord(D3DCMP_LESSEQUAL));
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_TEXTUREMAG, Ord(D3DFILTER_NEAREST));
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_TEXTUREMIN, Ord(D3DFILTER_NEAREST));
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_TEXTUREMAPBLEND, Ord(D3DTBLEND_MODULATE));
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_FILLMODE, Ord(D3DFILL_SOLID));
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_DITHERENABLE, 1);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_SPECULARENABLE,1);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_ANTIALIAS, 0);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_FOGENABLE, 0);
     FD3DDevice3.SetRenderState(D3DRENDERSTATE_FOGCOLOR,RGB_MAKE(0, 0, 0) );}
end;

procedure TDGCD3D.Render;
begin
    if Ffullscreen then
    begin
         with Fprimarysurface do
         begin
              if IsLost = DDERR_SURFACELOST then
                 if _Restore = DDERR_WRONGMODE then
                 begin
                      Application.Terminate;
                      exit;
                 end;
         end;
         with FBackSurface do
              if IsLost = DDERR_SURFACELOST then _Restore;
         FScene.Move(1.0);
         FViewport.Clear;
         clearsurface(fbacksurface,0);
         with fCanvas do
         begin
              stretchdraw(rect(0,0,w,h),BackgroundImage.Graphic);
              Pen.color:=clyellow;
              Brush.Style:=bsclear;
              Font.Color:=clyellow;
              textout(0,0,Format('tie fighter X = %f , Y = %f , Z = %f',[Frames.Items[0].X,Frames.Items[0].Y,Frames.Items[0].Z]));
              release;
         end;
         FViewport.Render(FScene);
         FD3DDevice.Update;
         Fprimarysurface.flip(nil,ddflip_wait);
    end;


end;

procedure TDGCD3D.DoOnActivate(Sender: TObject);
begin
   if Assigned(frmOnActivate) then
      frmOnActivate(Owner);
   InitDirect3d;
end;

procedure TDGCD3D.SetFOV(Value: TD3DValue);
begin
  if (Value <= 0.0) or (Value > 3.0) then
     Value := 0.5;
  FFOV := Value;
  if Assigned(FViewPort) then
     DXCheck( FViewport.SetField(Value) );
end;

procedure TDGCD3D.SetFrontClipping(Value: TD3DValue);
begin
  if Value <= 0.0 then
     Value := 1.0;
  if Value >= FBackClipping then
     value := FBackClipping - 1;
  FFrontClipping := Value;
  if Assigned(FViewport)  then
     DXCheck( FViewport.SetFront(Value));
end;

procedure TDGCD3D.SetBackClipping(Value: TD3DValue);
begin
  if Value <= 0.0 then
     value := 10000.0;
  if Value <= FFrontClipping then
     Value := FFrontClipping + 1;
  FBackClipping := Value;
  if Assigned(FViewport) then
     DXCheck( FViewport.SetBack(Value));
end;

procedure TDGCD3D.CleanUpDirect3D;
begin
  //stop page flipping
   if not Assigned(FDirectDraw) then exit;
   FlippingEnabled := False ;
   closingdown:=True;
//  if assigned(Fviewport ) then
//     Releasecome(FViewport);
  if Assigned(fframes) then
     fframes.destroy;
  if Assigned(flights) then
     flights.destroy;
  if assigned(Fscene ) then
     Fscene :=nil;
  if assigned(Fcameraframe ) then
     FCameraframe:=nil;
  if assigned(FD3DRM ) then
      FD3DRM:=nil;
  if assigned(FD3D ) then
      FD3D:=nil;
  if Assigned(FDirectDraw) then
   begin
      FDirectDraw.RestoreDisplayMode;
      Fdirectdraw.SetCooperativeLevel(0,DDSCL_NORMAL);
      Releasecome(FDirectDraw);
   end;
   tracestring('got here');
end;

procedure TDGCD3D.AppMessage(var Msg: TMsg; var Handled : boolean ) ;
begin
   //Enable/Disbale Idle event if application not active
   case Msg.Message of
        WM_ACTIVATEAPP:
        begin
          //if not window mode
          //   showwindow(form1.handle, sw_showmaximized);
          if not Boolean(Msg.wParam) then
             StopTimer
          else
             PostMessage(Application.Handle, WM_DGCACTIVATE, 0, 0);
        end;
        WM_DGCACTIVATE:
        begin
          //RestoreSurfaces;
          if FlippingEnabled then
             StartTimer
          else
            if Assigned(FOnPaint) then
              FOnPaint(Self);
          Application.OnIdle := AppIdle;
        end;
        WM_SYSCOMMAND:
        begin
           //Do not allow a screen saver to kick in
           Handled := (Msg.wParam = SC_SCREENSAVE);
        end;
   end;
end ;

procedure TDGCD3D.SetFlippingEnabled(b: Boolean);
begin
   if b <> FFlippingEnabled then
   begin
      FFlippingEnabled := b;
      if not (csDesigning in ComponentState) then
      begin
         if FFlippingEnabled then
            StartTimer
         else
            StopTimer;
      end;
   end;
end;

procedure TDGCD3D.Flip;
begin
   if closingdown then Exit;
   render;
end;

procedure TDGCD3D.AppIdle(Sender: TObject; var Done: Boolean);
begin
   Done := False;
   if not Assigned(FD3D) then exit;
   if Assigned(FOnFlip) then
      FOnFlip(Self);
   Flip;   
end;

procedure TDGCD3D.StartTimer;
begin
   Application.OnIdle := AppIdle;
end;

procedure TDGCD3D.StopTimer;
begin
   Application.OnIdle := nil;
end;

//TDGC3DCanvas Implementation
//========================
constructor TDGC3DCanvas.Create( ASurface : IDirectDrawSurface ) ;
begin
  inherited Create ;
  if ASurface = NIL then
    Raise EDGCCanvas.Create('Cannot create canvas for NIL surface' ) ;
  FSurface := ASurface ;
end;

destructor TDGC3DCanvas.Destroy ;
begin
  Release;
  inherited Destroy ;
end ;

procedure TDGC3DCanvas.CreateHandle ;
begin
  if FDeviceContext = 0 then begin
    FSurface.GetDC( FDeviceContext ) ;
    Handle := FDeviceContext ;
  end ;
end ;

procedure TDGC3DCanvas.Release ;
begin
  if FDeviceContext <> 0 then begin
    Handle := 0 ;
    FSurface.ReleaseDC( FDeviceContext ) ;
    FDeviceContext := 0 ;
  end ;
end ;

function  TDGC3DCanvas.DrawingAllowed : boolean ;
begin
  Result := FSurface.IsLost = DD_OK ;
end ;


procedure Register;
begin
  RegisterComponents('DGC3D', [TDGCD3D]);
  RegisterPropertyEditor(TypeInfo(string), TDGCRMFrameItem, 'Filename', TXFilenameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDGCRMFrameItem, 'Texture', TTextureFilenameProperty);
end;

end.
