unit DGC3DRM;

{ The Delpi Games Creator - 3DRM Alpha 1
 --------------------------------
 Copyright 1999 Paul Bearne

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial game use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.

 You may use these components to create any freeware/shareware/commercial
 game/application that you wish. If you wish to do any sort of printed or
 electronic publication about DGC, you must get written permission from
 one of the DGC authors.
}

// DGC 3D RM Mode component created by paul 22-08-99
// NOte this component is in it's alpha stage collision detection is basic
// also it will probably crash so no emails

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,DGCInput,
  DDraw,dxtools,math,D3DTypes,DsgnIntf,D3DCaps,DGCsnd,
  D3D,D3DRM,D3DRMobj,D3DRMdef,D3DRMwin,DGCMidi;

const
  WM_DGCACTIVATE = WM_USER + 200;

type
 //Default Exception Handler
 EDGCScreen = class(Exception);
 EDGCSurface = class(Exception);
 EDGCCanvas = class(Exception);

 TColorMode = (RAMP,RGB);
 TLightTypes =(Ambient,Point,Spot,Directional,ParallelPoint);
 TRotateDirection = (RotateLeft,RotateRight,RotateUp,RotateDown);
 TShadeType =(Wireframe,UnlitFlat,Flat,Gouraud,Phong);
 TWrapStyles = (CYLINDER,SPHERICAL,FLATWRAP,CHROME);
 TPXFmt = (non,bits1,bits2,bits4,bits8,bits15,bits16,bits24,bits32);
 T3DDisplayMode = (dm640x480x16,dm640x480x24,dm640x480x32,
                  dm800x600x16,dm800x600x24,dm800x600x32,dm1024x768x16,dm1024x768x24,dm1024x768x32
                  );

  TDGC3DProjectiontype =(PERSPECTIVE,ORTHOGRAPHIC,RIGHTHANDPERSPECTIVE,RIGHTHANDORTHOGRAPHIC);


  TDGC3DRMFrameItem  = Class;

  //Direct 3D Draw Canvas
  //==================
  TDGC3DCanvas = class( TCanvas )
  private
    { Private declarations }
    FSurface: IDirectDrawSurface;
    FDeviceContext: HDC ;
  protected
    { Protected declarations }
    procedure CreateHandle ; override ;
  public
    { Public declarations }
    constructor Create(ASurface : IDirectDrawSurface);
    destructor Destroy ; override ;
    procedure Release ;
    function  DrawingAllowed : boolean ;
  end;


  // device driver record
  // ====================
  Driverrec = record
            DGUID:TGUID;
            Name:string;
            Desc:string;
            ColorModel:string;
            IsHardware:Boolean;
  end;

  // Create a class for Light RGB values Delphi
  // will then expand any var of this type in the
  // property editor
  TSetColorRGBCallback = procedure(r,g,b: TD3DValue) of object;

  // will then expand any var of this type in the
  // property editor
  TSet3DValueCallback = procedure(X,Y,Z,Angle: TD3DValue) of object;
  // will then expand any var of this type in the
  // property editor
  TSet3DXYZCallback = procedure(X,Y,Z: TD3DValue) of object;
  // will then expand any var of this type in the
  // property editor
  TSetViewportValueCallback = procedure(Viewport:IDirect3dRMViewport2;X,Y,Width,Height,FOV,
                                        FfrontClipping,FBackClipping:TD3DValue;FScaling:Boolean;FProjectiontype:TDGC3DProjectiontype) of object;
  // will then expand any var of this type in the
  // property editor
  TSetCameraValueCallback = procedure(Camera,Scene:IDirect3dRMFrame3;Viewport:Idirect3drmViewport2;X,Y,Z:TD3Dvalue) of object;

  // Xfile filename property editor
  //===============================
  TXFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  // Texture filename Property editor
  //=================================
  TTextureFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  // Light color property editor
  //============================
  TLightColor = class(TPersistent)
  private
    SetcolorRgb:TsetColorRGBCallBack;
    FLightColor:TD3DColorValue;
    procedure SetLightColor(Index: integer; Value: TD3DValue); virtual;
  public
    constructor Create;
  published
    Property Red : TD3DValue index 0 read FLightColor.R write SetLightColor;
    Property Green : TD3DValue index 1 read FLightColor.G write SetLightColor;
    Property Blue : TD3DValue index 2 read FLightColor.B write SetLightColor;
  end;


  // 3dvector property editor
  //============================
  TDGC3DValue = class(TPersistent)
  private
    SetValue:Tset3DValueCallBack;
    FValue:TD3DVector;
    FAngle:TD3DValue;
    procedure Set3dValue(Index: integer; Value: TD3DValue); virtual;
  public
    constructor Create;
  published
    Property X : TD3DValue index 0 read FValue.X write Set3dvalue;
    Property Y : TD3DValue index 1 read FValue.Y write Set3dValue;
    Property Z : TD3DValue index 2 read FValue.Z write Set3dvalue;
    Property Angle:TD3Dvalue index 3 read FAngle write Set3dvalue;
  end;

  // 3dvector property editor
  //============================
  TDGC3DXYZ = class(TPersistent)
  private
    SetValue:Tset3DXYZCallBack;
    FValue:TD3DVector;
    procedure Set3dValue(Index: integer; Value: TD3DValue); virtual;
  public
    constructor Create;
  published
    Property X : TD3DValue index 0 read FValue.X write Set3dvalue;
    Property Y : TD3DValue index 1 read FValue.Y write Set3dValue;
    Property Z : TD3DValue index 2 read FValue.Z write Set3dvalue;
  end;


  // Viewport object and
  // Viewport property editor
  //============================
  TDGC3DRMViewport = class(TPersistent)
  private
    SetValue:TsetViewportValueCallBack;
    FViewport:IDirect3DRMViewport2;
    FX:TD3DValue;
    FY:TD3DValue;
    FWidth:TD3DValue;
    FHeight:TD3DValue;
    FFOV:TD3DValue;
    FFrontclipping:TD3DValue;
    FBackClipping:TD3DValue;
    FUniformScaling:Boolean;
    FProjectionType:TDGC3DProjectionType;
    procedure SetViewportValue(Index:Integer;Value: TD3DValue); virtual;
    procedure SetViewport(Viewport:IDirect3DRMViewport2);virtual;
    function GetViewportValue(Index:Integer):TD3DValue;virtual;
    procedure SetScaling(Value:Boolean);
    procedure SetProjectiontype(Value:TDGC3DProjectiontype);
  public
    constructor Create;
    procedure SetPlane(aLeft,aRight,aTop,aBottom:TD3DValue);
    procedure GetPlane(var aLeft,aRight,aTop,aBottom:TD3DValue);
    procedure Setcamera(AFrame:TDGC3DRMFRAMEITEM);
    property Viewport:IDirect3DRMViewport2 read FViewport write SetViewport;
  published
    // note that X + Width must not be greater than Physical Screen Width
    // and Y+Height Must Not be greater than Physical Height
    Property X : TD3DValue Index 1 read GetViewportValue write SetViewportvalue;
    Property Y : TD3DValue Index 2 read GetViewportValue write SetViewportValue;
    property Width : TD3DValue Index 3 read GetViewportValue write Setviewportvalue;
    property Height:TD3Dvalue Index 4 read GetViewportValue write Setviewportvalue;
    // Field of View
    property FOV:TD3DValue Index 5 read GetViewportValue write SetviewportValue;
    // Front Clipping Plane
    property FrontClipping:TD3DValue Index 6 read GetViewportValue write SetviewportValue;
    // Back Clipping Plane
    property BackClipping:TD3DValue Index 7 read GetViewportValue write SetviewportValue;
    property Uniformscaling:Boolean read FUniformScaling write SetScaling;
    property Projectiontype:TDGC3DProjectiontype read FProjectiontype write setprojectiontype;
  end;

  TDGC3DRMAnimation = class;
  // Light collection Items
  // Light objects are created as frames this allows for them to be manipulated
  //===========================================================================
  TDGC3DRMLightItem = class(TCollectionItem)
  private
         FD3DRM:IDirect3DRM3;
         FScene:IDirect3DRMFrame3;
         FFrame:IDirect3DRMFrame3;
         FViewPort:IDirect3DRMViewport2;
         FLight:IDirect3dRmLight;
         FLightColor:TLightColor;
         FLightType:TLightTypes;
         FEnabled:Boolean;
         FPenumbra:TD3DVALUE;
         FUmbra:TD3DVALUE;
         Frange:TD3DVALUE;
         Fname:string;
         FX,FY,FZ,FAngle:TD3DValue;
         FDirection:TRotateDirection;
         Fanimation:TDGC3DRMAnimation;
         FAutorotate:Boolean;
         FConstantatt,FLinearatt,FQuadraticatt:TD3DValue;
         FLookat:Boolean;
         FFollow:Boolean;
         FZOffset:TD3Dvalue;
         Lookatframe:TDGC3DRMFrameItem ;
  protected
        // enable or Disable a light
        procedure setenabled(Value:Boolean);
        function GetPenumbra:TD3DVALUE;
        function GetUmbra:TD3DVALUE;
        function getRange:TD3DValue;
        procedure SetPenUmbra(Value:TD3DVALUE);
        procedure SetUmBra(Value:TD3DVALUE);
        procedure SetRange(Value:TD3DVALUE);
        procedure SetPosition(Index:integer;Value:TD3DValue);
        procedure Setangle(Value:TD3DValue);
        // light attenuations
        procedure SetAttenuation(Index:Integer;Value:TD3DValue);
        function GetAttenuation(Index:Integer):TD3DValue;
        procedure moverelative;
  Public
        // over ride so we can create the image
        Constructor Create(ACollection:TCollection);override;
        Destructor Destroy;override;
        procedure Init(Direct3DRM:IDirect3DRM3;Scene:IDirect3DRMFrame3;ViewPort:IDirect3DRMViewport2);
        procedure Update;
        Procedure Spin;
        procedure StopSpinning;
        procedure Rotate(Adirection:TRotateDirection;stepsize:TD3DValue);
        procedure Move(X,Y,Z:Double);
        procedure animate;
        procedure Lookat(AFrame:TDGC3DRMFrameItem );
        procedure Follow(AFrameItem:TDGC3DRMFrameItem ;Aoffset:TD3Dvalue);
        property Frame:IDirect3DRMFrame3 read FFrame;
        property Light:IDirect3DRMLight read FLight;
        property Animation:TDGC3DRMAnimation read Fanimation;
  published
        Property LightColor:TLightColor read FLightColor write FLightColor;
        Property LightType:TLightTypes read FLightType write FLightType;
        Property Name:string read FName write Fname;
        Property Enabled:Boolean read FEnabled write SetEnabled;
        Property PenUmBra:TD3DVALUE read getpenumbra write SetPenUmbra;
        Property Umbra:TD3DVALUE read GetUmbra write SetUmbra;
        property Range:TD3DVALUE read GetRange write SetRange;
        Property X:TD3DValue Index 0 read FX write SetPosition;
        Property Y:TD3DValue Index 1 read FY write SetPosition;
        Property Z:TD3DValue Index 2 read FZ write SetPosition;
        property Orientation:TD3DValue  read FAngle write SetAngle;
        property Direction:TRotateDirection read FDirection write FDirection;
        property AutoSpin:Boolean read FAutorotate write FAutorotate;
        property ConstantAttenuation:TD3DValue Index 0 read GetAttenuation write SetAttenuation;
        property LinearAttenuation:TD3DValue Index 1 read GetAttenuation write SetAttenuation;
        property QaudraticAttenuation:TD3DValue Index 2 read GetAttenuation write SetAttenuation;
  end;

  // Light collection
  //==================
  TDGC3DRMLightCollection = class(Tcollection)
  private
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGC3DRMLightItem;
         procedure SetItem(Index:Integer;Value:TDGC3DRMLightItem);
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        property Items[Index:integer]:TDGC3DRMLightItem read GetItem write SetItem;
  end;

  // TDGCRMFACE Wrapper around D3dRMface2
  // expand upon later
  TDGC3DRMFACE = Class(Tpersistent)
  private
       FFaceColor:TLightColor;
       FD3DRM:IDirect3DRM3;
       FFace:IDirect3DRMFace2;
       FCount:Integer;
  protected
       function GetCount:Integer;
       procedure SetColor(Value:Tlightcolor);
  public
        Constructor Create(D3DRM:IDirect3Drm3);
        destructor Destroy;override;
        procedure Addvertex(X,Y,Z:TD3DVALUE);
        procedure GetVertex(Index:Integer;var Position,Normal:TD3dvector);
        function Getnormal:TD3Dvector;
        property Face:IDirect3DRMFace2 read FFace write FFace;
        property Count:Integer read GetCount;
  published
        Property Color:TLightColor read FFaceColor write SetColor;
  end;

(*  // TDGCRMMESH Wrapper around D3DMesh
  // expand upon later
  TDGC3DRMMESH = Class(Tpersistent)
  private
       FMeshColor:TLightColor;
       FD3DRM:IDirect3DRM3;
       FMesh:IDirect3DRMFace2;
       FCount:Integer;
  protected
       function GetCount:Integer;
       procedure SetColor(Value:Tlightcolor);
  public
        Constructor Create(D3DRM:IDirect3Drm3);
        destructor Destroy;override;
        procedure Addvertex(X,Y,Z:TD3DVALUE);
        procedure GetVertex(Index:Integer;var Position,Normal:TD3dvector);
        function Getnormal:TD3Dvector;
        property Mesh:IDirect3DRMMesh read FFace write FFace;
        property Count:Integer read GetCount;
  published
        Property Color:TLightColor read FMeshColor write SetColor;
  end;*)

  Tanimationrec = record
          ID:Integer;
          X,Y,Z,Angle:TD3DValue;
          Direction:Trotatedirection;
          R,G,B:TD3DVALUE;
   end;

  // TDGCanimation Item
  // due to major hang when changing cameras
  // i decide to create my own animation object
  // does the same but uses a Tlist of Items
  // with the exception of the time frame
  TDGC3DRMAnimation = class(Tobject)
  private
         FRunning:Boolean;
         Fanimationframe:Integer;
         Fanimation:Tlist;
         FLooped:Boolean;
         Fautoreverse:Boolean;
         Freversed:Boolean;
  public
        // frame that this animation corresponds to
        constructor Create;
        // frame animation
        procedure Addpositionkey(x,y,z,angle:TD3Dvalue;Direction:Trotatedirection;Color:TCOLOR);
        procedure AddScaleKey(x,y,z:TD3Dvalue);
        procedure doanimation;
        function GetPosition(Index:Integer):TD3Dvalue;
        function Getdirection:Trotatedirection;
        procedure Play;
        procedure Loop;
        procedure Start;
        procedure Stop;
        procedure Update;
        destructor Destroy;override;
        property X:TD3DValue Index 0 read Getposition;
        property Y:TD3Dvalue Index 1 read Getposition;
        property Z:TD3Dvalue Index 2 read Getposition;
        property Key:TD3DVALue Index 3 read Getposition;
        property angle:TD3Dvalue Index 4 read Getposition;
        property Direction:TRotatedirection read Getdirection;
        property R:TD3DValue Index 5 read Getposition;
        property G:TD3Dvalue Index 6 read Getposition;
        property B:TD3Dvalue Index 7 read Getposition;
        property Running:Boolean read FRunning;
        property Autoreverse:Boolean read Fautoreverse write Fautoreverse;
  end;

  // Frame items encapsulates a 3d object into it's own frame
  // and that adds it to the scene
  // ========================================================
  TDGC3DRMFrameItem  = Class(TcollectionItem)
  private
         // master frame
         Fanimation:TDGC3DRMAnimation;
         FMeshbuilder : IDirect3DRMMeshbuilder3;
         FD3DDevice:IDirect3DRMDevice3;
         FD3DRM:IDirect3DRM3;
         FScene:IDirect3DRMFrame3;
         FFrame:IDirect3DRMFrame3;
         FViewPort:IDirect3DRMViewport2;
         FBackground:TPicture;
         FColor:TLightColor;
         FShadeType:TShadeType;
         FRMShadeValue:TD3DRMRenderQuality;
         FName:string;
         FTextureFilename:String;
         FTexture:IDirect3drmtexture3;
         FAmbientlight:IDirect3drmlight;
         FFileName:string;
         FX,FY,FZ,FAngle:TD3DValue;
         FDirection:TRotateDirection;
         FWrapstyle:TWrapStyles;
         FAutorotate:Boolean;
         Fheight,Fwidth,Fdepth:TD3Dvalue;
         FSharpness:TD3DValue;
         FLookat:Boolean;
         FFollow:Boolean;
         FZOffset:TD3Dvalue;
         FLookatframe:TDGC3DRMFrameItem ;
         // boundingbox of meshbuilder
         // used for simple collision detection
         Fbox:TD3DRMBOX;
         FuseFullPaths:Boolean;
         // shadows
         FCastShadow:Boolean;
         FLightsourceIndex:Integer;
         // meshobject
         Fmesh:IDirect3DRMmesh;
         // Visible
         FVisible:Boolean;
         FScale:TDGC3DXYZ;
         Fanimationframe:Integer;
         Fanimated:Boolean;
  protected
           procedure moverelative;
           procedure SetVisible(Value:Boolean);
           procedure SetScale(Value:TDGC3DXYZ);
  public
        // over ride so we can create the image
        Constructor Create(ACollection:TCollection);override;
        Destructor Destroy;override;
        procedure Init(Direct3DRM:IDirect3DRM3;Scene:IDirect3DRMFrame3;ViewPort:IDirect3DRMViewport2;D3Ddevice:IDirect3dRMdevice3);
        procedure LoadFrame;
        procedure Loadtexture;
        procedure Update;
        // does a simple rotation can be used for simple animation
        Procedure Spin;
        procedure StopSpinning;
        // rotate the object once
        procedure Rotate(Adirection:TRotateDirection;stepsize:TD3DValue);
        procedure SetPosition(Index:integer;Value:TD3DValue);
        // angle of spin
        procedure Setangle(Value:TD3DValue);
        procedure SetShadeType(Value:TShadeType);
        procedure Move(X,Y,Z:Double);
        procedure Lookat(AFrame:TDGC3DRMFrameItem );
        procedure Follow(AFrameItem:TDGC3DRMFrameItem ;Aoffset:TD3Dvalue);
        procedure animate;
        function CreateMesh:IDirect3drmmesh;
        function Createwrap:IDirect3drmwrap;
        procedure CastShadow(alight:TDGC3DRMLightItem);
        property Frame:IDirect3DRMFrame3 read FFrame;
        property MeshBuilder:IDirect3drmmeshbuilder3 read Fmeshbuilder;
        property Animation:TDGC3DRMAnimation read Fanimation;
        Property Height:TD3Dvalue read FHeight write Fheight;
        Property Width:TD3Dvalue read Fwidth write Fwidth;
        Property Depth:TD3Dvalue read Fdepth write FDepth;

  published
        Property Name:string read Fname write Fname;
        Property FileName:string read FFilename write FFileName;
        Property X:TD3DValue Index 0 read FX write SetPosition ;
        Property Y:TD3DValue Index 1 read FY write SetPosition ;
        Property Z:TD3DValue Index 2 read FZ write SetPosition ;
        Property SpinAngle:TD3DValue  read FAngle write SetAngle;
        property SpinDirection:TRotateDirection read FDirection write FDirection;
        Property Color:TLightColor read FColor write FColor;
        Property ShadeType:TShadetype read FShadeType write SetShadeType;
        property Texture:string read FTextureFilename write FTexturefilename;
        property TextureWrapStyle:TWrapStyles read FWrapStyle write FWrapstyle;
        property AutoSpin:Boolean read FAutorotate write FAutorotate;
        // value of 10 gives metalic look higher becomes more like plastic
        property Materialsharpness:TD3Dvalue read FSharpness write FSharpness;
        property UseFullpaths:Boolean read FUseFullpaths write FuseFullPaths;
        property Showshadow:Boolean read FCastShadow write FcastShadow;
        property LightsourceIndex:Integer read FLightsourceindex write FLightSourceIndex;
        property Visible:Boolean read Fvisible write SetVisible;
        property Scale:TDGC3DXYZ read FScale write Setscale;


  end;

  // Collection of frames
  // ====================
  // need to create a new collection
  // adds some new methods
  // Delete(Index) item
  // Promote(Index) to move item up collection by 1
  // Swap(Index1,Index2) swaps two indexes
  // Demote(Index) to move index down by 1
  TDGC3DRMFrameCollection = class(Tcollection)
  private
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGC3DRMFrameItem ;
         procedure SetItem(Index:Integer;Value:TDGC3DRMFrameItem );
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        procedure swap(Index1,Index2:Integer);
        procedure Promote(Index1:integer);
        procedure Demote(Index1:Integer);
        procedure Delete(Index1:Integer);
        property Items[Index:integer]:TDGC3DRMFrameItem  read GetItem write SetItem;
  end;

  // Shadow wrapper
  //===============
  TDGC3DRMShadow = class(Tpersistent)
  private
         FShadow:Idirect3drmshadow2;
         // light source casting shadow
         FLight:TDGC3DRMLightItem;
         // object casting shadow
         FFrame:TDGC3DRMFRameItem;
         // Fscene Frame
         Fscene:Idirect3DRMFrame3;
         // Direct 3d rm object
         FD3DRM:Idirect3drm3;
         // Projection plane
         FPlane:TDGC3Dvalue;
         // Normal
         FNormal:TDGC3Dvalue;

  protected

  public
         constructor Create(AD3DRM:Idirect3drm3;Ascene:Idirect3drmframe3;alight:TDGC3DRMLightItem;aFrame:TDGC3DRMFrameItem);
         // creates the shadow using the the plane settings
         procedure Init;
  published
         property Plane:TDGC3DValue read FPlane write FPlane;
         property Normal:TDGC3DValue read FNormal write FNormal;
  end;


  TDGC3DRMCAMERAITEM = class(TCollectionItem)
  private
 //   SetValue:TsetCameraValueCallBack;
    FD3DDevice:IDirect3DRMDevice3;
    FD3DRM:IDirect3DRM3;
    Fcamera:IDirect3DRMFrame3;
    FScene:IDirect3dRMframe3;
    FViewport:IDirect3DRMViewport2;
    FX:TD3DValue;
    FY:TD3DValue;
    FZ:TD3DValue;
    Flookat:Boolean;
    FFollow:Boolean;
    FZOffset:TD3Dvalue;
    FYAngle:TD3DValue;
    FZangle:TD3DValue;
    Lookatframe:TDGC3DRMFrameItem ;
    Fanimation:TDGC3DRMAnimation;
    FXanglechanged,FYanglechanged:Boolean;
    procedure SetCameraValue(Index:Integer;Value: TD3DValue); virtual;
    procedure SetCameraYValue(Value: TD3DValue); virtual;
    procedure SetCameraXValue(Value: TD3DValue); virtual;
    procedure SetScene(Scene:IDirect3DRMframe3);virtual;
    procedure Setcamera(camera:IDirect3DRMframe3);virtual;
    procedure SetViewport(Viewport:Idirect3drmviewport2);virtual;
    function GetCameraValue(Index:Integer):TD3DValue;virtual;
    procedure moverelative;
  public
    constructor Create(Acollection:TCollection);
    procedure Init(Direct3DRM:IDirect3DRM3;Scene:IDirect3DRMFrame3;D3DDevice:IDirect3DRMDevice3);
    procedure Move(X,Y,Z:Double);
    procedure Update;
    procedure animate;
    procedure Lookat(AFrameItem:TDGC3DRMFrameItem );
    procedure Follow(AFrameItem:TDGC3DRMFrameItem ;Aoffset:TD3Dvalue);
    procedure Rotate(Adirection:Trotatedirection;Stepsize:TD3DValue);
    property Camera:IDirect3DRMframe3 read Fcamera write SetCamera;
    property Scene:IDirect3DRMFrame3 read FScene write SetScene;
    property Viewport:IDirect3DRMViewport2 read FViewport write SetViewport;
    property Animation:TDGC3DRMAnimation read Fanimation;
  published
    // note that X + Width must not be greater than Physical Screen Width
    // and Y+Height Must Not be greater than Physical Height
    Property X : TD3DValue Index 1 read GetcameraValue write SetCameravalue;
    Property Y : TD3DValue Index 2 read GetcameraValue write SetCameraValue;
    property Z : TD3DValue Index 3 read GetcameraValue write SetCameravalue;
    // angle of camera in degrees
    property Yangle:TD3DValue read FYangle write SetCameraYvalue;
    property Xangle:TD3DValue read FZangle write SetCameraXvalue;
  end;

  // Camera collection
  //==================
  TDGC3DRMCameraCollection = class(Tcollection)
  private
         FCurrentCamera:integer;
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGC3DRMCameraItem;
         procedure SetItem(Index:Integer;Value:TDGC3DRMCameraItem);
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        procedure Next;
        procedure Prev;
        procedure First;
        procedure Last;
        procedure Gotocamera(Index:integer);
        property Items[Index:integer]:TDGC3DRMCameraItem read GetItem write SetItem;
  end;

  // Main 3d component creates clipper or front and back buffers
  // This component replaces DGC screen when using 3D RM
  // needs more error handling
  // =============================================================
  TDGC3DRMSCREEN = class(TComponent)
  private
    { Private declarations }
    FMousecursor:Hcursor;
    // direct draw
    FDD:IdirectDraw;
    // front and back buffers
    FFront:Idirectdrawsurface4;
    FBack:IDirectDrawSurface4;
    FDepthBuffer:IDirectdrawSurface4;
    Frendersurface:Idirectdrawsurface;
    Fbackgroundsurface:IDirectdrawSurface;
    FhasImage:Boolean;
    Fdesc:TDDSurfacedesc2;
    FFrontdesc:TDDSurfacedesc2;
    FCaps:TDDSCaps2;
    FDisplayMode: T3DDisplayMode;
       // clipper used for windowed mode
    FClipper:IDirectdrawClipper;
    // direct 3D
    FD3D:Idirect3D3;
    FD3DRM:IDirect3DRM3;
    FD3DRMDevice:IDirect3DRMDevice3;
    FViewPort:Idirect3DRMViewport2;
    // Frames
    FScene:Idirect3DRMframe3;
    Fcamera:TDGC3DRMCAMERACollection;
    // test frame will hold 3d landscape
    FWorld:Idirect3DRMFrame3;
    // frame list
    FFrames:TDGC3DRMFrameCollection;
    // lights list
    FLights:TDGC3DRMLightCollection;
    // dgc related
    FFullscreen:Boolean;
    FCanvas:TDGC3DCANVAS;
    FFlippingenabled:Boolean;
    FOnPaint: TNotifyEvent;
    FOnFlip: TNotifyEvent;
    FOnInitialize: TNotifyEvent;
    FOnCleanUp: TNotifyEvent;
    FOnrender:TNotifyEvent;
    frmOnActivate: TNotifyEvent;
    FDGCInput   : TDGCInput;
    // mouse support
    Fmousepointer:TCursor;
    FBackground:Tpicture;
    FMouseX,FmouseY:Integer;
    FMouseState:Integer;
    FCreateZBuffer:Boolean;

    FShowMouse:Boolean;
    FFrontclipping,FBackClipping:TD3DValue;
    FFoV:TD3DValue;
    FViewportsettings:TDGC3DRMViewport;
    FBackgroundcolor:TColor;
    FDriverinfo:Boolean;
  protected
    { Protected declarations }
    // ddraw displaymode
    w,h,bpp:Integer;
    procedure SetDisplayMode(Value:T3DDisplayMode);
    Procedure Dodisplaymode;
    procedure StartTimer;
    procedure StopTimer;
    procedure DoOnActivate(Sender: TObject);
    procedure SetFlippingEnabled(b: Boolean);
    procedure SetMouseCursor(Value:Tcursor);
    procedure SetBackgroundimage(Value:TPicture);
  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent);override;
    Procedure Loaded;override;
    procedure InitDirect3D;
    Procedure InitDirectDraw;
    procedure CleanUpDirect3D;
    Procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function CreateFrame:TDGC3DRMFrameItem ;
    Procedure Render;
    procedure Flip;
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure AppMessage(var Msg: TMsg; var Handled : boolean ) ;
    procedure SetKeys(keyleft,keyright,keyup,keydown,fire1,fire2:word);
    procedure RestoreSurfaces;
    function Collide(frame1,frame2:Integer):Boolean;
    function KeyDown(Key: word): Boolean;
    destructor Destroy;override;
    // mouse event handlers
    procedure Mousefired(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Mousemoved(Sender: TObject;Shift: TShiftState; X, Y: Integer);
    // clear render surface to an rgb color
    procedure ClearRenderSurfaceRGB(Color:TColor);
    procedure Createbackgroundsurface(w,h:Integer);
    property Canvas: TDGC3DCanvas read Fcanvas;
    Property Back:IDirectDrawSurface4 read FBack;
    Property Front:IDirectDrawSurface4 read FFront;
    Property Rendersurface:IdirectdrawSurface read FRendersurface;
    // direct3d properties
    property Scene:IDirect3drmFrame3 Read FScene;
    property D3DRM:IDirect3drm3 read FD3DRM;
    property D3DRMDevice:IDirect3DRMDevice3 read FD3DRMDevice;
    property ViewPort:Idirect3DRMViewport2 read FViewport;
  published
    { Published declarations }
    Property DisplayMode:T3DDisplayMode read FDisplayMode write SetDisplayMode;
    Property Fullscreen:Boolean read FFullscreen write FFullscreen;
    property Frames:TDGC3DRMFrameCollection read FFrames write FFrames;
    property Lights:TDGC3DRMLightCollection read FLights write FLights;
    Property Camera:TDGC3DRMCAMERACollection read FCamera write Fcamera;
    property FlippingEnabled:Boolean read FFlippingEnabled write SetFlippingEnabled;
    property OnPaint:TNotifyEvent read FOnPaint write FOnPaint;
    property OnFlip:TNotifyEvent read FOnFlip write FOnFlip;
    property OnInitialize:TNotifyEvent read FOnInitialize write FOnInitialize;
    property OnCleanUp:TNotifyEvent read FOnCleanUp write FOnCleanUp;
    property OnRender:TNotifyEvent read FOnRender write FOnRender;
    property DGCInput:TDGCInput read FDGCInput  write FDGCInput;
    property ShowMouse:Boolean  read FShowMouse write FShowmouse;
    property MouseImage:TCursor read FMousepointer write SetMouseCursor;
    // mouse button state 1 = leftbutton 2 = rightbutton
    property MouseButton:Integer read Fmousestate write FMouseState;
    // viewport settings
    property ViewportSettings:TDGC3DRMViewport read FViewportSettings write FViewportSettings;
    property Backgroundcolor:TColor read FBackgroundColor write FBackgroundColor;
    property ShowDriverInfo:Boolean read FDriverinfo write FDriverinfo;
    property BackgroundImage:TPicture read FBackground write SetbackgroundImage;
  end;

 T3DElement = record
            dwtype:Longint;
            dvposition:TD3DVector;
            du,dv:Single;
 end;



procedure Register;

implementation

var
   Devicedriver:array[0..10] of Driverrec;
   Drivercount:Integer;
   Currentdriver:Integer;



// Callback function for device driver enumeration
//=================================================
function EnumDevicesCallback(lpGuid: pGUID;
      lpDeviceDescription: lpstr; lpDeviceName: lpstr;
      var lpHWDesc: TD3DDeviceDesc;
      var lpHELDesc: TD3DDeviceDesc;
      lpUserArg: Pointer) : HResult; stdcall;
var
  desc : TD3DDeviceDesc;
  i:Integer;
begin
  begin
    desc := lpHELDesc;
    if desc.dcmColorModel <> 0 then
    begin
         Devicedriver[drivercount].DGUID:=lpGuid^;
         Devicedriver[drivercount].Name:=lpDeviceName;
         Devicedriver[drivercount].Desc:=lpDeviceDescription;
         Devicedriver[drivercount].Ishardware:=False;
         case desc.dcmColorModel of
              D3DCOLOR_MONO : Devicedriver[drivercount].Colormodel := 'Ramp';
              D3DCOLOR_RGB  : Devicedriver[drivercount].Colormodel := 'RGB';
         end;
         Inc(drivercount);
    end;
    desc := lpHWDesc;
    if desc.dcmColorModel <> 0 then
    begin
         Devicedriver[drivercount].DGUID:=lpGuid^;
         Devicedriver[drivercount].Name:=lpDeviceName;
         Devicedriver[drivercount].Desc:=lpDeviceDescription;
         Devicedriver[drivercount].Ishardware:=true;
         case desc.dcmColorModel of
              D3DCOLOR_MONO : Devicedriver[drivercount].Colormodel := 'Ramp';
              D3DCOLOR_RGB  : Devicedriver[drivercount].Colormodel := 'RGB';
         end;
         Inc(drivercount);
    end;
  end;
  result := DDENUMRET_OK;
end;


// TDGC3DRMViewport
// ===============================
constructor TDGC3DRMViewport.Create;
begin
     inherited Create;
     FViewport:=Nil;
     FFOV:=0.5;
     FFrontclipping:=1;
     FbackClipping:=1000;
     Fprojectiontype:=Perspective;
     FUniformscaling:=True;
end;

procedure TDGC3DRMViewport.SetViewport(Viewport:IDirect3DRMViewport2);
begin
     if Assigned(FViewport) then
        FViewport:=nil;
     FViewport:=Viewport;
     // froce settings to viewport
     Uniformscaling:=Funiformscaling;
     Projectiontype:=Fprojectiontype;
end;

procedure TDGC3DRMViewport.SetViewportValue(Index:Integer;Value:TD3DValue);
begin
     case Index of
          1:FX:=Value;
          2:FY:=Value;
          3:FWidth:=Value;
          4:Fheight:=Value;
          5:FFOV:=Value;
          6:FFrontClipping:=Value;
          7:FBackClipping:=Value;
     end;
     // if adjust x and y offset we need to adjust width and Height
     Fwidth:=FWidth-(FX+1);
     Fheight:=Fheight-(FY+1);
     if Assigned(FViewport) then
     begin
          FViewport.SetField(FFOV);
          FViewport.SetFront(FFrontclipping);
          FViewport.SetBack(FBackClipping);
          FViewport.Configure(round(Fx),round(Fy),round(FWidth),round(FHeight));
     end
end;

// use uniform scaling or not
procedure TDGC3DRMViewport.SetScaling(Value:Boolean);
begin
     FUniformscaling:=Value;
     if Assigned(FViewport) then
          Fviewport.SetUniformscaling(Value);
end;

// set the viewing plane of the frontcclipping of the viewport relative to the cameras Zaxis
procedure TDGC3DRMViewport.SetPlane(aLeft,aRight,aTop,aBottom:TD3DValue);
begin
     if Assigned(Fviewport) then
        FViewport.SetPlane(aLeft,aRight,aTop,aBottom);
end;

// gets the viewing plane of the frontcclipping of the viewport relative to the cameras Zaxis
procedure TDGC3DRMViewport.GetPlane(var aLeft,aRight,aTop,aBottom:TD3DValue);
begin
     if Assigned(Fviewport) then
        FViewport.GetPlane(aLeft,aRight,aTop,aBottom);
end;

// sets the viewports camera to the given frame setting position orientation etc
procedure TDGC3DRMViewport.Setcamera(AFrame:TDGC3DRMFRAMEITEM);
begin
     if Assigned(Fviewport) then
        FViewport.setcamera(AFrame.Frame);
end;

// set the projection type note
// if you use Righthand then you must use D3DRM setoptions to set right hand coords first
procedure TDGC3DRMViewport.SetProjectiontype(Value:TDGC3DProjectiontype);
begin
     FProjectiontype:=Value;
     if Assigned(FViewport) then
        FViewport.SetProjection(TD3DRMProjectiontype(Ord(Fprojectiontype)));
end;

// get some info from the viewport
function TDGC3DRMViewport.GetViewportValue(Index:Integer):TD3DValue;
begin
     if not (Assigned(FViewport)) then
     begin
          case Index of
               1:result:=FX;
               2:Result:=FY;
               3:Result:=FWidth;
               4:Result:=Fheight;
               5:Result:=FFOV;
               6:Result:=FFrontClipping;
               7:Result:=FBackClipping;
          end;
     end
     else
     begin
          case Index of
               1:result:=FViewport.GetX;
               2:Result:=FViewport.GetY;
               3:Result:=FViewport.GetWidth;
               4:Result:=FViewport.GetHeight;
               5:Result:=FViewport.GetField;
               6:Result:=FViewport.GetFront;
               7:Result:=FViewport.GetBack;
          end;
     end;
end;

// TDGC 3D RM Component
//======================
Constructor TDGC3DRMScreen.Create(Aowner:Tcomponent);
begin
     inherited Create(Aowner);
     Fbackground:=nil;
     Frendersurface:=Nil;
     Fback:=Nil;
     Ffront:=Nil;
     FFullscreen:=true;
     FD3DRMDevice:=nil;
     FViewport:=nil;
     FD3D:=nil;
     FScene:=nil;

     Fcanvas:=nil;
     FDD:=nil;
     FDGCInput:=nil;
     FMousePointer:= crarrow;
     FMouseX:=0;
     FShowMouse:=False;;
     FMouseY:=0;
     FFOV:=0.5;
     FFrontClipping:=1.0;
     FBackClipping:=1000.0;
     Fcamera:=TDGC3DRMCAMERACollection.Create(Aowner);
     FViewportSettings:=TDGC3DRMViewport.Create;
     Fbackground:=Tpicture.Create;
     FhasImage:=false;
     dodisplaymode;
     FOnPaint:=Nil;
     Fdriverinfo:=False;
     FOnrender:=Nil;
     FOnFlip:=Nil;
     FONInitialize:=Nil;
     FOncleanup:=Nil;
     Lights:=TDGC3DRMLightCollection.Create(Aowner);
     Frames:=TDGC3DRMFrameCollection.Create(AOwner);
     if not (csDesigning in ComponentState) then
     begin
          frmOnActivate := TForm(Owner).OnActivate;
          TForm(Owner).OnActivate := DoOnActivate;
     end;
end;

procedure TDGC3DRMScreen.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
   inherited Notification(AComponent, Operation);
   if (Operation = opRemove) and not (csDestroying in ComponentState) then
   begin
      if FDGCInput = Acomponent then
         FDGCInput :=nil;
   end;
end;

// overirdden loaded method
// sets the frame to none so you do not see it if mouse cursor
// goes over some area
//=============================================================
Procedure TDGC3DRMScreen.Loaded;
begin
     inherited Loaded;
     //Set form properties
     if not (csDesigning in ComponentState) and FFullscreen then
     begin
        with Owner as TForm do
        begin
           BorderStyle := bsNone;
           BorderIcons := [];
           FormStyle := fsStayOnTop;
           Color := clBlack;
       end;
   end;
end;

procedure TDGC3DRMScreen.SetMouseCursor(Value:TCursor);
begin
     FMousePointer:=Value;
end;

procedure TDGC3DRMScreen.Mousefired(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if button in [mbleft] then
        FMousestate := 1
     else
         if button in [mbright] then
            Fmousestate :=1
         else
             Fmousestate := 0;
end;

procedure TDGC3DRMScreen.Mousemoved(Sender: TObject;Shift: TShiftState; X, Y: Integer);
begin
     FMouseX:=X;
     FMouseY:=Y;
end;

function TDGC3dRMScreen.CreateFrame:TDGC3DRMFrameItem ;
var
   Frame:TDGC3DRMFrameItem ;
begin
     if Assigned(Fd3drm) then
     begin
          // create a blank frame in the frame list
          Frame:=FFrames.Add as TDGC3DRMFrameItem ;
          Frame.Init(FD3DRM,FScene,FViewport,FD3DRMDevice);
          Result:=Frame;
     end
     else
         Result:=nil;
end;

procedure TDGC3DRMscreen.CreateBackgroundsurface(w, h: Integer);
var
   SurfaceDesc: TDDSurfaceDesc;
begin
   //Fill in the DirectDrawSurface descriptor prior to creating the surface }
   FillChar(SurfaceDesc, SizeOf(Surfacedesc), 0) ;
   with SurfaceDesc do
   begin
      dwSize := SizeOf(SurfaceDesc) ;
      dwFlags := DDSD_CAPS or DDSD_HEIGHT or DDSD_WIDTH;
      If Screen.Width < w then
         ddSCaps.dwCaps := DDSCAPS_OFFSCREENPLAIN + DDSCAPS_SYSTEMMEMORY
      else
         ddSCaps.dwCaps := DDSCAPS_OFFSCREENPLAIN;// + DDSCAPS_SYSTEMMEMORY;
      dwWidth := w ;
      dwHeight := h ;
   end;
   if FDD.CreateSurface(SurfaceDesc, FBackgroundSurface, NIL ) <> DD_OK then
      Raise EDGCSurface.Create(Format('Could not create memory surface (%d, %d)',
               [w, h])) ;
   //Create canvas
   FCanvas := TDGC3DCanvas.Create(FbackgroundSurface);
   if Assigned(Fbackground.Graphic) then
   begin
        Fcanvas.stretchDraw(rect(0,0,w,h),Fbackground.Graphic);
        Fcanvas.Release;
   end;
end;


//Initialise directdraw interface
procedure TDGC3DRMScreen.InitDirectDraw;
var
   FDD4:IDirectDraw4;
   FD3DDevice:IDirect3dDevice3;
   FIMdevice:IDirect3DDevice2;
   Mousecur:Hcursor;
   res:hresult;
   i:integer;
begin
     Directdrawcreate(nil,FDD,nil);
     FDD.Queryinterface(IID_IDirectdraw4,FDD4);
     // create Direct 3D object
     Fdd4.queryinterface(IID_IDirect3D3,FD3D);
     drivercount:=0;
     DXCheck(FD3D.EnumDevices(EnumDevicesCallback, Self));
     // choose hardware over software
     currentdriver := -1;
     for i := 0 to drivercount -1 do
     begin
          if devicedriver[i].ishardware then
          begin
             currentdriver:=i;
             break;
          end;
     end;
     // di not find hardware device so use last available driver
     // usaully has better caps
     if currentdriver = -1 then
        currentdriver:=drivercount -1 ;
     // Create a clipper it will be used if we go into windowed mode
     // create front and back buffers
     if FFullscreen then
     begin
          FDD.SetCooperativeLevel(TForm(Owner).Handle,DDSCL_FULLSCREEN or DDSCL_EXCLUSIVE or DDSCL_ALLOWREBOOT);
          FDD.SetDisplaymode(w,h,bpp);
          fillchar(FDesc,sizeof(FDesc),0);
          with FDesc do
          begin
               dwsize:=SizeOf(FDesc);
               dwFlags := DDSD_CAPS + DDSD_BACKBUFFERCOUNT;
               dwBackBufferCount := 1;
               ddsCaps.dwCaps := DDSCAPS_PRIMARYSURFACE + DDSCAPS_3DDEVICE
                       + DDSCAPS_FLIP + DDSCAPS_COMPLEX;
          end;
          FDD4.Createsurface(Fdesc,Ffront,nil);
          Fcaps.dwcaps:=DDSCAPS_BACKBUFFER;
          FFront.Getattachedsurface(Fcaps,FBack);
          DXCheck(FD3D.CreateDevice(Devicedriver[currentdriver].DGUID,FBack,FD3DDevice,nil));
          FD3DRM.Createdevicefromsurface(@Devicedriver[currentdriver].DGUID,FDD,Fback as IDirectdrawsurface,0,FD3DRMdevice);
          DXCheck(FD3DRMDevice.GetDirect3DDevice2(FIMDevice));
          DXCheck(FIMdevice.GetrenderTarget(FRendersurface));
          Fcanvas:=TDGC3DCanvas.Create(Frendersurface);
     end
     else
     begin
          FDD4.SetCooperativeLevel(TForm(Owner).Handle,DDSCL_NORMAL);
          fillchar(FDesc,sizeof(FDesc),0);
          with FDesc do
          begin
               dwsize:=SizeOf(FDesc);
               dwFlags := DDSD_CAPS;
               ddsCaps.dwCaps := DDSCAPS_Primarysurface + DDSCAPS_3DDEVICE;
          end;
          FDD4.Createsurface(Fdesc,Ffront,nil);
          DXCheck(FD3D.CreateDevice(devicedriver[currentdriver].DGUID,FFront,FD3DDevice,nil));
          FDD4.CreateClipper(0,FClipper,nil);
          FClipper.sethwnd(0,TForm(Owner).Handle);
          FD3DRM.Createdevicefromclipper(FClipper,@Devicedriver[currentdriver].DGUID,TForm(Owner).width,TForm(Owner).height,FD3DRMdevice);
          DXCheck(FD3DRMDevice.GetDirect3DDevice2(FIMDevice));
          DXCheck(FIMdevice.GetrenderTarget(FRendersurface));
          Fcanvas:=TDGC3DCanvas.Create(Frendersurface);
     end;
     if not showmouse then
      Screen.Cursor := crnone
     else
       Screen.cursor:=Mouseimage;
     Mousecur:=GetCursor;
     Application.Mainform.OnMouseMove:=Mousemoved;
     Application.MainForm.OnMouseDown:=Mousefired;
end;

procedure TDGC3DRMScreen.RestoreSurfaces;
var
   FDD4:IDirectDraw4;
   FD3DDevice:IDirect3dDevice3;
   FIMdevice:IDirect3DDevice2;
   Ftempcamera:Idirect3drmframe3;
   Mousecur:Hcursor;
   res:hresult;
   i:integer;
begin
     FViewport:=nil;
     if Fullscreen then
        FFront._Restore
     else
     begin
          FDD4.CreateClipper(0,FClipper,nil);
          FClipper.sethwnd(0,TForm(Owner).Handle);
          FD3DRM.Createdevicefromclipper(FClipper,@Devicedriver[currentdriver].DGUID,TForm(Owner).width,TForm(Owner).height,FD3DRMdevice);
          D3DCheck( FD3DRM.CreateViewport(FD3DRMDevice,Fcamera.Items[0].camera,0,0,
          FD3DRMDevice.GetWidth,FD3DRMDevice.GetHeight,FViewport));
     end;
     if Assigned(FViewportsettings) then
     begin
          FViewportSettings.Viewport:=FViewport;
          dodisplaymode;
     end;
end;

// initialise directdraw and direct3d
procedure TDGC3DRMScreen.Initdirect3D;
var
   D3DRM:Idirect3dRM;
   I:Integer;
   Tempcamera:TDGC3DRMcameraItem;
begin
     Direct3DrmCreate(D3DRM);
     D3DRM.QueryInterface(IID_IDirect3DRM3,FD3DRM);
     Initdirectdraw;
     FD3drm.CreateFrame(nil,FScene);
     Fscene.setzbuffermode(D3DRMZBUFFER_ENABLE);
     // change code here to see if we have a camera collection if so create then
     // all then set the create the viewport using the first camera in the collection
     // if not set create a tempory camera object
     if Fcamera.Count <=0 then
     begin
          // create a new camera frame
          Tempcamera:=FCamera.Add as TDGC3DRMCameraItem;
          Tempcamera.Init(FD3DRM,Fscene,FD3DRMDevice);
          tempcamera.Camera.SetOrientation(FScene,0,0,1,0,1,0);
          tempcamera.X:=0;
          tempcamera.Y:=0;
          tempcamera.Z:=-50;
     end
     else
     begin
         // got a camera collection so initialize them all
         for i:=0 to Fcamera.Count-1 do
             Fcamera.Items[i].Init(FD3DRM,Fscene,FD3DRMDevice);
         Tempcamera:=FCamera.Items[0] as TDGC3DRMCameraItem;
     end;
     // Create The viewport
     D3DCheck( FD3DRM.CreateViewport(FD3DRMDevice,tempcamera.Camera,0,0,
               FD3DRMDevice.GetWidth,FD3DRMDevice.GetHeight,FViewport));
     if Assigned(FViewportsettings) then
     begin
          FViewportSettings.Viewport:=FViewport;
          // set x y width and height to match the screen size
          dodisplaymode;
     end;
     if Assigned(Fcamera) then
     begin
          // should always be unless some error
          if FCamera.count > 0 then
          begin
               for i:=0 to Fcamera.Count-1 do
               begin
                    Fcamera.Items[i].Viewport:=FViewport;
                    Fcamera.Items[i].Update;
               end;
          end;
     end;
     // initialize the lights
     if Assigned(FLights) then
     Begin
         if Flights.Count > 0 then
         begin
              for i:=0 to Flights.Count -1 do
                  FLights.Items[i].Init(FD3DRM,FScene,FViewport);
         end;
     end;
     // initilize all frames
     if Assigned(FFrames) then
     Begin
          if FFrames.Count > 0 then
          begin
               for i:=0 to FFrames.Count -1 do
               begin
                    FFrames.Items[i].Init(FD3DRM,FScene,FViewport,FD3DRMDevice);
                    FFrames.Items[i].LoadFrame;
                    if Fframes.Items[i].showshadow then
                    begin
                         if (FFrames.Items[i].lightsourceindex >-1) and (FFrames.Items[i].Lightsourceindex < Flights.Count) then
                            FFrames.Items[i].CastShadow(Flights.Items[FFrames.Items[i].LightsourceIndex]);
                    end;
               end;
          end;
     end;
     if FHasimage then
        Createbackgroundsurface(FD3DRMDevice.GetWidth,FD3DRMDevice.GetHeight);
     if Assigned(FOnInitialize) then
        FOnInitialize(Self);
     // initialize directinput device if we have one
     if Assigned(FDGCInput) then
        FDGCInput.Init;
     Application.OnMessage := AppMessage;
end;

// need to take into extra keys
procedure TDGC3DRMScreen.SetKeys(keyleft,keyright,keyup,keydown,fire1,fire2:word);
begin
     if FDGCInput <> nil then
        FDGCInput.setkeys(keyleft,keyright,keyup,keydown,fire1,fire2);
end;

function TDGC3DRMScreen.KeyDown(Key: word): Boolean;
begin
   if FDGCInput <> nil then
      Result:=FDGCInput.GetKeyDown(KEY)
   else
      Result:=GetASyncKeyState(Key) < 0;
end;

procedure TDGC3DRmScreen.DoOnActivate(Sender: TObject);
var
   n:integer;
begin
   if Assigned(frmOnActivate) then
      frmOnActivate(Owner);
   InitDirect3d;
   // if we have dgc audio comp then initialize it
   for n := 0 to Owner.ComponentCount - 1 do
   begin
       if Owner.Components[n] is TDGCAudio then
          TDGCAudio(Owner.Components[n]).InitDirectSound;
       if Owner.Components[n] is TDGCMIDI then
       begin
          TDGCMIDI(Owner.Components[n]).Init;
          TDGCMIDI(Owner.Components[n]).Loadmidi;
       end;
   end;
end;

procedure TDGC3DRMSCREEN.setbackgroundimage(Value:Tpicture);
begin
    if value <> Fbackground then
    begin
         FBackground.Assign(Value);
         FhasImage:=true;
    end
end;

procedure TDGC3DRMSCreen.AppMessage(var Msg: TMsg; var Handled : boolean ) ;
begin
   //Enable/Disbale Idle event if application not active
   case Msg.Message of
        WM_ACTIVATEAPP:
        begin
          //if not window mode
          //   showwindow(form1.handle, sw_showmaximized);
          if not Boolean(Msg.wParam) then
             StopTimer
          else
             PostMessage(Application.Handle, WM_DGCACTIVATE, 0, 0);
        end;
        WM_DGCACTIVATE:
        begin
          RestoreSurfaces;
          if FlippingEnabled then
             StartTimer
          else
            if Assigned(FOnPaint) then
              FOnPaint(Self);
          Application.OnIdle := AppIdle;
        end;
        WM_SYSCOMMAND:
        begin
           //Do not allow a screen saver to kick in
           Handled := (Msg.wParam = SC_SCREENSAVE);
        end;
   end;
end ;

procedure TDGC3DRMSCreen.SetFlippingEnabled(b: Boolean);
begin
   if b <> FFlippingEnabled then
   begin
      FFlippingEnabled := b;
      if not (csDesigning in ComponentState) then
      begin
         if FFlippingEnabled then
            StartTimer
         else
            StopTimer;
      end;
   end;
end;

procedure TDGC3DRMSCreen.Flip;
begin
   render;
end;

procedure TDGC3DRMScreen.AppIdle(Sender: TObject; var Done: Boolean);
begin
   Done := False;
   if not Assigned(FD3D) then exit;
   if Assigned(FOnFlip) then
      FOnFlip(Self);
   Flip;
end;

procedure TDGC3DRMScreen.StartTimer;
begin
   Application.OnIdle := AppIdle;
end;

procedure TDGC3DRMSCREEN.StopTimer;
begin
   Application.OnIdle := nil;
end;



// clean up direct draw and direct 3d
procedure TDGC3DRMScreen.CleanUpDirect3D;
begin
  if assigned(Fcamera) then
     FCamera:=nil;
  if assigned(Fviewport ) then
     FViewport:=nil;
  if assigned(FD3DRMDevice ) and (Fullscreen) then
     FD3DRMDevice:=nil;
  if assigned(FD3DRM ) then
     FD3DRM:=nil;
  if assigned(FD3D ) then
     FD3D:=nil;
  if Assigned(FDD) then
  begin
      if fullscreen then
      begin
           FDD.RestoreDisplayMode;
           Fdd.SetCooperativeLevel(0,DDSCL_NORMAL);
      end;
      if assigned(Frendersurface) then
         Frendersurface:=nil;
      if assigned(Fclipper) then
         FClipper:=Nil;
      if assigned(FBack) then
         FBack:=Nil;
      if assigned(Ffront) then
         FFront:=Nil;
      FDD := nil;
   end;
end;


procedure TDGC3DRMScreen.ClearRenderSurfaceRGB(Color:TColor);
var
  BltFx: TDDBLTFX;
  r: HResult;
  Fillcolor:Dword;
  FClientrect:TRect;
begin
  case bpp of
    8 :Fillcolor:=Byte(Loword(Fillcolor));
    16 :
      fillcolor :=
        (LoByte(LoWord(Color)) shr 3 shl 11) or   // Red
        (HiByte(LoWord(Color)) shr 2 shl 5) or    // Green
        (LoByte(HiWord(Color)) shr 3);            // Blue
    24, 32 :
      Fillcolor:=
        (LoByte(LoWord(Color)) shl 16) or   // Red
        (HiByte(LoWord(Color)) shl 8) or    // Green
        (LoByte(HiWord(Color)));            // Blue
  end;
  ZeroMemory ( @BltFx, sizeof(BltFx));
  BltFx.dwSize := sizeof(BltFx);
  BltFx.dwFillColor := FillColor;
  if fullscreen then
     FClientrect:=rect(0,0,w,h)
  else
      FClientrect:=TForm(Owner).ClientRect;
  DXcheck(FRenderSurface.Blt(@FClientRect, nil, @FClientRect, DDBLT_COLORFILL + DDBLT_WAIT, @BltFx));
end;

// check to see if one from is in the bounding box of another
// just quick and simple at the moment
function TDGC3DRMScreen.Collide(Frame1,Frame2:Integer):Boolean;
begin
     result:=false;
     if ((Frame1 < 0) or (Frame1 > FFrames.Count-1))
        or ((Frame2 < 0) or (Frame2 > FFrames.Count-1)) then
           exit;
     // check the x and y against width and height note negative numbers possible
     // need to take this into account
     // two frames are in the same quadrent
     // see if both X values are negative or positive
     // see if both Y values are neative or positive
     if (FFrames.Items[frame1].X >= FFrames.Items[Frame2].X) and (FFrames.Items[Frame1].X <= FFrames.Items[Frame2].X + FFrames.Items[Frame2].Width) then
     // X is within the frame so check the Y
        if (FFrames.Items[frame1].Y >= FFrames.Items[Frame2].Y) and (FFrames.Items[Frame1].Y <= FFrames.Items[Frame2].Y + FFrames.Items[Frame2].height) then
        // Y matches so check Z against Z and Depth
          if ((FFrames.Items[frame1].z >= FFrames.Items[Frame2].Z) and (FFrames.Items[Frame1].Z <= FFrames.Items[Frame2].Z + FFrames.Items[Frame2].Depth)) or
             ((FFrames.Items[frame1].z + FFrames.Items[frame1].Depth >= FFrames.Items[Frame2].Z) and (FFrames.Items[Frame1].Z + FFrames.Items[Frame1].Depth <= FFrames.Items[Frame2].Z + FFrames.Items[Frame2].Depth)) then
               result:=true;

end;

// main render loop
//=================
procedure TDGC3DRMScreen.Render;
var
   i:Integer;
   r: HResult;
   BltFx : TDDBLTFX;
   Coords : TRect;
   p2min,p2max:TD3DVector;
begin
    dxcheck(FScene.Move(1.0));
    FViewport.Clear(D3DRMCLEAR_ALL);
    clearRendersurfaceRGB(Backgroundcolor);
    // draw the background
    if (FHasImage) then
    begin
       coords:=rect(0,0,FD3DRMDevice.GetWidth,FD3DRMDevice.GetHeight);
       Frendersurface.BltFast(0,0,Fbackgroundsurface,@coords,DDBLTFAST_WAIT);
    end;
    if assigned(FOnrender) then
       FOnrender(Self);
    if Assigned(Flights) then
    begin
         for i:=0 to Flights.Count -1 do
         begin
              Flights.Items[i].Update;
              Flights.Items[i].Animate;
         end;
    end;
    if Assigned(FCamera) then
    begin
         for i:=0 to Fcamera.Count -1 do
         begin
              Fcamera.Items[i].Update;
              Fcamera.Items[i].Animate;
         end;
    end;
    if Assigned(FFrames) then
    begin
         for i:=0 to FFrames.Count -1 do
         begin
              FFrames.Items[i].Update;
              FFrames.Items[i].animate;
         end;
    end;
    dxcheck(FViewport.Render(FScene));
    dxcheck(FD3DRMDevice.Update);
    // if in full screen mode need to flip the back surface to the front
    if FFullScreen then
       Ffront.Flip(nil,DDFlip_wait);
end;

Procedure TDGC3DRMSCREEN.Dodisplaymode;
begin
     case DisplayMode of
          dm640x480x16:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=16;
                      end;
          dm640x480x24:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=24;
                      end;
          dm640x480x32:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=32;
                      end;
          dm800x600x16:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=16;
                      end;
          dm800x600x24:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=24;
                      end;
          dm800x600x32:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=32;
                      end;
          dm1024x768x16:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=16;
                       end;
          dm1024x768x24:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=24;
                       end;
          dm1024x768x32:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=32;
                       end;
     else
        w := 640;
        h := 480;
        bpp:=16;
     end;
     // set viewport settings to equal screen size
     with FViewportsettings do
     begin
          Width:=w - X;
          Height:=H - Y;
     end;
end;

procedure TDGC3DRMSCREEN.SetDisplayMode(Value:T3DdisplayMode);
begin
     if Value <> FdisplayMode then
     begin
        FdisplayMode:=Value;
        Dodisplaymode;
     end;
end;

destructor TDGC3DRMScreen.Destroy;
begin
     if Assigned(Fcanvas) then
        Fcanvas.Destroy;
     if Assigned(Frames) then
        Frames.Destroy;
     if Assigned(Lights) then
        Lights.Destroy;
     if assigned(FDGCInput) then
        FDGCInput.Destroy;
     CleanUpDirect3D;
     inherited Destroy;
end;



// TDGCFrameCollection
// ==========================
constructor TDGC3DRMFrameCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGC3DRMFrameItem );
     Fowner:=Aowner;
end;

// must be overidden for streaming to work properly
function TDGC3DRMFrameCollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGC3DRMFrameCollection.SetItem(Index:integer;Value:TDGC3DRMFrameItem );
begin
     inherited setitem(Index,Value);
end;

function TDGC3DRMFrameCollection.GetItem(Index:integer):TDGC3DRMFrameItem ;
begin
     Result:=TDGC3DRMFrameItem (inherited GetItem(Index));
end;

procedure TDGC3DRMFrameCollection.Promote(Index1:integer);
begin
     if Index1 > 0 then
        Swap(Index1,Index1-1);
end;

procedure TDGC3DRMFrameCollection.Demote(Index1:integer);
begin
     if Index1 < Count-2 then
        Swap(Index1,Index1+1);
end;


procedure TDGC3DRMFrameCollection.Swap(Index1,Index2:Integer);
type
    Temprec = record
         FMeshbuilder : IDirect3DRMMeshbuilder3;
         FD3DDevice:IDirect3DRMDevice3;
         FD3DRM:IDirect3DRM3;
         FScene:IDirect3DRMFrame3;
         FFrame:IDirect3DRMFrame3;
         FViewPort:IDirect3DRMViewport2;
         FColor:TLightColor;
         FShadeType:TShadeType;
         FRMShadeValue:TD3DRMRenderQuality;
         FName:string;
         FTextureFilename:String;
         FTexture:IDirect3drmtexture3;
         FAmbientlight:IDirect3drmlight;
         FFileName:string;
         FX,FY,FZ,FAngle:TD3DValue;
         FDirection:TRotateDirection;
         FWrapstyle:TWrapStyles;
         FAutorotate:Boolean;
         FSharpness:TD3DValue;
         FLookat:Boolean;
         FFollow:Boolean;
         FZoffset:TD3DValue;
         Lookatframe:TDGC3DRMFrameItem ;
         box:TD3DRMBox;
 end;
var
   tempitem,tempitem1:TDGC3DRMFrameItem ;
   tempdata:Temprec;
begin
     tempitem:=GetItem(Index1);
     Tempitem1:=GetItem(Index2);
     with tempdata do
     begin
         FMeshbuilder :=tempitem.Fmeshbuilder;
         FD3DDevice:=Tempitem.FD3DDevice;
         FD3DRM:=tempitem.FD3DRM;
         FScene:=tempitem.FScene;
         FFrame:=Tempitem.FFrame;
         FViewPort:=Tempitem.FViewport;
         FColor:=Tempitem.FColor;
         FShadeType:=Tempitem.ShadeType;
         FRMShadeValue:=Tempitem.FRMShadeValue;
         FName:=TempItem.Name;
         FTextureFilename:=Tempitem.FTextureFilename;
         FTexture:=TempItem.Ftexture;
         FAmbientlight:=Tempitem.FAmbientlight;
         FFileName:=Tempitem.FFileName;
         FX:=Tempitem.FX;
         FY:=Tempitem.FY;
         FZ:=Tempitem.FZ;
         FAngle:=Tempitem.FAngle;
         FDirection:=Tempitem.FDirection;
         FWrapstyle:=Tempitem.FWrapStyle;
         FAutorotate:=Tempitem.FAutorotate;
         FSharpness:=Tempitem.FSharpness;
         FLookat:=Tempitem.Flookat;
         FFollow:=Tempitem.FFollow;
         FZoffset:=Tempitem.FZoffset;
         Lookatframe:=Tempitem.FLookatframe;
         Box:=Tempitem.Fbox;
     end;
     with Items[Index1] do
     begin
         FMeshbuilder :=tempitem1.Fmeshbuilder;
         FD3DDevice:=Tempitem1.FD3DDevice;
         FD3DRM:=tempitem1.FD3DRM;
         FScene:=tempitem1.FScene;
         FFrame:=Tempitem1.FFrame;
         FViewPort:=Tempitem1.FViewport;
         FColor:=Tempitem1.FColor;
         FShadeType:=Tempitem1.ShadeType;
         FRMShadeValue:=Tempitem1.FRMShadeValue;
         FName:=TempItem1.Name;
         FTextureFilename:=Tempitem1.FTextureFilename;
         FTexture:=TempItem1.Ftexture;
         FAmbientlight:=Tempitem1.FAmbientlight;
         FFileName:=Tempitem1.FFileName;
         FX:=Tempitem1.FX;
         FY:=Tempitem1.FY;
         FZ:=Tempitem1.FZ;
         FAngle:=Tempitem1.FAngle;
         FDirection:=Tempitem1.FDirection;
         FWrapstyle:=Tempitem1.FWrapStyle;
         FAutorotate:=Tempitem1.FAutorotate;
         FSharpness:=Tempitem1.FSharpness;
         FLookat:=Tempitem1.Flookat;
         FFollow:=tempitem1.FFollow;
         FZoffset:=tempitem1.FZoffset;
         FLookatframe:=Tempitem1.FLookatframe;
         Fbox:=tempitem1.Fbox;
     end;
     with Items[Index2] do
     begin
         FMeshbuilder :=tempdata.Fmeshbuilder;
         FD3DDevice:=tempdata.FD3DDevice;
         FD3DRM:=tempdata.FD3DRM;
         FScene:=tempdata.FScene;
         FFrame:=tempdata.FFrame;
         FViewPort:=tempdata.FViewport;
         FColor:=tempdata.FColor;
         FShadeType:=tempdata.FShadeType;
         FRMShadeValue:=tempdata.FRMShadeValue;
         FName:=tempdata.FName;
         FTextureFilename:=tempdata.FTextureFilename;
         FTexture:=tempdata.Ftexture;
         FAmbientlight:=tempdata.FAmbientlight;
         FFileName:=tempdata.FFileName;
         FX:=tempdata.FX;
         FY:=tempdata.FY;
         FZ:=tempdata.FZ;
         FAngle:=tempdata.FAngle;
         FDirection:=tempdata.FDirection;
         FWrapstyle:=tempdata.FWrapStyle;
         FAutorotate:=tempdata.FAutorotate;
         FSharpness:=tempdata.FSharpness;
         FLookat:=tempdata.Flookat;
         FFollow:=Tempdata.FFollow;
         FZoffset:=Tempdata.FZoffset;
         FLookatframe:=tempdata.Lookatframe;
         Fbox:=tempdata.box
     end;
end;


procedure TDGC3DRMFrameCollection.Delete(Index1:Integer);
type
    Temprec = record
         FMeshbuilder : IDirect3DRMMeshbuilder3;
         FD3DDevice:IDirect3DRMDevice3;
         FD3DRM:IDirect3DRM3;
         FScene:IDirect3DRMFrame3;
         FFrame:IDirect3DRMFrame3;
         FViewPort:IDirect3DRMViewport2;
         FColor:TLightColor;
         FShadeType:TShadeType;
         FRMShadeValue:TD3DRMRenderQuality;
         FName:string;
         FTextureFilename:String;
         FTexture:IDirect3drmtexture3;
         FAmbientlight:IDirect3drmlight;
         FFileName:string;
         FX,FY,FZ,FAngle:TD3DValue;
         FDirection:TRotateDirection;
         FWrapstyle:TWrapStyles;
         FAutorotate:Boolean;
         FSharpness:TD3DValue;
         FLookat:Boolean;
         FFollow:Boolean;
         FZoffset:TD3Dvalue;
         Lookatframe:TDGC3DRMFrameItem ;
         box:TD3DRMBox;
 end;
var
   tempitem,tempitem1:TDGC3DRMFrameItem ;
   tempdata:Temprec;
   tempcollection:TDGC3DRMFrameCollection;
   i:Integer;
begin
     Tempcollection:=TDGC3DRMFrameCollection.Create(FOwner);
     for i:=0 to Count-1 do
     begin
          Tempitem:=getitem(i);
          with tempdata do
          begin
               if i <> Index1 then
               begin
                   FMeshbuilder :=tempitem.Fmeshbuilder;
                   FD3DDevice:=Tempitem.FD3DDevice;
                   FD3DRM:=tempitem.FD3DRM;
                   FScene:=tempitem.FScene;
                   FFrame:=Tempitem.FFrame;
                   FViewPort:=Tempitem.FViewport;
                   FColor:=Tempitem.FColor;
                   FShadeType:=Tempitem.ShadeType;
                   FRMShadeValue:=Tempitem.FRMShadeValue;
                   FName:=TempItem.Name;
                   FTextureFilename:=Tempitem.FTextureFilename;
                   FTexture:=TempItem.Ftexture;
                   FAmbientlight:=Tempitem.FAmbientlight;
                   FFileName:=Tempitem.FFileName;
                   FX:=Tempitem.FX;
                   FY:=Tempitem.FY;
                   FZ:=Tempitem.FZ;
                   FAngle:=Tempitem.FAngle;
                   FDirection:=Tempitem.FDirection;
                   FWrapstyle:=Tempitem.FWrapStyle;
                   FAutorotate:=Tempitem.FAutorotate;
                   FSharpness:=Tempitem.FSharpness;
                   FLookat:=Tempitem.Flookat;
                   FFollow:=Tempitem.FFollow;
                   FZoffset:=Tempitem.FZoffset;
                   Lookatframe:=Tempitem.FLookatframe;
                   Box:=Tempitem.FBox;
              end
              else
              begin
                  tempitem.Fscene.Deletechild(tempitem.Frame);
                  tempitem.FFrame:=nil;
              end;
          end;
          tempitem1:=Tempcollection.Add as TDGC3DRMFrameItem ;
          with tempitem1 do
          begin
               FMeshbuilder :=tempdata.Fmeshbuilder;
               FD3DDevice:=tempdata.FD3DDevice;
               FD3DRM:=tempdata.FD3DRM;
               FScene:=tempdata.FScene;
               FFrame:=tempdata.FFrame;
               FViewPort:=tempdata.FViewport;
               FColor:=tempdata.FColor;
               FShadeType:=tempdata.FShadeType;
               FRMShadeValue:=tempdata.FRMShadeValue;
               FName:=tempdata.FName;
               FTextureFilename:=tempdata.FTextureFilename;
               FTexture:=tempdata.Ftexture;
               FAmbientlight:=tempdata.FAmbientlight;
               FFileName:=tempdata.FFileName;
               FX:=tempdata.FX;
               FY:=tempdata.FY;
               FZ:=tempdata.FZ;
               FAngle:=tempdata.FAngle;
               FDirection:=tempdata.FDirection;
               FWrapstyle:=tempdata.FWrapStyle;
               FAutorotate:=tempdata.FAutorotate;
               FSharpness:=tempdata.FSharpness;
               FLookat:=tempdata.Flookat;
               FFollow:=tempdata.FFollow;
               FZoffset:=tempdata.FZoffset;
               FLookatframe:=tempdata.Lookatframe;
               FBox:=tempdata.Box;
          end;
     end;
     Clear;
     for i:=0 to Tempcollection.Count-1 do
     begin
           Tempitem:=Tempcollection.items[i];
           with tempdata do
           begin
                FMeshbuilder :=tempitem.Fmeshbuilder;
                FD3DDevice:=Tempitem.FD3DDevice;
                FD3DRM:=tempitem.FD3DRM;
                FScene:=tempitem.FScene;
                FFrame:=Tempitem.FFrame;
                FViewPort:=Tempitem.FViewport;
                FColor:=Tempitem.FColor;
                FShadeType:=Tempitem.ShadeType;
                FRMShadeValue:=Tempitem.FRMShadeValue;
                FName:=TempItem.Name;
                FTextureFilename:=Tempitem.FTextureFilename;
                FTexture:=TempItem.Ftexture;
                FAmbientlight:=Tempitem.FAmbientlight;
                FFileName:=Tempitem.FFileName;
                FX:=Tempitem.FX;
                FY:=Tempitem.FY;
                FZ:=Tempitem.FZ;
                FAngle:=Tempitem.FAngle;
                FDirection:=Tempitem.FDirection;
                FWrapstyle:=Tempitem.FWrapStyle;
                FAutorotate:=Tempitem.FAutorotate;
                FSharpness:=Tempitem.FSharpness;
                FLookat:=Tempitem.Flookat;
                FFollow:=Tempitem1.FFollow;
                FZoffset:=Tempitem1.FZoffset;
                Lookatframe:=Tempitem.FLookatframe;
                Box:=Tempitem.FBox;
              end;
              tempitem1:=Add as TDGC3DRMFrameItem ;
              with tempitem1 do
              begin
                   FMeshbuilder :=tempdata.Fmeshbuilder;
                   FD3DDevice:=tempdata.FD3DDevice;
                   FD3DRM:=tempdata.FD3DRM;
                   FScene:=tempdata.FScene;
                   FFrame:=tempdata.FFrame;
                   FViewPort:=tempdata.FViewport;
                   FColor:=tempdata.FColor;
                   FShadeType:=tempdata.FShadeType;
                   FRMShadeValue:=tempdata.FRMShadeValue;
                   FName:=tempdata.FName;
                   FTextureFilename:=tempdata.FTextureFilename;
                   FTexture:=tempdata.Ftexture;
                   FAmbientlight:=tempdata.FAmbientlight;
                   FFileName:=tempdata.FFileName;
                   FX:=tempdata.FX;
                   FY:=tempdata.FY;
                   FZ:=tempdata.FZ;
                   FAngle:=tempdata.FAngle;
                   FDirection:=tempdata.FDirection;
                   FWrapstyle:=tempdata.FWrapStyle;
                   FAutorotate:=tempdata.FAutorotate;
                   FSharpness:=tempdata.FSharpness;
                   FLookat:=tempdata.Flookat;
                   FFollow:=Tempdata.FFollow;
                   FZoffset:=tempdata.FZoffset;
                   FLookatframe:=tempdata.Lookatframe;
                   FBox:=tempdata.Box;
              end;
     end;
end;

// Tframe items Object methods
// =======================
Constructor TDGC3DRMFrameItem .Create(ACollection:TCollection);
begin
     inherited Create(Acollection);
     FScene:=nil;
     FFrame:=nil;
     FtextureFilename:='';
     Ftexture:=nil;
     FAnimation:=nil;
     FSharpness:=1.0;
     FName:='';
     FFileName:='';
     FX:=0.0;
     FY:=0.0;
     FZ:=0.0;
     Fangle:=0.0;
     FColor:=TLightColor.Create;
     Fscale:=TDGC3DXYZ.Create;
     Fscale.X:=1;
     FScale.Y:=1;
     FScale.Z:=1;
     FColor.Red:=0.8;
     FColor.Blue:=0.8;
     FColor.Green:=0.8;
     Fautorotate:=False;
     Fanimationframe:=-1;
     FLookat:=False;
     FFollow:=False;
     FUseFullPaths:=True;
     Fautorotate:=False;
     FcastShadow:=False;
     FVisible:=True;
end;

// create and initialize the Direct 3d Light Source
procedure TDGC3DRMFrameItem .Init(Direct3DRM:IDirect3DRM3;Scene:IDirect3DRMFrame3;ViewPort:IDirect3DRMViewport2;D3DDevice:IDirect3DRMDevice3);
begin
     if Assigned(Scene) then
     begin
          FD3DRM:=Direct3DRM;
          FViewport:=Viewport;
          FD3DDevice:=D3DDevice;
          FScene:=Scene;
          Direct3DRM.CreateFrame(Fscene,FFrame);
          FFrame.SetPosition(FScene,-X,-Y,-Z);
          DXCheck(FD3DRM.CreateMeshBuilder(FMeshbuilder) );
          Fanimation:=TDGC3DRManimation.Create;
     end;
end;

// add a shadow into the scene
procedure TDGC3DRMFRameitem.CastShadow(alight:TDGC3DRMLightItem);
var
   Shadow:TDGC3DRMShadow;
begin
     if Assigned(FD3DRM) then
     begin
          Shadow:=TDGC3DRMShadow.Create(FD3DRM,FScene,alight,self);
          Shadow.Init;
     end;
end;

procedure TDGC3DRMFrameitem.Moverelative;
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(FLookatframe.FFrame.GetPosition(Fscene, p1));
     P1.Z:=P1.Z + FZoffset;
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+(D3DMultiply(D3DVAL(y), p2.w));
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FFRame.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;

procedure TDGC3DRMFrameitem.animate;
var
   aangle:Td3dvalue;
   Adirection:Trotatedirection;
begin
      if not assigned(Fanimation) then
         Exit;
      if Fanimation.Fanimation.Count <= 0 then
         Exit;
      if Fanimation.running then
      begin
           X:=Fanimation.X;
           Y:=Fanimation.Y;
           Z:=Fanimation.Z;
           aangle:=Fanimation.angle;
           ADirection:=Fanimation.direction;
           Rotate(Adirection,aangle * PI/180);
           Fanimation.update;
      end;
end;


//procedure TDGC3DRMFrameitem.Moveabsolute(X,Y,Z);
//begin
//end;

procedure TDGC3DRMFrameItem .Update;
begin
     if Assigned(FFrame) then
     begin
          if autospin then
             spin;
          FFrame.SetColorRGB(FColor.Red,FColor.Green,Fcolor.BLue);
          if FLookat then
          begin
             FFrame.LookAt(FlookatFrame.FFrame,FScene,D3DRMCONSTRAIN_Z);
             FLookat:=False;
          end
          else
          if FFollow then
          begin
               MOVERELATIVE;
               FFollow:=False;
          end
          else
              DXCheck(FFrame.Setposition(Fscene,-X,-Y,-Z));

     end;
end;

procedure TDGC3DRMFrameitem.follow(AFrameItem:TDGC3DRMFrameItem ;AOffset:TD3Dvalue);
begin
     if Assigned(FFrame) then
     begin
          //FZ:=AframeItem.Z;
          FZoffset:=Aoffset;
          Flookatframe:=Aframeitem;
          FFollow:=True;
     end;
end;

procedure TDGC3DRMFrameItem .SetPosition(Index:integer;Value:TD3DValue);
begin
     case Index of
          0:FX:=Value;
          1:FY:=Value;
          2:FZ:=Value;
     end;
     if Assigned(FFrame) then
     begin
           //Move(FX,FY,FZ)
     end;
end;

procedure TDGC3DRMFrameItem.LookAt(AFrame:TDGC3DRMFrameItem );
begin
     if Assigned(FFrame) then
     begin
          Flookatframe:=Aframe;
          FFrame.LookAt(AFrame.FFrame,FScene,D3DRMCONSTRAIN_Z);
          FLookat:=True;
     end;
end;

procedure TDGC3DRMFrameItem .Setangle(Value:TD3DValue);
begin
     Fangle:=Value;
     if Assigned(FFrame) then
        Spin;
end;

procedure TDGC3DRMFrameItem .Spin;
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  case SpinDirection of
      rotateright:DXCheck( Fframe.setrotation(FFrame,0,-1,0,FAngle));
       rotateleft:DXCheck( Fframe.Setrotation(FFrame,0,1,0,FAngle));
          rotateup:DXCheck( Fframe.Setrotation(FFrame,1,0,0,FAngle));
        Rotatedown:DXCheck( Fframe.Setrotation(FFrame,-1,0,0,FAngle));
  end;
  Autospin:=true;
end;

procedure TDGC3DRMFrameItem .StopSpinning;
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  case SpinDirection of
      rotateright:DXCheck( Fframe.setrotation(FFrame,0,-1,0,0));
       rotateleft:DXCheck( Fframe.Setrotation(FFrame,0,1,0,0));
          rotateup:DXCheck( Fframe.Setrotation(FFrame,1,0,0,0));
        Rotatedown:DXCheck( Fframe.Setrotation(FFrame,-1,0,0,0));
  end;
  Autospin:=False;
end;

// takes rotation direction and step size as parameters
procedure TDGC3DRMFrameItem .Rotate(Adirection:Trotatedirection;Stepsize:TD3DValue);
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
 if not Assigned(Fframe) then Exit;
 case ADirection of
        rotateleft:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,0,-1,0,Stepsize));
       rotateright:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,0,1,0,Stepsize));
          rotateup:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,1,0,0,Stepsize));
        Rotatedown:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,-1,0,0,Stepsize));
  end;
  FFrame.Setposition(FScene,-x,-y,-z);
end;



procedure TDGC3DRMFrameItem .SetShadeType(Value:TShadetype);
begin
     FShadeType:=Value;
     case FshadeType of
         Wireframe :FRMShadeValue := D3DRMRENDER_WIREFRAME;
         UnlitFlat :FRMShadeValue := D3DRMRENDER_UNLITFLAT;
         Flat      :FRMShadeValue := D3DRMRENDER_FLAT;
         Gouraud   :FRMShadeValue := D3DRMRENDER_GOURAUD;
         Phong     :FRMShadeValue := D3DRMRENDER_PHONG;
     end;
     if Assigned(FD3DDevice) then
     begin
          DXCheck(FD3DDevice.SetQuality(FRMShadeValue));
          DXCheck(FD3DDevice.SetShades(64));
          DXCheck(FD3DRM.SetDefaultTextureShades(128));
          DXCheck(FD3DRM.SetDefaultTextureColors(64));
          DXCheck(FD3DDevice.SetDither(False));
     end;
end;


procedure TDGC3DRMFrameItem.LoadFrame;
var
  Visualarray : IDirect3DRMVisualArray;
  Visual  : IDirect3DRMVisual;
  PFilename : PChar;
  i : integer;
  Hres : HResult;
  mat:IDIrect3DRMMATERIAL2;
  wrap:IDirect3DRMwrap;
  tempframe:IDirect3drmframe;
  wrapstyle:TD3DRMWRAPTYPE;

  miny, maxy:TD3DValue;
  Tempfilename:string;
begin
  if Filename = '' then exit;
  if not FuseFullpaths then
    Tempfilename:=Extractfilename(FileName)
  else
      Tempfilename:=FFileName;
  PFilename := StrAlloc(Length(tempfilename)+1);
  StrPCopy(PFilename,tempFilename);
  Hres:= FMeshbuilder.Load(PFilename,nil,D3DRMLOAD_FROMFILE,nil,nil);
  // see if file was not loaded
  if (Hres = D3DRMERR_FILENOTFOUND) or (Hres = D3DRMERR_BADFILE) then
  begin
     if assigned(PFilename) then
        StrDispose(PFilename);
     Exit;
  end;
  DXCheck(Hres);
  Loadtexture;
  FMeshbuilder.Scale(FScale.X,Fscale.Y,Fscale.Z);
  DXCheck(FD3DRM.CreateMaterial(FSharpness, mat));
  DXCheck(Fmeshbuilder.SetMaterial(mat));
  DXCheck(Fmeshbuilder.SetQuality(FRMShadeValue));
  DXCheck(Fmeshbuilder.Generatenormals(0,D3DRMGENERATENORMALS_PRECOMPACT));
  DXCheck(Fmeshbuilder.CreateMesh(Fmesh));
  DXCheck(Fmeshbuilder.GetBox(Fbox));
  maxy := Fbox.max.y;
  miny := Fbox.min.y;
  Fheight := FBox.max.y - FBox.min.y;
  Fwidth  := FBox.max.X - FBox.min.x;
  Fdepth  := FBox.max.z - FBox.min.z;
  case FWrapStyle of
       FlatWrap : wrapstyle := D3DRMWRAP_FLAT;
       spherical : wrapstyle := D3DRMWRAP_SPHERE;
       CYLINDER:wrapstyle :=D3DRMWRAP_CYLINDER;
       Chrome:wrapstyle :=D3DRMWRAP_CHROME;
  end;
  // do a simple wrap
  DXCheck(FD3DRM.CreateWrap(wrapstyle, Nil, 0.0,
                              0.0, 0.0, 0.0,
                              1.0, 0.0, 0.0,
                              0.0, 1.0, 0.0,
                              D3DDivide(miny, Fheight), 1.0,
                              D3DDivide(-1.0, Fheight), wrap));

  DXCheck(wrap.Apply(Fmesh));
  DXCheck(Fframe.AddVisual(Fmesh));
  DXCheck(Fframe.SetPosition(FScene,-x,-y,-z));
  DXCheck(FD3DRM.CreateLightRGB(D3DRMLIGHT_AMBIENT,FColor.red,FColor.Green,FColor.Blue,FAmbientlight));
  DXCheck(FFrame.addlight(FAmbientlight));
  Releasecom(wrap);
  Releasecom(mat);
end;

procedure TDGC3DRMFrameitem.SetVisible(Value:Boolean);
begin
     if FVisible <> Value then
     begin
          Fvisible:=Value;
          if Assigned(FFrame) then
          begin
               if Not Fvisible then
               begin
                    FFrame.Deletevisual(Fmesh);
               end
               else
               begin
                    FFrame.Addvisual(Fmesh);
               end;
           end;
      end;
end;

procedure TDGC3DRMFrameItem.SetScale(Value:TDGC3DXYZ);
begin
     FScale:=Value;
     if Assigned(FFrame) then
     begin
          Fframe.addScale(D3DRMCOMBINE_after,FScale.X,FScale.Y,FScale.Z);
     end;
end;

function TDGC3DRMFrameItem.CreateMesh:IDirect3drmmesh;
begin
end;


function TDGC3DRMFrameItem.Createwrap:IDirect3drmwrap;
begin
end;

procedure TDGC3DRMFrameItem.Loadtexture;
var
   pfilename:PChar;
   hres:Hresult;
   Tempfilename:string;
begin
     if Texture <> '' then
     begin
       if not FuseFullpaths then
          Tempfilename:=Extractfilename(FTextureFileName)
       else
           Tempfilename:=FTextureFileName;
       PFilename := StrAlloc(Length(FtextureFilename)+1);
       StrPCopy(PFilename,FtextureFilename);
       hres:=FD3drm.Loadtexture(PFilename,Ftexture);
       if (Hres = D3DRMERR_FILENOTFOUND) or (Hres = D3DRMERR_BADFILE) then
       begin
            if assigned(PFilename) then
               StrDispose(PFilename);
            Exit;
       end;
//       meshbuilder.SetTexture(Ftexture);
       FFrame.Setmaterialmode(D3DRMMATERIAL_FROMFRAME);
       FFrame.Settexture(FTexture);
     end;
     if assigned(PFilename) then
         StrDispose(PFilename);
end;

procedure TDGC3DRMFrameItem.Move(X,Y,Z:Double);
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(FFrame.GetPosition(Fscene, p1));
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+X;//(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+Y;//(D3DMultiply(D3DVAL(y), p2.w));
     p2.z:=p2.Z+Z;
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FFrame.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;


Destructor TDGC3DRMFrameItem.Destroy;
begin
     if Assigned(fanimation) then
        Fanimation.destroy;
     releasecom(Fmeshbuilder);
     Releasecom(Ftexture);
     Releasecom(FFrame);
     inherited Destroy;
end;


// create an animation object and set the frame to this frame
//============================================================
constructor TDGC3DRManimation.Create;
begin
     inherited Create;
     Frunning:=False;
     Freversed:=False;
     Fautoreverse:=False;
     Fanimation:=Tlist.Create;
     Fanimationframe:=0;
end;


function TDGC3drmanimation.getPosition(Index:integer):TD3Dvalue;
var
   keydata:^Tanimationrec;
begin
     if fanimationframe > Fanimation.Count -1 then
        Exit;
     new(keydata);
     Keydata:=Fanimation.Items[FanimationFrame];
     case Index of
          0:Result:=keydata^.X;
          1:Result:=keydata^.Y;
          2:Result:=keydata^.Z;
          3:Result:=Keydata^.ID;
          4:Result:=Keydata^.Angle;
          5:Result:=Keydata^.R;
          6:Result:=KeyData^.G;
          7:Result:=Keydata^.B;
     end;
end;

function TDGC3DRManimation.Getdirection:Trotatedirection;
var
   keydata:^Tanimationrec;
begin
     if fanimationframe > Fanimation.Count -1 then
        Exit;
     new(keydata);
     Keydata:=Fanimation.Items[FanimationFrame];
     Result:=keydata^.Direction;
end;

destructor TDGC3DRManimation.Destroy;
begin
     // free the list
     if Assigned(Fanimation) then
        Fanimation.free;
     inherited destroy;
end;

procedure TDGC3DRManimation.Play;
begin
     if Assigned(Fanimation) then
     begin
          Flooped:=False;
          Fanimationframe:=0;
          Start;
     end;
end;

procedure TDGC3DRManimation.LOOP;
begin
     if Assigned(Fanimation) then
     begin
          Flooped:=True;
          FanimationFrame:=0;
          Start;
     end;
end;

procedure TDGC3DRManimation.Update;
begin
    if FRunning then
    begin
       if not Freversed then
       begin
            Inc(Fanimationframe);
            if Fanimationframe >= Fanimation.Count-1 then
            begin
                 if Flooped then
                 begin
                    if not Fautoreverse then
                       Fanimationframe:=0
                    else
                        Freversed:=true;
                 end
                 else
                     Stop;
            end;
       end
       else
       begin
            dec(Fanimationframe);
            if Fanimationframe <= 0 then
            begin
                 if Flooped then
                 begin
                    if not Fautoreverse then
                       Fanimationframe:=Fanimation.Count-1
                    else
                        Freversed:=false;
                 end
                 else
                     Stop;
            end;
       end;
    end;

end;

procedure TDGC3DRManimation.Start;
begin
     Frunning:=True;
end;

procedure TDGC3DRManimation.Stop;
begin
     Frunning:=False;
end;


procedure TDGC3DRManimation.AddPositionkey(x,y,z,angle:TD3DValue;direction:Trotatedirection;Color:TCOLOR);
var
   KeyData:^Tanimationrec;
begin
     new(Keydata);
     Keydata.ID:=0;
     Keydata.X:=X;
     Keydata.Y:=Y;
     keydata.Z:=Z;
     Keydata.R:=Color and $FF;
     Keydata.B:=Color and $FF0000;
     Keydata.G:=Color and $FF00;
     Keydata.angle:=angle;
     Keydata.Direction:=Direction;
     Fanimation.Add(keydata);
end;

procedure TDGC3DRManimation.doanimation;
begin

//     if Assigned(Fanimation) then
//     begin
//          Fanimationframe:=round(Time);
//          DXcheck(Fanimation.SetTime(Time));
//     end;
end;

procedure TDGC3DRManimation.addscalekey(x,y,z:TD3DValue);
begin
  //   if Assigned(Fanimation) then
  //        DXcheck(Fanimation.Addscalekey(Time,x,y,z));

end;

// TDGC3DRMCameraItem
// ===============================
constructor TDGC3DRMCAMERAItem.Create(Acollection:TCollection);
begin
     inherited Create(Acollection);
     Fcamera:=Nil;
     FAnimation:=nil;
     Fscene:=Nil;
     FD3DRM:=nil;
     FViewport:=nil;
     Flookat:=False;
     FFollow:=False;
     FX:=0;
     FY:=0;
     FZ:=0;
     FYAngle:=0;
     FZangle:=0;
     FZoffset:=0;
     FXanglechanged:=true;
     FYanglechanged:=true;
end;

// create and initialize
procedure TDGC3DRMCameraItem .Init(Direct3DRM:IDirect3DRM3;Scene:IDirect3DRMFrame3;D3DDevice:IDirect3DRMDevice3);
begin
     if Assigned(Scene) then
     begin
          FD3DRM:=Direct3DRM;
          FViewport:=nil;
          FD3DDevice:=D3DDevice;
          FScene:=Scene;
          Direct3DRM.CreateFrame(Fscene,FCamera);
          FCamera.SetPosition(FScene,-X,-Y,-Z);
          Fanimation:=TDGC3DRManimation.Create;
     end;
end;

// give this object the camera object
procedure TDGC3DRMCAMERAItem.Setcamera(camera:IDirect3DRMframe3);
begin
     if Assigned(Fcamera) then
        Fcamera:=nil;
     Fcamera:=camera;
end;

// set the scene
procedure TDGC3DRMCAMERAItem.SetScene(Scene:IDirect3DRMframe3);
begin
     if Assigned(FScene) then
        FScene:=nil;
     FScene:=Scene;
end;

// set the camera viewport
procedure TDGC3DRMCAMERAItem.SetViewport(Viewport:IDirect3DRMViewport2);
begin
     if Assigned(FViewport) then
        FViewport:=nil;
     FViewport:=Viewport;
end;

// update cameras positio etc
procedure TDGC3DRMCAMERAItem.Update;
begin
     if Assigned(Fcamera) then
     begin
          if FLookat then
          begin
             FCamera.LookAt(lookatFrame.FFrame,FScene,D3DRMCONSTRAIN_Z);
             FLookat:=False;
          end
          else
              if FFollow then
              begin
                   MOVERELATIVE;
                   FFollow:=False;
              end
              else
                 Fcamera.setposition(FScene,X,Y,Z);

     end;
end;

// move the camera frame
procedure TDGC3DRMCAMERAItem.Move(X,Y,Z:Double);
begin
     Fcamera.SetPosition(FScene,X,Y,Z);
     if FXanglechanged then
     begin
           Rotate(Rotateup,Xangle* Pi/180);
           FXanglechanged:=False;
     end;
     if FYanglechanged then
     begin
          Rotate(Rotateleft,Yangle* Pi/180);
          FYanglechanged:=False;
     end;
end;

procedure TDGC3DRMcameraitem.animate;
var
   aangle:Td3dvalue;
   Adirection:Trotatedirection;
begin
      if not assigned(Fanimation) then
         Exit;
      if Fanimation.Fanimation.Count <= 0 then
         Exit;
      if Fanimation.running then
      begin
           X:=Fanimation.X;
           Y:=Fanimation.Y;
           Z:=Fanimation.Z;
           aangle:=Fanimation.angle;
           ADirection:=Fanimation.direction;
           Rotate(Adirection,aangle * PI/180);
           Fanimation.update;
      end;
end;

procedure TDGC3DRMCAMERAItem.Lookat(AFrameItem:TDGC3DRMFrameItem );
begin
     if Assigned(FCamera) then
     begin
          lookatframe:=Aframeitem;
          FCamera.LookAt(AFrameItem.FFrame,FScene,D3DRMCONSTRAIN_Z);
          FLookat:=True;
     end;
end;

procedure TDGC3DRMCAMERAItem.Moverelative;
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(Lookatframe.FFrame.GetPosition(Fscene, p1));
     P1.Z:=P1.Z + FZoffset;
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+(D3DMultiply(D3DVAL(y), p2.w));
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FCamera.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;


procedure TDGC3DRMCAMERAItem.follow(AFrameItem:TDGC3DRMFrameItem ;AOffset:TD3Dvalue);
begin
     if Assigned(FCamera) then
     begin
          //FZ:=AframeItem.Z;
          FZoffset:=Aoffset;
          lookatframe:=Aframeitem;
          FFollow:=True;
     end;
end;

// takes rotation direction and step size as parameters
procedure TDGC3DRMCAMERAItem.Rotate(Adirection:Trotatedirection;Stepsize:TD3DValue);
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
 if not Assigned(Fcamera) then Exit;
 case ADirection of
        rotateleft:DXCheck( Fcamera.addrotation(D3DRMCOMBINE_REPLACE,0,-1,0,Stepsize));
       rotateright:DXCheck( Fcamera.addrotation(D3DRMCOMBINE_REPLACE,0,1,0,Stepsize));
          rotateup:DXCheck( Fcamera.addrotation(D3DRMCOMBINE_REPLACE,1,0,0,Stepsize));
        Rotatedown:DXCheck( Fcamera.addrotation(D3DRMCOMBINE_REPLACE,-1,0,0,Stepsize));
  end;
  DXCheck(Fcamera.Setposition(Fscene,x,y,z));
end;

procedure TDGC3DRMCAMERAItem.SetcameraValue(Index:Integer;Value:TD3DValue);
begin
     case Index of
          1:FX:=Value;
          2:FY:=Value;
          3:FZ:=Value;
     end;
     if Assigned(Fcamera) then
     begin
          //positioncamera
    //      Fcamera.SetPosition(FScene,X,Y,Z);
     end
end;


procedure TDGC3DRMCAMERAITEM.SetCameraXvalue(Value:TD3Dvalue);
begin
     FZangle:=Value;
     FXanglechanged:=True;
end;

procedure TDGC3DRMCAMERAITEM.SetCameraYvalue(Value:TD3Dvalue);
begin
     Fyangle:=Value;
     //positioncamera
     FYanglechanged:=True;
end;

function TDGC3DRMCAMERAITEM.GetcameraValue(Index:Integer):TD3DValue;
begin
     case Index of
          1:result:=FX;
          2:Result:=FY;
          3:Result:=FZ;
     end;
end;


// TDGCCameraCollection
// ==========================
constructor TDGC3DRMCameraCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGC3DRMCameraItem);
     Fowner:=Aowner;
     FCurrentcamera:=0;
end;

// must be overidden for streaming to work properly
function TDGC3DRMCameraCollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGC3DRMCameraCollection.Next;
begin
     Inc(FCurrentCamera);
     if Fcurrentcamera > Count -1 then
        FCurrentCamera:=Count-1;
     with Items[FCurrentCamera] do
          FViewport.SetCamera(Fcamera);
end;

procedure TDGC3DRMCameraCollection.Prev;
begin
     Dec(FCurrentCamera);
     if Fcurrentcamera < 0  then
        FCurrentCamera:=0;
     with Items[FCurrentCamera] do
          FViewport.SetCamera(Fcamera);
end;

procedure TDGC3DRMCameraCollection.First;
begin
    if Count <= 0 then
       Exit;
    FCurrentCamera:=0;
    with Items[FCurrentCamera] do
          FViewport.SetCamera(Fcamera);
end;

procedure TDGC3DRMCameraCollection.Last;
begin
     if Count <= 0 then
        Exit;
     FCurrentCamera:=Count-1;
     with Items[FCurrentCamera] do
          FViewport.SetCamera(Fcamera);
end;

procedure TDGC3DRMCameraCollection.gotocamera(Index:integer);
begin
     if Count <=0 then Exit;
     if (Index >= 0) and (Index <= Count -1) then
     begin
        FCurrentCamera:=Index;
        with Items[FCurrentCamera] do
             FViewport.SetCamera(Fcamera);
     end;
end;

procedure TDGC3DRMCameraCollection.SetItem(Index:integer;Value:TDGC3DRMCameraItem);
begin
     inherited setitem(Index,Value);
end;

function TDGC3DRMCameraCollection.GetItem(Index:integer):TDGC3DRMcameraItem;
begin
     Result:=TDGC3DRMCameraItem(inherited GetItem(Index));
end;

// TLight Object methods
// =======================
Constructor TDGC3DRMLightItem.Create(ACollection:TCollection);
begin
     inherited Create(Acollection);
     Flight:=nil;
     FLightType:=Ambient;
     FLightColor:=TLightColor.Create;
     FLightColor.Red:=0.5;
     FLightColor.Blue:=0.5;
     FLightColor.Green:=0.5;
     FFrame:=nil;
     FAnimation:=nil;
     FEnabled:=False;
     FPenumbra:=0.2;
     FUmbra:=0.4;
     FRange:=255;
     FX:=0.0;
     FY:=0.0;
     FZ:=0.0;
     Fangle:=0.0;
     FAutoRotate:=False;
     FLookat:=False;
     FFollow:=False;
end;


// create and initialize the Direct 3d Light Source
// Note Lights are created as inividual frames this allows the direction and orientation
// to be manipulated
procedure TDGC3DRMLightItem.Init(Direct3DRM:IDirect3DRM3;Scene:IDirect3DRMFrame3;ViewPort:IDirect3DRMViewport2);
begin
     if Assigned(Direct3DRM) then
     begin
          FD3DRM:=Direct3DRM;
          Fscene:=Scene;
          FViewport:=Viewport;
          // create an rgb light object
          DXCheck(Direct3DRM.CreateLightRGB(TD3DRMLightType(Ord(FLightType)),FLightcolor.Red,
             FLightColor.Green,FLightColor.Blue,Flight));
          // create a frame for the light
          DXCheck(Direct3DRM.CreateFrame(Fscene,FFrame));
          // Set the position of the frame
          DXCheck(FFrame.SetPosition(FScene,-FX,-FY,-FZ));
          // set the orientation of the frame
          DXCheck(FFrame.SetOrientation(Fscene, D3DVAL(-1.0), D3DVAL(-1.0), D3DVAL(1.0), D3DVAL(0.0), D3DVAL(5.0), D3DVAL(0.0)));
          // add the light
          DXCheck(FFrame.AddLight(Flight));
          Fanimation:=TDGC3DRManimation.Create;
     end;
end;

procedure TDGC3DRMlightitem.animate;
var
   aangle:Td3dvalue;
   Adirection:Trotatedirection;
begin
      if not assigned(Fanimation) then
         Exit;
      if Fanimation.Fanimation.Count <= 0 then
         Exit;
      if Fanimation.running then
      begin
           X:=Fanimation.X;
           Y:=Fanimation.Y;
           Z:=Fanimation.Z;
           aangle:=Fanimation.angle;
           ADirection:=Fanimation.direction;
           Rotate(Adirection,aangle * PI/180);
           DXCheck(FLight.SetColorRGB(Fanimation.R,Fanimation.G,Fanimation.B));
           Fanimation.update;
      end;
end;

// destroy lights frame
Destructor TDGC3DRMLightItem.Destroy;
begin
     // release frame
     if Assigned(fframe) then
        fframe:=nil;
     inherited Destroy;
end;

// switch light on or off by setting its color or making it black
procedure TDGC3DRMLightItem.setenabled(Value:Boolean);
begin
     Fenabled:=Value;
     if (Assigned(FLight)) then
     begin
          if Fenabled then
             // set light color to colors set
             DXCheck(FLight.SetColorRGB(FLightColor.Red,FLightColor.Green,FLightcolor.BLue))
          else
              // set light color to black (off)
              DXCheck(FLight.SetColorRGB(0,0,0));
     end;
end;

// get outer cone
function TDGC3DRMLightItem.GetPenumbra:TD3DVALUE;
begin
     if Assigned(Flight) then
        Result:=Flight.GetPenumbra
     else
         Result:=FPenumbra;
end;

// get inner cone note in radiuns
function TDGC3DRMLightItem.GetUmbra:TD3DVALUE;
begin
     if Assigned(Flight) then
        Result:=Flight.Getumbra
     else
         Result:=FUmbra;
end;

procedure TDGC3DRMLightItem.follow(AFrameItem:TDGC3DRMFrameItem ;AOffset:TD3Dvalue);
begin
     if Assigned(FFrame) then
     begin
          //FZ:=AframeItem.Z;
          FZoffset:=Aoffset;
          lookatframe:=Aframeitem;
          FFollow:=True;
     end;
end;

// make a light look at a specific frame
procedure TDGC3DRMLightItem.LookAt(AFrame:TDGC3DRMFrameItem );
begin
     if Assigned(FFrame) then
     begin
          lookatframe:=Aframe;
          FFrame.LookAt(AFrame.FFrame,FScene,D3DRMCONSTRAIN_Z);
          FLookat:=True;
     end;
end;

// get the distance at which objects will be effected by light
function TDGC3DRMLightItem.getRange:TD3DValue;
begin
     if Assigned(Flight) then
        Result:=Flight.Getrange
     else
         Result:=FRange;
end;

// get the lights attenuation
function TDGC3DRMLightItem.getAttenuation(Index:Integer):TD3DValue;
begin
     if Assigned(FLight) then
     begin
          case Index of
               0:Result:=FLight.GetConstantAttenuation;
               1:Result:=FLight.GetLinearAttenuation;
               2:Result:=FLight.GetQuadraticAttenuation;
          end;
     end
     else
     begin
          case Index of
               0:Result:=FConstantAtt;
               1:Result:=FLinearAtt;
               2:Result:=FQuadraticAtt;
          end;
     end;
end;

// sets the lights attenuation for non infinate light sources
procedure TDGC3DRMLightItem.SetAttenuation(Index:Integer;Value:TD3DValue);
begin
     case Index of
          0:begin
                 FConstantatt:=Value;
                 if Assigned(Flight) then
                    DXCheck(FLight.SetConstantAttenuation(FConstantAtt));
            end;
          1:begin
                 FLinearatt:=Value;
                 if Assigned(Flight) then
                    DXCheck(FLight.SetLinearAttenuation(FLinearAtt));
            end;
          2:begin
                 FQuadraticatt:=Value;
                 if Assigned(Flight) then
                    DXCheck(FLight.SetQuadraticAttenuation(FQuadraticAtt));
            end;
     end;
end;

// sets the light spinning
// by setting it's rotation to Angle
procedure TDGC3DRMLightItem.Spin;
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  case Direction of
      rotateright:DXCheck( Fframe.setrotation(FFrame,0,-1,0,FAngle));
       rotateleft:DXCheck( Fframe.Setrotation(FFrame,0,1,0,FAngle));
          rotateup:DXCheck( Fframe.Setrotation(FFrame,1,0,0,FAngle));
        Rotatedown:DXCheck( Fframe.Setrotation(FFrame,-1,0,0,FAngle));
  end;
  Autospin:=true;
end;

// stops light spinning
procedure TDGC3DRMLightItem.StopSpinning;
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  case Direction of
      rotateright:DXCheck( Fframe.setrotation(FFrame,0,-1,0,0));
       rotateleft:DXCheck( Fframe.Setrotation(FFrame,0,1,0,0));
          rotateup:DXCheck( Fframe.Setrotation(FFrame,1,0,0,0));
        Rotatedown:DXCheck( Fframe.Setrotation(FFrame,-1,0,0,0));
  end;
  Autospin:=False;
end;

// takes rotation direction and step size as parameters
procedure TDGC3DRMLightItem.Rotate(Adirection:Trotatedirection;Stepsize:TD3DValue);
var
  p : TD3DVector;
  DxAngle:TD3DValue;
begin
  if not Assigned(Fframe) then Exit;
  case ADirection of
        rotateleft:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,0,-1,0,Stepsize));
       rotateright:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,0,1,0,Stepsize));
          rotateup:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,1,0,0,Stepsize));
        Rotatedown:DXCheck( Fframe.addrotation(D3DRMCOMBINE_REPLACE,-1,0,0,Stepsize));

  end;
  FFrame.Setposition(FScene,-x,-y,-z);
end;

// set inner portion of the light cone
procedure TDGC3DRMLightItem.SetPenUmbra(Value:TD3DVALUE);
begin
     if Value <> FpenUmbra then
        FPenUmbra:=Value;
     if Assigned(Flight) then
        DXCheck(Flight.SetPenUmbra(Value));
end;

procedure TDGC3DRMLightitem.Moverelative;
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(Lookatframe.FFrame.GetPosition(Fscene, p1));
     P1.Z:=P1.Z + FZoffset;
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+(D3DMultiply(D3DVAL(y), p2.w));
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FFRame.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;


// called by render to update lights position and color
procedure TDGC3DRMLightItem.Update;
begin
     if Assigned(FScene) then
     begin

          if autospin then
             spin;
          if Fenabled then
             DXCheck(FLight.SetColorRGB(FLightColor.Red,FLightColor.Green,FLightcolor.BLue))
          else
              DXCheck(FLight.SetColorRGB(0,0,0));
          if FLookat then
          begin
             FFrame.LookAt(lookatFrame.FFrame,FScene,D3DRMCONSTRAIN_Z);
             FLookat:=False;
          end
          else
              if FFollow then
              begin
                   MOVERELATIVE;
                   FFollow:=False;
              end
              else
                  DXCheck(FFrame.SetPosition(FScene,-X,-Y,-Z));
     end;
end;

// set the outer portion of light cone
procedure TDGC3DRMLightItem.SetUmBra(Value:TD3DVALUE);
begin
     if Assigned(Flight) then
        DXCheck(Flight.SetUmbra(Value));
end;

// set range at which objects are effected by this light
procedure TDGC3DRMLightItem.SetRange(Value:TD3DVALUE);
begin
     if Assigned(Flight) then
        DXCheck(Flight.SetRange(Value));
end;

// set the lights position
procedure TDGC3DRMLightItem.SetPosition(Index:integer;Value:TD3DValue);
begin
     case Index of
          0:FX:=Value;
          1:FY:=Value;
          2:FZ:=Value;
     end;
//     if Assigned(FFrame) then
//           Move(FX,FY,FZ);
end;

// move light frame to a new position
procedure TDGC3DRMLightItem.Move(X,Y,Z:Double);
var
   P1:TD3DVECTOR;
   P2:TD3DRMVECTOR4D;
begin
     Dxcheck(FFrame.GetPosition(Fscene, p1));
     Dxcheck(FViewport.Transform(p2, p1));
     p2.x:=p2.X+(D3DMultiply(D3DVAL(x), p2.w));
     p2.y:=p2.Y+(D3DMultiply(D3DVAL(y), p2.w));
     p2.z:=p2.Z+Z;
     Dxcheck(Fviewport.InverseTransform(p1, p2));
     Dxcheck(FFrame.SetPosition(Fscene, p1.x, p1.y, p1.z));
end;

// set the angle of rotation for spin
procedure TDGC3DRMLightItem.Setangle(Value:TD3DValue);
begin
     Fangle:=Value;
     if Assigned(FFrame) then
        Rotate(Fdirection,Fangle);
end;


// TDGCLightCollection
// ==========================
constructor TDGC3DRMLightCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGC3DRMLightItem);
     Fowner:=Aowner;
end;

// must be overidden for streaming to work properly
function TDGC3DRMLightCollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGC3DRMLightCollection.SetItem(Index:integer;Value:TDGC3DRMLightItem);
begin
     inherited setitem(Index,Value);
end;

function TDGC3DRMLightCollection.GetItem(Index:integer):TDGC3DRMLightItem;
begin
     Result:=TDGC3DRMLightItem(inherited GetItem(Index));
end;


// TDGC3D Face object
//====================
constructor TDGC3DRMFACE.Create(D3DRM:Idirect3DRM3);
begin
     inherited Create;
     FD3DRM:=D3DRM;
     if Assigned(FD3DRM) then
        DXCheck(FD3DRM.CreateFace(FFace));
end;

// destroy the face interface
destructor TDGC3DRMFACE.Destroy;
begin
     if Assigned(FFace) then
        FFace:=nil;
     inherited Destroy;
end;

// get the number of vertices in the face
function TDGC3DRMFACE.Getcount:Integer;
begin
     if Assigned(FFace) then
          Result:=FFace.GetvertexCount
     else
         Result:=-1;
end;

// set the color of a face
procedure TDGC3DRMFACE.SetColor(Value:TLightcolor);
begin
     FFaceColor:=Value;
     if Assigned(FFace) then
          DXCheck(FFace.setcolorrgb(FFacecolor.Red,FFaceColor.Green,FFaceColor.Blue));
end;

// get the normal vector for this face
Function TDGC3DRMFace.GetNormal:TD3DVector;
var
   Temp:TD3DVector;
begin
     if Assigned(FFace) then
     begin
        DXcheck(FFace.GetNormal(Temp));
        Result:=temp;
    end;
end;

// add a new vertex to the face
procedure TDGC3DRMFACE.Addvertex(X,Y,Z:TD3DVALUE);
begin
     if Assigned(FFace) then
          DXCheck(FFace.addvertex(X,Y,Z));
end;

// get a vertex position from face with normal
procedure TDGC3DRMFACE.Getvertex(Index:Integer;var Position,Normal:TD3dvector);
begin
     if Assigned(FFace) then
        DXCheck(FFace.GetVertex(Index,Position,Normal));
end;

// TDGC3DRMShadow
// ============================
constructor TDGC3DRMShadow.Create(AD3DRM:Idirect3drm3;AScene:IDirect3DRMFrame3;alight:TDGC3DRMLightItem;Aframe:TDGC3DRMFrameitem);
begin
     inherited Create;
     FD3DRM:=AD3DRM;
     FScene:=AScene;
     Flight:=alight;
     FFrame:=AFrame;
     FNormal:=TDGC3Dvalue.Create;
     with FNormal do
     begin
          X:=0;
          Y:=1;
          Z:=0;
     end;
     FPlane:=TDGC3DValue.Create;
     with FPlane do
     begin
          X:=0;
          Y:=-5*FFrame.Scale.Y;
          Z:=0;
     end;
end;

procedure TDGC3DRMshadow.Init;
begin
     if Assigned(Fd3drm) then
     begin
          DXCheck(Fd3drm.Createshadow(FFrame.Frame,FLight.Light,FPlane.X,Fplane.Y,FPlane.Z,FNormal.X,FNormal.Y,FNormal.Z,FShadow));
          DXCheck(FScene.Addvisual(FShadow));
     end;
end;



//TDGC3DCanvas Implementation
//========================
constructor TDGC3DCanvas.Create( ASurface : IDirectDrawSurface ) ;
begin
  inherited Create ;
  if ASurface = NIL then
    Raise EDGCCanvas.Create('Cannot create canvas for NIL surface' ) ;
  FSurface := ASurface ;
end;

destructor TDGC3DCanvas.Destroy ;
begin
  Release;
  inherited Destroy ;
end ;

procedure TDGC3DCanvas.CreateHandle ;
begin
  if FDeviceContext = 0 then begin
    FSurface.GetDC( FDeviceContext ) ;
    Handle := FDeviceContext ;
  end ;
end ;

procedure TDGC3DCanvas.Release ;
begin
  if FDeviceContext <> 0 then begin
    Handle := 0 ;
    FSurface.ReleaseDC( FDeviceContext ) ;
    FDeviceContext := 0 ;
  end ;
end ;

function  TDGC3DCanvas.DrawingAllowed : boolean ;
begin
  Result := FSurface.IsLost = DD_OK ;
end ;


// property Editors
//=================
constructor TlightColor.Create;
begin
     inherited Create;
     FLightColor.A := 1.0;
end;

// light color object
procedure TLightColor.SetLightColor(Index: integer; Value: TD3DValue);
begin
  if Value < 0.0 then
     Value := 0.0;
  case Index of
    0 : FLightColor.R := Value;
    1 : FLightColor.G := Value;
    2 : FLightColor.B := Value;
  end;
  if assigned(SetColorRGB) then
     SetColorRGB(Red,Green,Blue);
end;


// light 3d value object
constructor TDGC3DVALUE.Create;
begin
     inherited Create;
end;

procedure TDGC3Dvalue.Set3dvalue(Index: integer; Value: TD3DValue);
begin
  case Index of
    0 : FValue.X := Value;
    1 : FValue.Y := Value;
    2 : FValue.Z := Value;
    3 : Fangle:=value;
  end;
  if assigned(SetValue) then
     SetValue(x,y,z,angle);
end;

// XYZ 3d value object
constructor TDGC3DXYZ.Create;
begin
     inherited Create;
end;

procedure TDGC3DXYZ.Set3dvalue(Index: integer;Value:TD3DValue);
begin
  case Index of
    0 : FValue.X := Value;
    1 : FValue.Y := Value;
    2 : FValue.Z := Value;
  end;
  if assigned(SetValue) then
     SetValue(x,y,z);
end;




procedure TXFilenameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.create(Application);
  try
    FileOpen.Options:=[ofHideReadOnly,ofEnableSizing,ofPathMustExist,ofFileMustexist];
    FileOpen.DefaultExt:='.X';
    Fileopen.Filter:='3D Mesh Files | *.X';
    if FileOpen.Execute then SetValue(FileOpen.FileName);
  finally
    FileOpen.Free;
  end;
end;

function TXFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;


procedure TTextureFilenameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.create(Application);
  try
    FileOpen.Options:=[ofHideReadOnly,ofEnableSizing,ofPathMustExist,ofFileMustexist];
    FileOpen.DefaultExt:='.bmp';
    Fileopen.Filter:='Texture Files | *.bmp;*.ppm';
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TTextureFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;


procedure Register;
begin
  RegisterComponents('DGC3D', [TDGC3DRMSCREEN]);
  RegisterPropertyEditor(TypeInfo(string), TDGC3DRMFrameItem , 'Filename', TXFilenameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDGC3DRMFrameItem , 'Texture', TTextureFilenameProperty);
end;

end.
