unit DGCInput;

interface

uses
  Windows,Trace, Messages, SysUtils,Classes, Graphics,DXtools, Controls,Dinput, Forms, Dialogs;

{
 The Delpi Games Creator - Beta 7
 --------------------------------
 Copyright 1996,1997,1998,1999 John Pullen, Paul Bearne, Jeff Kurtz

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial game use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.

 You may use these components to create any freeware/shareware/commercial
 game/application that you wish. If you wish to do any sort of printed or
 electronic publication about DGC, you must get written permission from
 one of the DGC authors.

 Needs to be looked at at present needs to set multiple defines
 change function getKeydown back to taking Virtual key codes and map them to
 DIK key codes
 }


type

TDInputKeys = (DIK_ESCAPE,DIK_1,DIK_2,DIK_3,DIK_4,DIK_5,DIK_6,DIK_7,DIK_8,
                 DIK_9,DIK_0,DIK_MINUS,DIK_EQUALS,DIK_BACK,DIK_TAB,
                 DIK_Q,DIK_W,DIK_E,DIK_R,DIK_T,DIK_Y,DIK_U,DIK_I,DIK_O,DIK_P,
                 DIK_LBRACKET,DIK_RBRACKET,DIK_RETURN,DIK_LCONTROL,DIK_A,DIK_S,
                 DIK_D,DIK_F,DIK_G,DIK_H,DIK_J,DIK_K,DIK_L,DIK_SEMICOLON,
                 DIK_APOSTROPHE,DIK_GRAVE,DIK_LSHIFT,DIK_BACKSLASH,DIK_Z,DIK_X,
                 DIK_C,DIK_V,DIK_B,DIK_N,DIK_M,DIK_COMMA,DIK_PERIOD,DIK_SLASH,
                 DIK_RSHIFT,DIK_MULTIPLY,DIK_LMENU,DIK_SPACE,DIK_CAPITAL,
                 DIK_F1,DIK_F2,DIK_F3,DIK_F4,DIK_F5,DIK_F6,DIK_F7,DIK_F8,
                 DIK_F9,DIK_F10,DIK_NUMLOCK,DIK_SCROLL,DIK_NUMPAD7,DIK_NUMPAD8,
                 DIK_NUMPAD9,DIK_SUBTRACT,DIK_NUMPAD4,DIK_NUMPAD5,DIK_NUMPAD6,
                 DIK_ADD,DIK_NUMPAD1,DIK_NUMPAD2,DIK_NUMPAD3,DIK_NUMPAD0,
                 DIK_DECIMAL,NOKEY01,NOKEY02,NOKEY03,DIK_F11,DIK_F12,
                 NOKEY04,NOKEY05,NOKEY06,NOKEY07,NOKEY08,NOKEY09,NOKEY10,NOKEY11,NOKEY12,
                 NOKEY13,NOKEY14,DIK_F13,DIK_F14,DIK_F15,
                 NOKEY15,NOKEY16,NOKEY17,NOKEY18,NOKEY19,NOKEY20,NOKEY21,NOKEY22,NOKEY23,
                 DIK_KANA,NOKEY66,NOKEY67,NOKEY68,NOKEY69,NOKEY70,NOKEY71,NOKEY72,NOKEY73,
                 DIK_CONVERT,NOKEY74,DIK_NOCONVERT,NOKEY75,DIK_YEN,
                 NOKEY76,NOKEY77,NOKEY78,NOKEY79,NOKEY80,NOKEY81,NOKEY82,NOKEY83,
                 NOKEY85,NOKEY86,NOKEY87,NOKEY88,NOKEY89,NOKEY90,NOKEY91,DIK_NUMPADEQUALS,
                 NOKEY24,NOKEY25,DIK_CIRCUMFLEX,DIK_AT,DIK_COLON,
                 DIK_UNDERLINE,DIK_KANJI,DIK_STOP,DIK_AX,DIK_UNLABELED,
                 NOKEY26,NOKEY27,NOKEY92,NOKEY93,DIK_NUMPADENTER,DIK_RCONTROL,
                 NOKEY28,NOKEY29,NOKEY30,NOKEY31,NOKEY32,NOKEY33,NOKEY34,NOKEY35,
                 NOKEY36,NOKEY37,NOKEY38,NOKEY39,NOKEY40,NOKEY41,NOKEY42,NOKEY43,
                 NOKEY44,NOKEY45,NOKEY46,NOKEY47,NOKEY48,DIK_NUMPADCOMMA,
                 NOKEY49,DIK_DIVIDE,NOKEY50,DIK_SYSRQ,DIK_RMENU,
                 NOKEY51,NOKEY52,NOKEY53,NOKEY54,NOKEY55,NOKEY56,NOKEY57,NOKEY58,
                 NOKEY59,NOKEY60,NOKEY61,NOKEY62,DIK_PAUSE,
                 NOKEY63,DIK_HOME,DIK_UP,DIK_PRIOR,NOKEY64,DIK_LEFT,NOKEY95,
                 DIK_RIGHT,NOKEY65,DIK_END,DIK_DOWN,DIK_NEXT,DIK_INSERT,
                 DIK_DELETE,NOKEY96,NOKEY97,NOKEY98,NOKEY99,NOKEY100,NOKEY101,
                 NOKEY102,DIK_LWIN,DIK_RWIN,DIK_APPS,DIK_POWER,DIK_SLEEP);



type
  TInputDevice = (Keyboard,Mouse,JoyStick);
  TDGCInput = class(TComponent)
  private
    { Private declarations }
    FDevice:TinputDevice;
    FDirectInput:IDirectinput;
    FDirectInputDevice:IDirectInputDevice;
    FDirectInputDevice2:IdirectInputdevice2;

  protected
    { Protected declarations }
    leftkey,rightkey,upkey,downkey:TDInputkeys;
    fire1,fire2:TDinputkeys;
    StartX,StartY:Integer;
    keystate:TDInputkeys;
  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent);override;
    procedure Init;
    destructor Destroy;override;
    function GetKeyDown(Key:word):Boolean;
    procedure SetKeys(leftk,Rightk,upk,downk,fr1,fr2:word);
    procedure Mousefired(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Mousemoved(Sender: TObject;Shift: TShiftState; X, Y: Integer);
    function VKtoDIK(Key:Word):TDInputkeys;

  published
    { Published declarations }
    property Device:TInputDevice read FDevice write FDevice;


  end;

{procedure Register;}

implementation

var
   Adevice:Idirectinputdevice;
   Adevice2:IDirectInputdevice2;
   ADirectInput:IDirectInput;

constructor TDGCInput.Create(Aowner:Tcomponent);
begin
     inherited Create(aowner);
     FDevice := Keyboard;
end;

function TDGCInput.VktoDIK(Key:Word):TDinputkeys;
begin
     case key Of
          VK_BACK: Result := DIK_BACK;
          VK_TAB         : Result := DIK_TAB;
          VK_RETURN      : Result := DIK_RETURN;
          VK_SHIFT       : Result := DIK_LSHIFT;
          VK_CONTROL     : Result := DIK_LCONTROL;
          VK_MENU        : Result := DIK_LMENU;
          VK_CAPITAL     : Result := DIK_CAPITAL;
          VK_KANA        : Result := DIK_KANA;
          VK_HANJA       : Result := DIK_KANJI;
          VK_CONVERT     : Result := DIK_CONVERT;
          VK_NONCONVERT  : Result := DIK_NOCONVERT;
          VK_ESCAPE      : Result := DIK_ESCAPE;
          VK_SPACE       : Result := DIK_SPACE;
          VK_PRIOR       : Result := DIK_PRIOR;
          VK_NEXT        : Result := DIK_NEXT;
          VK_END         : Result := DIK_END;
          VK_HOME        : Result := DIK_HOME;
          VK_LEFT        : Result := DIK_LEFT;
          VK_UP          : Result := DIK_UP;
          VK_RIGHT       : Result := DIK_RIGHT;
          VK_DOWN        : Result := DIK_DOWN;
          VK_PRINT       : Result := DIK_SYSRQ;
          VK_INSERT      : Result := DIK_INSERT;
          VK_DELETE      : Result := DIK_DELETE;
          Ord('1')       : Result := DIK_1;
          Ord('2')       : Result := DIK_2;
          Ord('3')       : Result := DIK_3;
          Ord('4')       : Result := DIK_4;
          Ord('5')       : Result := DIK_5;
          Ord('6')       : Result := DIK_6;
          Ord('7')       : Result := DIK_7;
          Ord('8')       : Result := DIK_8;
          Ord('9')       : Result := DIK_9;
          Ord('0')       : Result := DIK_0;
          Ord('A')       : Result := DIK_A;
          Ord('B')       : Result := DIK_B;
          Ord('C')       : Result := DIK_C;
          Ord('D')       : Result := DIK_D;
          Ord('E')       : Result := DIK_E;
          Ord('F')       : Result := DIK_F;
          Ord('G')       : Result := DIK_G;
          Ord('H')       : Result := DIK_H;
          Ord('I')       : Result := DIK_I;
          Ord('J')       : Result := DIK_J;
          Ord('K')       : Result := DIK_K;
          Ord('L')       : Result := DIK_L;
          Ord('M')       : Result := DIK_M;
          Ord('N')       : Result := DIK_N;
          Ord('O')       : Result := DIK_O;
          Ord('P')       : Result := DIK_P;
          Ord('Q')       : Result := DIK_Q;
          Ord('R')       : Result := DIK_R;
          Ord('S')       : Result := DIK_S;
          Ord('T')       : Result := DIK_T;
          Ord('U')       : Result := DIK_U;
          Ord('V')       : Result := DIK_V;
          Ord('W')       : Result := DIK_W;
          Ord('X')       : Result := DIK_X;
          Ord('Y')       : Result := DIK_Y;
          Ord('Z')       : Result := DIK_Z;
          VK_LWIN        : Result := DIK_LWIN;
          VK_RWIN        : Result := DIK_RWIN;
          VK_APPS        : Result := DIK_APPS;
          VK_NUMPAD0     : Result := DIK_NUMPAD0;
          VK_NUMPAD1     : Result := DIK_NUMPAD1;
          VK_NUMPAD2     : Result := DIK_NUMPAD2;
          VK_NUMPAD3     : Result := DIK_NUMPAD3;
          VK_NUMPAD4     : Result := DIK_NUMPAD4;
          VK_NUMPAD5     : Result := DIK_NUMPAD5;
          VK_NUMPAD6     : Result := DIK_NUMPAD6;
          VK_NUMPAD7     : Result := DIK_NUMPAD7;
          VK_NUMPAD8     : Result := DIK_NUMPAD8;
          VK_NUMPAD9     : Result := DIK_NUMPAD9;
          VK_MULTIPLY    : Result := DIK_MULTIPLY;
          VK_ADD         : Result := DIK_ADD;
          VK_SUBTRACT    : Result := DIK_MINUS;
          VK_DECIMAL     : Result := DIK_DECIMAL;
          VK_DIVIDE      : Result := DIK_DIVIDE;
          VK_F1          : Result := DIK_F1;
          VK_F2          : Result := DIK_F2;
          VK_F3          : Result := DIK_F3;
          VK_F4          : Result := DIK_F4;
          VK_F5          : Result := DIK_F5;
          VK_F6          : Result := DIK_F6;
          VK_F7          : Result := DIK_F7;
          VK_F8          : Result := DIK_F8;
          VK_F9          : Result := DIK_F9;
          VK_F10         : Result := DIK_F10;
          VK_F11         : Result := DIK_F11;
          VK_F12         : Result := DIK_F12;
          VK_F13         : Result := DIK_F13;
          VK_F14         : Result := DIK_F14;
          VK_F15         : Result := DIK_F15;
          VK_NUMLOCK     : Result := DIK_NUMLOCK;
          VK_SCROLL      : Result := DIK_SCROLL;
          VK_LSHIFT      : Result := DIK_LSHIFT;
          VK_RSHIFT      : Result := DIK_RSHIFT;
          VK_LCONTROL    : Result := DIK_LCONTROL;
          VK_RCONTROL    : Result := DIK_RCONTROL;
          VK_LMENU       : Result := DIK_LMENU;
          VK_RMENU       : Result := DIK_RMENU;
     else
          Result:=NOKEY01;
    end;
end;


// callback function to enumerate the joystick devices
function Initinputjoystick(var PINST:TDIDeviceInstance;lpvcontext:Pointer):Integer; stdcall;
var
   Fdevices:IDirectinputDevice;
begin
     if ADirectinput.createdevice(Pinst.GuidInstance,FDevices,nil) <> DI_OK then
     begin
          Result:=1;
     end;
     ADevice := Fdevices;
     Fdevices.Queryinterface(IID_IDirectInputDevice2,Adevice2);
     Result:=0;
end;

procedure TDGCInput.Init;
var
   diprg:TDIPropRange;
   diprhd:TDIPropDWord;
begin
     // Create the Direct Input Object
      dxcheck(DirectinputCreate(Hinstance,DIRECTINPUT_VERSION,FdirectInput,nil));
      case FDevice of
          Keyboard:begin
                        Dxcheck(FDirectInput.CreateDevice(GUID_SysKeyboard, FDirectInputDevice, Nil));
                        Dxcheck(FDirectInputDevice.SetDataFormat(c_dfDIKeyboard));
                        Dxcheck(FDirectInputDevice.SetCooperativeLevel(Application.MainForm.Handle,DISCL_FOREGROUND or DISCL_NONEXCLUSIVE));
                        Dxcheck(FDirectInputdevice.Acquire);
                   end;
          Mouse:   begin
                        // use proper keycodes direct mouse
                        //Application.mainform.OnMouseMove:=Mousemoved;
                        //Application.mainform.ONMousedown:=MouseFired;
                        Dxcheck(FdirectInput.CreateDevice(Guid_SysMouse,FdirectInputDevice,nil));
                        Dxcheck(FDirectInputDevice.SetDataFormat(c_dfDIMouse));
                        Dxcheck(FDirectInputDevice.SetCooperativeLevel(Application.MainForm.Handle,DISCL_FOREGROUND or DISCL_EXCLUSIVE));
                        Dxcheck(FDirectInputdevice.Acquire);
                   end;
          JoyStick:begin
                        // Enumerate Devices here First
                        AdirectInput:=FDirectInput;
                        Dxcheck(FDirectinput.EnumDevices(DIDEVTYPE_JOYSTICK,
                                InitInputJoystick, @FDirectInput, DIEDFL_ATTACHEDONLY));
                        FDirectinputdevice:=ADevice;
                        Fdirectinputdevice2:=ADevice2;
                        Dxcheck(FDirectInputDevice.SetDataFormat(c_dfDIJoystick));
                        Dxcheck(FDirectInputDevice.SetCooperativeLevel(Application.MainForm.Handle,DISCL_FOREGROUND or DISCL_EXCLUSIVE));
                        diprg.diph.dwSize := sizeof(TDIPROPRANGE);
                        diprg.diph.dwHeaderSize := sizeof(TDIPROPHEADER);
                        diprg.diph.dwHow := DIPH_BYOFFSET;
                        diprg.lMin := -1000;
                        diprg.lMax := +1000;
                        diprg.diph.dwObj := DIJOFS_X;    // set the x-axis range
                        dxcheck(Fdirectinputdevice.SetProperty(DIPROP_RANGE, diprg.diph ));
                        diprg.diph.dwObj := DIJOFS_Y;    // set the y-axis range
                        dxcheck(FDirectinputdevice.SetProperty(DIPROP_RANGE, diprg.diph));
                        diprhd.diph.dwsize:=SizeOf(TDIPropDWord);
                        diprhd.diph.dwHeaderSize:=SizeOf(diprhd.diph);
                        diprhd.diph.dwObj:=0;
                        diprhd.diph.dwHow := DIPH_DEVICE;
                        diprhd.dwData:=15*100;
                        FdirectInputdevice.SetProperty(DIPROP_DEADZONE,diprhd.diph);
                        diprhd.diph.dwsize:=SizeOf(TDIPropDWord);
                        diprhd.diph.dwHeaderSize:=SizeOf(diprhd.diph);
                        diprhd.diph.dwObj:=0;
                        diprhd.diph.dwHow := DIPH_DEVICE;
                        diprhd.dwData:=95*100;
                        FdirectInputdevice.SetProperty(DIPROP_Saturation,diprhd.diph);
                        diprhd.diph.dwsize:=SizeOf(TDIPropDWord);
                        diprhd.diph.dwHeaderSize:=SizeOf(diprhd.diph);
                        diprhd.diph.dwObj:=0;
                        diprhd.diph.dwHow := DIPH_DEVICE;
                        diprhd.dwData:=DIPROPAUTOCENTER_OFF;
                        FdirectInputdevice.SetProperty(DIPROP_AUTOCENTER,diprhd.diph);
                        Dxcheck(FDirectInputdevice.Acquire);
                  end;
      end;
end;

procedure TDGCinput.Mousefired(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if Button in [mbleft]  then
        keystate:=fire1;
     if button in [mbright]  then
        keystate := fire2;
end;

procedure TDGCInput.Mousemoved(Sender: TObject;Shift: TShiftState; X, Y: Integer);
begin
     if X = StartX then Keystate := NOKEY32;
     if X < StartX then
        Keystate:=leftkey
     else
         if X > StartX then
            keystate:=RIGHTkey;
     if Y < StartY then
        Keystate:=UPkey
     else
        if Y > StartY then
           KeyState := DOWNkey;
     if (X = StartX) and (Y = StartY) then
         Keystate:=NOKEY01;
     StartX:=X;
     StartY:=Y
end;

procedure TDGCinput.SetKeys(leftk,Rightk,upk,downk,fr1,fr2:word);
begin
     leftkey:=Vktodik(leftk);
     Rightkey:=Vktodik(rightk);
     upkey:=VKtoDIK(upk);
     downkey:=VKtoDIK(downk);
     fire1:=VKtoDIK(fr1);
     fire2:=VKtoDIK(fr2);
end;

function TDGCInput.GetKeyDown(Key:Word):Boolean;
var
    res :hresult;
    Buffer : array[0..255] of Byte;
    js:TDIJoyState;
    ms:TDiMouseState;
    i:integer;
    DIKKey:TDInputkeys;
begin

     DiKkey:=VKtoDIK(Key);
     // code to see if key is pressed
     case Fdevice of
     KeyBoard:    if FDirectInputDevice.GetDeviceState(256,@Buffer) <> DI_OK then
                   begin
                        Result:=False;
                   end
                   else
                   begin
                       if (Buffer[Ord(DIKKEY)+1] and $80) = $80 then
                          Result:=True
                       else
                       begin
                           Result:=False;
                       end;
                   end;
     Joystick:begin
                   FDirectInputdevice.Acquire;
                   Dxcheck(FDirectinputdevice2.Poll);
                   res:=FDirectInputDevice.Getdevicestate(SizeOf(TDiJoyState),@js);
                   if Js.lx = 0 then
                      keystate := NoKey01;
                   if js.ly = 0 then
                      keystate := NoKey01;
                   if js.lX < 0 then
                      Keystate:=leftkey
                   else
                       if js.lX > 0 then
                          keystate:=RIGHTkey;
                   if js.lY < 0 then
                      Keystate:=UPkey
                   else
                       if js.lY > 0 then
                          KeyState := DOWNkey;
                    if (js.lX = 0) and (js.lY = 0) then
                       Keystate:=NOKEY01;
                   // fire button pressed
                   if js.rgbButtons[0] and $80 = $80 then
                      keystate:=fire1;
                   if js.rgbButtons[1] and $80 = $80 then
                      keystate:=fire2;
                   if keystate = VKtoDIK(Key) then
                      Result:=True
                   else
                       Result:=False;


              end;
       mouse:begin
                   // set a variable called mousestate here and set it to a value if mouse not 0 in eventhandler
                   FDirectInputdevice.Acquire;
                   dxcheck(FDirectInputDevice.GetdeviceState(SizeOf(ms),@ms));
                   // lost joystick aquire again
//                   if res = DIERR_INPUTLOST then
//
                   if ms.lX < 0 then
                      Keystate:=leftkey
                   else
                       if ms.lX > 0 then
                          keystate:=RIGHTkey;
                   if ms.lY < 0 then
                      Keystate:=UPkey
                   else
                       if ms.lY > 0 then
                          KeyState := DOWNkey;
                   if ms.rgbButtons[0] and $80 = $80 then
                      keystate :=fire1;
                   if ms.rgbButtons[1] and $80 = $80 then
                      keystate :=fire2;
                   if keystate = VKtoDIK(Key) then
                      Result:=True
                   else
                       Result:=False;



            end;

     end;
end;

destructor TDGCInput.Destroy;
begin
     if FDirectinputdevice <> nil then
        FdirectInputDevice.Unacquire;
     FdirectInputDevice:=nil;
     FDirectInput := nil;
     inherited Destroy;
end;


{procedure Register;
begin
  RegisterComponents('DGC', [TDGCInput]);
end;}

end.
