{
 The Delpi Games Creator - Beta 6
 --------------------------------
 Copyright 1996,1997 John Pullen, Paul Bearne, Jeff Kurtz

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.
}


unit DGCJoy;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mmsystem;

type                    

  TJoyMode = (Digital, Analog);
  TJoyButtons = Procedure(B1, B2, B3, B4:Boolean) of Object;
  TJoyMove    = Procedure(XPos, YPos, ZPos:Integer) of Object;

  TDGCJoystick = class(TComponent)
  private
    { Private declarations }

    FJoy1Enabled : Boolean;
    FJoy1Found   : Boolean;
    FJoy1Status  : Integer;
    FJoy1Caps    : TJoyCaps;
    FJoy1Info    : TJoyInfo;
    FCenter1     : Integer;
    FOffset1     : Integer;
    FJoy1Notify  : Boolean;
    FJoy1Thresh  : Integer;
    FJoy1Polling : Integer;
    FJoy1Mode    : TJoyMode;

    FJoy2Enabled : Boolean;
    FJoy2Found   : Boolean;
    FJoy2Status  : Integer;
    FJoy2Caps    : TJoyCaps;
    FJoy2Info    : TJoyInfo;
    FCenter2     : Integer;
    FOffset2     : Integer;
    FJoy2Notify  : Boolean;
    FJoy2Thresh  : Integer;
    FJoy2Polling : Integer;
    FJoy2Mode    : TJoyMode;

    FOnJoy1Up       : TNotifyEvent;
    FOnJoy1DOwn     : TNotifyEvent;
    FOnJoy1Right    : TNotifyEvent;
    FOnJoy1Left     : TNotifyEvent;
    FOnJoy1UpLeft   : TNotifyEvent;
    FOnJoy1UpRight  : TNotifyEvent;
    FOnJoy1DownLeft : TNotifyEvent;
    FOnJoy1DownRight: TNotifyEvent;
    FOnJoy1Center   : TNotifyEvent;
    FOnJoy1BtnDown  : TJoyButtons;
    FOnJoy1BtnUp    : TJoyButtons;
    FOnJoy1AnMove   : TJoyMove;

    FOnJoy2Up       : TNotifyEvent;
    FOnJoy2DOwn     : TNotifyEvent;
    FOnJoy2Right    : TNotifyEvent;
    FOnJoy2Left     : TNotifyEvent;
    FOnJoy2UpLeft   : TNotifyEvent;
    FOnJoy2UpRight  : TNotifyEvent;
    FOnJoy2DownLeft : TNotifyEvent;
    FOnJoy2DownRight: TNotifyEvent;
    FOnJoy2Center   : TNotifyEvent;
    FOnJoy2BtnDown  : TJoyButtons;
    FOnJoy2BtnUp    : TJoyButtons;
    FOnJoy2AnMove   : TJoyMove;

    FVersion     : String;
    NVersion     : String;
    FWinHandle   : HWND;
    FJoysGo      : Boolean;

  protected
    { Protected declarations }
    Constructor Create(AOwner: TComponent); Override;
    Destructor  Destroy; Override;
    Procedure   WndProc(Var Msg: TMessage);
  public
    { Public declarations }
    property Joy1Info    : TJoyInfo Read FJoy1Info;
    property Joy1Caps    : TJoyCaps Read FJoy1Caps;
    property Joy1Found   : Boolean  Read FJoy1Found;
    property Joy1Status  : Integer  Read FJoy1Status;

    property Joy2Info    : TJoyInfo Read FJoy2Info;
    property Joy2Caps    : TJoyCaps Read FJoy2Caps;
    property Joy2Found   : Boolean  Read FJoy2Found;
    property Joy2Status  : Integer  Read FJoy2Status;

    procedure StartJoysticks;
    procedure StopJoysticks;
    procedure UpdateJoysticks;
  published
    { Published declarations }
    property Joy1Thresh  : Integer  Read FJoy1Thresh  Write FJoy1Thresh;
    property Joy1Polling : Integer  Read FJoy1Polling Write FJoy1Polling;
    property Joy1Mode    : TJoyMode Read FJoy1Mode    Write FJoy1Mode;
    property Joy1Notify  : Boolean  Read FJoy1Notify  Write FJoy1Notify;
    property Joy1Enabled : Boolean  Read FJoy1Enabled Write FJoy1Enabled;

    property Joy2Thresh  : Integer  Read FJoy2Thresh  Write FJoy2Thresh;
    property Joy2Polling : Integer  Read FJoy2Polling Write FJoy2Polling;
    property Joy2Mode    : TJoyMode Read FJoy2Mode    Write FJoy2Mode;
    property Joy2Notify  : Boolean  Read FJoy2Notify  Write FJoy2Notify;
    property Joy2Enabled : Boolean  Read FJoy2Enabled Write FJoy2Enabled;

    property Version     : String   Read FVersion     Write NVersion;

    property OnJoy1Center    : TNotifyEvent Read FOnJoy1Center    Write FOnJoy1Center;
    property OnJoy1Down      : TNotifyEvent Read FOnJoy1Down      Write FOnJoy1Down;
    property OnJoy1DownLeft  : TNotifyEvent Read FOnJoy1DownLeft  Write FOnJoy1DownLeft;
    property OnJoy1DownRight : TNotifyEvent Read FOnJoy1DownRight Write FOnJoy1DownRight;
    property OnJoy1Left      : TNotifyEvent Read FOnJoy1Left      Write FOnJoy1Left;
    property OnJoy1Right     : TNotifyEvent Read FOnJoy1Right     Write FOnJoy1Right;
    property OnJoy1Up        : TNotifyEvent Read FOnJoy1Up        Write FOnJoy1Up;
    property OnJoy1UpLeft    : TNotifyEvent Read FOnJoy1UpLeft    Write FOnJoy1UpLeft;
    property OnJoy1UpRight   : TNotifyEvent Read FOnJoy1UpRight   Write FOnJoy1UpRight;
    property OnJoy1BtnDown   : TJoyButtons  Read FOnJoy1BtnDown   Write FOnJoy1BtnDown;
    property OnJoy1BtnUp     : TJoyButtons  Read FOnJoy1BtnUp     Write FOnJoy1BtnUp;
    property OnJoy1AnMove    : TJoyMove     Read FOnJoy1AnMove    Write FOnJoy1AnMove;

    property OnJoy2Center    : TNotifyEvent Read FOnJoy2Center    Write FOnJoy2Center;
    property OnJoy2Down      : TNotifyEvent Read FOnJoy2Down      Write FOnJoy2Down;
    property OnJoy2DownLeft  : TNotifyEvent Read FOnJoy2DownLeft  Write FOnJoy2DownLeft;
    property OnJoy2DownRight : TNotifyEvent Read FOnJoy2DownRight Write FOnJoy2DownRight;
    property OnJoy2Left      : TNotifyEvent Read FOnJoy2Left      Write FOnJoy2Left;
    property OnJoy2Right     : TNotifyEvent Read FOnJoy2Right     Write FOnJoy2Right;
    property OnJoy2Up        : TNotifyEvent Read FOnJoy2Up        Write FOnJoy2Up;
    property OnJoy2UpLeft    : TNotifyEvent Read FOnJoy2UpLeft    Write FOnJoy2UpLeft;
    property OnJoy2UpRight   : TNotifyEvent Read FOnJoy2UpRight   Write FOnJoy2UpRight;
    property OnJoy2BtnDown   : TJoyButtons  Read FOnJoy2BtnDown   Write FOnJoy2BtnDown;
    property OnJoy2BtnUp     : TJoyButtons  Read FOnJoy2BtnUp     Write FOnJoy2BtnUp;
    property OnJoy2AnMove    : TJoyMove     Read FOnJoy2AnMove    Write FOnJoy2AnMove;

  end;

procedure Register;

implementation

Constructor TDGCJoystick.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   FVersion     := 'DGC Beta 7';
   FJoy1Thresh  := 500;
   FJoy1Polling := 10;
   FJoy1Mode    := Digital;
   FJoy1Notify  := True;
   FJoy1Enabled := True;
   FJoy1Found   := True;

   FJoy2Thresh  := 500;
   FJoy2Polling := 10;
   FJoy2Mode    := Digital;
   FJoy2Notify  := True;
   FJoy2Enabled := False;
   FJoy2Found   := True;

   JoyGetDevCaps(JoystickID1, @FJoy1Caps, SizeOf(FJoy1Caps));
   JoyGetDevCaps(JoystickID2, @FJoy2Caps, SizeOf(FJoy2Caps));
end;

Destructor TDGCJoystick.Destroy;
begin
   JoyReleaseCapture(JoystickID1);
   JoyReleaseCapture(JoystickID2);
   DeallocateHWnd(FWinHandle);
   inherited Destroy;
end;

Procedure TDGCJoystick.UpdateJoysticks;
begin
   If (FJoy1Enabled) and (FJoy1Found) then
     FJoy1Status := JoyGetPos(JoystickID1, @FJoy1Info);
   If (FJoy2Enabled) and (FJoy2Found) then
     FJoy2Status := JoyGetPos(JoystickID2, @FJoy2Info);
end;

Procedure TDGCJoystick.StopJoysticks;
begin
   If Not FJoysGo then exit else FJoysGo := False;
   JoyReleaseCapture(JoystickID1);
   JoyReleaseCapture(JoystickID2);
   DeallocateHWnd(FWinHandle);
end;

Procedure TDGCJoystick.StartJoysticks;
begin
   If FJoysGo then exit else FJoysGo := True;
   FJoy1Status := JoyGetPos(JoystickID1,@FJoy1Info);
   If FJoy1Status <> JOYERR_NOERROR then FJoy1Found := False;
   JoyReleaseCapture(JoystickID1);

   FJoy2Status := JoyGetPos(JoystickID2,@FJoy2Info);
   If FJoy2Status <> JOYERR_NOERROR then FJoy2Found := False;
   JoyReleaseCapture(JoystickID2);

   FWinHandle  := AllocateHWND(WndProc);

//   If FJoy1Notify = True then ShowMessage('True') else ShowMessage('False');
   If (FJoy1Status = JOYERR_NOERROR) and (FJoy1Enabled = True) then
   begin
      FJoy1Status := JoySetCapture(FWinHandle, JoystickID1, FJoy1Polling, FJoy1Notify);
      If FJoy1Status <> JOYERR_NOERROR then FJoy1Found := False;
   end;

   If (FJoy2Status = JOYERR_NOERROR) and (FJoy2Enabled = True) then
   begin
      FJoy2Status := JoySetCapture(FWinHandle, JoystickID2, FJoy2Polling, FJoy2Notify);
      If FJoy2Status <> JOYERR_NOERROR then FJoy2Found := False;
   end;

   If FJoy1Mode = Digital then
      JoySetThreshold(JoyStickID1, (FJoy1Caps.wXMax - FJoy1Caps.wXMin) div 8 )
   else
      JoySetThreshold(JoystickID1, FJoy1Thresh);

   If FJoy2Mode = Digital then
      JoySetThreshold(JoyStickID2, (FJoy2Caps.wXMax - FJoy2Caps.wXMin) div 8 )
   else
      JoySetThreshold(JoystickID2, FJoy2Thresh);

   FCenter1 := (FJoy1Caps.wXMax - FJoy1Caps.wXMin) div 2;
   FOffset1 := (FJoy1Caps.wXMax - FJoy1Caps.wXMin) div 4;

   FCenter2 := (FJoy2Caps.wXMax - FJoy2Caps.wXMin) div 2;
   FOffset2 := (FJoy2Caps.wXMax - FJoy2Caps.wXMin) div 4;

end;

Procedure TDGCJoystick.WndProc(Var Msg: TMessage);
var
   B1, B2, B3, B4 : Boolean;
begin
   B1:=False; B2:=False; B3:=False; B4:=False;
   If (FJoy1Found) and (FJoy1Enabled) then
   begin
     FJoy1Status := JoyGetPos(JoystickID1, @FJoy1Info);

     If Msg.msg = MM_JOY1BUTTONDOWN then
        begin
          If (FJoy1Info.wButtons and JOY_BUTTON1) = JOY_BUTTON1 then B1:=True;
          If (FJoy1Info.wButtons and JOY_BUTTON2) = JOY_BUTTON2 then B2:=True;
          If (FJoy1Info.wButtons and JOY_BUTTON3) = JOY_BUTTON3 then B3:=True;
          If (FJoy1Info.wButtons and JOY_BUTTON4) = JOY_BUTTON4 then B4:=True;
          If Assigned(FOnJoy1BtnDown) then FOnJoy1BtnDown(B1,B2,B3,B4);
        end;

     If Msg.Msg = MM_JOY1BUTTONUP then
        begin
          If (FJoy1Info.wButtons and JOY_BUTTON1) <> JOY_BUTTON1 then B1:=True;
          If (FJoy1Info.wButtons and JOY_BUTTON2) <> JOY_BUTTON2 then B2:=True;
          If (FJoy1Info.wButtons and JOY_BUTTON3) <> JOY_BUTTON3 then B3:=True;
          If (FJoy1Info.wButtons and JOY_BUTTON4) <> JOY_BUTTON4 then B4:=True;
          If Assigned(FOnJoy1BtnUp) then FOnJoy1BtnUp(B1,B2,B3,B4);
        end;

     If (FJoy1Mode = Analog)  and ((Msg.Msg = MM_JOY1MOVE) or (Msg.Msg = MM_JOY1ZMOVE)) then
        If Assigned(FOnJoy1AnMove) then
           FOnJoy1AnMove(Fjoy1Info.wXPos, FJoy1Info.wYPos, FJoy1Info.wZPos);

     If (FJoy1Mode = Digital) and (Msg.Msg = MM_JOY1MOVE) then
     begin
       If FJoy1Info.wYPos < FCenter1 - FOffset1 then        //Up
          begin
            If FJoy1Info.wXPos < FCenter1 - FOffset1 then     //UpLeft
              begin
                If Assigned(FOnJoy1UpLeft) then FOnJoy1UpLeft(Self);
              end
            else
            If FJoy1Info.wXPos > FCenter1 + FOffset1 then     //UpRight
              begin
               If Assigned(FOnJoy1UpRight) then FOnJoy1UpRight(Self);
              end
          else
            If Assigned(FOnJoy1Up) then FOnJoy1Up(Self);
          end
       else
       If FJoy1Info.wYPos > FCenter1 + FOffset1 then        //Down
          begin
            If FJoy1Info.wXPos < FCenter1 - FOffset1 then   //DownLeft
              begin
                If Assigned(FOnJoy1DownLeft) then FOnJoy1DownLeft(Self);
              end
            else
            If FJoy1Info.wXPos > FCenter1 + FOffset1 then   //DownRight
              begin
                If Assigned(FOnJoy1DownRight) then FOnJoy1DownRight(Self);
              end
          else
            If Assigned(FOnJoy1Down) then FOnJoy1Down(Self);
          end;

       //Left
       If (FJoy1Info.wXPos < FCenter1 - FOffset1) and
          (FJoy1Info.wYPos > FCenter1 - FOffset1) and
          (FJoy1Info.wYPos < FCenter1 + FOffset1) then
            If Assigned(FOnJoy1left) then FOnJoy1Left(Self);
       //Right
       If (FJoy1Info.wXPos > FCenter1 + FOffset1) and
          (FJoy1Info.wYPos > FCenter1 - FOffset1) and
          (FJoy1Info.wYPos < FCenter1 + FOffset1) then
            If Assigned(FonJoy1Right) then FOnJoy1Right(Self);

       //Center
       If (FJoy1Info.wXPos > FCenter1 - FOffset1) and
          (FJoy1Info.wXPos < FCenter1 + FOffset1) and
          (FJoy1Info.wYPos > FCenter1 - FOffset1) and
          (FJoy1Info.wYPos < FCenter1 + FOffset1) then
             If Assigned(FOnJoy1Center) then FOnJoy1Center(Self);
     end; //end of Digital mode
   end; //end of Joystick1

   //Joystick2
   B1:=False; B2:=False; B3:=False; B4:=False;
   If (FJoy2Found) and (FJoy2Enabled) then
   begin
     FJoy2Status := JoyGetPos(JoystickID2, @FJoy2Info);

     If Msg.msg = MM_JOY2BUTTONDOWN then
        begin
          If (FJoy2Info.wButtons and JOY_BUTTON1) = JOY_BUTTON1 then B1:=True;
          If (FJoy2Info.wButtons and JOY_BUTTON2) = JOY_BUTTON2 then B2:=True;
          If (FJoy2Info.wButtons and JOY_BUTTON3) = JOY_BUTTON3 then B3:=True;
          If (FJoy2Info.wButtons and JOY_BUTTON4) = JOY_BUTTON4 then B4:=True;
          If Assigned(FOnJoy2BtnDown) then FOnJoy2BtnDown(B1,B2,B3,B4);
        end;

     If Msg.Msg = MM_JOY2BUTTONUP then
        begin
          If (FJoy2Info.wButtons and JOY_BUTTON1) <> JOY_BUTTON1 then B1:=True;
          If (FJoy2Info.wButtons and JOY_BUTTON2) <> JOY_BUTTON2 then B2:=True;
          If (FJoy2Info.wButtons and JOY_BUTTON3) <> JOY_BUTTON3 then B3:=True;
          If (FJoy2Info.wButtons and JOY_BUTTON4) <> JOY_BUTTON4 then B4:=True;
          If Assigned(FOnJoy2BtnUp) then FOnJoy2BtnUp(B1,B2,B3,B4);
        end;

     If (FJoy2Mode = Analog)  and ((Msg.Msg = MM_JOY2MOVE) or (Msg.Msg = MM_JOY2ZMOVE)) then
        If Assigned(FOnJoy2AnMove) then
           FOnJoy2AnMove(Fjoy2Info.wXPos, FJoy2Info.wYPos, FJoy2Info.wZPos);

     If (FJoy2Mode = Digital) and (Msg.Msg = MM_JOY2MOVE) then
     begin
       If FJoy2Info.wYPos < FCenter2 - FOffset2 then        //Up
          begin
            If FJoy2Info.wXPos < FCenter2 - FOffset2 then     //UpLeft
              begin
                If Assigned(FOnJoy2UpLeft) then FOnJoy2UpLeft(Self);
              end
            else
            If FJoy2Info.wXPos > FCenter2 + FOffset2 then     //UpRight
              begin
               If Assigned(FOnJoy2UpRight) then FOnJoy2UpRight(Self);
              end
          else
            If Assigned(FOnJoy2Up) then FOnJoy2Up(Self);
          end
       else
       If FJoy2Info.wYPos > FCenter2 + FOffset2 then        //Down
          begin
            If FJoy2Info.wXPos < FCenter2 - FOffset2 then   //DownLeft
              begin
                If Assigned(FOnJoy2DownLeft) then FOnJoy2DownLeft(Self);
              end
            else
            If FJoy2Info.wXPos > FCenter2 + FOffset2 then   //DownRight
              begin
                If Assigned(FOnJoy2DownRight) then FOnJoy2DownRight(Self);
              end
          else
            If Assigned(FOnJoy2Down) then FOnJoy2Down(Self);
          end;

       //Left
       If (FJoy2Info.wXPos < FCenter2 - FOffset2) and
          (FJoy2Info.wYPos > FCenter2 - FOffset2) and
          (FJoy2Info.wYPos < FCenter2 + FOffset2) then
            If Assigned(FOnJoy2left) then FOnJoy2Left(Self);
       //Right
       If (FJoy2Info.wXPos > FCenter2 + FOffset2) and
          (FJoy2Info.wYPos > FCenter2 - FOffset2) and
          (FJoy2Info.wYPos < FCenter2 + FOffset2) then
            If Assigned(FonJoy2Right) then FOnJoy2Right(Self);

       //Center
       If (FJoy2Info.wXPos > FCenter2 - FOffset2) and
          (FJoy2Info.wXPos < FCenter2 + FOffset2) and
          (FJoy2Info.wYPos > FCenter2 - FOffset2) and
          (FJoy2Info.wYPos < FCenter2 + FOffset2) then
             If Assigned(FOnJoy2Center) then FOnJoy2Center(Self);
     end; //end of Digital mode
   end; //end of Joystick2

   Msg.result := DefWindowProc(FWinHandle, Msg.Msg, Msg.wParam, Msg.lParam);
end;

procedure Register;
begin
  RegisterComponents('DGC', [TDGCJoystick]);
end;

end.
