{
 The Delpi Games Creator - Beta 6
 --------------------------------
 Copyright 1996,1997 John Pullen, Paul Bearne, Jeff Kurtz

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.
}

unit DGCMLO;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, DGCMap;

type
  TfrmOpenMap = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    ListBox1: TListBox;
    Button3: TButton;
    Button4: TButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure Button3Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
    FMapLib : TDGCMaps;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  public
    { Public declarations }
    property MapLib  : TDGCMaps Read FMapLib   Write FMapLib;
  end;

var
  frmOpenMap: TfrmOpenMap;

implementation
{$R *.DFM}

constructor TfrmOpenMap.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   FMapLib := TDGCMaps.Create;
   FMapLib.MapCount := -1;
end;

destructor TfrmOpenMap.Destroy;
begin
   If assigned(FMapLib) then MapLib.Freemaps;
   If assigned(FMapLib) then FMapLib.Free;
   inherited Destroy;
end;

procedure TfrmOpenMap.Button3Click(Sender: TObject);
var
   loop : integer;
begin
   OpenDialog.FileName := '*.map';
   If OpenDialog.Execute then
   begin
      ListBox1.Clear;
      FMapLib.LoadFromFile(OpenDialog.Filename);
      For Loop := 0 to FMapLib.MapCount do
          ListBox1.Items.Add(FMapLib.Maps[Loop].Name);

      ListBox1.Enabled := True;
      ListBox1.ItemIndex := 0;
      Panel1.Caption := Format('Index :%d',[0]);
      Panel2.Caption := Format('%d x %d',[MapLib.Maps[0].XSize, mapLib.Maps[0].YSize]);
      Panel3.Caption := Format('Count: %d',[MapLib.MapCount+1]);
   end;
end;

procedure TfrmOpenMap.ListBox1Click(Sender: TObject);
var
   idx : integer;
begin
   idx := ListBox1.ItemIndex;
   Panel1.Caption := Format('Index :%d',[idx]);
   Panel2.Caption := Format('%d x %d',[MapLib.Maps[idx].XSize, MapLib.Maps[idx].YSize]);
end;

procedure TfrmOpenMap.FormCreate(Sender: TObject);
begin
  If not assigned(FMapLib) then FMapLib := TDGCMapS.Create;
end;

procedure TfrmOpenMap.FormActivate(Sender: TObject);
var
   l : integer;
begin
   If not assigned(FMapLib) then exit;
   If FMapLib.MapCount > -1 then
      for l := 0 to FMapLib.MapCount do
          frmOpenMap.ListBox1.Items.Add(FMapLib.Maps[l].Name);
   If FMapLib.MapCount >=0 then
   begin
      ListBox1.ItemIndex := 0;
      Panel1.Caption := Format('Index :%d',[0]);
      Panel2.Caption := Format('%d x %d',[MapLib.Maps[0].XSize, mapLib.Maps[0].YSize]);
      Panel3.Caption := Format('Count: %d',[MapLib.MapCount+1]);
   end;
end;

procedure TfrmOpenMap.Button4Click(Sender: TObject);
begin
   SaveDialog.FileName := '*.map';
   If SaveDialog.Execute then
   begin
      FMapLib.SaveToFile(SaveDialog.Filename);
   end;
end;

end.
