unit Midi;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,DMusic,DGCsnd;

type
  TDGCPerformance = class(Tobject)
  Private
         FMusic:IDirectMusic;
         FSound:TDGCSound;
         FPerformance:IDirectMusicperformance;
         FMusicPort:IDirectMusicPort;
  protected
         Procedure AddMusicPort;
  Public
        Constructor Create(Directsound:TDGCAudio);

  Published
        Property Performance:IDirectMusicPerformance read FPerformance;
  end;


  TDGCMidi = class(TComponent)
  private
    { Private declarations }
    Fperformance:TPerformance;
    FDirectSound:TDGCAudio;
  protected
    { Protected declarations }
    Procedure SetDirectsound(Value:TDGCAudio);
  public
    { Public declarations }
    // function to inititialize com
    Constructor Create(Acomponent:Tcomponent);
  published
    { Published declarations }
    Property Sound:TDGCAudio read Fdirectsound write Setdirectsound;
  end;

procedure Register;

implementation

// Tmidi component implementation
// This component will play a midi file
Constructor Tmidifile.Create(Acomponent:Tcomponent);
var
   res:Hresult;
begin
     FDirectsound:=nil;
     FPerformance:=nil;
     // initialize Com
     res:=CoInitialize(nil);
     if Failed(res) then
        messagedlg(' Failed to initialize the com Interface ');
end;

// destroy the com interface
Destructor TDGCmidi.Destroy;
begin
     

// implementation of the performance object
Constructor TDGCPerformance.Create(Directsound:TDGCAudio);
var
   res:Hresult;
begin
     FPerformance = nil;
     FSound:=Directsound;
     //Create the object
     res:=Cocreateinstance(CLS_IDDirectMusicPerformance,nil,CLSCTX_INPROC_SERVER  or CLSCTX_INPROC_HANDLER,
          IID_IDirectMusicPerformance,FPerformance);
     if Failed(res) then
        messagedlg('Failed to create direct music performance);
     // got a performance now initialize it
     res:=FPerformance.Init(Fmusic,FSound.Fdirectsound,nil);
     if Failed(res) then
        messagedlg('Failed to Init performance);
end;

procedure TDGCPerformance.AddMusicPort;
var
   synthGuid:GUID;
   res:Hresult;
   portprams:TPortParams;
begin
     Fmusicport = Nil;
     res:=Fmusic.GetdefaultPort(&synthGuid);
     if Failed(res) then
        messagedlg('could not get default port from Direct music');
     with portparams do
     begin
          dwsize:=sizeof(TPortParams);
          dwChannelGroups:=minchannelgroups;
          dwvalidparams:=DMus_PortParams_Channelgroups;
     end;

end;

procedure Register;
begin
  RegisterComponents('DGC', [TDGCMidi]);
end;

end.
