{
 The Delpi Games Creator - Beta 7
 --------------------------------
 Copyright 1996,1997,1998,1999 John Pullen, Paul Bearne, Jeff Kurtz

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial game use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.

 You may use these components to create any freeware/shareware/commercial
 game/application that you wish. If you wish to do any sort of printed or
 electronic publication about DGC, you must get written permission from
 one of the DGC authors.
}

{
Changes:
Beta 7.1
17-July-99 Paul : Added TDGCbackground Component
14-July-99 Paul : modified setpixel to write directly to surface
14-july-99 paul : created editor for HI color image libs
7-July-99 Paul  : Added TDGCDirectinput Component
29-june-99 Paul : Added Mouse Support
Beta 7
09-june-99 Paul : Added TDGCHiColorimagelib use a collection to hold any image type
24-may-99 Paul  : Major rewrite to use Direct draw 4 and Directx 6


Beta 6
27-Oct-97 Jeff : Started Hi-Color support.
06-Oct-97 Jeff : Added Window Mode
01-Aug-97 Jeff : Added GetTileDraw function
01-Aug-97 Jeff : Added GetMapTile function
01-Aug-97 Jeff : Added SetMapTile procedure
28-Jly-97 Jeff : Added DrawMap procedure
18-Jly-97 Jeff : Added Tile Library Support
06-Jun-97 Jeff : Fixed clipping on BltClip method

}

unit DGC;

interface

//{$Define DX6}


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DDraw,D3DRM,D3D,D3DTypes,DXTools ,DGCILib, BmpUtil,jpeg, ExtCtrls,DDUtil, DGCMap,DGCInput;

const
  WM_DGCACTIVATE = WM_USER + 200;
//  COLORDEPTH = 16;



type
  //Default Exception Handler
  EDGCScreen = class(Exception);
  EDGCSurface = class(Exception);
  EDGCCanvas = class(Exception);

  TDGCMapPos = record
    MapX : Integer;
    MapY : Integer;
    Tile : Byte;
  end;

  //General enumerated types
  TDisplayMode = (dm640x480x8,dm640x480x16,dm640x480x24,dm640x480x32, dm320x200x8, dm800x600x8,
                  dm800x600x16,dm800x600x24,dm800x600x32, dm1024x768x8,dm1024x768x16,dm1024x768x24,dm1024x768x32,
                  dm640x400x8, dm320x240x8);
  TPaletteMode = (pmExclusive, pmNormal);
  //Events
  TDGCSurface = class; //Forward

  TSurfaceLost = procedure (Surface: TDGCSurface) of Object;

  //Direct Draw Canvas
  //==================
  TDGCCanvas = class( TCanvas )
  private
    { Private declarations }
    FSurface: IDirectDrawSurface4 ;
    FDeviceContext: HDC ;
  protected
    { Protected declarations }
    procedure CreateHandle ; override ;
  public
    { Public declarations }
    constructor Create(ASurface : IDirectDrawSurface4);
    destructor Destroy ; override ;
    procedure Release ;
    function  DrawingAllowed : boolean ;
  end;

  //DGC Surface
  TDGCScreen = class;
  TDGCSurface = class(TObject)
  private
    { Private declarations }
    FSurface: IDirectDrawSurface4 ;
    FCanvas: TDGCCanvas;
    FTransparentColor: byte;
    FWidth: Integer;
    FHeight: Integer;
    FWidthBytes: Integer;
    FClientRect: TRect;
    FClipRect: TRect;
    Fcolordepth:Integer;
    IsBackBuffer: Boolean;
    FInvideomemory:Boolean;
    FOnSurfaceLost: TSurfaceLost;
    SurfacePtr: Pointer;
    fCacheLevel: Double;  //cam holds time date
    procedure SetTransparentColor(NewValue: byte);
    function ConvertColor( Color : TColor ) : integer;
  protected
    { Protected declarations }
    Function ReadSurface:IDirectDrawSurface4; //cam
  public
    { Public declarations }
    constructor Create(DirectDraw4: IDirectDraw4; w, h: Integer;Colordepth:integer);
    constructor CreatePrimary(DGCScreen: TDGCScreen;Colordepth:Integer);
    constructor CreateBackBuffer(Primary: TDGCSurface;Colordepth:Integer);
    constructor CreateBackBufferW(DGCScreen: TDGCScreen; Flags: DWORD;Colordepth:Integer);
    constructor CreateZBuffer(DirectDraw4:IdirectDraw4;D3D:Idirect3D3;BackBuffer:TdgcSurface;Colordepth:Integer);
    destructor Destroy; override;
    procedure SetPixel(x, y: Integer; Color: TColor);
    function  GetPixel(x, y: Integer) : TColor;
    function GetPointer: Pointer;
    Function getDC:HDC;
    procedure ReleasePointer;
    function  CollisionTest(x, y: Integer; SrcSurface: TDGCSurface;
         sx, sy: Integer; PixelTest: Boolean): Boolean;
    procedure Erase(Color: Byte);
    procedure EraseRect(r: TRect; Color: Byte);
    procedure Scroll(x, y: Integer);
    procedure Draw(x, y: Integer; SrcSurface: TDGCSurface; TransParent: Boolean);
    procedure StretchFlip(dr: TRect; SrcSurface: TDGCSurface; TransParent, FlipX,FlipY: Boolean);
    procedure StretchDraw(dr: TRect; SrcSurface: TDGCSurface; TransParent: Boolean);
    procedure BltFast(x, y: Integer; SrcSurface: TDGCSurface; r: TRect; TransParent: Boolean);
    procedure BltClip(x, y: Integer; SrcSurface: TDGCSurface; r: TRect; TransParent: Boolean);
    procedure Tile(x, y: Integer; SrcSurface: TDGCSurface; TransParent: Boolean);
    property Surface: IDirectDrawSurface4 read ReadSurface;   //cam
    property CacheLevel: Double read fCacheLevel;  //cam
//    property Surface: IDirectDrawSurface4 read FSurface;
    property Canvas: TDGCCanvas read FCanvas;
    property TransparentColor: byte read FTransparentColor write SetTransparentColor;
    property Width: Integer read FWidth;
    property Height: Integer read FHeight;
    property WidthBytes: Integer read FWidthBytes;
    property ClientRect: TRect read FClientRect;
    property ClipRect: TRect read FClipRect write FClipRect;
    property Invideomemeory:Boolean read FInvideomemory write Finvideomemory;
    property OnSurfaceLost: TSurfaceLost read FOnSurfaceLost write FOnSurfaceLost;
  end;

  // image collection items
  TScrolldirection = (Scrollleft,Scrollright);

  TScrollregion = class(TPersistent)
  private
    Fleft: word;
    Ftop: word;
    Fbottom: word;
    FX,FY:Word;
    Fwidth:Word;
    procedure SetRegion(Index: Integer; Value: Word);
  protected
  public
  published

    property Left: word index 0 read Fleft write Setregion default 0;
    property Top: word index 1 read Ftop write Setregion default 0;
    property Height: word Index 2 read Fbottom write Setregion default 100;
    property Width:Word Index 5 read FWidth write setregion default 100;
    property X:Word Index 3 read FX write FX default 0;
    property Y:Word Index 4 read FY write FY default 0;
  end;

  TDGCBackgroundImageItem = class(TCollectionItem)
  private
         FScreen:TDGCScreen;
         FImage:TPicture;
         FStep:Word;
         FDirection:TScrollDirection;
         FScrollRegion:TScrollregion;
         Fname:string;
         Fautoscroll:Boolean;
         FSurface:TDGCSurface;
         Fstretch:Boolean;
         CurrentXpos:Integer;
  Protected
         Procedure SetImage(value:TPicture);
  Public
        // over ride so we can create the image
        Constructor Create(ACollection:TCollection);override;
        Procedure Update;
        Procedure Init;
        Function Scrollrecttorect:Trect;
        Function scrollrect(left,Top,Bottom,Width,X,Y:integer):Tscrollregion;
        Procedure Scroll;
        Destructor Destroy;override;
        Property DGCScreen:TDGCscreen read FScreen;
  published
        property Autoscroll:Boolean read Fautoscroll write Fautoscroll;
        Property Image:TPicture read FImage write setImage;
        Property Name:string read FName write Fname;
        Property Step:Word read FStep write FStep;
        Property Direction:TScrolldirection read FDirection write FDirection;
        Property Scrollregion:TScrollregion read FScrollregion write FScrollregion;
        property Stretch:Boolean read Fstretch write Fstretch;

  end;

  TDGCBackgroundCollection = class(Tcollection)
  private
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGCBackgroundImageItem;
         procedure SetItem(Index:Integer;Value:TDGCBackgroundImageItem);
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        property Items[Index:integer]:TDGCBackgroundImageItem read GetItem write SetItem;
  end;

  TDGCBackground = class(TComponent)
  private
    { Private declarations }
        FScreen:TDGCScreen;
        FImages:TDGCBackgroundCollection;
        Fcount:Integer;
        FVersion:string;
  Protected
           Function getimagecount:Integer;
           Procedure SetImages(Value:TDGCBackgroundCollection);
  Public
        Constructor Create(Aowner:Tcomponent); override;
        Procedure Notification(AComponent: TComponent; Operation: TOperation); override;
        Procedure Init;
        Procedure Update;
        Destructor Destroy;override;
        Procedure Savetofile(filename:string);
        Procedure Loadfromfile(Filename:string);
        Property ImageCount:Integer read GetImagecount;
  Published
        Property DGCScreen:TDGCScreen Read FScreen write FScreen;
        Property Images:TDGCBackgroundcollection read Fimages write SetImages;
        property Version:string read Fversion write Fversion;
  end;

  // image collection items
  TDGCImageItem = class(TCollectionItem)
  private
         FImage:TPicture;
         FImagesize:Word;
         Fheight,Fwidth:Integer;
         Fname:string;
  Protected
         Procedure SetImage(value:TPicture);

  Public
        // over ride so we can create the image
        Constructor Create(ACollection:TCollection);override;

        Destructor Destroy;override;
        Property Height:Integer Read Fheight;
        Property Width:Integer Read Fwidth;
        property Imagesize:Word read FImagesize;
  published
        Property Image:TPicture read FImage write setImage;
        property Name:string read FName write Fname;
  end;


  TDGCCollection = class(Tcollection)
  private
         FOwner:Tcomponent;
         function getitem(Index:Integer):TDGCImageItem;
         procedure SetItem(Index:Integer;Value:TDGCImageItem);
  protected
         // must be overridden for streaming to work
         constructor Create(Aowner:Tcomponent);
         function Getowner:TPersistent;override;
  public
        property Items[Index:integer]:TDGCImageItem read GetItem write SetItem;
  end;


  // background bitmap object
  TDGCHiColorImageLib = class(Tcomponent)
  Private
        FScreen:TDGCScreen;
        FImages:TDGCCollection;
        Ftransparent:Boolean;
        Fcount:Integer;
  Protected
       function getimagecount:Integer;
       procedure SetImages(Value:TDGCCollection);
  Public
        Constructor Create(Aowner:Tcomponent); override;
        destructor Destroy;override;
        Procedure Savetofile(filename:string);
        Procedure Loadfromfile(Filename:string);
        Property ImageCount:Integer read GetImagecount;
  Published
        Property DGCScreen:TDGCScreen Read FScreen write FScreen;
        Property UseTransparent:Boolean Read Ftransparent write Ftransparent;
        //Property Images:TOwnedcollection read FImages write Fimages;
        Property Images:TDGCcollection read Fimages write SetImages;

  end;




  //Surface Image List
  TDGCSurfaceList = array[0..0] of TDGCSurface;
  PDGCSurfaceList = ^TDGCSurfaceList;

  //Main DGC Component
  //==================
  TDGCScreen = class(TComponent)
  private
    { Private declarations }
    FMousecursor:Hcursor;
    FScreenrc:Prect;
    FZBuffer:TDGCSurface;
    FUse3D:Boolean;
    FDisplayMode: TDisplayMode;
    FDirectDraw: IDirectDraw4;
    FPalette: IDirectDrawPalette;
    FPaletteEntries: T256PaletteEntry;
    Fbackgroundlibrary:TDGCBackground;
    FFront: TDGCSurface;
    FBack: TDGCSurface;
    FFlippingEnabled : Boolean;
    FDebug: Boolean;
    FOnPaint: TNotifyEvent;
    FOnFlip: TNotifyEvent;
    FOnInitialize: TNotifyEvent;
    FOnCleanUp: TNotifyEvent;
    frmOnActivate: TNotifyEvent;
    FBeepOnException: Boolean;
    FCyclePalette : Array[0..511] of TPaletteEntry;
    FCycleStep    : Integer;
    FCycleStepCnt : Integer;
    FCycleSkip    : Integer;
    FCycleSkipCnt : Integer;
    FCycleLow     : Integer;
    FCycleHigh    : Integer;
    FDoCycling    : Boolean;
    FGotCyclePal  : Boolean;
    FVersion         : String;
    NVersion         : String;
    FBackBuffers   : Integer;
    FDGCImageLib   : TDGCImageLib;
    FImageList     : PDGCSurfaceList;
    FImageListCount: Integer;
    FImageLib      : TDGCImageLib;
    FHicolorlib    : TDGCHiColorImageLib;
    FDGCTileLib    : TDGCImageLib;
    FTileList      : PDGCSurfaceList;
    FTileListCount : Integer;
    FTileLib       : TDGCImageLib;
    FMapLib        : TDGCMapLib;
    FSkipTile0     : Boolean;
    FFirstTileXPos : Integer;
    FFirstTileYPos : Integer;
    FFirstTileX    : Integer;
    FFirstTileY    : Integer;
    FMapIdxUsed    : Integer;
    Fbackground    : TDGCBackground;
    FWindowMode    : Boolean;
    FWindowVBL     : Boolean;
    FPaletteMode   : TPaletteMode;
    FDDClipper     : IDirectDrawClipper;
    FDDBackClipper : IDirectDrawClipper;
    FWindowStretch : Boolean;
    FFormWidth     : Integer;
    FFormHeight    : Integer;
    FWinBufWidth   : Integer;
    FWinBufHeight  : Integer;
    FColorDepth    : Integer;
    FDGCDirectInput   : TDGCInput;
    FDrawobject:Idirectdraw;

    // mouse support
    Fmousepointer:TCursor;
    // FmousePointer:Integer;  // Index in image list to use as mouse Pointer
    FMouseX,FmouseY:Integer;
    FMouseState:Integer;
    FCreateZBuffer:Boolean;

    FShowMouse:Boolean;
    procedure DoException(Sender: TObject; E: Exception);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure AppMessage(var Msg: TMsg; var Handled : boolean ) ;
    procedure SetFlippingEnabled(b: Boolean);
    procedure DoOnActivate(Sender: TObject);
    procedure InitDirectDraw4;

    procedure SetDebug(NewVal: Boolean);
    function  GetScreenWidth: Integer;
    function  GetScreenHeight: Integer;
    procedure StartTimer;
    procedure StopTimer;
    function  GetClipRect: TRect;
    procedure SetClipRect(NewVal: TRect);
    procedure CreateDefaultPalette;
    function  GetImage(Index: Integer): TDGCSurface;
    function  GetTile(Index: Integer): TDGCSurface;
    Procedure Dodisplaymode(var w,h,bpp:integer);
    procedure SetMouseCursor(Value:Tcursor);
    procedure SetColordepth(Value:Integer);
    procedure SetDisplayMode(Value:TDisplayMode);
  protected
    { Protected declarations }
    procedure Loaded; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    // mouse event handlers
    procedure Mousefired(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Mousemoved(Sender: TObject;Shift: TShiftState; X, Y: Integer);

  public
    // used by other components to get the keycodes set by sprite engine
    Fkeyleft,Fkeyright,Fkeydown,Fkeyup,Fkeyfire,FKeyfire2:Word;

    FWindowWidth   : Integer;
    FWindowHeight  : Integer;
    procedure SaveAsBitmap(Surface: TDGCSurface; FileName: String);
    procedure DrawMap(MapSurface: TDGCSurface; Idx, MapX, MapY, ScrX, ScrY: Integer; Trans : Boolean);
    function  GetTileDrawn(X,Y:Integer) : TDGCMapPos;
    function  GetMapTile(MapIdx,MapX,MapY:Integer) : Byte;
    procedure SetMapTile(MapIdx,MapX,MapY : Integer; NewTile:Byte);
    procedure SetKeys(keyleft,keyright,keyup,keydown,fire1,fire2:word);
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure DoSurfaceLost(Surface: TDGCSurface);
    procedure Flip;
    procedure CreateSurface(var Surface: TDGCSurface; W, H: Integer);
    procedure WaitForVerticalBlank;
    function  KeyDown(Key: word): Boolean;
    procedure SetPalette(var NewPalette: T256PaletteEntry);
    procedure FadePaletteOut(Delay: Integer);
    procedure FadePaletteIn(Delay: Integer);
    procedure RestoreSurfaces;
    procedure FlipScroll(XSpeed, YSpeed: Integer);
    procedure CyclePalette(Low, High, Step, Skip : Integer);
    procedure CycleUpdate;
    procedure SetImageLibrary(Lib: TDGCImageLib; UsePalette: Boolean);
    Procedure SetHiColorlibrary(Lib: TDGCHiColorImageLib);
    Procedure SetupImagelist(count:integer);
    procedure FreeImageList;
    procedure SetTileLibrary(Lib: TDGCImageLib; UsePalette: Boolean);
    procedure SetupTileList(count:integer);
    procedure FreeTileList;
    procedure SetKeyColor(Image : TDGCSurface; X,Y : Integer);
    property DirectDraw4:  IDirectDraw4 read FDirectDraw;
    property DirectDraw: IDirectDraw read FDrawobject;
    property Palette: IDirectDrawPalette read FPalette;
    property Front: TDGCSurface read FFront;
    property Back: TDGCSurface read FBack;
    property ScreenWidth: Integer read GetScreenWidth;
    property ScreenHeight: Integer read GetScreenHeight;
    property ClipRect: TRect read GetClipRect write SetClipRect;
    property Images[Index: Integer]: TDGCSurface read GetImage;
    property ImageList:PDGCSurfaceList read Fimagelist write Fimagelist;
    property Tiles[Index: Integer]: TDGCSurface read GetTile;
    property TileList:PDGCSurfaceList read FTilelist write FTilelist;
    property Use3d:Boolean read FUse3D write Fuse3D;
    property ColorDepth:      Integer      Read FColorDepth      write SetColordepth;
    procedure CleanUpDirectDraw4;

  published
    { Published declarations }
    property DisplayMode:     TDisplayMode read FDisplayMode     write SetDisplayMode;
    property FlippingEnabled: Boolean      read FFlippingEnabled write SetFlippingEnabled;
    property Debug:           Boolean      read FDebug           write SetDebug;
    property BeepOnException: Boolean      read FBeepOnException write FBeepOnException;
    property OnPaint:         TNotifyEvent read FOnPaint         write FOnPaint;
    property OnFlip:          TNotifyEvent read FOnFlip          write FOnFlip;
    property OnInitialize:    TNotifyEvent read FOnInitialize    write FOnInitialize;
    property OnCleanUp:       TNotifyEvent read FOnCleanUp       write FOnCleanUp;
    property Version:         String       read FVersion         write NVersion;
    property PaletteCycle:    Boolean      read FDoCycling       write FDoCycling;
    property ImageLibrary:    TDGCImageLib read FImageLib        write FImageLib;
    Property HiColorLib:      TDGCHiColorImageLib    read FHicolorlib      Write FHicolorlib;
    Property Background:      TDGCBackground    read FBackground      Write FBackground;
    property TileLibrary:     TDGCImageLib read FTileLib         write FTileLib;
    property MapLibrary:      TDGCMapLib   read FMapLib          Write FMapLib;
    property SkipTile0:       Boolean      read FSkipTile0       Write FSkipTile0;
    property BackBuffers:     Integer      Read FBackBuffers     Write FBackBuffers;
    property WindowMode:      Boolean      Read FWindowMode      Write FWindowMode;
    property WindowVBL:       Boolean      Read FWindowVBL       Write FWindowVBL;
    property PaletteMode:     TPaletteMode Read FPaletteMode     Write FPaletteMode;
    property WindowStretch:   Boolean      Read FWindowStretch   Write FWindowStretch;
    property WinBufWidth:     Integer      Read FWinBufWidth     Write FWinBufWidth;
    property WinBufHeight:    Integer      Read FWinBufHeight    Write FWinBufHeight;
    property DGCInput:        TDGCInput    read FDGCDirectInput  write FDGCDirectInput;
    property ShowMouse:       Boolean      read FShowMouse       write FShowmouse;
    property MouseImage:      TCursor      read FMousepointer    write SetMouseCursor;
    // mouse button state 1 = leftbutton 2 = rightbutton
    property MouseButton:    Integer      read Fmousestate      write FMouseState;

  end;

implementation

uses Trace, dgcsnd;

//TDGCCanvas Implementation
//========================
constructor TDGCCanvas.Create( ASurface : IDirectDrawSurface4 ) ;
begin
  inherited Create ;
  if ASurface = NIL then
    Raise EDGCCanvas.Create('Cannot create canvas for NIL surface' ) ;
  FSurface := ASurface ;
end;

destructor TDGCCanvas.Destroy ;
begin
  Release;
  inherited Destroy ;
end ;

procedure TDGCCanvas.CreateHandle ;
begin
  if FDeviceContext = 0 then begin
    FSurface.GetDC( FDeviceContext ) ;
    Handle := FDeviceContext ;
  end ;
end ;

procedure TDGCCanvas.Release ;
begin
  if FDeviceContext <> 0 then begin
    Handle := 0 ;
    FSurface.ReleaseDC( FDeviceContext ) ;
    FDeviceContext := 0 ;
  end ;
end ;

function  TDGCCanvas.DrawingAllowed : boolean ;
begin
  Result := FSurface.IsLost = DD_OK ;
end ;

// TDGCImageCollectioitems
//========================
Constructor TDGCImageItem.Create(Acollection:Tcollection);
begin
     Inherited create(acollection);
     Fimage:=TPicture.Create;
end;

Procedure TDGCImageItem.SetImage(Value:TPicture);
begin
     FImage.assign(value);
     Fheight:=FImage.Height;
     FWidth:=FImage.Width;
end;

Destructor TDGCImageItem.Destroy;
begin
     Fimage.free;
     Inherited destroy;
end;


// TDGCCollection
// ==========================
constructor TDGCCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGCImageItem);
     Fowner:=Aowner;
end;



// must be overidden for streaming to work properly
function TDGCcollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGCCollection.SetItem(Index:integer;Value:TDGCImageitem);
begin
     inherited setitem(Index,Value);
end;

function TDGCCollection.GetItem(Index:integer):TDGCImageitem;
begin
     Result:=TDGCImageitem(inherited GetItem(Index));
end;



//TDGCImage Implementation
//========================
Constructor TDGCHiColorImagelib.create(AOwner: TComponent);
begin
     inherited create(AOwner);
     FScreen:=Nil;
     Ftransparent:=False;
     Fimages:=TDGCCollection.Create(self);
end;

procedure TDGCHiColorImagelib.SetImages(Value:TDGCCollection);
begin
     Images.assign(Value);
end;


procedure TDGCHiColorImagelib.Savetofile(Filename:string);
var
   FileStream:TFilestream;
begin
      Filestream:=TFilestream.create(filename,fmCreate);
      filestream.Writecomponentres('DGC_HI_COLOR_LIB',Self);
      Filestream.Free;
end;

Procedure TDGCHiColorImagelib.Loadfromfile(filename:String);
var
   Filestream:Tfilestream;
begin
     // create dummy component
     try
        fImages.Clear;
        Filestream:=TFilestream.create(filename,fmopenread);
        Filestream.Readcomponentres(self);
        Filestream.Free;
        if DGCScreen <> nil then
           DGCScreen.SetHicolorlibrary(Self);
     finally
        //comp.free;
     end;
end;



Function TDGCHiColorImageLib.getImagecount:Integer;
begin
     if assigned(Fimages) then
        result:=Fimages.count;
end;

Destructor TDGCHiColorImageLib.Destroy;
begin
     Fimages.free;
     inherited destroy;
end;

// TDGCBackgroundImageitems
//========================
procedure TScrollregion.SetRegion(Index: Integer;
  Value: Word);
begin
  case Index of
    0:
      if Value <> Fleft then
      begin
        FLeft := Value;
      end;
    1:
      if Value <> Ftop then
      begin
        Ftop := Value;
      end;
    2:
      if Value <> Fbottom then
      begin
        Fbottom := Value;
      end;
    3:if Value <> FX then
      begin
        FX := Value;
      end;
    4:if Value <> FY then
      begin
        FY := Value;
      end;
    5:if Value <> Fwidth then
      begin
        Fwidth := Value;
      end;
  end;
end;

Constructor TDGCBackgroundImageItem.Create(Acollection:Tcollection);
begin
     Inherited create(acollection);
     Fimage:=TPicture.Create;
     Fscreen:=nil;
     Fautoscroll:=true;
     FStretch:=True;
     FDirection:=ScrollLeft;
     FStep:=1;
     FSurface:=nil;
     FScrollregion:=scrollRect(0,0,100,100,0,0);
end;

function TDGCBackgroundImageitem.scrollrect(left,Top,Bottom,Width,X,Y:integer):Tscrollregion;
var
   temprect:Tscrollregion;
begin
     temprect:=Tscrollregion.create;
     temprect.left:=left;
     temprect.top:=top;
     temprect.height:=bottom;
     temprect.Width:=Width;
     temprect.X:=X;
     Temprect.Y:=Y;
     result:=temprect;
end;

Procedure TDGCBackgroundImageItem.SetImage(Value:TPicture);
begin
   FImage.assign(value);
end;

procedure TDGCBackgroundImageItem.Scroll;
begin
     //carry out scroll

     if FScreen <> nil then
     begin

       if Scrollregion.Left+scrollregion.Width > Fsurface.Width then
          Scrollregion.Width:=Fsurface.Width - Scrollregion.Left;
       if Scrollregion.top+scrollregion.height > Fsurface.height then
          Scrollregion.height:=Fsurface.height - Scrollregion.top;
{       if scrollregion.Left < 0 then
          scrollregion.Left}
       if Direction = Scrollleft then
       begin
          inc(currentxpos,step);
          if currentxpos >= scrollregion.Width+Scrollregion.Left then
             currentxpos:=Scrollregion.Left+step;
          Fscreen.Back.bltclip(Scrollregion.X,scrollregion.Y,Fsurface,rect(currentxpos,scrollregion.Top,ScrollRegion.Width+Scrollregion.left,scrollregion.Height+scrollregion.top),true);
          Fscreen.Back.bltclip(Scrollregion.X+((Scrollregion.Width+Scrollregion.Left)-currentxpos),scrollregion.Y,Fsurface,rect(0,Scrollregion.top,currentxpos,Scrollregion.Height+scrollregion.top),true);
       end;
       if Direction = Scrollright then
       begin
          dec(currentxpos,step);
          if currentxpos < scrollregion.Left then
             currentxpos:=Scrollregion.Left+scrollregion.Width-1;
          Fscreen.back.bltclip(scrollregion.X,scrollregion.Y,Fsurface,rect(CurrentXpos,scrollregion.Top,Scrollregion.Left+Scrollregion.width,Scrollregion.Height+scrollregion.top),true);
          Fscreen.back.bltclip(Scrollregion.X+((Scrollregion.Width+Scrollregion.Left)-Currentxpos),scrollregion.Y,Fsurface,rect(0,scrollregion.top,currentxpos,Scrollregion.Height+scrollregion.top),true);
       end;
     end;
end;

Procedure TDGCBackgroundImageItem.Update;
begin
     // scroll it here for time being just show it
     if autoscroll then
        Scroll;
end;

function TDGCBackgroundImageitem.Scrollrecttorect:Trect;
begin
     with scrollregion do
          result:=rect(left,Top,0,height);
end;

Procedure TDGCBackgroundImageItem.Init;
var
   Surfacedc:HDC;
begin
     //create a surface and render image onto it
   //Create Surfaces for Objects
   CurrentXpos:=0;
   with Fimage  do
   begin
        if stretch then
            Fsurface := TDGCSurface.Create(FScreen.FDirectDraw,Fscreen.front.Width,Fscreen.Front.height,FScreen.Colordepth)
        else
        Fsurface := TDGCSurface.Create(FScreen.FDirectDraw,Image.width,Image.height,FScreen.Colordepth);
        Fsurface.OnSurfaceLost := FScreen.DoSurfaceLost;
        if assigned(Fsurface) then
        begin
           if stretch then
              Fsurface.Canvas.Stretchdraw(rect(0,0,Fsurface.Width,Fsurface.Height),Fimage.Graphic)
           else
               Fsurface.canvas.Draw(0,0,Fimage.graphic);
           Fsurface.canvas.release;
        end;
        Fsurface.TransparentColor := rgb(0,0,0);
   end;

   //If in window mode and using normal palette -- draw the images to the
   //surface's canvas
   If Fscreen.FPaletteMode = pmNormal then
   begin
        With FSurface.Canvas do
        begin
             stretchDraw(cliprect,Fimage.graphic);
             Release;
        end;
   end;
end;

Destructor TDGCBackgroundImageItem.Destroy;
begin
     Fimage.free;
     Inherited destroy;
end;

// TDGCBackgroundCollection
// ==========================
constructor TDGCBackgroundCollection.Create(Aowner:Tcomponent);
begin
     inherited Create(TDGCBackgroundImageItem);
     Fowner:=Aowner;
end;



// must be overidden for streaming to work properly
function TDGCBackgroundCollection.GetOwner:TPersistent;
begin
     Result:=Fowner;
end;

procedure TDGCBackgroundCollection.SetItem(Index:integer;Value:TDGCBackgroundImageItem);
begin
     inherited setitem(Index,Value);
end;

function TDGCBackgroundCollection.GetItem(Index:integer):TDGCBackgroundImageItem;
begin
     Result:=TDGCBackgroundImageItem(inherited GetItem(Index));
end;



//TDGCBackground Implementation
//========================
Constructor TDGCBackground.create(AOwner: TComponent);
begin
     inherited create(AOwner);
     FScreen:=Nil;
     Fimages:=TDGCBackgroundCollection.Create(self);
     FVersion:='1.0';
end;

procedure TDGCBackground.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
   inherited Notification(AComponent, Operation);
   if (Operation = opRemove) and not (csDestroying in ComponentState) then
   begin
      if FScreen = AComponent then
         FScreen := nil;
   end;
end;

procedure TDGCBackground.SetImages(Value:TDGCBackgroundCollection);
begin
     Images.assign(Value);
end;

procedure TDGCBackground.Init;
var
   i:integer;
begin
     if assigned(FImages) then
     begin
          for i:=0 to Images.Count-1 do
          begin
               Images.Items[i].Fscreen:=Fscreen;
               Images.Items[i].Init;
          end;
     end;
end;


procedure TDGCBackground.Update;
var
   i:integer;
begin
     if assigned(FImages) then
     begin
          if Fscreen <> nil then
          begin
          //     FScreen.back.Eraserect(Fscreen.Back.ClientRect,0);
               for i:=0 to Images.Count-1 do
                   Images.Items[i].Update;
          end;
     end;
end;


procedure TDGCBackground.Savetofile(Filename:string);
var
   FileStream:TFilestream;
begin
      Filestream:=TFilestream.create(filename,fmCreate);
      filestream.Writecomponentres('DGC_Background_LIB',Self);
      Filestream.Free;
end;

Procedure TDGCBackground.Loadfromfile(filename:String);
var
   Filestream:Tfilestream;
begin
     // create dummy component
     try
        fImages.Clear;
        Filestream:=TFilestream.create(filename,fmopenread);
        Filestream.Readcomponentres(self);
        Filestream.Free;
        if DGCScreen <> nil then
        begin
             // set each surface to FScreen

        end;
     finally
        //comp.free;
     end;
end;


Function TDGCBackground.getImagecount:Integer;
begin
     if assigned(Fimages) then
        result:=Fimages.count;
end;

Destructor TDGCBackground.Destroy;
begin
     Fimages.free;
     inherited destroy;
end;

//TDGCSurface Implementation
//==========================
//This handles the creation of a direct draw surface and creates a
//Canvas object for the surface.


constructor TDGCSurface.Create(DirectDraw4: IDirectDraw4; w, h: Integer;Colordepth:Integer);
var
   SurfaceDesc: TDDSurfaceDesc2;
begin
   inherited Create;
   //Fill in the DirectDrawSurface descriptor prior to creating the surface }
   IsBackBuffer := False;
   Fcolordepth:=Colordepth;
   FillChar(SurfaceDesc, SizeOf(Surfacedesc), 0) ;
   with SurfaceDesc do
   begin
      dwSize := SizeOf(SurfaceDesc) ;
      dwFlags := DDSD_CAPS or DDSD_HEIGHT or DDSD_WIDTH;
      If Screen.Width < w then
         ddSCaps.dwCaps := DDSCAPS_OFFSCREENPLAIN + DDSCAPS_SYSTEMMEMORY
      else
         ddSCaps.dwCaps := DDSCAPS_OFFSCREENPLAIN;// + DDSCAPS_SYSTEMMEMORY;
      dwWidth := w ;
      dwHeight := h ;
   end;
   if DirectDraw4.CreateSurface(SurfaceDesc, FSurface, NIL ) <> DD_OK then
      Raise EDGCSurface.Create(Format('Could not create memory surface (%d, %d)',
               [w, h])) ;
   //Create canvas
   FWidth := w;
   FHeight := h;
   FClientRect := Rect(0, 0, w, h);
   FClipRect := FClientRect;
   FCanvas := TDGCCanvas.Create(FSurface);
   //Get Pitch
   if FSurface.GetSurfaceDesc(SurfaceDesc) = DD_OK then
      FWidthBytes := SurfaceDesc.lPitch
   else
      FWidthBytes := 0;

   fCacheLevel:= Double(Time);  //cam
end;

Var
   pxformat:TDDPixelFormat;

Function EnumZBufferCallback(var ppfd:TDDPIXELFORMAT;pddpfDesired:pointer ):Hresult;stdcall;
begin
    // If this is ANY type of depth-buffer, stop.
    if( ppfd.dwFlags = DDPF_ZBUFFER ) then
    begin

        pxformat:=ppfd;

        // Return with D3DENUMRET_CANCEL to end the search.
        Result:=D3DENUMRET_CANCEL;
    end;

    // Return with D3DENUMRET_OK to continue the search.
    Result:=D3DENUMRET_OK;
end;


constructor TDGCSurface.CreateZbuffer(DirectDraw4:Idirectdraw4;D3D:IDirect3D3;BackBuffer:TDGCSurface;Colordepth:Integer);
var
   Caps: TDDSCaps2;
   surfacedesc:TDDSurfacedesc2;
   pixelformat,PixelFormat2:TDDPixelformat;
begin
     inherited Create;
     IsBackBuffer := False;
     D3D.EnumZBufferFormats(IID_IDirect3DrgbDevice,EnumZbufferCallback,@Pixelformat);

     Fcolordepth:=Colordepth;
     FillChar(SurfaceDesc, SizeOf(Surfacedesc), 0) ;
     with Surfacedesc do
     begin
          dwSize := SizeOf(SurfaceDesc) ;
          dwFlags:= DDSD_CAPS or DDSD_WIDTH or DDSD_HEIGHT or DDSD_PIXELFORMAT;
          if  Backbuffer.Finvideomemory then
                    ddsCaps.dwCaps := DDSCAPS_ZBUFFER+DDSCAPS_VIDEOMEMORY
          else
              ddsCaps.dwCaps := DDSCAPS_ZBUFFER+DDSCAPS_SYSTEMMEMORY;
          ddpfPixelFormat:=pxformat;
	  dwWidth := BackBuffer.Width;
	  dwHeight:= Backbuffer.height;
     end;
     Dxcheck(DirectDraw4.CreateSurface(SurfaceDesc, FSurface, NIL ));
     DXCheck(Backbuffer.Surface.AddAttachedSurface( FSurface ));
     FWidth := Backbuffer.Width;
     FHeight := Backbuffer.Height;
     FWidthBytes := Backbuffer.WidthBytes;
     FClientRect := Rect(0, 0, FWidth, FHeight);
     FClipRect := FClientRect;
end;



constructor TDGCSurface.CreatePrimary(DGCScreen: TDGCScreen;Colordepth:Integer);
var
   SurfaceDesc: TDDSurfaceDesc2;
begin
   inherited Create;
   //Fill in the DirectDrawSurface descriptor prior to creating the surface }
   IsBackBuffer := False;
   Fcolordepth:=Colordepth;
   FillChar(SurfaceDesc, SizeOf(SurfaceDesc), 0);
   SurfaceDesc.dwSize := SizeOf(SurfaceDesc);

   with SurfaceDesc do
   begin
      If DGCScreen.FWindowMode then
      begin
        dwFlags := DDSD_CAPS;
        ddSCaps.dwCaps := DDSCAPS_PRIMARYSURFACE + DDSCAPS_3DDEVICE;
      end
      else
      begin
        dwFlags := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
        ddSCaps.dwCaps := DDSCAPS_COMPLEX + DDSCAPS_FLIP + DDSCAPS_3DDEVICE  + DDSCAPS_PRIMARYSURFACE;
        dwBackBufferCount := 1;//DGCScreen.FBackBuffers;
      end;

   end;

   // create the complex flipping surface
   if DGCScreen.DirectDraw4.CreateSurface(SurfaceDesc, FSurface, NIL ) <> DD_OK then
       Raise EDGCSurface.Create( 'Create Primary Surface failed' ) ;
   //Create canvas
   FCanvas := TDGCCanvas.Create(FSurface);
   //Get Screen Width and Height
   if DGCScreen.DirectDraw4.GetDisplayMode(SurfaceDesc) <> DD_OK then
           Raise EDGCSurface.Create('Get DisplayMode Failed');
   If DGCScreen.WindowMode then
   begin
      FWidth      := DGCScreen.FWindowWidth;
      FHeight     := DGCScreen.FWindowheight;
      FWidthBytes := FWidth;
   end
   else
   begin
      FWidth      := SurfaceDesc.dwWidth;
      FHeight     := SurfaceDesc.dwHeight;
      FWidthBytes := SurfaceDesc.lPitch;
   end;

   FClientRect := Rect(0, 0, FWidth, FHeight);
   FClipRect := FClientRect;
end;

constructor TDGCSurface.CreateBackBuffer(Primary: TDGCSurface;Colordepth:Integer);
var
   Caps: TDDSCaps2;
   SurfaceDesc: TDDSurfaceDesc2;
begin
     inherited Create;
     IsBackBuffer := True;
     Fcolordepth:=Colordepth;
     Caps.dwCaps := DDSCAPS_BACKBUFFER;
     DXCheck(Primary.Surface.GetAttachedSurface(Caps, FSurface ));
     FillChar(SurfaceDesc, SizeOf(SurfaceDesc), 0);
     SurfaceDesc.dwSize := SizeOf(SurfaceDesc);
     DXCheck(FSurface.GetSurfaceDesc(surfacedesc));
     if Surfacedesc.ddsCaps.dwcaps = DDSCAPS_VIDEOMEMORY then
        FInvideomemory :=True;
     FCanvas := TDGCCanvas.Create(FSurface);

     //Set Width/Height Flags - Copy from Primary
     FWidth := Primary.Width;
     FHeight := Primary.Height;
     FWidthBytes := Primary.WidthBytes;
     FClientRect := Rect(0, 0, FWidth, FHeight);
     FClipRect := FClientRect;
end;

constructor TDGCSurface.CreateBackBufferW(DGCScreen: TDGCScreen; Flags : DWORD;Colordepth:Integer);
var
  Desc : TDDSurfaceDesc2;
begin
  inherited Create;
  Fcolordepth:=Colordepth;
  FillChar(Desc,Sizeof(Desc),0);
  Desc.dwSize := Sizeof(Desc);

  Desc.dwFlags        := DDSD_CAPS or DDSD_WIDTH or DDSD_HEIGHT;
  Desc.dwWidth        := DGCScreen.FWindowWidth;
  Desc.dwHeight       := DGCScreen.FWindowHeight;
  Desc.ddSCaps.dwCaps := DDSCAPS_OFFSCREENPLAIN + DDSCAPS_3DDEVICE;

  if DGCScreen.DirectDraw4.CreateSurface(Desc, FSurface, NIL ) <> DD_OK then
     Raise EDGCSurface.Create( 'Failed Creating BackBufferW' ) ;

  FCanvas := TDGCCanvas.Create(FSurface);

  //Set Width/Height Flags - Copy from Primary
  FWidth      := DGCScreen.FWindowWidth;
  FHeight     := DGCScreen.FWindowHeight;
  FWidthBytes := FWidth;
  FClientRect := Rect(0, 0, FWidth, FHeight);
  FClipRect   := FClientRect;
end;

//The time in seconds will determine the cachelevel.
//when purging is required, the lowest value will be the least used.
Function TDGCSurface.ReadSurface:IDirectDrawSurface4;
begin
  fCacheLevel := Double(Time);
  result:= fSurface;
end;

destructor TDGCSurface.Destroy;
begin
   //Free canvas
   if Assigned(FCanvas) then
      FCanvas.Free;

   //Release Surface (Back buffers are released when primary surfaced
   //released
   if Assigned(FSurface) and not IsBackBuffer
   then Fsurface:=nil;
   inherited Destroy;
end;

function TDGCSurface.ConvertColor( Color : TColor ) : integer;
begin
  Case Fcolordepth of
    8 :
      raise Exception.Create('Cannot convert paletized colors.');
    16 :
      Result :=
        (LoByte(LoWord(Color)) shr 3 shl 11) or   // Red
        (HiByte(LoWord(Color)) shr 2 shl 5) or    // Green
        (LoByte(HiWord(Color)) shr 3);            // Blue
    24, 32 :
      Result :=
        (LoByte(LoWord(Color)) shl 16) or   // Red
        (HiByte(LoWord(Color)) shl 8) or    // Green
        (LoByte(HiWord(Color)));            // Blue
    else raise Exception.Create('Unknown pixel format : cannot convert color.');
  end;
end;


procedure TDGCSurface.SetPixel(x, y: Integer; Color: TColor);
var
   SurfaceDesc: TDDSurfaceDesc2;
   R:TRect;
   PixelClr: DWORD;
begin
   // use canvas to draw on the surface as it will sort out color mapping
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc2) ;
   Surface.Lock(nil, SurfaceDesc, DDLOCK_WAIT, 0) ;

   case FColordepth of
        8:  PByte(Byte(SurfaceDesc.lpSurface)+(Surfacedesc.lpitch*Y + X))^ := Color;
       16:  PDWord(integer(SurfaceDesc.lpSurface)+Surfacedesc.lpitch*Y + X*2)^ := Convertcolor(Color);
       24:  PDword(DWord(SurfaceDesc.lpSurface)+surfacedesc.lpitch*Y + X*3)^ := Convertcolor(Color) ;
       32:  PDWORD(DWord(SurfaceDesc.lpSurface)+surfacedesc.lPitch*Y + X*4)^ := Convertcolor(Color);
   end; //case
{   with Canvas do
   begin
        PDWORD(DWord(SurfaceDesc.lpSurface)+surfacedesc.lPitch*Y + X*2)^ :=Pixelclr;
        release;
   end;}
   Surface.UnLock(nil);

end;

function TDGCSurface.GetPixel(x, y: Integer) : TColor;
var
   SurfaceDesc: TDDSurfaceDesc2;
   R:trect;
begin
   Result := 0;
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc2) ;
   R:=Rect(x, y, x, y);
   if FSurface.Lock(@R, SurfaceDesc, DDLOCK_SURFACEMEMORYPTR +
            DDLOCK_WAIT, 0) <> DD_OK then exit;
   With Canvas do
   begin
      Result := PWord(SurfaceDesc.lpSurface)^;
      Release;
   end;
   FSurface.UnLock(@r);
end;

// get the HDC for the surface
function TDGCsurface.getdc:HDC;
var
   ret:Hresult;
   surfdc:HDC;
begin
     ret:=Fsurface.GetDC(surfdc);
     if Failed(ret) then
        Showmessage('Failed to Get DC :');
     result:=Surfdc;
end;

function TDGCSurface.GetPointer: Pointer;
var
   SurfaceDesc: TDDSurfaceDesc2;
begin
   SurfaceDesc.dwSize := SizeOf(SurfaceDesc) ;
   if FSurface.Lock(@FClientRect, SurfaceDesc, DDLOCK_SURFACEMEMORYPTR +
            DDLOCK_WAIT, 0) <> DD_OK then
   begin
      SurfacePtr := nil;
      Result := nil;
      exit;
   end;
   SurfacePtr := SurfaceDesc.lpSurface;
   Result := SurfaceDesc.lpSurface;
end;

procedure TDGCSurface.ReleasePointer;
begin
   if SurfacePtr <> nil then
   begin
      FSurface.UnLock(SurfacePtr);
      SurfacePtr := nil;
   end;
end;

procedure TDGCSurface.SetTransparentColor(newvalue:byte);
var
   ColorKey: TDDColorKey ;
begin

   FTransparentColor := NewValue;
   ColorKey.dwColorSpaceLowValue := FTransparentColor ;
   ColorKey.dwColorSpaceHighValue := FTransparentColor;
   if FSurface.SetColorKey(DDCKEY_SRCBLT, @ColorKey) <> DD_OK then
      Raise EDGCSurface.Create('SetColorKey failed') ;
end;

function TDGCSurface.CollisionTest(x, y: Integer; SrcSurface: TDGCSurface;
         sx, sy: Integer; PixelTest: Boolean): Boolean;
var
   r, r1, r2: TRect;
   lx, ly, w, h: Integer;
   bits1, bits2: Pointer;
   savebits1, savebits2: PByte;
   pitch1, pitch2: Integer;
   t1, t2: Byte;
   SurfaceDesc: TDDSurfaceDesc2;
begin
   Result := False; //default to no collision
   r1 := Rect(x, y, x + FWidth, y + FHeight);
   r2 := Rect(sx, sy, sx + SrcSurface.Width, sy + SrcSurface.Height);
   //Do the images intersect?
   if not InterSectRect(r, r1, r2) then
      exit
   else
      if not PixelTest then
      begin
         Result := True;
         exit;
      end;

   //Check Pixel Data
   w := r.Right - r.Left; //width of intersecting rectangle
   h := r.Bottom - r.Top; //height of intersecting rectangle
   //Set Rectangle 1
   r1.Left := r.Left - r1.Left;
   r1.Top := r.Top - r1.Top;
   r1.Right := r1.Left + w;
   r1.Bottom := r1.Top + h;
   //Set Rectangle 2
   r2.Left := r.Left - r2.Left;
   r2.Top := r.Top - r2.Top;
   r2.Right := r2.Left + w;
   r2.Bottom := r2.Top + h;

   //Get pointer to surface 1
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc2) ;
   if FSurface.Lock(@r1, SurfaceDesc, DDLOCK_SURFACEMEMORYPTR +
            DDLOCK_WAIT, 0) <> DD_OK then exit;

   bits1 := SurfaceDesc.lpSurface;
   pitch1 := SurfaceDesc.lPitch - w;

   //Get pointer to surface 1
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc2);
   if SrcSurface.Surface.Lock(@r2, SurfaceDesc, DDLOCK_SURFACEMEMORYPTR +
            DDLOCK_WAIT, 0) <> DD_OK then
   begin
      FSurface.UnLock(@r1);
      exit;
   end;
   bits2 := SurfaceDesc.lpSurface;
   pitch2 := SurfaceDesc.lPitch - w;

   savebits1 := bits1;
   savebits2 := bits2;
   t1 := FTransparentColor;
   t2 := SrcSurface.TransparentColor;
   for ly := 1 to h do
   begin
      for lx := 1 to w do
      begin
         if (savebits1^ <> t1) and (savebits2^ <> t2) then
         begin
            FSurface.UnLock(@r1);
            SrcSurface.Surface.UnLock(@r2);
            Result := True;
            exit;
         end;
         Inc(savebits1);
         Inc(savebits2);
      end;
      Inc(savebits1, pitch1);
      Inc(savebits2, pitch2);
   end;
   FSurface.UnLock(@r1);
   SrcSurface.Surface.UnLock(@r2);
end;

procedure TDGCSurface.Erase(Color: Byte);
var
  BltFx: TDDBLTFX;
  r: HResult;
begin
  ZeroMemory ( @BltFx, sizeof(BltFx));
  BltFx.dwSize := sizeof(BltFx);
  BltFx.dwFillColor := Color;
  r := FSurface.Blt(@FClientRect, nil, @FClientRect, DDBLT_COLORFILL + DDBLT_WAIT, @BltFx);
  if r <> DD_OK then
     if (r = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
        FOnSurfaceLost(self)
     else
         raise EDGCSurface.Create('Erase (Blt) Failed');
end;

procedure TDGCSurface.EraseRect(r: Trect; Color: Byte);
var
  BltFx: TDDBLTFX;
  res: HResult;
begin
  ZeroMemory ( @BltFx, sizeof(BltFx));
  BltFx.dwSize := sizeof(BltFx);
  BltFx.dwFillColor := Color;
  res := FSurface.Blt(@r, nil, @r, DDBLT_COLORFILL + DDBLT_WAIT, @BltFx);
  if res <> DD_OK then
     if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
        FOnSurfaceLost(self)
     else
         raise EDGCSurface.Create('Erase (Blt) Failed');
end;

procedure TDGCSurface.Scroll(x, y: Integer);
var
   r: TRect;
   res: HResult;
begin
   r := FClipRect;
   //X Scroll
   if x < 0 then
   begin
      Inc(r.Left, Abs(x));
      x := FClipRect.Left;
   end
   else
   begin
      Dec(r.Right, x);
      Inc(x, FClipRect.Left);
   end;

   //y Scroll
   if y < 0 then
   begin
      Inc(r.Top, Abs(y));
      y := FClipRect.Top;
   end
   else
   begin
      Dec(r.Bottom, y);
      Inc(y, FClipRect.Top);
   end;

   //Do the blit
   res := FSurface.BltFast(x, y, FSurface, @r,
                          DDBLTFAST_NOCOLORKEY or DDBLTFAST_WAIT);
   if res <> DD_OK then
      if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
         FOnSurfaceLost(self)
      else
         raise EDGCSurface.Create('Scroll (BltFast) Failed');
end;

procedure TDGCSurface.BltClip(x, y: Integer; SrcSurface: TDGCSurface; r: TRect; TransParent: Boolean);
var
   res: HResult;
   wi,hi : integer;
   srcrect:TRect;
   bltfx:TDDBltfx;
begin
   //get width and height of source image
   wi := r.right  - r.left;
   hi := r.bottom - r.top;

   //check bounds
   if (x > FClipRect.Right)  or
      (y > FClipRect.Bottom) or
      (x + wi < FClipRect.Left) or
      (y + hi < FClipRect.Top)  then Exit;

   //do clipping
   if x + wi > FCLipRect.Right then
      r.right := r.right - ((x+wi) - FClipRect.Right);

   If x < FClipRect.Left then
      r.left := r.left + (FClipRect.Left + x);

   If y + hi > FClipRect.Bottom then
      r.Bottom := r.Bottom - ((y+hi)-FClipRect.Bottom);

   If y < FClipRect.Top then
      r.Top := r.Top + (FClipRect.Top - y);

   If x < 0 then x := 0;
   if y < 0 then y := 0;

   //Draw Image
   srcrect:=Rect(X,Y,X+R.Right,Y+R.Bottom);
   if Transparent then
      res := FSurface.Bltfast(x,y, SrcSurface.Surface, @r,
                         DDBLTFAST_SRCCOLORKEY or DDBLTFAST_WAIT)
   else
      res := FSurface.Bltfast(x, y, SrcSurface.Surface, @r,
                          DDBLTFAST_NOCOLORKEY or DDBLTFAST_WAIT);
   if res <> DD_OK then
      if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
         FOnSurfaceLost(self)
      else
         raise EDGCSurface.Create('BlitClip (BltFast) Failed');
end;

procedure TDGCSurface.Draw(x, y: Integer; SrcSurface: TDGCSurface; TransParent: Boolean);
var
   res: HResult;
   r: TRect;
   sr: TRect;

begin
   sr := Rect(x, y, x + (SrcSurface.Width-1) , y + (SrcSurface.Height-1));
   if not IntersectRect(r, sr, FClipRect) then exit;
   r  := SrcSurface.ClientRect;

   if x < FClipRect.Left then
      r.Left := FClipRect.Left - x;

   if x + r.Right > FClipRect.Right then
          r.Right := FClipRect.Right - x;

   if x < FClipRect.Left then x := FClipRect.Left;

   if y < FClipRect.Top then
      r.Top := FClipRect.Top -y;

   if y + r.Bottom > FClipRect.Bottom then
      r.Bottom := FClipRect.Bottom - y;

   If y < FClipRect.Top then y := FClipRect.Top;

   if Transparent then
      res := FSurface.BltFast(x, y, SrcSurface.Surface, @r,
                           DDBLTFAST_SRCCOLORKEY + DDBLTFAST_WAIT)
   else
      res := FSurface.BltFast(x, y, SrcSurface.Surface, @r,
                            DDBLTFAST_NOCOLORKEY + DDBLTFAST_WAIT);
   if res <> DD_OK then
      if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
        FOnSurfaceLost(self)
      else
         raise EDGCSurface.Create('Draw (BltFast) Failed');
end;

procedure TDGCSurface.StretchDraw(dr: TRect; SrcSurface: TDGCSurface; TransParent: Boolean);
var
   res: HResult;
   r: TRect;
   BltFx: TDDBltFx;
begin
   //Draw Image
   r := SrcSurface.FClientRect;
   ZeroMemory (@BltFx, sizeof(BltFx));
   BltFx.dwSize := sizeof(BltFx);
   if Transparent then
      res := FSurface.Blt(@dr, SrcSurface.Surface, @r, DDBLT_WAIT or DDBLT_KEYSRC, @BltFx)
   else
      res := FSurface.Blt(@dr, SrcSurface.Surface, @r, DDBLTFAST_WAIT, @BltFx);
   if res <> DD_OK then
      if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
         FOnSurfaceLost(self)
      else
         raise EDGCSurface.Create('StretchDraw (BltFast) Failed');
end;

procedure TDGCSurface.StretchFlip(dr: TRect; SrcSurface: TDGCSurface; TransParent, FlipX,FlipY: Boolean);
var
   res: HResult;
   r: TRect;
   BltFx: TDDBltFx;
begin
   //Draw Image
   r := SrcSurface.ClientRect;
   ZeroMemory (@BltFx, sizeof(BltFx));
   BltFx.dwSize := sizeof(BltFx);
   If FlipX = true then BltFX.dwDDFX := BltFX.dwDDFX or DDBLTFX_MIRRORLEFTRIGHT;
   If FlipY = true then BltFX.dwDDFX := BltFX.dwDDFX or DDBLTFX_MIRRORUPDOWN;
   if Transparent then
      res := FSurface.Blt(@dr, SrcSurface.Surface, @r, DDBLT_WAIT or DDBLT_KEYSRC or DDBLT_DDFX, @BltFx)
   else
      res := FSurface.Blt(@dr, SrcSurface.Surface, @r, DDBLTFAST_WAIT or DDBLT_DDFX, @BltFx);
   if res <> DD_OK then
      if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
         FOnSurfaceLost(self)
      else
         raise EDGCSurface.Create('StretchFlip (BltFast) Failed');
end;

procedure TDGCSurface.BltFast(x, y: Integer; SrcSurface: TDGCSurface; r: TRect; TransParent: Boolean);
var
   res: HResult;
begin
   //Draw Image
   if Transparent then
      res := FSurface.BltFast(x, y, SrcSurface.Surface, @r,
                         DDBLTFAST_SRCCOLORKEY or DDBLTFAST_WAIT)
   else
      res := FSurface.BltFast(x, y, SrcSurface.Surface, @r,
                          DDBLTFAST_NOCOLORKEY or DDBLTFAST_WAIT);
   if res <> DD_OK then
      if (res = DDERR_SURFACELOST) and Assigned(FOnSurfaceLost) then
         FOnSurfaceLost(self)
      else
         raise EDGCSurface.Create('BltFast Failed');
end;

procedure TDGCSurface.Tile(x, y: Integer; SrcSurface: TDGCSurface; TransParent: Boolean);
var
   sx, ey, ex: Integer;
   w, h: Integer;
begin
   w := SrcSurface.Width;
   h := SrcSurface.Height;
   ey := FClipRect.Bottom + h;
   ex := FClipRect.Right + w;
   Inc(x, FClipRect.Left);
   Inc(y, FClipRect.Top);
   while y < ey do
   begin
      sx := x;
      while sx < ex do
      begin
         Draw(sx, y, SrcSurface, Transparent);
         Inc(sx, w);
      end;
      Inc(y, h);
   end;
end;

//TDGCScreen Implementation
//=======================
constructor TDGCScreen.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   //Initialize
   FPalette         := nil;
   FDGCImageLib     := nil;
   FDGCDirectInput  := nil;
   FBackground   := nil;
   FDGCTileLib      := nil;
   FImageList       := nil;
   FTileList        := nil;
   FVersion         := 'DGC Beta 7.1';
   FBackBuffers     := 2;
   FWindowMode      := False;
   Fuse3D:=False;
   FWinBufWidth     := 0;
   FWinBufHeight    := 0;
   FWindowVBL       := True;
   FPaletteMode     := pmNormal;
   FWindowStretch   := False;
   FMousePointer    := crarrow;
   FMouseX          :=0;
   FShowMouse       :=False;;
   FMouseY          :=0;
   FColorDepth      := 16;
   FDisplayMode     := dm640x480x16;
   Debug            := True;
   FBeepOnException := True;
   if not (csDesigning in ComponentState) then
   begin
      frmOnActivate := TForm(Owner).OnActivate;
      TForm(Owner).OnActivate := DoOnActivate;
   end;
end;

destructor TDGCScreen.Destroy;
begin
   CleanUpDirectDraw4;
   inherited Destroy;
end;

{ Allocates memory for an image lib being loaded }
{ from a sprite bank library file                }
Procedure TDGCScreen.SetupImagelist(Count:Integer);
begin
   FreeImageList;
   FImageListCount := Count;
   GetMem(FImageList, FImageListCount * SizeOf(TDGCSurface));
end;


procedure TDGCScreen.SetMouseCursor(Value:TCursor);
begin
     FMousePointer:=Value;
end;

procedure TDGCScreen.Mousefired(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if button in [mbleft] then
        FMousestate := 1
     else
         if button in [mbright] then
            Fmousestate :=1
         else
             Fmousestate := 0;
end;

procedure TDGCScreen.Mousemoved(Sender: TObject;Shift: TShiftState; X, Y: Integer);
begin
     FMouseX:=X;
     FMouseY:=Y;
end;

procedure TDGCScreen.DrawMap(MapSurface: TDGCSurface; Idx, MapX, MapY, ScrX, ScrY: Integer; Trans : Boolean);
var
   xi   : word;        //x increment
   yi   : word;        //y increment
   xx   : integer;     //x pos on screen
   yy   : integer;     //y pos on screen
   w    : word;        //w width of tiles
   h    : word;        //h hieght of tiles
   xs   : word;        //Map X-Size
   ys   : word;        //Map Y-Size
   i    : byte;        //Tile to draw
   t    : integer;     //Temp (for calc'ing beginning tile to draw
   pitch: integer;     //used in tile image calc

begin
   //check for things necessary to draw a map
   If not (assigned(TileLibrary) or assigned(MapLibrary)) then exit;
   if FTileListCount < 1 then exit;
   if ScrX > ClipRect.Right then exit;
   If ScrY > ClipRect.Bottom then exit;

   //tile width & height
   w := Tiles[0].Width;
   h := Tiles[0].Height;

   //map size
   xs:= FMapLib.MapLib.Maps[Idx].XSize;
   ys:= FMapLib.MapLib.Maps[Idx].YSize;
   //starting map index
   xi := 0;
   yi := 0;

   //calc first horizontal tile to draw
   If ScrX < ClipRect.Left then                         //if off the left side of the screen
   begin
      t := (-ScrX + ClipRect.Left) div w;               //number of tiles to skip
      MapX := t;                            //set map x index
      xx := ScrX + (t*w);                   //adjust screen x pos
     ScrX := xx;                           //assign screen x pos
  end
   else
      xx := ScrX;

   //calc first vertical tile to draw
   If ScrY < ClipRect.Top then                         //same stuff as above! just vertical
   begin
      t := (-ScrY + ClipRect.Top) div h;
      MapY := t;
      yy := ScrY + (t*h);
      ScrY := yy;
   end
   else
     yy := ScrY;

   //set the pitch
   Pitch := MapX+((MapY + yi) * xs);        // pitch = bytes to the next vertical line

   //Capture some info for Picking tiles from the screen (GetTileDrawn)
   FFirstTileXPos := ScrX;
   FFirstTileYPos := ScrY;
   FFirstTileX    := MapX;
   FFirstTileY    := MapY;
   FMapIdxUsed    := Idx;

   While yy < ClipRect.Bottom do                          //vertically on the screen?
   begin
      if (MapY+yi < ys) then                              //within map? (vertical pos)
      While xx < ClipRect.Right do                        //horizontally on the screen?
      begin
         if (MapX+xi < xs) then                           //within map? (horiz. spot)
         begin
            i := FMapLib.MapLib.Maps[Idx].Data[xi + pitch];//get image number
            If not ((FSkipTile0) and (i = 0)) then        //using SkipTile0
               MapSurface.Draw(xx,yy,Tiles[i],Trans);        //draw the tile!
         end;
         Inc(xx,w);                                       //inc screen x pos by tile width
         Inc(xi);                                         //inc x index into map
      end;
      Inc(yy,h);                                          //inc screen y pos by tile height
      Inc(yi);                                            //inc y index into map
      Inc(Pitch, xs);                                     //adjust pitch by x size of map
      xi := 0;                                            //reset x increment into map
      xx := ScrX;                                         //reset screen x pos
   end;
end;

function  TDGCScreen.GetTileDrawn(X,Y:Integer) : TDGCMapPos;
var
   yi : integer;
   xi : integer;
   w  : integer;
   h  : integer;
   xs : integer;
   ys : integer;

begin
   Result.MapX := -1;
   Result.MapY := -1;
   Result.Tile := 0;
   If (x < ClipRect.Left) or (x > ClipRect.Right)  or
      (y < ClipRect.Top)  or (y > ClipRect.Bottom) then exit;
   If not (assigned(TileLibrary) or assigned(MapLibrary)) then exit;

   if FTileListCount < 1 then exit;
   if x < FFirstTileXPos then exit;
   If y < FFirstTileYPos then exit;

   //tile width & height
   w := Tiles[0].Width;
   h := Tiles[0].Height;
   //map size
   xs:= FMapLib.MapLib.Maps[FMapIdxUsed].XSize;
   ys:= FMapLib.MapLib.Maps[FMapIdxUsed].YSize;

   if x = 0 then x := 1;
   if y = 0 then y := 1;
   xi := ((x-FFirstTileXPos) div w)+FFirstTileX;
   yi := ((y-FFirstTileYPos) div h)+FFirstTileY;

   If (xi > xs -1) or (xi < 0) then exit;
   If (yi > ys -1) or (yi < 0) then exit;

   Result.MapX := XI;
   Result.MapY := YI;
   Result.Tile := FMapLib.MapLib.Maps[FMapIdxUsed].Data[xi+(yi* xs)];
end;

procedure TDGCScreen.SetMapTile(MapIdx:Integer; MapX,MapY : Integer; NewTile:Byte);
begin
   If (MapX > FMapLib.MapLib.Maps[MapIdx].XSize) or (MapX < 0) or
      (MapY > FMapLib.MapLib.Maps[MapIdx].YSize) or (MapY < 0) then exit;
   FMapLib.MapLib.Maps[MapIdx].Data[MapX +(MapY * FMapLib.MapLib.Maps[MapIdx].XSize)] := NewTile;
end;

function  TDGCScreen.GetMapTile(MapIdx,MapX,MapY:Integer) : Byte;
begin
   Result := 0;
   If (MapX > FMapLib.MapLib.Maps[MapIdx].XSize) or (MapX < 0) or
      (MapY > FMapLib.MapLib.Maps[MapIdx].YSize) or (MapY < 0) then exit;
   Result := FMapLib.MapLib.Maps[MapIdx].Data[MapX +(MapY * FMapLib.MapLib.Maps[MapIdx].XSize)];
end;

Procedure TDGCScreen.SetupTilelist(Count:Integer);
begin
   FreeTileList;
   FTileListCount := Count;
   GetMem(FTileList, FTileListCount * SizeOf(TDGCSurface));
end;

procedure TDGCScreen.Loaded;
begin
   inherited Loaded;
   //Set form properties
   if not (csDesigning in ComponentState) and not WindowMode then
   begin
      with Owner as TForm do
      begin
         BorderStyle := bsNone;
         BorderIcons := [];
         FormStyle := fsStayOnTop;
         Color := clBlack;
      end;
   end;
end;

procedure TDGCScreen.DoOnActivate(Sender: TObject);
var
   n: Integer;
   Colors : Integer;
begin
{   If Not FWindowMode then FPaletteMode := pmExclusive;}
   Colors := (LongInt(1) shl GetDeviceCaps(TForm(Owner).Canvas.Handle, BitsPixel)) *
                     LongInt(GetDeviceCaps(TForm(Owner).Canvas.Handle, Planes));
   // need to change this
   If (Colors <> 256) and (FWindowMode) and (FColorDepth = 8) then
   begin
      If MessageDlg('You are not in 256 color mode. Do you want to run this ' +
         'application in Full-Screen mode?',mtConfirmation,[mbYes,mbNo],0) = mrNo then
         Application.Terminate
      else
         FWindowMode := False;
   end;

   if Assigned(frmOnActivate) then
      frmOnActivate(Owner);
   InitDirectDraw4;
   for n := 0 to Owner.ComponentCount - 1 do
       if Owner.Components[n] is TDGCAudio then
          TDGCAudio(Owner.Components[n]).InitDirectSound;
end;


procedure TDGCScreen.SetColorDepth(Value:Integer);
begin
     if Value <> FColordepth then
        Fcolordepth:=Value;
end;

procedure TDGCScreen.SetDisplayMode(Value:TdisplayMode);
var
   w,h,bpp:Integer;
begin
     if Value <> FdisplayMode then
     begin
        FdisplayMode:=Value;
        Dodisplaymode(w,h,bpp);
        Colordepth:=bpp;
     end;
end;

Procedure TDGCScreen.Dodisplaymode(var w,h,bpp:integer);
begin
     case DisplayMode of
          dm640x480x8:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=8;
                      end;
          dm640x480x16:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=16;
                      end;
          dm640x480x24:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=24;
                      end;
          dm640x480x32:
                      begin
                           w := 640;
                           h := 480;
                           bpp:=32;
                      end;
          dm320x200x8:
                      begin
                           w := 320;
                           h := 200;
                           bpp:=8;
                      end;
          dm800x600x8:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=8;
                      end;
          dm800x600x16:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=16;
                      end;
          dm800x600x24:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=24;
                      end;
          dm800x600x32:
                      begin
                           w := 800;
                           h := 600;
                           bpp:=32;
                      end;
          dm1024x768x8:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=8;
                       end;
          dm1024x768x16:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=16;
                       end;
          dm1024x768x24:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=24;
                       end;
          dm1024x768x32:
                       begin
                            w := 1024;
                            h := 768;
                            bpp:=32;
                       end;
          dm640x400x8:
                      begin
                           w:= 640;
                           h := 400;
                           bpp:=8;
                      end;
          dm320x240x8:
                      begin
                           w := 320;
                           h := 240;
                           bpp:=8;
                      end;
     else
        w := 640;
        h := 480;
        bpp:=16;
     end;
     Colordepth:=bpp;
end;

procedure TDGCScreen.InitDirectDraw4;
var
   w, h,bpp: Integer;
   ErrTxt: String;
   ret: HRESULT;

   Pixelformat:TDDPixelformat;
   RC:PRect;
   Mousecur:Hcursor;
   Iconinfo:Ticoninfo;
begin
   if Assigned(FDirectDraw) then exit;

   //Create Direct Draw Object
   if DirectDrawCreate(nil, FDrawObject, nil) <> DD_OK then
      raise EDGCScreen.Create('Failed to create IDirectDraw object');
   if FDrawobject.Queryinterface(IID_IDirectDraw4,FDirectDraw)<> DD_OK then
      raise EDGCScreen.Create('Failed to create IDirectDraw 4 object');;
   Dodisplaymode(w,h,bpp);

   FFormWidth    := TForm(Owner).Width;
   FFormHeight   := TForm(Owner).Height;

   If (FWinBufWidth <= 0) or (FwinBufheight <=0) then
   begin
     FWindowWidth  := W;
     FWindowHeight := H;
   end
   else
   begin
     FWindowWidth  := FWinBufWidth;
     FWindowHeight := FWinBufHeight;
   end;

   //Set Cooperative Level
   If FWindowMode then
      If FPaletteMode = pmExclusive then
         ret := DirectDraw4.SetCooperativeLevel(TForm(Owner).Handle, DDSCL_FULLSCREEN or DDSCL_EXCLUSIVE )
      else
         ret := DirectDraw4.SetCooperativeLevel(TForm(Owner).Handle, DDSCL_NORMAL or DDSCL_FPUSETUP)
   else
   begin

      DXCheck(DirectDraw4.SetCooperativeLevel(TForm(Owner).Handle,DDSCL_FULLSCREEN or DDSCL_EXCLUSIVE)); //or DDSCL_FPUSETUP));
   end;


   //Set Display Mode
   Application.OnException := DoException;
   Application.OnMessage := AppMessage;
   Application.Mainform.OnMouseMove:=Mousemoved;
   Application.MainForm.OnMouseDown:=Mousefired;

   if not FWindowMode then
      If DirectDraw4.SetDisplayMode(w, h, Fcolordepth,0,0) <> DD_OK then
      begin
         CleanUpDirectDraw4;
         Raise EDGCScreen.Create('Set Display Mode Failed');
      end;
   //Create Surfaces
   FFront := TDGCSurface.CreatePrimary(Self,Fcolordepth);
   FFront.OnSurfaceLost := DoSurfaceLost;
   If FWindowMode then
      FBack := TDGCSurface.CreateBackBufferW(Self,0,Fcolordepth)
   else
      FBack := TDGCSurface.CreateBackBuffer(FFront,Fcolordepth);
   FBack.OnSurfaceLost := DoSurfaceLost;

   //Create DirectDrawClipper Object
   If WindowMode then
   begin
      If FWindowStretch then
      begin
         TForm(Owner).ClientWidth  := FFormWidth;
         TForm(Owner).ClientHeight := FFormHeight;
         FDirectDraw.CreateClipper(0,FDDClipper, Nil);
         FDDClipper.SetHWnd(0,TForm(Owner).Handle);
         FFront.Surface.SetClipper(FDDClipper);
      end
      else
      begin
         TForm(Owner).ClientWidth  := FWindowWidth;
         TForm(Owner).ClientHeight := FWindowheight;
         FDirectDraw.CreateClipper(0,FDDClipper, Nil);
         FDDClipper.SetHWnd(0,TForm(Owner).Handle);
         FDirectDraw.CreateClipper(0,FDDBackClipper, Nil);
         FDDBackClipper.SetHWnd(0,TForm(Owner).Handle);
         FBack.Surface.SetClipper(FDDBackClipper);
         FFront.Surface.SetClipper(FDDClipper);
      end;
   end;
   //Erase front and back buffers to Color Index 0
   if use3d then
      CreateDefaultPalette;

   FDirectDraw.FlipToGDISurface;
   Back.Erase(0);
   Flip;
   Back.Erase(0);
   FDirectDraw.FlipToGDISurface;
   if not showmouse then
      Screen.Cursor := crnone
   else
       Screen.cursor:=Mouseimage;
   Mousecur:=GetCursor;
   if Mousecur <> Fmousecursor then
   begin
        FmouseCursor:=Mousecur;
        GetIconInfo(Mousecur,IConInfo);
        if Iconinfo.hbmMask <> 0 then
           DeleteObject(Iconinfo.hbmmask);
        if Iconinfo.hbmcolor <> 0 then
           DeleteObject(Iconinfo.hbmcolor);
   end;
   //Allow the game to be initialized but before calling event
   //Set library if one has been specified
//   if assigned(FBackground) then
//      setbackground(FBackground);
   if assigned(Fbackground) then
      Fbackground.Init;
   if assigned(FHicolorlib) then
      setHicolorlibrary(FHicolorlib);
   if Assigned(FImageLib) then
      SetImageLibrary(FImageLib, True);
   if Assigned(FTileLib) then
      SetTileLibrary(FTileLib, True);
   // initialize direct input if we have it
   if Assigned(FDGCDirectInput) then
      FDGCDirectInput.Init;
   if Assigned(FOnInitialize) then
      FOnInitialize(Self);
end;

procedure TDGCScreen.CleanUpDirectDraw4;
var
   rc:Prect;
begin
   //stop page flipping
   if not Assigned(FDirectDraw) then exit;
   FlippingEnabled := False ;

   //Call Cleanup method
   if Assigned(FOnCleanUp) then
      OnCleanUp(Self);

   //Free converted image library image list;
   FreeImageList;
   FreeTileList;

   //Free the TDGCCanvas objects before the surfaces
   if Assigned(FBack) then FBack.Free;
   if Assigned(FFront) then FFront.Free;

   //Free Palette
   if Assigned(FPalette) then
//      FPalette._Release;
   FPalette := nil;

   //Free the DirectDraw COM object by calling its Release method
   if Assigned(FDirectDraw) then
   begin
      FDirectDraw.RestoreDisplayMode;
      Fdirectdraw.SetCooperativeLevel(0,DDSCL_NORMAL);
      //FDirectDraw._Release;
      FDirectDraw := nil;
   end;

   new(rc);
   rc:=FScreenrc;
   ClipCursor(rc);
   Dispose(rc);
   //Dispose(Fscreenrc);
   // remove application exception handler
   Application.OnException := nil;
   Application.OnMessage := nil;
   {Application.Mainform.OnMouseMove:=nil;
   Application.MainForm.OnmouseDown:=nil;}
end;

procedure TDGCScreen.DoException(Sender: TObject; E: Exception);
begin
   if FBeepOnException then
      MessageBeep(0);
   if FDebug then
      TraceString(E.Message);
end ;

procedure TDGCScreen.Flip;
var
   r: HResult;
   BltFx : TDDBLTFX;
   Coords : TRect;
   Iconinfo:TICONINFO;
   Mousecur:HCursor;
   pt:TPoint;
   rc:prect;
begin

   If WindowMode then
   begin
      ZeroMemory(@BltFx, sizeof(BltFx));
      BltFx.dwSize := sizeof(BltFx);
      If FWindowStretch then
         Coords := TForm(Owner).ClientRect
      else
         Coords := FFront.FClientRect;
      with TForm(Owner) do
        begin
          Coords.TopLeft     := ClientToScreen(Coords.TopLeft);
          Coords.BottomRight := ClientToScreen(Coords.BottomRight);
          //make sure the cursor is clipped to the window
          {new(rc);
          rc^:=rect(0,0,TForm(Owner).Width,TForm(Owner).Height);
          rc^.Topleft:=ClientToScreen(Rc^.TopLeft);
          rc^.Topleft:=ClientToScreen(Rc^.Bottomright);
          ClipCursor(rc);
          Dispose(rc);}
        end;
      if Fshowmouse then
      begin
           GetCursorPos(pt);
           if ptinrect(Coords,pt) then
           begin
                DrawIcon(FBACK.Canvas.Handle,Fmousex,Fmousey,mousecur);
                Fback.Canvas.release;
           end;
        //if ((Fimagelistcount > Fmousepointer) and (Fmousepointer >=0)) then
        //begin
               //FBack.Draw(FMousex,FMousey,Fimagelist[FmousePointer],True);
        //end;
      end;

      If FWindowVBL then WaitForVerticalBlank;

      With FFront do
           r := FSurface.Blt(@Coords, FBack.FSurface, @FClientRect, DDBLT_WAIT, @BltFx);
   end
   else
   begin
      if Fshowmouse then
      begin
         // get The current mouse Pointer

           GetCursorPos(pt);
           DrawIcon(FBACK.Canvas.Handle,pt.x,pt.y,mousecur);
           Fback.Canvas.release;
           //if ((Fimagelistcount > Fmousepointer) and (Fmousepointer >=0)) then
        //begin
               //FBack.Draw(FMousex,FMousey,Fimagelist[FmousePointer],True);
        //end;
      end;
      r := FFront.Surface.Flip(nil, DDFLIP_WAIT);
   end;
   if r <> DD_OK then
      if r = DDERR_SURFACELOST then
         RestoreSurfaces
      else
         raise EDGCScreen.Create('Flip Failed');
   if (FDoCycling = True) and (FGotCyclePal = True) then CycleUpdate;
end;

Procedure TDGCScreen.CycleUpdate;
begin
  if FColordepth <> 8 then exit;
  if (FDoCycling = True) and (FGotCyclePal = True) then
  begin
    Inc(FCycleSkipCnt,1);
    If FCycleSkipCnt > FCycleSkip then
    begin
       Inc(FCycleStepCnt, FCycleStep);
       If (FCycleStepCnt > FCycleHigh - FCycleLow ) then
          FCycleStepCnt := FCycleStepCnt - (FCycleHigh - FCycleLow)-1 ;
       If FCycleStepCnt < 0 then
          FCycleStepCnt := FCycleStepCnt + (FCycleHigh-FCycleLow) ;
       FPalette.SetEntries(0,FCycleLow, FCycleHigh-FCycleLow +1, @FCyclePalette[FCycleStepCnt]);
       FCycleSkipCnt := 0;
    end;
  end;
end;

procedure TDGCScreen.CyclePalette(Low, High, Step, Skip : Integer);
var
   Loop : Integer;
   Pal  : T256PaletteEntry;
begin
   if Fcolordepth <> 8 then exit;
   FPalette.GetEntries(0, 0, 256, @Pal[0]);
   for Loop := 0 to High - Low do
   begin
     FCyclePalette[Loop].peRed   := Pal[Loop+Low].peRed;
     FCyclePalette[Loop].peGreen := Pal[Loop+Low].peGreen;
     FCyclePalette[Loop].peBlue  := Pal[Loop+Low].peBlue;

     FCyclePalette[Loop + (High-Low)+1 ].peRed   := Pal[Loop+Low].peRed;
     FCyclePalette[Loop + (High-Low)+1 ].peGreen := Pal[Loop+Low].peGreen;
     FCyclePalette[Loop + (High-Low)+1 ].peBlue  := Pal[Loop+Low].peBlue;
   end;
   FCycleStep := Step;
   FCycleSkip := Skip;
   FCycleLow  := Low;
   FCycleHigh := High;
   FGotCyclePal := True;
end;

procedure TDGCScreen.AppIdle(Sender: TObject; var Done: Boolean);
begin
   Done := False;
   if not Assigned(FDirectDraw) then exit;
   if assigned(Fbackground) then
      Fbackground.Update;
   if Assigned(FOnFlip) then
      FOnFlip(Self);
   if not Use3D then
      Flip;
end;

procedure TDGCScreen.AppMessage(var Msg: TMsg; var Handled : boolean ) ;
begin
   //Enable/Disbale Idle event if application not active
   case Msg.Message of
        WM_ACTIVATEAPP:
        begin
          //if not window mode
          //   showwindow(form1.handle, sw_showmaximized);
          if not Boolean(Msg.wParam) then
             StopTimer
          else
             PostMessage(Application.Handle, WM_DGCACTIVATE, 0, 0);
        end;
        WM_DGCACTIVATE:
        begin
          RestoreSurfaces;
          if FlippingEnabled then
             StartTimer;
          //else
          if Assigned(FOnPaint) then
             FOnPaint(Self);
        end;
        WM_SYSCOMMAND:
        begin
           //Do not allow a screen saver to kick in
           Handled := (Msg.wParam = SC_SCREENSAVE);
        end;
   end;
end ;

procedure TDGCScreen.SetFlippingEnabled(b: Boolean);
begin
   if b <> FFlippingEnabled then
   begin
      FFlippingEnabled := b;
      if not (csDesigning in ComponentState) then
      begin
         if FFlippingEnabled then
            StartTimer
         else
            StopTimer;
      end;
   end;
end;

procedure TDGCScreen.SetDebug(NewVal: Boolean);
begin
   if FDebug <> NewVal then
   begin
      FDebug := NewVal;
      //DebugMode := FDebug;
   end;
end;

procedure TDGCScreen.CreateSurface(var Surface: TDGCSurface; W, H: Integer);
begin
   Surface := nil;
   Surface := TDGCSurface.Create(DirectDraw4, W, H,Colordepth);
   Surface.TransparentColor := RGB(0,0,0);
end;

procedure TDGCScreen.WaitForVerticalBlank;
begin
   if DirectDraw4.WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0) <> DD_OK then
      raise EDGCScreen.Create('WaitForVericalBlankError');
end;

function TDGCScreen.GetScreenWidth: Integer;
begin
   Result := Front.Width;
end;

function TDGCScreen.GetScreenHeight: Integer;
begin
   Result := Front.Height;
end;

procedure TDGCScreen.SetKeys(keyleft,keyright,keyup,keydown,fire1,fire2:word);
begin
     Fkeyleft:=Keyleft;
     Fkeyright:=Keyright;
     FKeydown:=Keydown;
     FKeyup:=Keyup;
     Fkeyfire:=fire1;
     Fkeyfire2:=Fire2;
     if FDGCDirectInput <> nil then
        FDGCdirectInput.setkeys(keyleft,keyright,keyup,keydown,fire1,fire2);
end;

function TDGCScreen.KeyDown(Key: word): Boolean;
begin
   if FDGCDirectInput <> nil then
      Result:=FDGCDirectInput.GetKeyDown(KEY)
   else
      Result:=GetASyncKeyState(Key) < 0;
end;

procedure TDGCScreen.SetPalette(var NewPalette: T256PaletteEntry);
var
   Flags: DWORD;
begin
   If FColorDepth <> 8 then exit;
   //First Release Pallete
   FPaletteEntries := NewPalette;
   if Assigned(FPalette) then
   begin
      if FPalette.SetEntries(0, 0, 256, @FPaletteEntries[0]) <> DD_OK then
         raise EDGCScreen.Create('SetEntries Failed');
      exit;
   end;

   //Create the Palette
   Flags := DDPCAPS_8BIT or DDPCAPS_ALLOW256;

   if FDirectDraw.CreatePalette (Flags, @FPaletteEntries[0], FPalette, nil ) <> DD_OK then
      raise EDGCScreen.Create('CreatePalette Failed');

   //Set Palette
   if FFront.Surface.SetPalette(FPalette) <> DD_OK then
      Raise EDGCScreen.Create('SetPalette Failed') ;
end;

// no palette set so can not fade
procedure TDGCScreen.FadePaletteOut(Delay: Integer);
var
   Pal  : T256PaletteEntry;
   n, c : Integer;
begin
   if Fcolordepth <> 8 then exit;
   if not Assigned(FPalette) then
      raise EDGCScreen.Create('No palette set');
   //Get the current colours
   FPalette.GetEntries(0, 0, 256, @Pal[0]);

   //Create the temporary Palette

   //Set the color and step
   for c := Delay DownTo 0 do
   begin
      for n := 0 to 255 do
      begin
         with Pal[n] do
         begin
            peRed := (FPaletteEntries[n].peRed * c) div Delay;
            peGreen := (FPaletteEntries[n].peGreen * c) div Delay;
            peBlue := (FPaletteEntries[n].peBlue * c) div Delay;
         end;
      end;
      WaitForVerticalBlank;
      FPalette.SetEntries(0, 0, 256, @Pal[0]);
   end;
end;

procedure TDGCScreen.FadePaletteIn(Delay: Integer);
var
   Pal: T256PaletteEntry;
   n, c: Integer;
begin
   if Fcolordepth <> 8 then exit;
   if not Assigned(FPalette) then
      raise EDGCScreen.Create('No palette set');

   //Set the color and step
   ZeroMemory(@Pal[0], SizeOf(Pal));
   for c := 0 to Delay do
   begin
      for n := 0 to 255 do
      begin
         with Pal[n] do
         begin
            peRed := (FPaletteEntries[n].peRed * c) div Delay;
            peGreen := (FPaletteEntries[n].peGreen * c) div Delay;
            peBlue := (FPaletteEntries[n].peBlue * c) div Delay;
         end;
      end;
      WaitForVerticalBlank;
      FPalette.SetEntries(0, 0, 256, @Pal[0]);
   end;
end;

Procedure TDGCScreen.SetHiColorlibrary(Lib: TDGCHiColorImagelib);
var
   n:integer;
   Surfacedc:HDC;
   Picture:TDGCImageitem;
begin
   {FreeImageList;}
   if Lib = nil then exit;
   if Lib.ImageCount = 0 then exit;

   //Allocate Memory for Surfaces List
   FreeImageList;

   //Create Surfaces for Objects
   FImageListCount := Lib.ImageCount;
   GetMem(FImageList, FImageListCount * SizeOf(TDGCSurface));
   for n := 0 to Lib.ImageCount - 1 do
   begin
      Picture:=Lib.Images.Items[n];
      with Picture  do
      begin
         // major change in way surface image is created here
         // when using the original method the system crashes
         FImageList^[n] := TDGCSurface.Create(FDirectDraw,Image.width,Image.height,Colordepth);
         FImageList^[n].OnSurfaceLost := DoSurfaceLost;
         if assigned(Fimagelist^[n].Fsurface) then
         begin
            Fimagelist^[n].canvas.Draw(0,0,image.graphic);
            Fimagelist^[n].canvas.release;
         end;
         {TempImage.Free;}
         FImageList^[n].TransparentColor := RGB(0,0,0);
      end;
   end;

   //If in window mode and using normal palette -- draw the images to the
   //surface's canvas
   If FPaletteMode = pmNormal then
   for n := 0 to Lib.ImageCount - 1 do
   begin
      With FImageList[n].Canvas do
      begin
        picture:=lib.Images.items[n] as TDGCImageitem;
        stretchDraw(cliprect,Picture.image.graphic);
        Release;
      end;
   end;
end;


procedure TDGCScreen.SetImageLibrary(Lib: TDGCImageLib; UsePalette: Boolean);
var
   n: Integer;
   Pal: T256PaletteEntry;
   TempImage : TImage;
   SurfaceDC:HDC;
begin
   //Now assign library and create a palette
   FreeImageList;
   if Lib = nil then exit;
   if Lib.ImageCount = 0 then exit;
   FDGCImageLib := Lib;
   if (UsePalette) and (FColordepth = 8) then
   begin
      for n := 0 to 255 do
      begin
         with Lib.Images.Header.Palette[n] do
         begin
            Pal[n].peRed := Red;
            Pal[n].peGreen := Green;
            Pal[n].peBlue := Blue;
            Pal[n].peFlags := 0;
         end;
      end;
      SetPalette(Pal);
   end;

   //Allocate Memory for Surfaces List
   FreeImageList;

   //Create Surfaces for Objects
   FImageListCount := Lib.ImageCount;
   GetMem(FImageList, FImageListCount * SizeOf(TDGCSurface));
   for n := 0 to Lib.ImageCount - 1 do
   begin
      with Lib.Images.ImageData[n] do
      begin
         // major change in way surface image is created here
         // when using the original method the system crashes
         FImageList^[n] := TDGCSurface.Create(FDirectDraw, Width, Height,Colordepth);
         FImageList^[n].OnSurfaceLost := DoSurfaceLost;
         TempImage := TImage.Create(Self);
         TempImage.Width := Lib.Images.ImageData[n].Width;
         TempImage.Height := Lib.Images.ImageData[n].Height;
         Lib.DrawImage(TempImage.Canvas,0,0,n);
         if assigned(Fimagelist^[n].Fsurface) then
         begin
            Fimagelist^[n].canvas.Draw(0,0,Tempimage.Picture.Graphic);
            Fimagelist^[n].canvas.release;
         end;
         TempImage.Free;
         FImageList^[n].TransparentColor := RGB(0,0,0);
      end;
   end;

   //If in window mode and using normal palette -- draw the images to the
   //surface's canvas
   If FPaletteMode = pmNormal then
   for n := 0 to Lib.ImageCount - 1 do
   begin
      TempImage := TImage.Create(Self);
      TempImage.Width := Lib.Images.ImageData[n].Width;
      TempImage.Height := Lib.Images.ImageData[n].Height;
      Lib.DrawImage(TempImage.Canvas,0,0,n);
      With FImageList[n].Canvas do
      begin
        Draw(0,0,TempImage.Picture.Bitmap);
        Release;
      end;
      TempImage.Free;
   end;
   //If Image Library samples were loaded from file then
   //free them
   if FDGCImageLib.IsFileLibrary then
      FDGCImageLib.Images.FreeImages;
end;

procedure TDGCScreen.SetTileLibrary(Lib: TDGCImageLib; UsePalette: Boolean);
var
   n: Integer;
   Pal: T256PaletteEntry;
   TempImage : TImage;
   SurfaceDC:Hdc;
begin
   //Now assign library and create a palette
   FreeTileList;
   if Lib = nil then exit;
   if Lib.ImageCount = 0 then exit;
   FDGCTileLib := Lib;
   if (UsePalette) and (FColordepth = 8) then
   begin
      for n := 0 to 255 do
      begin
         with Lib.Images.Header.Palette[n] do
         begin
            Pal[n].peRed := Red;
            Pal[n].peGreen := Green;
            Pal[n].peBlue := Blue;
            Pal[n].peFlags := 0;
         end;
      end;
      SetPalette(Pal);
   end;

   //Allocate Memory for Surfaces List
   FreeTileList;

   //Create Surfaces for Objects
   FTileListCount := Lib.ImageCount;
   GetMem(FTileList, FTileListCount * SizeOf(TDGCSurface));
   for n := 0 to Lib.ImageCount - 1 do
   begin
      with Lib.Images.ImageData[n] do
      begin
         FTileList^[n] := TDGCSurface.Create(FDirectDraw, Width, Height,Colordepth);
         FTileList^[n].OnSurfaceLost := DoSurfaceLost;
         TempImage := TImage.Create(Self);
         TempImage.Width := Lib.Images.ImageData[n].Width;
         TempImage.Height := Lib.Images.ImageData[n].Height;
         Lib.DrawImage(TempImage.Canvas,0,0,n);
         if assigned(FTilelist^[n].Fsurface) then
         begin
            FTilelist^[n].canvas.Draw(0,0,Tempimage.Picture.Graphic);
            FTilelist^[n].canvas.release;
         end;
         TempImage.Free;
         FTileList^[n].TransparentColor := RGB(0,0,0);
         FTileList^[n].ClipRect := rect(0,0,width,height);
      end;
   end;
   //If in window mode and using normal palette -- draw the images to the
   //surface's canvas
   If FPaletteMode = pmNormal then
   for n := 0 to Lib.ImageCount - 1 do
   begin
      TempImage := TImage.Create(Self);
      TempImage.Width := Lib.Images.ImageData[n].Width;
      TempImage.Height := Lib.Images.ImageData[n].Height;
      Lib.DrawImage(TempImage.Canvas,0,0,n);
      With FTileList[n].Canvas do
      begin
        Draw(0,0,TempImage.Picture.Bitmap);
        Release;
      end;
      TempImage.Free;
   end;
   //If Image Library samples were loaded from file then
   //free them
   if FDGCTileLib.IsFileLibrary then
      FDGCTileLib.Images.FreeImages;
end;

function TDGCScreen.GetImage(Index: Integer): TDGCSurface;
begin
   if FImageList = nil then
      raise EDGCScreen.Create('A library must be set with SetImageLibrary');
   Result := FImageList^[Index];
end;

function TDGCScreen.GetTile(Index: Integer): TDGCSurface;
begin
   if FTileList = nil then
      raise EDGCScreen.Create('A tile library must be set with SetTileLibrary');
   Result := FTileList^[Index];
end;

procedure TDGCScreen.FreeImageList;
var
   n: Integer;
begin
   if FImageList = nil then exit;
   //Free Surface variables
   for n := 0 to FImageListCount - 1 do
       FImageList^[n].Free;
   //Free List
   FreeMem(FImageList, FImageListCount * SizeOf(TDGCSurface));
   FImageList := nil;
end;

procedure TDGCScreen.FreeTileList;
var
   n: Integer;
begin
   if FTileList = nil then exit;
   //Free Surface variables
   for n := 0 to FTileListCount - 1 do
       FTileList^[n].Free;
   //Free List
   FreeMem(FTileList, FTileListCount * SizeOf(TDGCSurface));
   FTileList := nil;
end;

procedure TDGCScreen.DoSurfaceLost(Surface: TDGCSurface);
begin
   RestoreSurfaces;
end;

procedure TDGCScreen.RestoreSurfaces;
var
   r: HResult;
begin
   r := FFront.Surface._Restore;
   if r <> DD_OK then
   begin
      case r of
        DDERR_WRONGMODE: TraceString('Restore Failed: Wrong Mode');
        DDERR_INVALIDOBJECT: TraceString('Restore Failed: Invalid Object');
        DDERR_NOEXCLUSIVEMODE: TraceString('Restore Failed: No Exclusive');
        DDERR_GENERIC: TraceString('Restore Failed: Generic');
      else
        TraceString('Restore Failed: UnKnown');
      end;
      raise EDGCScreen.Create('RestoreSurfaces Failed (Front)');
   end;
   if FDGCImageLib <> nil then
   begin
      if FDGCImageLib.IsFileLibrary then
         FDGCImageLib.ReLoadFromFile;
           SetImageLibrary(FDGCImageLib, True);
   end;

   if FDGCTileLib <> nil then
   begin
      if FDGCTileLib.IsFileLibrary then
         FDGCTileLib.ReLoadFromFile;
           SetTileLibrary(FDGCTileLib, True);
   end;
   //if Assigned(FOnPaint) then
   //   FOnPaint(Self);
end;

procedure TDGCScreen.StartTimer;
begin
   Application.OnIdle := AppIdle;
end;

procedure TDGCScreen.StopTimer;
begin
   Application.OnIdle := nil;
end;

procedure TDGCScreen.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
   inherited Notification(AComponent, Operation);
   if (Operation = opRemove) and not (csDestroying in ComponentState) then
   begin
      if FImageLib = AComponent then
         FImageLib := nil;
      If FTileLib  = AComponent then
         FTileLib  := Nil;
      if FHiColorlib = Acomponent then
         Fhicolorlib:=Nil;
      if FBackground = Acomponent then
         Fbackground :=nil;
      if FDGCDirectInput = Acomponent then
         FDGCDirectInput :=nil;
   end;
end;

function TDGCScreen.GetClipRect: TRect;
begin
   Result := FFront.ClipRect;
end;

procedure TDGCScreen.SetClipRect(NewVal: TRect);
begin
   FFront.ClipRect := NewVal;
   FBack.ClipRect := NewVal;
end;

procedure TDGCScreen.CreateDefaultPalette;
var
   n: Integer;
   Palette: T256PaletteEntry;
   Handle: hWnd;
   dc: HDC;
begin
   //Create Random Colors for non system colors
   if (fcolordepth <> 8) then exit;
   for n := 10 to 245 do
   begin
      with Palette[n] do
      begin
         peRed := Random(255);
         peGreen := Random(255);
         peBlue := Random(255);
         peFlags := 0;
      end;
   end;
   Handle := GetFocus;
   dc := GetDC(Handle);
   If FPaletteMode = pmNormal then
   begin
     GetSystemPaletteEntries(dc, 0, 255, Palette[0]);
   end
   else
   begin
     GetSystemPaletteEntries(dc, 0, 10, Palette[0]);
     GetSystemPaletteEntries(dc,246, 10, Palette[246]);
   end;

   ReleaseDC(Handle, dc);

   SetPalette(Palette);
end;

procedure TDGCScreen.FlipScroll(XSpeed, YSpeed: Integer);
var
   nsh, nsw : Integer;
   FromSurface, ToSurface: TDGCSurface;
   x, y, xp, yp: Integer;
begin
   //Create Surfaces
   try
      FromSurface := TDGCSurface.Create(DirectDraw4, FFront.Width, FFront.Height,Colordepth);
      try
         ToSurface := TDGCSurface.Create(DirectDraw4, FFront.Width, FFront.Height,Colordepth);
      except
         FromSurface.Free;
         exit;
      end;
   except
      raise;
      exit;
   end;
   //DO the Flip - First take a copy of the front and back buffers
   try
      FromSurface.Draw(0, 0, FFront, False);
      ToSurface.Draw(0,0, FBack, False);
      FBack.Erase(0);
      if YSpeed <> 0 then
         nsh := (FromSurface.Height div Abs(YSpeed)) - 1
      else
         nsh := 0;
      if XSpeed <> 0 then
         nsw := (FromSurface.Width div Abs(XSpeed)) - 1
      else
         nsw := 0;
      xp := 0;
      yp := 0;
      if YSpeed = 0 then
         y := 0
      else if YSpeed > 0 then
         y := ToSurface.Height
      else
         y := -ToSurface.Height;
      if XSpeed = 0 then
         x := 0
      else if XSpeed > 0 then
         x := ToSurface.Width
      else
         x := -ToSurface.Width;
      while (nsw > 0) or (nsh > 0) do
      begin
         if nsh > 0 then
            Inc(yp, YSpeed);
         if nsw > 0 then
            Inc(xp, XSpeed);
         FBack.Draw(0 - xp, 0 - yp, FromSurface, False);
         FBack.Draw(x - xp, y - yp, ToSurface, False);
         Flip;
         Dec(nsw);
         Dec(nsh);
      end;
      FBack.Draw(0, 0, ToSurface, False);
      Flip;
   finally
      FromSurface.Free;
      ToSurface.Free;
   end;
end;

procedure TDGCScreen.SaveAsBitmap(Surface: TDGCSurface; FileName: String);
var
   BmpInfo: PBitmapInfo;
   HeaderSize: Integer;
   Bmp: TBitmap;
   palette : array[0..255] of TPaletteEntry;
   n : integer;
   Col : TPaletteEntry;
   SurfaceDesc: TDDSurfaceDesc2;
   r:trect;
begin

   Bmp := TBitmap.Create;

//   ImgHdr := Images.ImageData[idx];
   HeaderSize := SizeOf(TBitmapInfo) + (256 * SizeOf(TRGBQuad));
   BmpInfo := AllocMem(HeaderSize);
   //First Get Colours
   FPalette.GetEntries(0,0,256,@Palette[0]);
   // start at 1 as index is for transparency
   for n := 0 to 255 do
   begin
       Col := Palette[n];
       with BmpInfo^.bmiColors[n] do
       begin
            rgbRed := Col.peRed;
            rgbGreen := Col.peGreen;
            rgbBlue := Col.peBlue;
       end;
   end;

//   Palette := Images.Header.Palette;
//   ImgLibPalToBmpInfo(Palette, BmpInfo);

   with BmpInfo^.bmiHeader do
   begin
      biSize := SizeOf(TBitmapInfoHeader);
      biWidth := Surface.FWidth;
      biHeight := -Surface.Height;
      biPlanes := 1;
      biBitCount := 8; //always convert to 8 bit image
      biCompression := BI_RGB;
      biClrUsed := 0;
      biClrImportant := 0;
   end;
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc) ;
   r:=Rect(0, 0, Surface.Width, Surface.Height);

   if Surface.Surface.Lock(@r, SurfaceDesc, DDLOCK_SURFACEMEMORYPTR +
            DDLOCK_WAIT, 0) <> DD_OK then exit;
   CreateDIB256(Bmp, BmpInfo, SurfaceDesc.lpSurface);
   Surface.Surface.UnLock(SurfaceDesc.lpSurface);
   Bmp.SaveToFile(FileName);
   FreeMem(BmpInfo, HeaderSize);
   Bmp.Free;
end;

// Note: This routine was trown together rather rapidly so I haven't   *
//       had a chance to check it for bugs!!!                          *
procedure TDGCScreen.SetKeyColor(Image : TDGCSurface; X,Y : Integer);
var
   SurfaceDesc: TDDSurfaceDesc2;
   ColorVal : TColor;
   ColorKey: TDDColorKey ;
   r:trect;
begin
   ColorVal := 0;
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc) ;
   r:=Rect(x, y, x, y);
   if Image.Surface.Lock(@r, SurfaceDesc, DDLOCK_SURFACEMEMORYPTR +
            DDLOCK_WAIT, 0) <> DD_OK then exit;
   With Image.Canvas do
   begin
      Case FColorDepth of
        8:  ColorVal := PByte(SurfaceDesc.lpSurface)^;
        16: ColorVal := PWord(SurfaceDesc.lpSurface)^;
        24: ColorVal := PDWord(SurfaceDesc.lpSurface)^;
      end;
      Release;
   end;
   Image.Surface.UnLock(SurfaceDesc.lpSurface);

   ColorKey.dwColorSpaceLowValue := ColorVal;
   ColorKey.dwColorSpaceHighValue := ColorVal;
   if Image.Surface.SetColorKey(DDCKEY_SRCBLT, @ColorKey) <> DD_OK then
      Raise EDGCSurface.Create('SetColorKey failed') ;
end;


end.
