{The Delpi Games Creator - Beta 7
 --------------------------------
 Copyright 1996,1997,1998,1999 John Pullen, Paul Bearne, Jeff Kurtz

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.
}

{Revision History
 ----------------
Beta 1
 24-Jun-99 : Paul Created TDGCMidi Thanks to Dean and members of the Jedi project for fixing the GetObject Problem
             Note for some reason CoUnitialize cause a GP fault on My PIII 550 if called directly
}
unit dgcmidi;

interface

uses
  Windows, Messages,DGCSnd,Activex,Dmusic,DXtools, DsgnIntf,SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  // image collection items

  TDGCMidi = class(TComponent)
  private
    { Private declarations }
    FPerformance:IDirectMusicPerformance;
    FDGCSound:TDGCAudio;
    FMusic:IDirectMusic;
    Floader:IDirectMusicLoader;
    FMusicSegment:IDirectMusicSegment;
    FMusicObjDesc:TDMUS_OBJECTDESC;
    FSegState:IDirectMusicSegmentState;
    FElementName:string;
    FRepeats:Cardinal;
    FStartpoint:Integer;
    Fduration:Integer;
    // startpoint props in seconds these used to hold millisecond value
    FactDuration:Integer;
    FactStartPoint:Integer;
    Fversion:string;
  protected
           procedure Setrepeats(Value:Cardinal);
           procedure SetDuration(Value:integer);
           procedure SetStartpoint(Value:Integer);
           function GetPlaying:Boolean;

  public
    { Public declarations }
    // need to initilialize com
    constructor Create(Aowner:tcomponent);override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    // Initialize the Interface
    procedure Init;
    // Destructor needs to close down com
    destructor Destroy;override;
    // Load A segment
    procedure LoadMidi;
    // Play the loaded segment
    procedure Play;
    // Stop the segment
    procedure Stop;
    // is the music segment playing
    // will change this to An Event Later
    property Isplaying:Boolean read Getplaying;
  published
    { Published declarations }
    property FileName:string read FElementName write FElementname;
    property DGCSound:TDGCAudio read FDGCSound write Fdgcsound;
    property Repeats:Cardinal read Frepeats write SetRepeats;
    property Duration:integer read FDuration write SetDuration;
    property StartPoint:integer read FStartPoint write SetStartPoint;
    property Version:string read Fversion write Fversion;
  end;

  TFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

{procedure Register;}

implementation

procedure TFilenameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.create(Application);
  try
    FileOpen.Options:=[ofHideReadOnly,ofEnableSizing,ofPathMustExist,ofFileMustexist];
    FileOpen.DefaultExt:='mid';
    Fileopen.Filter:='Standard Midi Files | *.mid';
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

// TDGCMidi Component
constructor TDGCMidi.Create(Aowner:Tcomponent);
begin
     inherited Create(aowner);
     // initialize com
     CoInitialize(nil);
     Fperformance := Nil;
     FMusic := nil;
     FDGCSound := nil;
     FMusicSegment := nil;
     FLoader := nil;
     Fversion:='1.0';
end;

procedure TDGCMidi.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
   inherited Notification(AComponent, Operation);
   if (Operation = opRemove) and not (csDestroying in ComponentState) then
   begin
      if FDGCSound = AComponent then
         FDGCSound := nil;
   end;
end;

// duration in seconds so convert to Milli seconds
procedure TDGCMidi.SetDuration(Value:Integer);
begin
     If FDuration <> Value then
          FDuration := Value;
     FactDuration:=FDuration*1000;
end;

procedure TDGCMidi.SetStartpoint(Value:Integer);
begin
     if FStartPoint <> Value then
          FStartpoint := Value;
     FactStartpoint := FStartpoint *1000;
end;

function TDGCMidi.GetPlaying:Boolean;
begin
     Result := (Fperformance.Isplaying(FMusicSegment,FSegState) = S_OK);
end;

procedure TDGCMidi.SetRepeats(Value:Cardinal);
begin
     if Frepeats <> Value then
        FRepeats := Value;
end;

Procedure TDGCMidi.Init;
begin
     // see if we have a performance if not create one
     if Fperformance = nil then
        CoCreateInstance(CLSID_DirectMusicPerformance,nil,CLSCTX_INPROC,IID_IDirectMusicperformance,FPerformance);
     // has dgc sound component been added
     // if so then init performance using it's Dsound interface
     // if not let Dmusic Create Dsound interface
     if FPerformance = nil then
        raise Exception.Create('Failed to Create Direct music Performance');
     if FDGCSound <> nil then
        DXCheck(FPerformance.Init(FMusic,FDGCSound.directSound,0))
     else
         DXCheck(FPerformance.Init(FMusic,nil,0));
     // now add the default midi port
     // needs a bit more what if there is no default port set
     DXCheck(Fperformance.Addport(nil));
     // Create the loader
     CoCreateInstance(CLSID_DirectMusicLoader,nil,CLSCTX_Inproc,IID_IDirectMusicLoader,FLoader);
end;

// load the midi file
procedure TDGCMidi.Loadmidi;
var
   MidiFilelength:Integer;
begin
    // if we have a segment destroy it
    if FMusicSegment <> nil then
       FMusicSegment := nil;
    Zeromemory(@FMusicObjDesc,SizeOf(TDMUS_OBJECTDESC));
    // set the object desc parameters
    with FMusicObjDesc do
    begin
         dwsize := SizeOf(TDMUS_OBJECTDESC);
         guidclass := CLSID_DirectMusicSegment;
         StringtoWidechar(FelementName,wszFileName,SizeOf(wszFilename));
         dwvaliddata := DMUS_OBJ_CLASS or DMUS_OBJ_FULLPATH or DMUS_OBJ_FILENAME;
    end;
    dxcheck(FLoader.GetObject(FMusicObjDesc,IID_IDirectMusicSegment,Pointer(FMusicSegment)));
    dxcheck(FMusicSegment.setParam(GUID_StandardMidiFile,$FFFFFFFF,0,0,Pointer(FPerformance)));
    dxcheck(FMusicSegment.setParam(GUID_Download,$FFFFFFFF,0,0,Pointer(FPerformance)));
    Fmusicsegment.GetLength(MidiFilelength);
    if (FactDuration <  MidiFilelength) and (Factduration > 0) then
       Fmusicsegment.SetLength(FactDuration);
    if factstartpoint < MidiFilelength - FactDuration then
       FMusicSegment.SetStartpoint(FactStartpoint);
    // repeats is number of times to play it after finishing the first
    FMusicSegment.Setrepeats(repeats-1);
end;

// PLay The midi Segment
procedure TDGCMidi.Play;
begin
     if Fperformance <> nil then
        FPerformance.PlaySegment(FMusicSegment,0,0,@FSegState);
end;

procedure TDGCMidi.Stop;
begin
    if Fperformance <> nil then
       FPerformance.Stop(nil,nil,0,0);
end;

destructor TDGCMidi.Destroy;
begin
     if FMusicSegment <> nil then
        FMusicSegment.SetParam(GUID_UNLoad,$FFFFFFFF,0,0,Pointer(Fperformance));
     FMusicsegment:=nil;
     if Fperformance <> nil then
        Fperformance.Closedown;
     Fperformance := nil;
     Floader:=nil;
     FMusic:=nil;
     inherited destroy;
end;

{procedure Register;
begin
  RegisterComponents('DGC', [TDGCMidi]);
  RegisterPropertyEditor(TypeInfo(string), TDGCMidi, 'Filename', TFilenameProperty);
end;}

end.
