{The Delpi Games Creator - Beta 6
 --------------------------------
 Copyright 1996,1997 John Pullen, Paul Bearne, Jeff Kurtz

 This unit is part of the freeware Delphi Games Creator. This unit is
 completely free to use for personal or commercial use. The code is
 supplied with no guarantees on performance or stabilibty and must be
 used at your own risk.

20-Jun-97 Jeff : Fixed boundary clippings

}
unit DGCStar;

interface

uses
  Windows, Messages, SysUtils, Classes,
   Graphics, Controls, Forms, Dialogs, DGC, DDraw, BMPUtil,trace;

const
     MaxStars = 10000;
type

  TStar = Record
        X     : Integer;
        Y     : Integer;
        Z     : Integer;
        OldX  : Integer;
        OldY  : Integer;
        Color : Tcolor;
  end;

  TStarMode = (Horizontal, Vertical, ThreeD);

  TDGCStarField = class(TComponent)
  private
    { Private declarations }
    FScreen:TDGCScreen;
    FStars:Array[1.. MaxStars] of TStar;
    FNumOfStars:Integer;
    FStarVelocity:Integer;
    FTowards  : Boolean;
    FWidth    : Integer;
    FLWidth   : Integer;
    FHeight   : Integer;
    FCenterX  : Integer;
    FCenterY  : Integer;
    FFlashing : Boolean;
    FErase    : Boolean;
    FColored  : Boolean;

    FLeft     : Integer;
    FRight    : Integer;
    FTop      : Integer;
    FBottom   : Integer;
    FStarMode : TStarMode;
    FVersion  : String;
    NVersion  : String;
  protected
    { Protected declarations }
    Procedure SetNumOfstars(value:Integer);
    Procedure Calc2Dposition;
    Procedure ClearStars;
    Procedure CreateStars;
    Procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    { Public declarations }
    Constructor Create(Aowner:Tcomponent);Override;
    Procedure Update;
    Procedure Generate;
  published
    { Published declarations }
    Property NumberOfStars:Integer read FNumofStars write FNumofStars;
    Property Velocity   : Integer    read FStarVelocity write FStarVelocity;
    Property Towards    : Boolean    read FTowards  Write FTowards;
    Property DGCScreen  : TDGCScreen Read FScreen   Write FScreen;
    Property CenterX    : Integer    Read FCenterX  Write FCenterX;
    Property CenterY    : Integer    Read FCenterY  Write FCenterY;
    Property Flashing   : Boolean    Read FFlashing Write FFlashing;
    Property Erase      : Boolean    Read FErase    Write FErase;
    Property Colored    : Boolean    Read FColored  Write FColored;
    Property EdgeLeft   : Integer    Read FLeft     Write FLeft;
    Property EdgeRight  : Integer    Read FRight    Write FRight;
    Property EdgeTop    : Integer    Read FTop      Write FTop;
    Property EdgeBottom : Integer    Read FBottom   Write FBottom;
    Property StarMode   : TStarMode  Read FStarMode Write FStarMode;
    Property Version    : String     Read FVersion  Write NVersion;
  end;

procedure Register;

implementation
Constructor TDGCStarField.Create(Aowner:Tcomponent);
begin
     Inherited create(Aowner);
     Fnumofstars   :=200;
     FScreen       :=nil;
     FStarVelocity :=2;
     FTowards      := True;
     FCenterX      := 9999;
     FCenterY      := 9999;
     FErase        := True;
     FTop          := 0;
     FLeft         := 0;
     FRight        := 9999;
     FBottom       := 9999;
     FStarMode     := ThreeD;
     FVersion      := 'DGC Beta 6';
end;

Procedure TDGCStarField.Generate;
begin
  FLWidth := FScreen.Back.WidthBytes;
  FWidth  := FScreen.Back.Width;
  FHeight := FScreen.Back.Height;
  If FWidth  < FRight  then FRight  := FWidth;
  If FHeight < FBottom then FBottom := Fheight;
  If FLeft   < 0 then FLeft   := 0;
  If FTop    < 0 then FTop    := 0;
  If FRight  < 0 then FRight  := 0;
  If FBottom < 0 then FBottom := 0;
  If FCenterX = 9999 then FCenterX := FWidth  Div 2;
  If FCenterY = 9999 Then FCenterY := FHeight Div 2;
  CreateStars;
  Calc2DPosition;
end;

Procedure TDGCStarField.CreateStars;
var
   i:integer;
begin
   Randomize;
   for i:= 1 to FNumOfStars do
   begin
     Case FStarMode of
     ThreeD:
      begin
        FStars[i].X     := Random(FWidth ) - FWidth  div 2;
        FStars[i].Y     := Random(FHeight) - FHeight div 2;
        FStars[i].Z     := Random(255);
        FStars[i].Color := RGB(Random(255),random(255),Random(255));
      end;
     Horizontal:
      begin
        FStars[i].X := Random(FWidth);
        FStars[i].Y := Random(FBottom-FTop)+FTop;
        FStars[i].z := Random(255);
        If Not FColored then
        begin
          Fstars[i].color:=clsilver;
          {Case FStars[i].Z of
            001..050 : FStars[i].Color := clwhite;
            051..100 : FStars[i].Color := 243;
            101..150 : FStars[i].Color := 242;
            151..200 : FStars[i].Color := 241;
            201..255 : FStars[i].Color := 240;
          end; //end case FStars}
        end
        else
          FStars[i].Color := RGB(Random(255),Random(255),Random(255));
      end;
     Vertical:
      begin
        FStars[i].X := Random(FRight-FLeft)+FLeft;
        FStars[i].Y := Random(FHeight);
        FStars[i].z := Random(255);
        If Not FColored then
        begin
          Fstars[i].color:=clsilver;
          {Case FStars[i].Z of
            001..050 : FStars[i].Color := 244;
            051..100 : FStars[i].Color := 243;
            101..150 : FStars[i].Color := 242;
            151..200 : FStars[i].Color := 241;
            201..255 : FStars[i].Color := 240;
          end; //end case FStars}
        end
        else
          FStars[i].Color := RGB(Random(255),random(255),Random(255));
      end;
     end; //end case
   end;
end;

Procedure TDGCStarField.Calc2DPosition;
var
   I    : Integer;
   NewX : Integer;
   NewY : Integer;
   SurfaceDesc: TDDSurfaceDesc2;
   R:TRect;
begin
   SurfaceDesc.dwSize := SizeOf(TDDSurfaceDesc2) ;
   r:=Rect(0, 0, FWidth, FHeight);
   if FScreen.Back.Surface.Lock(@r,
      SurfaceDesc, DDLOCK_SURFACEMEMORYPTR + DDLOCK_WAIT, 0) <> DD_OK then Exit;
   Case FStarMode of
   ThreeD:
   begin
    for i:= 1 to FNumofStars do
    begin
      if (FStars[i].Z > 0) and (FStars[i].Z < 256) then
      begin
        NewX:=((FStars[i].X shl 7) div FStars[i].Z)+(FCenterX);
        NewY:=((FStars[i].Y shl 7) div FStars[i].Z)+(FCenterY);
        If (NewX>FLeft) and (NewX<FRight) and (NewY>FTop) and (NewY<FBottom) then
        begin
          If Not FColored then
             If FFlashing then
                FStars[i].Color := RGB(Random(255),Random(255),Random(255))
             else
               Fstars[i].color:=clsilver;
             Case FScreen.Colordepth of
             16 :PDWord(integer(SurfaceDesc.lpSurface)+Surfacedesc.lpitch*newY + newX*2)^ :=
                 (LoByte(LoWord(Fstars[i].Color)) shr 3 shl 11) or   // Red
                 (HiByte(LoWord(Fstars[i].Color)) shr 2 shl 5) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)) shr 3);            // Blue
             24 :PDword(DWord(SurfaceDesc.lpSurface)+surfacedesc.lpitch*newY + newX*3)^:=
                 (LoByte(LoWord(Fstars[i].Color)) shl 16) or   // Red
                 (HiByte(LoWord(Fstars[i].Color)) shl 8) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)));            // Blue}
             32 :PDword(DWord(SurfaceDesc.lpSurface)+(surfacedesc.lpitch*newY) + (newX*4))^:=
                 (LoByte(LoWord(Fstars[i].Color)) shl 16) or   // Red
                 (HiByte(Longword(Fstars[i].Color)) shl 8) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)));            // Blue
             end;
          FStars[i].OldX := NewX;
          FStars[i].OldY := NewY;
          If FTowards then
             Dec(FStars[i].Z, FStarVelocity)
          else
             Inc(FStars[i].Z, FStarVelocity);
        end
        else
        begin
          FStars[i].X := Random(FWidth ) - FWidth  div 2;
          FStars[i].Y := Random(FHeight) - FHeight div 2;
          FStars[i].Color := RGB(Random(255),Random(255),Random(255));
          If Towards then
             FStars[i].Z := 255
          else
            FStars[i].Z := Random(255);
        end;   //end If NewX
     end
     else
     begin
       FStars[i].X := Random(FWidth ) - FWidth  div 2;
       FStars[i].Y := Random(FHeight) - FHeight div 2;
       FStars[i].Color := RGB(Random(255),random(255),Random(255));
       If Towards then
          FStars[i].Z := 255
       else
          FStars[i].Z := Random(255);
     end;      //end if FStar
   end;        //end For
  end;         //end of ThreeD
  Horizontal:
  begin
    for i := 1 to FNumOfStars do
    begin
      If FFlashing and not FColored then
         FStars[i].Color := RGB(Random(255),Random(255),Random(255));
      If FTowards then
      begin
       Case FStars[i].Z of
         000..050 : Dec(FStars[i].X,4 + Velocity);
         051..100 : Dec(FStars[i].X,3 + Velocity);
         101..150 : Dec(FStars[i].X,2 + Velocity);
         151..200 : Dec(FStars[i].X,1 + Velocity);
         201..260 : Dec(FStars[i].X,0 + Velocity);
       end; //end case FStars
       If FStars[i].X < FLeft then
       begin
         FStars[i].X := FRight + Random(50);
         FStars[i].Y := Random(FBottom-FTop)+FTop;
         FStars[i].z := Random(255);
         If Not FColored then
         begin
           Fstars[i].color:=Clsilver;
         end
         else
           FStars[i].Color := RGB(Random(255),random(255),Random(255));

       end;
      end;

      If Not FTowards then
      begin
       Case FStars[i].Z of
         000..050 : Inc(FStars[i].X,4 + Velocity);
         051..100 : Inc(FStars[i].X,3 + Velocity);
         101..150 : Inc(FStars[i].X,2 + Velocity);
         151..200 : Inc(FStars[i].X,1 + Velocity);
         201..260 : Inc(FStars[i].X,0 + Velocity);
       end; //end case FStars
       If FStars[i].X > FRight then
       begin
         FStars[i].X := FLeft - Random(50);
         FStars[i].Y := Random(FBottom-FTop)+FTop;
         FStars[i].z := Random(255);
         If Not FColored then
         begin
           Fstars[i].color:=clsilver;
         end
         else
           FStars[i].Color := RGB(Random(255),Random(255),random(255));
       end;
      end; //end if FTowards

      If (FStars[i].X>FLeft) and (FStars[i].X<FRight) and
         (FStars[i].Y>FTop)  and (FStars[i].Y<FBottom) then
      begin
           Case FScreen.Colordepth of
             16 :PDWord(integer(SurfaceDesc.lpSurface)+Surfacedesc.lpitch*Fstars[i].Y + Fstars[i].X*2)^ :=
                 (LoByte(LoWord(Fstars[i].Color)) shr 3 shl 11) or   // Red
                 (HiByte(LoWord(Fstars[i].Color)) shr 2 shl 5) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)) shr 3);            // Blue
             24 :PDword(DWord(SurfaceDesc.lpSurface)+surfacedesc.lpitch*Fstars[i].Y + Fstars[i].X*3)^:=
                 (LoByte(LoWord(Fstars[i].Color)) shl 16) or   // Red
                 (HiByte(LoWord(Fstars[i].Color)) shl 8) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)));            // Blue}
             32 :PDword(DWord(SurfaceDesc.lpSurface)+(surfacedesc.lpitch*Fstars[i].Y) + (Fstars[i].X*4))^:=
                 (LoByte(LoWord(Fstars[i].Color)) shl 16) or   // Red
                 (HiByte(Longword(Fstars[i].Color)) shl 8) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)));            // Blue
            end;
      end;
    end;  //end for
  end;    //end of Horizontal
  Vertical:
  begin
    for i := 1 to FNumOfStars do
    begin
      If FFlashing and not FColored then
         FStars[i].Color := Random(255);
      If FTowards then
      begin
       Case FStars[i].Z of
         000..050 : Dec(FStars[i].Y,4 + Velocity);
         051..100 : Dec(FStars[i].Y,3 + Velocity);
         101..150 : Dec(FStars[i].Y,2 + Velocity);
         151..200 : Dec(FStars[i].Y,1 + Velocity);
         201..260 : Dec(FStars[i].Y,0 + Velocity);
       end; //end case FStars
       If FStars[i].Y < FTop then
       begin
         FStars[i].X := Random(FRight-FLeft)+FLeft;
         FStars[i].Y := FBottom + Random(20);
         FStars[i].z := Random(255);
         If Not FColored then
         begin
           Fstars[i].color:=clsilver;
         end
         else
           FStars[i].Color := RGB(Random(255),random(255),random(255));
       end;
      end;

      If Not FTowards then
      begin
       Case FStars[i].Z of
         000..050 : Inc(FStars[i].Y,4 + Velocity);
         051..100 : Inc(FStars[i].Y,3 + Velocity);
         101..150 : Inc(FStars[i].Y,2 + Velocity);
         151..200 : Inc(FStars[i].Y,1 + Velocity);
         201..260 : Inc(FStars[i].Y,0 + Velocity);
       else
         Inc(FStars[i].Y,1);
       end; //end case FStars
       If FStars[i].Y > FBottom then
       begin
         FStars[i].X := Random(FRight-FLeft)+FLeft;
         FStars[i].Y := FTop - Random(20);
         FStars[i].z := Random(255);
         If Not FColored then
         begin
           Fstars[i].color:=clsilver;
         end
         else
           FStars[i].Color := RGB(random(255),random(255),Random(255));
       end;

      end; //end if FTowards

      If (FStars[i].X>FLeft) and (FStars[i].X<FRight) and
         (FStars[i].Y>FTop)  and (FStars[i].Y<FBottom) then
         begin
          Case FScreen.Colordepth of
             16 :PDWord(integer(SurfaceDesc.lpSurface)+Surfacedesc.lpitch*Fstars[i].Y + Fstars[i].X*2)^ :=
                 (LoByte(LoWord(Fstars[i].Color)) shr 3 shl 11) or   // Red
                 (HiByte(LoWord(Fstars[i].Color)) shr 2 shl 5) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)) shr 3);            // Blue
             24 :PDword(DWord(SurfaceDesc.lpSurface)+surfacedesc.lpitch*Fstars[i].Y + Fstars[i].X*3)^:=
                 (LoByte(LoWord(Fstars[i].Color)) shl 16) or   // Red
                 (HiByte(LoWord(Fstars[i].Color)) shl 8) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)));            // Blue}
             32 :PDword(DWord(SurfaceDesc.lpSurface)+(surfacedesc.lpitch*Fstars[i].Y) + (Fstars[i].X*4))^:=
                 (LoByte(LoWord(Fstars[i].Color)) shl 16) or   // Red
                 (HiByte(Longword(Fstars[i].Color)) shl 8) or    // Green
                 (LoByte(HiWord(Fstars[i].Color)));            // Blue
            end;
       end;
     end;  //end for
    end;         //end of Vertical
   end;         //end of Case
   FScreen.Back.Surface.Unlock(@r);
end;

Procedure TDGCStarField.ClearStars;
begin
    FScreen.Back.EraseRect(Rect(EdgeLeft, EdgeTop, EdgeRight, EdgeBottom),0);
end;

Procedure TDGCStarField.Update;
begin
    If FErase then ClearStars;
    Calc2dPosition;
end;

Procedure TDGCStarField.SetNumofStars(value:Integer);
begin
     if (value <> FNumofstars) then
     begin
          if value > 10000 then
             value:=10000;
          FNumofstars:=Value;
          if Fscreen <> nil then
             CreateStars;
     end;
end;

procedure TDGCStarField.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and not (csDestroying in ComponentState) then
  begin
       if FScreen = AComponent then
          FScreen := nil;
  end;
end;

procedure Register;
begin
  RegisterComponents('DGC', [TDGCStarField]);
end;

end.
