unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtDlgs, DGC, Menus, ExtCtrls, Buttons, ImgList, ComCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Load1: TMenuItem;
    New1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Bitmap1: TMenuItem;
    Load2: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    DGCHiColorImagelib1: TDGCHiColorImagelib;
    Panel2: TPanel;
    Image1: TImage;
    Panel3: TPanel;
    ListBox1: TListBox;
    Panel4: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Edit1: TEdit;
    Label1: TLabel;
    ImageList1: TImageList;
    SaveAs1: TMenuItem;
    StatusBar1: TStatusBar;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;

    procedure Save1Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Load2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
    CurrentFilename:string;
    isdirty:Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Save1Click(Sender: TObject);
begin
    if currentfilename <> '' then
       DGCHicolorImagelib1.Savetofile(CurrentFileName)
    else
    begin
         if savedialog1.execute then
         begin
              DGCHicolorImagelib1.Savetofile(Savedialog1.FileName);
              Currentfilename:=Savedialog1.FileName;
              isdirty:=False;
         end;
    end;
end;

procedure TForm1.Load1Click(Sender: TObject);
var
   i:Integer;
begin
     if opendialog1.Execute then
     begin
          ListBox1.Items.Clear;
          DGCHicolorimagelib1.Loadfromfile(Opendialog1.FileName);
          for i:= 0 to DGCHIcolorImagelib1.Images.Count-1  do
          begin
               Listbox1.Items.Add((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Name);
               Image1.Picture:=((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Image);
          end;
          if Listbox1.Items.Count > 0 then
          begin
             Listbox1.ItemIndex:=0;
             Image1.Picture:=((DGCHIColorImagelib1.Images.Items[0] as TDGCImageItem).Image);
             Edit1.text:=((DGCHIColorImagelib1.Images.Items[0] as TDGCImageItem).Name);
          end;
          currentfilename:=OpenDialog1.FileName;
     end;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var
   i:Integer;
begin
     for i:= 0 to DGCHIcolorImagelib1.Images.Count-1  do
     begin
          if Listbox1.ItemIndex = -1 then Exit;
          if Listbox1.Items[listbox1.ItemIndex] = (DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Name then
          begin
             Image1.Picture:=((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Image);
             Edit1.text:=((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Name);
          end;
     end;
end;

procedure TForm1.Load2Click(Sender: TObject);
begin
    if OpenpictureDialog1.Execute then
    begin
         with (DGCHicolorImageLib1.Images.Add as TDGCImageItem) do
         begin
              Image.loadfromfile(OpenPictureDialog1.FileName);
              Name:=Format('Image%d',[DGCHIcolorImagelib1.Images.Count]);
              Listbox1.Items.Add(Name);
         end;
         if Listbox1.ItemIndex = -1 then Exit;
            Listbox1.ItemIndex:=listbox1.Items.Count-1;
         Image1.Picture:=((DGCHIColorImagelib1.Images.Items[Listbox1.Itemindex] as TDGCImageItem).Image);
         isdirty:=True;
    end;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
var
   i:integer;
   itempos:integer;
   TempCollection:TDGCcollection;
   ImageItem:TDGCImageItem;
begin
     if ListBox1.Items.Count > 0 then
     begin
          Tempcollection:=TDGCCollection.Create(TDGCImageItem);
          for i:= 0 to Listbox1.items.Count -1 do
          begin
               if Listbox1.Items[listbox1.ItemIndex] <> (DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Name then
               begin
                   ImageItem:=Tempcollection.Add as TDGCImageItem;
                   ImageItem.name:=TDGCImageItem(DGCHIColorImagelib1.Images.Items[i]).name;
                   Imageitem.Image:=TDGCImageItem(DGCHIColorImagelib1.Images.Items[i]).Image;
                   ListBox1.Items.Delete(i);
               end;
         end;
         DGCHicolorImagelib1.Images.Clear;
         listBox1.Items.Clear;
         for i:=0 to Tempcollection.Count - 1 do
         begin
              Imageitem:=DGCHicolorImageLib1.Images.Add as TDGCImageItem;
              Imageitem.name:=TDGCImageItem(TempCollection.Items[i]).name;
              Imageitem.Image:=TDGCImageItem(TempCollection.Items[i]).Image;
              Listbox1.Items.Add(Imageitem.Name);
         end;
         if Listbox1.Items.Count > 0 then
         begin
              ListBox1.ItemIndex := Listbox1.Items.Count -1;
              Image1.Picture:=TDGCImageItem(TempCollection.Items[listbox1.itemindex]).Image;
         end
         else
             Image1.Picture:=nil;
         isdirty:=True;
     end;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
     Listbox1.Items[ListBox1.ItemIndex]:=Edit1.Text;
     (DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex] as TDGCImageItem).Name:=Edit1.text;
     isdirty:=True;
end;

procedure TForm1.New1Click(Sender: TObject);
begin
      Listbox1.Items.Clear;
      DGCHIColorImagelib1.Images.Clear;
      Edit1.Text:='';
      Currentfilename:='';
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
var
   i:integer;
   Name:string;
   Image:Tpicture;
   itempos:integer;
begin
     if ListBox1.Items.Count > 0 then
     begin
          if Listbox1.ItemIndex < Listbox1.Items.Count-1 then
          begin
               itempos:=Listbox1.ItemIndex;
               Image:=TPicture.Create;
               name:=TDGCImageitem(DGCHIColorimagelib1.Images.Items[Listbox1.ItemIndex]).name;
               Image.assign(TDGCImageitem(DGCHIColorimagelib1.Images.Items[Listbox1.ItemIndex]).Image);
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.Itemindex]).Name:=TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex+1]).Name;
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.Itemindex]).Image:=TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex+1]).Image;
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex+1]).Name:=name;
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex+1]).Image.assign(Image);
               Listbox1.Items.Clear;
               for i:= 0 to DGCHIcolorImagelib1.Images.Count-1  do
               begin
                    Listbox1.Items.Add((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Name);
                    Image1.Picture:=((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Image);
               end;
               listbox1.ItemIndex:=itempos+1;
               Image1.Picture:=((DGCHIColorImagelib1.Images.Items[itempos+1] as TDGCImageItem).Image);
               Edit1.Text:=Listbox1.Items[Listbox1.ItemIndex];
               isdirty:=True;
          end;
     end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var
   i:integer;
   Name:string;
   Image:Tpicture;
   itempos:integer;
begin
     if ListBox1.Items.Count > 0 then
     begin
          if Listbox1.ItemIndex > 0 then
          begin
               itempos:=Listbox1.ItemIndex;
               Image:=TPicture.Create;
               name:=TDGCImageitem(DGCHIColorimagelib1.Images.Items[Listbox1.ItemIndex]).name;
               Image.assign(TDGCImageitem(DGCHIColorimagelib1.Images.Items[Listbox1.ItemIndex]).Image);
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.Itemindex]).Name:=TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex-1]).Name;
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.Itemindex]).Image:=TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex-1]).Image;
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex-1]).Name:=name;
               TDGCImageItem(DGCHIColorImagelib1.Images.Items[Listbox1.ItemIndex-1]).Image.assign(Image);
               Listbox1.Items.Clear;
               for i:= 0 to DGCHIcolorImagelib1.Images.Count-1  do
               begin
                    Listbox1.Items.Add((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Name);
                    Image1.Picture:=((DGCHIColorImagelib1.Images.Items[i] as TDGCImageItem).Image);
               end;
               listbox1.ItemIndex:=itempos-1;
               Image1.Picture:=((DGCHIColorImagelib1.Images.Items[itempos-1] as TDGCImageItem).Image);
               Edit1.Text:=Listbox1.Items[Listbox1.ItemIndex];
          end;
          isdirty:=True;
     end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     CurrentFilename:='';
     isdirty:=False;
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
     if savedialog1.execute then
     begin
          DGCHicolorImagelib1.Savetofile(Savedialog1.FileName);
          Currentfilename:=Savedialog1.FileName;
          isdirty:=False;
     end;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     if isdirty then
     begin
          if Messagedlg('You Have not saved the changes to the Image Library Save Changes ?',mtinformation,[mbyes,mbno],0) = mryes then
             save1click(Sender);
     end;
     canclose:=True;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
     Close;
end;

end.
