/*********************************
	Coder : Lim Young Il
	1999. 9.
	Tetris Game By Text Mode
*********************************/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

// Out Line Position
#define X1 5
#define Y1 2
#define X2 20
#define	Y2 23

// Key Function
#define LEFT 	75 	// Left Arrow Button
#define RIGHT 	77	// Right Arrow Button
#define DOWN 	80	// Down Arrow Button
#define ROTATE	72	// Up Arrow Button
#define DROP	32	// Space Bar Button
#define END		27	// ESC Button

char BType = 0;		// Block Type variable

int count = 0;

char *video;     // video memory pointer

int EndCheck;	// End check variable

int LevelCheck;		// Level Up check variable

int LeftLine = 10;

int LEVEL = 6000;	// Down Block Time variable

int Lcount = 1; 	// Level Counter

// seed variable
int seed1 = 11;
int seed2;
int seed3;

int multi1, multi2;

/********************************************
			Block Type Data
*********************************************/

char block[4][4] = { { 0, 0, 0, 0 },
					 { 0, 0, 0, 0 },
					 { 0, 0, 0, 0 },
					 { 0, 0, 0, 0 } };

char Initblock[4][4] = { { 0, 0, 0, 0 },
						 { 0, 0, 0, 0 },
						 { 0, 0, 0, 0 },
						 { 0, 0, 0, 0 } };

//----------------------------------------

char block1[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 1, 1, 1, 0 },
					  { 0, 0, 0, 0 } };

char block11[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block21[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 1, 0 },
					  { 0, 1, 0, 0 } };

char block31[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 0, 1, 0, 0 } };
//---------------------------------------
char block2[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 1, 0 } };

char block12[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 1, 0 },
					  { 1, 1, 1, 0 },
					  { 0, 0, 0, 0 } };

char block22[4][4] = { { 0, 0, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block32[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 1, 0 },
					  { 1, 0, 0, 0 } };
//---------------------------------------
char block3[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 1, 1, 0, 0 } };

char block13[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 1, 0 },
					  { 0, 0, 1, 0 } };

char block23[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block33[4][4] = { { 0, 0, 0, 0 },
					  { 1, 0, 0, 0 },
					  { 1, 1, 1, 0 },
					  { 0, 0, 0, 0 } };

//---------------------------------------
char block4[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 0, 1, 1, 0 } };

char block14[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 0, 1, 1, 0 } };

char block24[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 0, 1, 1, 0 } };

char block34[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 0, 1, 1, 0 } };
//---------------------------------------
char block5[4][4] = { { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block15[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 1, 1 },
					  { 0, 0, 0, 0 } };

char block25[4][4] = { { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block35[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 1, 1 },
					  { 0, 0, 0, 0 } };
//---------------------------------------
char block6[4][4] = { { 0, 0, 0, 0 },
					  { 1, 0, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block16[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 1, 1, 0, 0 } };

char block26[4][4] = { { 0, 0, 0, 0 },
					  { 1, 0, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 0, 1, 0, 0 } };

char block36[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 1, 0 },
					  { 1, 1, 0, 0 } };
//---------------------------------------
char block7[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 1, 0, 0, 0 } };

char block17[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 0, 1, 1, 0 } };

char block27[4][4] = { { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 1, 0, 0, 0 } };

char block37[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 1, 1, 0, 0 },
					  { 0, 1, 1, 0 } };

//--------------------------------------

char block8[4][4] = { { 0, 0, 0, 0 },
					  { 0, 0, 0, 0 },
					  { 0, 1, 0, 0 },
					  { 0, 0, 0, 0 } };
//--------------------------------------

int Button = 0;

int X;
int Y;

int Make = 0; 	// MakeBlock() check veriable

void OutBox( int x1, int y1, int x2, int y2, char type, char color );

void Init( void );

void PutChar( int x, int y, char type, char color );

void DrawBlock( int x, int y );

void MovBlock( int Button );

void XDelTrace( int x, int y );
void YDelTrace( int x, int y );

int ChanX( int x );
int ChanY( int y );

int Ucheck( void );
int Dcheck( void );
int Lcheck( void );
int Rcheck( void );

void MakeBlock( void );		// Make New Block

void DownBlock( void );	// Move to Down side the Block

void ChanBlock( int type );		// Change to New Block

void InitBlock( void );		// Initialize Block function

void DelTrace( int x, int y );	// Delete Block Trace function

void Rotate( void );	// Rotate block function

void DelLine( void );	// Delete Line function

void DropBlock( void );		// Drop Block function

void LevelUp( void );	// Level Up check function

void SetMode( int mode )
{
	asm mov ax, mode;
	asm int 10h;
}

void Init( void )
{
	int  i;
	video = MK_FP(0xB000,0x8000); // set text mode video memory address

	for( i = 0; i < 4000; i += 2 )
	{
		*( video + i ) = 0xDB;
		*( video + i + 1 ) = 0x09;
	}
}

void PutChar( int x, int y, char type, char color )
{
	*(char *)(video + x + y) = type;      // ASCII charcter
	*(char *)(video + x + y + 1) = color;  // color & attribute
}

// Change co-ordinate
int ChanX( int x )
{
	return( (x - 1) * 2  );
}

int ChanY( int y )
{
	return( (y - 1) * 80 );
}

// random function
int Myrandom( int num )
{
	seed2 = (int)time(NULL);
	seed3 = (int)clock();

	if( seed1 == 0 ) seed1 = 17;
	if( seed2 == 0 ) seed2 = 29;
	if( seed3 == 0 ) seed3 = 31;

	multi1 = (int)(seed1 * seed2 * seed3);

	multi2 = (int)( ( (long)multi1 * num ) / (RAND_MAX + 1) );

	seed1 = multi1;

	if( multi2 < 0 ) multi2 *= -1;
	if( multi2 == num) multi2 -= 1;
	return( multi2 );

}

// Draw Back Ground Box
void OutBox( int x1, int y1, int x2, int y2, char type, char color )	// Background
{
	char *CHAR;
	char string;
	char i, j, k, l, m, n, o, p; // loop veriable

	for( o = x1; o < x2 + 1; o++ )
	{
		for( p = y1; p < y2 + 2; p++ )
		{
			PutChar( ChanX(o), ChanY(p), type, color );
		}
	}

	gotoxy( 28, 2 );
	textattr(7);
	cputs("LEVEL");

	gotoxy( 30, 3 );
	textattr(7);
	cprintf( "%d", Lcount );

	gotoxy( 26, 11 );
	textattr(7);
	cputs("LEFT LINE");

	gotoxy( 30, 12 );
	textattr(7);
	cprintf( "%d", LeftLine );

}

void OutLine( x1, y1, x2, y2 )
{
	int i, j, k, l;
	// Draw line from Left Upper End to Right Upper End
	for( i = x1; i <= x2; i += 1 )
	{
		PutChar( ChanX(i), ChanY(y1), 0xDB, 0x05);
	}

	// Draw line from Left Upper End to Left Down End
	for( j = y1; j <= y2+1; j += 1 )
	{
		PutChar( ChanX(x1), ChanY(j), 0xDB, 0x05 );
	}

	// Draw line from Left Down End to Right Down End
	for( k = x1; k <= x2; k += 1 )
	{
		PutChar( ChanX(k), ChanY(y2+1), 0xDB, 0x05 );
	}

	// Draw line from Right Upper End to Right Down End
	for( l = y1; l <= y2+1; l += 1 )
	{
		PutChar( ChanX(x2), ChanY(l), 0xDB, 0x05 );
	}
}



void DrawBlock( int X, int Y )
{
	char i, j;

	for( i = 0; i < 4; i++ )
		for( j = 0; j < 4; j++ )
		{
			if( (block[i][j] == 0) && (*( video + ChanX(X + j ) + ChanY(Y + i) ) != 0) )
				PutChar( ChanX(X + j), ChanY(Y + i), *( video + ChanX(X + j ) + ChanY(Y + i) ), *( video + ChanX(X + j ) + ChanY(Y + i) + 1 ) );
			if( block[i][j] != 0 )
			{
				PutChar( ChanX(X + j), ChanY(Y + i), block[i][j] * 0x08, 0x07 );
				if( BType == 8 ) PutChar( ChanX(X + j), ChanY(Y + i), block[i][j] * 0x02, 0x07 );
			}
		}

}

void MovBlock( int Button )
{
	switch( Button )
	{
		case RIGHT: if( Rcheck() == 1 ) break;	// Move Right
					DelTrace( X, Y );
					DrawBlock( ++X, Y );
					break;

		case LEFT: 	if( Lcheck() == 1 ) break;	// Move Left
					DelTrace( X, Y );
					DrawBlock( --X, Y );
					break;


		case DOWN: 	if( Dcheck() == 1 ) break;	// Move Down
					DelTrace( X, Y );
					DrawBlock( X, ++Y );
					break;

		case ROTATE:if( BType % 5 == 0 )
					if( RRcheck() == 1 ) break;
					if( Dcheck() == 1 ) break;	// Rotate
					if( Ucheck() == 1 ) break;
					if( Lcheck() == 1 ) break;
					if( Rcheck() == 1 ) break;
					DelTrace( X, Y );
					Rotate();
					ChanBlock( BType );
					DrawBlock( X, Y );
					break;

		case DROP:  sound( 200 );	// Drop
					delay( 5 );
					nosound();
					DropBlock();
					break;

	}
}

void DelTrace( int x, int y )
{
	char i, j;
	for( i = 0; i < 4; i++ )
		for( j = 0; j < 4; j++ )
			if( block[i][j] != 0 ) PutChar( ChanX(x + j), ChanY(y + i), 0x00, 0x05 );
}


void XDelTrace( int x, int y )
{
	char i;

	for( i = x; i < x + 4; i++ )
	{
		PutChar( ChanX(i), ChanY(y), 0x00, 0x05 );
	}
}

void YDelTrace( int x, int y )
{
	char i;

	for( i = y; i < y + 4; i++ )
	{
		PutChar( ChanX(x), ChanY(i), 0x00, 0x05 );
	}
}

int Ucheck( void )		// Upper Check
{
	int i, j, k, l;
	for( i = 0; i < 4; i++ )
	{
		if( block[i][0] != 0 )
		{
			if( *( video + ChanX(X + 0) + ChanY(Y + i - 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( j = 0; j < 4; j++ )
	{
		if( block[j][1] != 0 )
		{

			if( *( video + ChanX(X + 1) + ChanY(Y + j - 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( k = 0; k < 4; k++ )
	{
		if( block[k][2] != 0 )
		{
			if( *( video + ChanX(X + 2) + ChanY(Y + k - 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( l = 0; l < 4; l++ )
	{
		if( block[l][3] != 0 )
		{
			if( *( video + ChanX(X + 3) + ChanY(Y + l - 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	return( 0 );
}


int Dcheck( void )		// Down Check
{
	int i, j, k, l;
	for( i = 3; i > -1; i-- )
	{
		if( block[i][0] != 0 )
		{
			if( *( video + ChanX(X + 0) + ChanY(Y + i + 1) ) != 0x00 )
			{
				++Make;
				return( 1 );
			}
			break;
		}
	}

	for( j = 3; j > -1; j-- )
	{
		if( block[j][1] != 0 )
		{
			if( *( video + ChanX(X + 1) + ChanY(Y + j + 1) ) != 0x00 )
			{
				++Make;
				return( 1 );
			}
			break;
		}
	}

	for( k = 3; k > -1; k-- )
	{
		if( block[k][2] != 0 )
		{
			if( *( video + ChanX(X + 2) + ChanY(Y + k + 1) ) != 0x00 )
			{
				++Make;
				return( 1 );
			}
			break;
		}
	}

	for( l = 3; l > -1; l-- )
	{
		if( block[l][3] != 0 )
		{

			if( *( video + ChanX(X + 3) + ChanY(Y + l + 1) ) != 0x00 )
			{
				++Make;
				return( 1 );
			}
			break;
		}
	}

	return( 0 );
}

int Lcheck( void )	// Left Check
{
	int i, j, k, l;
	for( i = 0; i < 4; i++ )
	{
		if( block[3][i] != 0 )
		{

			if( *( video + ChanX(X + i - 1) + ChanY(Y + 3) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( j = 0; j < 4; j++ )
	{
		if( block[2][j] != 0 )
		{

			if( *( video + ChanX(X + j - 1) + ChanY(Y + 2) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( k = 0; k < 4; k++ )
	{
		if( block[1][k] != 0 )
		{

			if( *( video + ChanX(X + k - 1) + ChanY(Y + 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( l = 0; l < 4; l++ )
	{
		if( block[0][l] != 0 )
		{

			if( *( video + ChanX(X + l - 1) + ChanY(Y + 0) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	return( 0 );
}

int Rcheck( void )		// Right Check
{
	int i, j, k, l;

	for( i = 3; i > -1; i-- )
	{
		if( block[3][i] != 0 )
		{

			if( *( video + ChanX(X + i + 1) + ChanY(Y + 3) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( j = 3; j > -1; j-- )
	{
		if( block[2][j] != 0 )
		{

			if( *( video + ChanX(X + j + 1) + ChanY(Y + 2) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( k = 3; k > -1; k-- )
	{
		if( block[1][k] != 0 )
		{

			if( *( video + ChanX(X + k + 1) + ChanY(Y + 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( l = 3; l > -1; l-- )
	{
		if( block[0][l] != 0 )
		{

			if( *( video + ChanX(X + l + 1) + ChanY(Y + 0) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	return( 0 );
}

int RRcheck( void )		// Right Check
{
	int i, j, k, l;

	for( i = 3; i > -1; i-- )
	{
		if( block[3][i] != 0 )
		{

			if( *( video + ChanX(X + i + 2) + ChanY(Y + 3) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( j = 3; j > -1; j-- )
	{
		if( block[2][j] != 0 )
		{

			if( *( video + ChanX(X + j + 2) + ChanY(Y + 2) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( k = 3; k > -1; k-- )
	{
		if( block[1][k] != 0 )
		{

			if( *( video + ChanX(X + k + 2) + ChanY(Y + 1) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	for( l = 3; l > -1; l-- )
	{
		if( block[0][l] != 0 )
		{

			if( *( video + ChanX(X + l + 2) + ChanY(Y + 0) ) != 0x00 )
			{
				return( 1 );
			}
			break;
		}
	}

	return( 0 );
}

void MakeBlock( void )
{
	EndCheck = 0;
	InitBlock();
	X = (X1 + X2)/2;
	Y = Y1+1;
	BType = Myrandom( 8 ) + 1;
	ChanBlock( BType );
	Dcheck();
	if( Make != 0 ) EndCheck += 1;	// End at limit line

	DrawBlock( X, Y );
}

void DownBlock( void )
{
	MovBlock( DOWN );

	sound( 50 );
	delay( 5 );
	nosound();

	Dcheck();

	if( Make != 0 )
	{
		DelLine();
		Make = 0;
		MakeBlock();
	}

	count = 0;
}

void ChanBlock( int type ) 	// Change from block[][] to New block
{
	int n , o;

	switch( type )
	{
//------------------------------------------------
		case 1:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block1[n][o];
				}
			break;

		case 11:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block11[n][o];
				}
			break;

		case 21:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block21[n][o];
				}
			break;

		case 31:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block31[n][o];
				}
			break;
//-------------------------------------------------

		case 2:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block2[n][o];
				}
			break;

		case 12:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block12[n][o];
				}
			break;

		case 22:
		for( n = 0; n < 4; n++ )
			for( o = 0; o < 4; o++ )
			{
				block[n][o] = block22[n][o];
			}
		break;

		case 32:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block32[n][o];
				}
			break;

//-----------------------------------------------

		case 3:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block3[n][o];
				}
			break;

		case 13:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block13[n][o];
				}
			break;

		case 23:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block23[n][o];
				}
			break;

		case 33:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block33[n][o];
				}
			break;

//-------------------------------------------------

		case 4:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block4[n][o];
				}
			break;

		case 14:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block14[n][o];
				}
			break;

		case 24:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block24[n][o];
				}
			break;

		case 34:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block34[n][o];
				}
			break;

//------------------------------------------------

		case 5:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block5[n][o];
				}
			break;

		case 15:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block15[n][o];
				}
			break;

		case 25:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block25[n][o];
				}
			break;

		case 35:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block35[n][o];
				}
			break;

//--------------------------------------------------

		case 6:
				for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block6[n][o];
				}
			break;

		case 16:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block16[n][o];
				}
			break;

		case 26:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block26[n][o];
				}
			break;

		case 36:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block36[n][o];
				}
			break;

//-------------------------------------------------

		case 7:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block7[n][o];
				}
			break;

		case 17:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block17[n][o];
				}
			break;

		case 27:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block27[n][o];
				}
			break;

		case 37:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block37[n][o];
				}
			break;

//-------------------------------------------------

		case 8:
			for( n = 0; n < 4; n++ )
				for( o = 0; o < 4; o++ )
				{
					block[n][o] = block8[n][o];
				}
			break;
//-------------------------------------------------

	}
}

void InitBlock( void )
{
	char i, j;
	for( i = 0; i < 4; i++ )
		for( j = 0; j < 4; j++ )
			block[i][j] = Initblock[i][j];
}

void Rotate( void )
{
	if( BType > 30 ) BType -= 30;
	else BType += 10;
}

void DelLine( void )	// Delete full line
{
	int i, j, k, l, m, check;
	for( i = Y2; i > Y1; i-- )
	{
		check = 0;
		for( j = X1+1; j < X2; j++ )
		{
			if( *( video + ChanX(j) + ChanY(i) ) == 0x02 )
			{
				check = 0;
				break;
			}
			if( *( video + ChanX(j) + ChanY(i) ) == 0x00 ) 	// find empty block
			{
				check += 1;
			}
		}
		if( check == 0 )
		{
			LevelCheck += 1;	// Level Up check variable

			LeftLine -= 1;	// Left Line check variable

			gotoxy( 30, 12 );
			cprintf(" ");

			textattr(7);
			cprintf( "%d", LeftLine );

			sound( 80 );
			delay( 100 );
			nosound();
			sound( 400 );
			delay( 200 );
			nosound();

			for( k = X1+1; k < X2; k++ )	// Delete line loop
				PutChar( ChanX(k), ChanY(i), 0x00, 0x05 );

			for( l = i; l > Y1+1; l-- )		// Offset line loop
				for( m = X1+1; m < X2; m++ )
				{
					*( video + ChanX(m) + ChanY(l) ) = *( video + ChanX(m) + ChanY(l-1) );
					*( video + ChanX(m) + ChanY(l) + 1 ) = *( video + ChanX(m) + ChanY(l-1) + 1 );
				}
			i += 1;
		}
	}
}

void DropBlock( void )
{
	while( 1 )
	{
		if( Dcheck() == 1 ) break;
		MovBlock( DOWN );
		if( kbhit() != 0 )
		{
			Button = getch();
			if( Button == 27 ) break;
			Button = 0;
		}
	}
}

void LevelUp( void )	// Level Up check function
{
	if( LevelCheck >= 10 )
	{
		gotoxy( (X1+X2)/2 - 6, (Y1+Y2)/2 - 5 );
		textattr(7);
		cputs( " Stage Clear!! " );
		getch();

		OutBox( X1, Y1, X2, Y2, 0x00, 0x00 );
		OutLine( X1, Y1, X2, Y2 );

		LEVEL -= 200;
		LevelCheck = 0;
		Lcount++;

		LeftLine = 10;	// Left Line Number Initialize
		gotoxy( 30, 12 );
		cprintf("  ");
		gotoxy( 30, 12 );
		textattr(7);
		cprintf( "%d", LeftLine );

		gotoxy( 30, 3 );
		textattr(7);
		cprintf( "%d", Lcount );
	}
}

void EndMusic( void )
{
	int i;
	int Sound[160] = {	13, 13, 13, 16, 20, 21, 18, 20, 16,
						14, 25, 23, 21, 18, 20, 21, 23, 21, 16,
						13, 13, 16, 20, 21, 18, 20, 16,
						14, 25, 23, 21, 18, 20, 21,
						13, 13, 13, 16, 20, 21, 18, 20, 16,
						14, 25, 23, 21, 18, 20, 21, 23, 21, 16,
						13, 13, 16, 20, 21, 18, 20, 16,
						14, 25, 23, 21, 18, 20, 21, // 68
						21, 21, 21, 21, 25, 23, 21, 20,
						20, 23, 21, 20, 18, 21, 21, 20, 18, 16,
						21, 21, 21, 21, 23, 20, 21, 23, 25,// 95
						26, 25, 21, 21, 25, 21, 25, 23, // 103 8 minute sleep
						25, 26, 28, 28, 28, 28, 26, 25, 28, // 8 minute
						25, 26, 26, 26, 26, 25, 23, 26,//  120
						25, 26, 28, 28, 28, 28, 26, 25, 28,
						26, 26, 28, 26, 25, 23, 21, 23, 21,
						13, 13, 16, 20, 21, 18, 20, 16,
						14, 25, 23, 21, 18, 20, 21, // 153
						14, 25, 23, 21, 18, 20, 21 }; // 160
	int Delay[160] = { 	250, 750, 500, 500, 500, 250, 750, 500, 4000,
						500, 500, 500, 1500, 500, 500, 1000, 500, 500, 2000,
						1000, 500, 500, 500, 250, 750, 500, 4000,
						500, 500, 500, 1500, 500, 500, 4000,
						250, 750, 500, 500, 500, 250, 750, 500, 4000,
						500, 500, 500, 1500, 500, 500, 1000, 500, 500, 2000,
						1000, 500, 500, 500, 250, 750, 500, 4000,
						500, 500, 500, 1500, 500, 500, 4000,	// 68
						500, 250, 2500, 500, 500, 500, 250, 2500,
						250, 750, 500, 250, 2250, 250, 250, 500, 250, 2250,
						500, 250, 1250, 750, 750, 500, 500, 500, 2500, //95
						500, 500, 500, 1000, 500, 500, 1500, 1000, // 103 8 minute sleep
						750, 750, 500, 500, 500, 1000, 500, 500, 3500, // 112 8 minute sleep
						500, 500, 500, 500, 1000, 500, 500, 2500,	// 120 line 8 minute sleep
						500, 750, 500, 500, 500, 1000, 500, 500, 3500, // 129 line 4 minute
						500, 500, 500, 500,/* 8 minute*/ 1000, 500, 250, 250, 4000,
						1000, 500, 500, 500, 250, 750, 500, 4000,
						500, 500, 500, 1500, 500, 500, 4000,
						500, 500, 500, 1500, 500, 500, 4000 };
	for( i = 0; i < 160; i++ )
	{

		if( kbhit() != 0 ) break;

		sound( 131*pow(1.06, Sound[i]) );
		delay( Delay[i] );
		nosound();
		if( i == 80 ) delay( 250 );
		if( i == 85 ) delay( 500 );
		if( i == 88 ) delay( 250 );
		if( i == 102 ) delay( 250 );
		if( i == 111 ) delay( 250 );
		if( i == 119 ) delay( 375 );
		if( i == 128 ) delay( 500 );
		if( i == 132 ) delay( 250 );
	}

}

void main( void )
{
	SetMode( 0x01 );

	Init();

	OutBox( X1, Y1, X2, Y2, 0x00, 0x00 );
	OutLine( X1, Y1, X2, Y2 );

	OutBox( 25, 2, 35, 5, 0xDB, 0x05 );
	OutLine( 25, 2, 35, 5 );

	OutBox( 25, 20, 35, 23, 0xDB, 0x05 );

// Make New Block
	MakeBlock();

	while(1)
	{
		count++;

		if( LEVEL == 0 )
		{
			gotoxy( (X1+X2)/2 - 3, (Y1+Y2)/2 - 5 );
			textattr(7);
			cputs("You are The Best Player!!!");
			EndMusic();
			getch();
			break;
		}

		if( count > LEVEL )
		{
			DownBlock();
			LevelUp();
		}

		if( EndCheck != 0 )
		{
			gotoxy( (X1+X2)/2 - 3, (Y1+Y2)/2 - 5 );
			textattr(7);
			cputs("Game Over");
			EndMusic();
			getch();
			break;
		}

		if( kbhit() != 0 )
		{
			Button = getch();
			MovBlock( Button );
			if( Button == 27 ) break;
			Button = 0;
		}

	}
	SetMode( 0x03 );
}