/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves
 *      shawn@talula.demon.co.uk
 *      http://www.talula.demon.co.uk/allegro/
 *
 *      This is a pared-down version of allegro.h internal.h and interndj.h
 *      It is for compiling the IRQ routines separate from Allegro with
 *      minimal fuss
 *
 *      See readme.txt for copyright information.
 */


#ifndef DJGPP
#error This file should only be used by the djgpp version of Allegro
#endif

#include <dos.h>

/* macros to enable and disable interrupts */
#define DISABLE()   asm volatile ("cli")
#define ENABLE()    asm volatile ("sti")

int _install_irq(int num, int (*handler)());
void _remove_irq(int num);
void _restore_irq(int irq);
void _enable_irq(int irq);
void _disable_irq(int irq);

#define _eoi(irq) { outportb(0x20, 0x20); if ((irq)>7) outportb(0xA0, 0x20); }

typedef struct _IRQ_HANDLER
{
   int (*handler)();             /* our C handler */
   int number;                   /* irq number */
   __dpmi_paddr old_vector;      /* original protected mode vector */
} _IRQ_HANDLER;

/* General Stuff */

#ifndef TRUE 
#define TRUE         -1
#define FALSE        0
#endif

/* Locking */

#define END_OF_FUNCTION(x)    void x##_end() { }
#define LOCK_DATA(d,s)        _go32_dpmi_lock_data((d), (s))
#define LOCK_CODE(c,s)        _go32_dpmi_lock_code((c), (s))
#define UNLOCK_DATA(d,s)      _unlock_dpmi_data((d), (s))

#define LOCK_VARIABLE(x)      LOCK_DATA((void *)&x, sizeof(x))
#define LOCK_FUNCTION(x)      LOCK_CODE(x, (long)x##_end - (long)x)


