//
//      Ensure all critical systems are shut down at exit
//      In spite of any compiler 'features'
//

#include <stdlib.h>
#include <signal.h>

extern void S_Term();   // Sound
extern void T_Term();   // Timer
extern void K_Term();   // Keyboard

static void Signal_Terminate(int sig);

/*
 * At_Exit()
 *
 * If you want something done properly you have to DO IT YOURSELF
 */

void At_Exit()
{
// These are safeguards for normal termination

atexit(K_Term);
atexit(S_Term);
atexit(T_Term);

// These are for ABnormal termination

signal(SIGINT,  Signal_Terminate);
// MR: added
#ifndef _WIN32
signal(SIGQUIT, Signal_Terminate);
#endif
signal(SIGABRT, Signal_Terminate);
signal(SIGSEGV, Signal_Terminate);
signal(SIGILL,  Signal_Terminate);
signal(SIGFPE,  Signal_Terminate);
signal(SIGTERM,  Signal_Terminate);
// MR: modified
#if !defined(__BEOS__) && !defined(_WIN32)
signal(SIGTRAP,  Signal_Terminate);
#endif
}

/*
 * Signal_Terminate(int signal)
 *
 * Perform the shutdown and print debug information
 */

void Signal_Terminate(int sig)
{
T_Term();
K_Term();
S_Term();
#ifdef __DJGPP__
__djgpp_traceback_exit(sig);
#endif
}


