/*
 *      Console:   Console routines, Logger etc.
 */

#include "itg/itg.h"      // Need the graphics lib

// Defines

#define C_LEN 60        // max 60 items in the queue, 20 realistically
#define C_WID 80        // 80 rows

// Variables

//extern char **C_list;          // List of items
extern char graflog;           // Is graphical log being used?
extern int  logx,logy,loglen;  // graphical log x,y and length in lines
extern char *cfa;              // Last function address
extern char conlen;            // Number of lines in the log, up to 20
extern char conwid;            // Number of rows in the log, up to 80
extern char conlog;            // Toggle, if we log the console to bootlog.txt
extern int conx,cony;          // Window position in pixels
extern char digit[256][8];     // The font we will use
extern char *swapscreen;       // The draw surface
extern char InGFX;          // Are we in graphics mode yet
extern void (*bootmsg)(char *msg, ...); // dynamic logger (call this mainly)
extern char buggy;             // Did bugs occur?

// Logger

void Init_logger();
void boot0(char *msg, ...);             // Text logger
void boot1(char *msg, ...);             // Graphics logger
void boot2(char *msg, ...);             // Quiet logger

void switch_logger_on();                // Enable boot1 logger
void switch_logger_off();               // Reset to proper game settings
void logger_get_backing();              // get backing for in-game console

// Console routines

void C_init();                          // Start the console up
void C_term();                          // Shut the console down
void C_updatelist();                    // Print the messages on screen
void C_cls();                           // Clear all the messages
void C_gotoxy(int x,int y);             // Set the text window position

void C_printf(char *msg, ...);          // Printf on the console
void C_printit(char *msg);              // Raw print on console
void C_printxy(int x,int y,char *msg);  // print direct a string
void C_bumplist();                      // Write a CRLF to the console
void C_color(int r,int g,int b);        // Set text colour
void C_delete();                        // Wipe current line


// Support routines

void panic(char *curfunc,char *m,char *n);      // Crash out with an error
void S_panic(char *curfunc,char *m,char *n);    // Panic for C++ d'tors
void Plot(int max);                             // Plot the 'working' dots
void Bug(char *msg, ...);                       // Log nonfatal error


