/*
	iRE:		Core Data structures

	Version: 	1.0.1

	(C) 1998 JP MORRIS

	17/2/98
*/

#ifndef __IRCORE
#define __IRCORE

#define IKV "0.05"      // IRE Kernel Version

#define STORE 1024
#define OSTORE 128
#define W_SIZE 10

#define STARTX 128
#define RANDOM_TILE 0xffff      // Appears as an eyesore

#define CHAR_U 0  // Directions for the sequence cache in CHlist
#define CHAR_D 1
#define CHAR_L 2
#define CHAR_R 3

#define VSH 8
#define VSW 8
#define MAPSIG 0xf15e0005

#define MAX_W 1024
#define MAX_H 1024
#define MAX_MEMBERS 128

#define CRASH(); asm("int $3");
#define MAP_POS(x,y) (ytab[y]+(x))

#include "itg/itg.h"

///////////////////////////////////////////////////////////////////////////
//  Script Processing Data Structures                                    //
///////////////////////////////////////////////////////////////////////////

// Statistics

struct STATS
{
int  hp;
int dex;
int  str;
int intel;
int  weight;
int quantity;
char  prob; char tick;       // Probability, unused.  Animation timer.
int   oldbehave;
int damage;                   // Damage (caused by a weapon)
int  oldhp;                    // Previous hp, used internally
long pFlags;
struct OBJECT *owner;
short vv[18];
};

// A single sprite

extern struct S_POOL
{
char *name;
char *fname;
SPRITE image;
short w,h;
unsigned short wxh;
short x,y;
} *SPlist;

extern S_POOL *RTlist;
extern long RTtot;

// A complete animation sequence

extern struct SEQ_POOL
{
char *name;
S_POOL **seq;
int frames;
unsigned char flags;
int x,y;
unsigned char speed;
S_POOL *overlay;        // This is always drawn on top of the sprite
                        // but it has no physical existence
} *SQlist;

// Virtual Runtime Module code

extern struct VRM
   {
   char *name;
   char *fname;
   char *vrm;
   void *instance;
   } *COlist;


///////////////////////////////////////////////////////////////////////////
//  Graphics Kernel Data Structures                                      //
///////////////////////////////////////////////////////////////////////////

extern char *screen;		// the screen
extern char *swapscreen;	// scroll buffer
extern char *bg_screen;		// the background screen
extern short *array;		// the world
extern char *GIFPIC;		// backing

extern PALETTE pal,fpal;

struct S_FLAGS
{
unsigned long 	 on	:1;     // active?
unsigned long 	 onscreen:1;    // Is it onscreen?
unsigned long 	 overlay:1;     // Is it an overlay?
unsigned long 	 solid:1;       // Is it solid to people?
unsigned long    fragile:1;     // Will it break if you drop it?
unsigned long    trigger:1;     // Is it a trigger?
unsigned long    invisible:1;   // Will it only appear in the editor?
unsigned long    party:1;       // Is it a Party Member? (affects solidity)
unsigned long    fixed:1;       // Is is nailed to the ground (can't pick up, push)
unsigned long    container:1;   // Is is a container?
unsigned long    translucent:1; // Is it translucent?
unsigned long    large :1;      // Object bigger than 1 tile
unsigned long    spikeproof:1;  // Isn't hurt by objects below
unsigned long    wield :1;      // Can it be wielded?
unsigned long    stepupdated :1;// Was just updated (used by stepping code)
unsigned long    yours:1;       // Does it belong to you?
unsigned long    blocklight :1; // Does it blocklight?
unsigned long    tabletop   :1; // Can you drop things on it even if it's solid?
unsigned long    didinit    :1; // Have we done the INIT function?
unsigned long    didupdate  :1; // Have we moved just now (prevent runaway)?
unsigned long    person     :1; // Is a person
unsigned long    seekstate  :1; // Used by PathUpdate in ire_game.cc
unsigned long    quantity   :1; // Can it be a pile of things?
unsigned long 	 spare :9;
};

struct FUNCS            // This is called when you...
{
char use[32];           // USE it
int  ucache;
char talk[32];          // TALK to it
int  tcache;
char kill[32];          // KILL/BREAK it
int  kcache;
char look[32];          // LOOK at it
int  lcache;
char stand[32];         // STAND on it
int  scache;
char hurt[32];          // HURT/DAMAGE it
int  hcache;
char init[32];          // Called when object first created
int  icache;
// The ?cache number succeeding each entry is the index in the array of VRMs
// to the one that will be called, and is used for optimisation.

char contains[8][32];
char contents;
// Up to 8 objects can be put in the object when it's first created

char resurrect[32];          // Object it becomes when resurrected
char dirty;                  // Changed from defaults?  (used in editor)
};

// Descriptions for looking at things

extern struct D_TEXT
{
char *name;
char *text;
} *DSlist;


// Tiles

extern struct TILE
{
char *name;
S_FLAGS flags;
SEQ_POOL *form;     // Direct access to animation
char seqname[32];   // Name of animation (in editor)
int sptr,slen,sdir; // animation info
FUNCS funcs;        // VRM Function table
char *desc;         // description
} *TIlist;

extern long TItot;

// MR: vc doesn't seem to like __attribute__
#ifdef _WIN32

#pragma pack( push, pack_1byte ,1 )

// Create a type which is a single byte which is single-byte-aligned (packed)
typedef unsigned char pBYTE ;
// Create a type which is two bytes which is single-byte-aligned (packed)
typedef unsigned short pWORD ;

#pragma pack( pop, pack_1byte )

#else
// Create a type which is a single byte which is single-byte-aligned (packed)
typedef unsigned char pBYTE __attribute__ ((aligned (1)));
// Create a type which is two bytes which is single-byte-aligned (packed)
typedef unsigned short pWORD __attribute__ ((aligned (1)));
#endif


// Moving object entitiy

extern struct OBJECT
{
char *name;
S_FLAGS flags;
int w,h,mw,mh;
int x,y,z;
char *personalname;
char **schedule;
void *UN_USED;
SEQ_POOL *form;
int sptr,slen,sdir; // animation info
STATS *maxstats;    // Statistics structure
STATS *stats;       // Current stats
FUNCS *funcs;       // VRM Function table
short curdir;
short dir[4];       // u,d,l,r
char *desc;         // Examine Description
char *shortdesc;    // Short Description
int   behave;       // Current Behaviour VRM
int   tag;          // Tags are used for triggering things
int   user[10];     // 10 User variables
pBYTE hblockx,hblocky,hblockw,hblockh;
pBYTE vblockx,vblocky,vblockw,vblockh;
pBYTE HareaX,HareaY,HareaW,HareaH;
pBYTE VareaX,VareaY,VareaW,VareaH;
//typedef unsigned char   rUBYTE __attribute__ ((aligned (1))) ;       /*  unsigned 8 bits value type  */
int   save_id;     // Assigned object number (during saving and loading)
int   inside_id;   // What object is it inside? (during saving and loading)
int   temp[8];     // Reserved space
char  light;        // Light it casts
struct OBJECT *enemy;
struct OBJECT **wield;
struct OBJECT *pocket;
struct OBJECT *next;
} *CHlist;

extern OBJECT *party[MAX_MEMBERS];
// World structure

extern struct WORLD
{
int sig;	                // Signature
int w,h;
unsigned short *physmap;        // Physical world
OBJECT *object;                 // Linked list of objects
//LAYER *roof;                    // Rooftops
unsigned char *roof;            // Rooftop
OBJECT **objmap;
int *temp[31];
} curmap;

extern struct OBJLIST
{
OBJECT *ptr;
OBJLIST *next;
} *MasterList;
extern struct OBJLIST *ActiveList;

extern int ytab[];

extern int vscheduler,mainproc,use_none,look_none;

extern void panic(char *c,char *a,char *b);
extern void S_panic(char *c,char *a,char *b);

#define box(a,b,c,d,e,f) ITG_box(a,b,c,d,e,f)

#endif

