#ifndef __IRE__FS__
#define __IRE__FS__


/*
	IRE:		Abstracted FileSystem

	Version: 	2.1.0

	(C) 1999 JP MORRIS

	27/6/96         - Written
	19/4/98         - Changed name of RVFS datastypes to avoid collision
                          with MIKMOD's data types
	25/5/99		- Added getl, getsh, getb, putl, putsh, putb
			  Extended truename array to 256 bytes
*/

#include "rvfs.h"

extern char resdir[];   // Name of the main directory

struct LOAD
{
FILE *fileptr;
long Xlength;
long Xorigin;
char truename[256];

void open(char *filename);
void open_current(char *filename);
void close();
short LOAD::getb();
short LOAD::getw();
long getl();
void read(void *ptr,long s,long n);
long filelength();
void fseek(long ptr,short Whence);
LOAD();
~LOAD();
};

extern short exist(char *fname);                    // Exists as a file?
extern short Gexist(char *fname);                   // Exists in RFS either?
extern void RFS_Mount(short Rargc,char *Rargv[]);   // Mount a .RAR file
extern long RFS_Open(char* fname);                  // Open file from RFS
extern long RAR_Open(char *rar, char* fname);       // Open RARfile in RFS
extern void Init_Filesystem();                      // Start the system
extern void RFS_Add(char *fn);                      // Add RARfile to system

extern long getl(FILE *fp);
extern void putl(long l,FILE *fp);
extern short getsh(FILE *fp);
extern void putsh(short s,FILE *fp);
extern char getb(FILE *fp);
extern void putb(char b,FILE *fp);

#endif
