/*
 *  - Large view of the world
 */


#include <stdio.h>
#include "igui.hpp"
#include "../memory.hpp"
#include "../console.hpp"
#include "../core.hpp"
#include "menusys.h"
#include "../keys.hpp"

// defines

// variables

extern int focus,BM_Id;

extern long M_core;     // Total amount of core, from memory.cc
extern int s_proj;      // Flag, are sprites being displayed?
extern int l_proj;      // Flag, are layers being displayed?

// functions

extern int ReadMap(int x,int y);
extern void Toolbar();

// GoFocal - The menu tab function.  This is called from the toolbar

void BM_GoFocal()
{
int temp;               // Used to get button handles

if(focus==4)            // Make sure we don't redraw if the user clicks again
	return;

focus=4;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(BM_Id);     // And make the button stick inwards

// Set up Map window

IG_BlackPanel(64,64,384,384);

for(int cy=0;cy<384;cy++)
    for(int cx=0;cx<384;cx++)
        {
        temp=ReadMap(cx,cy);
        if(temp==RANDOM_TILE)
            dot(cx+64,cy+64,BLUE,swapscreen);
        else
            dot(cx+64,cy+64,TIlist[temp].form->seq[0]->image.spr[0],swapscreen);
        }

}



