/*
 *      IRE editor main module
 */

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <stdarg.h>

#include <netinet/in.h>    // For the endian functions

#include "../core.hpp"     // Main data structures
#include "../itg/itg.h"      // GFX lib
#include "../init.hpp"     // Init module
#include "../linklist.hpp" // Linked list alloc and free routines
#include "../memory.hpp"   // Memory module
#include "../loaders.hpp"  // Loader module
#include "../keys.hpp"     // Keyboard routines
#include "../fs.hpp"       // Filesystem
#include "../oscli.hpp"    // Operating system command line interpreter
#include "../console.hpp"  // Text output and logger routines
#include "../cookies.h"    // Signatures for the Z1/Z2 map files
#include "../script.hpp"   // The script file loader and search routines
#include "../loadsave.hpp" // Map IO routines
#include "../sound.hpp"    // Include the SMTab data structure
#include "../vidmodes.h"   // Include the Video mode controller

#include "igui.hpp"

// Defines

// Variables

// Mapfile, filename of the current map, begins with 0xff if not defined
char mapname[]=COOKIE_MapName;

int MapXpos_Id,MapYpos_Id;
int ytab[MAX_H];

char mapxstr[]="X: 0    ";      // Room for 5 digit number
char mapystr[]="Y: 0    ";
char InGFX=0,buggy=0,do_cd=0;
char show_roof = 0;
char fullrestore = 0;
OBJECT **objectstore;
OBJLIST *ActiveList;

int AB_Id,BG_Id,OB_Id,TL_Id,BM_Id;
int  mapx=0,mapy=0;     // Initial map coordinates



//short bgp_size=0;
//SPRITE *bgpool;
SPRITE transfer;
SPRITE eyesore;
SPRITE warning;
char *screen;		        // the screen
char *bg_screen;		// the background screen
WORLD curmap;

OBJECT *objsel;         // Object selected in objects.cc
OBJECT *player;         // For the DLX engine

OBJECT *current_object; // parameters For the DLX engine
OBJECT *victim;         // parameters For the DLX engine
TILE   *current_tile;
char   *message;
int    *storage;

int Waves=0,Songs=0;    // Sound engine dummies
SMTab *modtab,*wavtab;  // More dummies

// defaults for the DLX engine
int mainproc,vscheduler,look_none,use_none,status,follower,loadproc,playervrm,all_dead;
//extern char show_vrm_calls;
extern char in_editor;

int s_proj=1;           // Project Sprites flag
int l_proj=0;           // Project Layers flag (OFF BY DEFAULT)
int sx_proj=1;          // Exclude other Sprites flag (1 = OFF)
int lx_proj=1;          // Exclude other Layer objects flag (1 = OFF)

char __up[]={22,0};     // The arrow icons (in the font)
char __down[]={23,0};
char __left[]={20,0};
char __left2[]={20,20,0};
char __right[]={21,0};
char __right2[]={21,21,0};

OBJECT *largemap[24][24];
OBJECT *solidmap[24][24];


// Functions

void banner();

void LoadMap();
void SaveMap();
void Toolbar();

void Eproject_sprites(char *screen);    // Project the sprites onto the map
void Eproject_roof(int x,int y);        // Project the rooftop objects

void Quit();
void Snap();
extern void AB_GoFocal();       // About box handle
extern void BG_GoFocal();       // Background handle
extern void OB_GoFocal();       // Objects
extern void TL_GoFocal();       // Roofs
extern void BM_GoFocal();       // World view (big map)
extern void gen_largemap();     // Build the large-objects map

// Code

/*
 *      Main - start up all the things, run them, stop all the things, exit
 */

main(int argc,char *argv[])
{
#ifdef __DJGPP__
printf("This product includes software developed by the University of California,\n");
printf("Berkeley and its contributors\n");
sleep(1);
#endif

strcpy(resdir,"res");   // Set default directory for resources

banner();

in_editor = 1;    // Some init functions are not necessary for the editor

V_init();         // Init video modes
M_init();         // Init memory systems

puts("Init_logger();");
Init_logger();

bootmsg("Allocating screens\n");
bg_screen = (char *)M_get(640000,1);
Loader_Init();

// Get commandline input

if(argc>=2)
    OSCLI(argc,argv);       // input from OSCLI

INI_file("editor.ini");         // Read the main ini file and act upon it
V_format(VideoMode);            // Set correct RGB format

// For the editor, we must ensure that a file is loaded.

if((unsigned char)mapname[0]==(unsigned char)0xff)
	{
	puts("\nPlease specify the name of the level you want to edit.");
	puts("  EG.  edit -edit mymap\n");
	exit(1);
	}

Init_Filesystem();              // Start VFS

if(Gexist("!autoire.ini"))      // If the user ini file exists,
    INI_file("!autoire.ini");   // Read it in and act upon it

Init_Font();                    // Load font for console

bootmsg("Memory now available :%ld bytes decimal\n",coreleft());

// Init the VRM system

// Init_DLX();

// Now, parse/compile the scripts

Compile("main.txt");    // This is less a compiler than it was once

Init_Funcs();           // Set up the VRM functions.
                        // We aren't going to USE them, but we need to set up
                        // the function caches, obj->funcs->ucache etc.

// Make sure there are some tiles

if(TItot<1)
    panic("main","No tiles were defined","Check 'section: tiles' in the scriptfile");

transfer.allocate(256,256);     // Allocate transfer buffer for Map clipping

LoadMap();                      // What it says

Loader_Term();                  // Initialisation completed, free some blocks

load_CEL(&eyesore,"eyesore.cel");       // Load the 'randomise-me' tile
load_CEL(&warning,"warning.cel");       // Load the error tile

IG_Init(128);                   // Set up the iGUI for max 128 buttons

Toolbar();                      // Draw the menu bar at the top
                                // And then start the iGUI event loop

AB_GoFocal();                   // Start on the ABOUT screen

do IG_Dispatch(); while(running);       // Loop until quit

SaveMap();                      // Save the map
IG_Term();                      // Free the iGUI resources

M_term();                       // Shut down memory alloc'er
banner();                       // Show the banner
}

/*
 *      Banner - Display the red banner at the top of the screen in startup
 */

void banner()
{
off();
textcolor(15);
textbackground(4);
cprintf("            IRE Editor - IT-HE RPG Engine (C) 1999 IT-HE Software               \r\n");
textcolor(7);
textbackground(0);
window(1,2,80,25);
}

/*
 *      Toolbar - set up the GUI components that are present in all cases
 */

void Toolbar()
{
IG_KillAll();
IG_AddKey(0x1b,Quit);           // Add key binding for ESC = Quit
IG_AddKey(0x5d,Snap);           // Add key binding for shift-F10
IG_Panel(0,0,640,32);

IG_Panel(0,32,640,480-32);
AB_Id = IG_Tab(540,4,"About",AB_GoFocal,NULL,NULL);
BG_Id = IG_Tab(4,4,"Background",BG_GoFocal,NULL,NULL);
OB_Id = IG_Tab(100,4,"Sprites",OB_GoFocal,NULL,NULL);
TL_Id = IG_Tab(173,4,"Roof",TL_GoFocal,NULL,NULL);
BM_Id = IG_Tab(220,4,"World view",BM_GoFocal,NULL,NULL);
IG_TextButton(594,4,"Quit",Quit,NULL,NULL);

// Hotkeys for the sections

IG_AddKey(KEY_1,BG_GoFocal);
IG_AddKey(KEY_2,OB_GoFocal);
IG_AddKey(KEY_3,TL_GoFocal);
IG_AddKey(KEY_4,BM_GoFocal);
IG_AddKey(KEY_0,AB_GoFocal);
}

/*
 *      Quit - The callback handler for Quitting
 */

void Quit()
{
if(Confirm(-1,-1,"Are you sure you want to quit?",NULL))
  running = 0;
}

/*
 *      Snap - The callback handler for taking a screen dump
 */

void Snap()
{
BMPshot((short *)swapscreen,640);
}


/* ================================ Map RW =============================== */

/*
 *      DrawMap - Display the map on screen
 */

void DrawMap(int x,int y,char s,char l,char f)
{
int xctr=0;
int xctr2=0,ptr,bit;
char *ss;
char stemp[128];
int mapx,mapy;

#define STARTX 0

xctr=0;
xctr2=STARTX;

mapy = y;
mapx = x;

ptr=mapy*curmap.w;
ptr+=mapx;

bit=curmap.w - VSW;
xctr=STARTX;
for(int ctr=0;ctr<VSH;ctr++)
	{
	for(int ctr2=0;ctr2<VSW;ctr2++)
		{
                if(curmap.physmap[ptr] == RANDOM_TILE)
                    eyesore.block_put_sprite(xctr,xctr2,bg_screen);
                else
                if(curmap.physmap[ptr]>=TItot)
                    warning.block_put_sprite(xctr,xctr2,bg_screen);
                else
                    TIlist[curmap.physmap[ptr]].form->seq[0]->image.block_put_sprite(xctr,xctr2,bg_screen);
		xctr+=32;
		ptr++;
		}
	xctr=STARTX;
	xctr2+=32;
	ptr+=bit;
	}

//gen_largemap();

if(s)
          Eproject_sprites(bg_screen);
if(l)
          Eproject_roof(x,y);

transfer.get_sprite(0,0,bg_screen);
transfer.block_put_sprite(VIEWX,VIEWY,swapscreen);

sprintf(mapxstr,"X: %5d",mapx);
IG_UpdateText(MapXpos_Id,mapxstr);

sprintf(mapystr,"Y: %5d",mapy);
IG_UpdateText(MapYpos_Id,mapystr);

//IG_BlackPanel(24,40,102,12);
//IG_Text(25,41,stemp,WHITE);
}

/*
 *      WriteMap - update a tile on the map
 */

void WriteMap(int x,int y,int tile)
{
int xctr=0;
int xctr2=0,ptr,bit;
ptr=y*curmap.w;
ptr+=x;
curmap.physmap[ptr]=tile;
}

/*
 *      ReadMap - get a tile from the map
 */

int ReadMap(int x,int y)
{
int xctr=0;
int xctr2=0,ptr,bit;
ptr=y*curmap.w;
ptr+=x;
return(curmap.physmap[ptr]);
}

/*
 *      WriteRoof - update a tile on the map
 */

void WriteRoof(int x,int y,int tile)
{
int xctr=0;
int xctr2=0,ptr,bit;
ptr=y*curmap.w;
ptr+=x;
curmap.roof[ptr]=tile;
}

/*
 *      ReadMap - get a tile from the map
 */

int ReadRoof(int x,int y)
{
int xctr=0;
int xctr2=0,ptr,bit;
ptr=y*curmap.w;
ptr+=x;
return(curmap.roof[ptr]);
}

/*
 *      Eproject_sprites- Display the sprites on the map
 */

void Eproject_sprites(char *screen)
{
int cx,cy,vx,vy,yoff,startx,starty;
OBJECT *temp;

temp=curmap.object->next;               //  First is dummy, second is first

startx=-4;
starty=-4;
if(startx+mapx<0) startx=0;
if(starty+mapy<0) starty=0;

//for(;temp;temp=temp->next)              // Traverse the list
for(vy=starty;vy<VSH;vy++)
    {
    yoff=ytab[mapy+vy];
    for(vx=startx;vx<VSW;vx++)
        {
        for(temp=curmap.objmap[yoff+mapx+vx];temp;temp=temp->next)
            if(temp)                            // Safety check
                {
                cx = temp->x;                   // Get X and Y for conciseness
                cy = temp->y;

                if(temp == objsel || sx_proj)   // If object is tagged, or the
                    {                           // exclude switch is not enabled

                    // And if the object is in the screen region

                    if((cx+temp->mw >= mapx) && (cx <= mapx+VSW))
                        if((cy+temp->mh >= mapy) && (cy <= mapy+VSH))
                            {

                            // Then we plot the object with the CLIP method
                            // <<5 multiplies by 32, converting the map
                            // coordinates into pixels.

                            temp->form->seq[0]->image.clip_sprite((cx-mapx)<<5,(cy-mapy)<<5,screen);

                            // If the object is the Tagged Object, highlight it.

                            if(objsel == temp)
                                ClipBox((cx-mapx)<<5,(cy-mapy)<<5,temp->w-1,temp->h-1,WHITE,screen);

                            // If the object is the Owner of the current object, highlight in red.

                            if(objsel)
                                if(objsel->stats->owner == temp)
                                ClipBox((cx-mapx)<<5,(cy-mapy)<<5,temp->w-1,temp->h-1,RED,screen);
                            }
                    }
                }
        }
    }
}

/*
 *      Eproject_roof- Display the roof objects on the map
 */

void Eproject_roof(int x,int y)
{
int xctr=0;
int xctr2=0,ptr,bit;
char *ss;
char stemp[128];
int mapx,mapy;

#define STARTX 0

xctr=0;
xctr2=STARTX;

mapy = y;
mapx = x;

ptr=mapy*curmap.w;
ptr+=mapx;

bit=curmap.w - VSW;
xctr=STARTX;
for(int ctr=0;ctr<VSH;ctr++)
	{
	for(int ctr2=0;ctr2<VSW;ctr2++)
		{
                if(curmap.roof[ptr] == RANDOM_TILE)
                    eyesore.cel_put_sprite(xctr,xctr2,bg_screen);
                else
                if(curmap.roof[ptr])
                    if(curmap.roof[ptr]<RTtot)
                        RTlist[curmap.roof[ptr]].image.cel_put_sprite(xctr,xctr2,bg_screen);
		xctr+=32;
		ptr++;
		}
	xctr=STARTX;
	xctr2+=32;
	ptr+=bit;
	}

return;
}

/*
 *      SaveMap- Write the map to disk, calls functions in loadsave.cc
 */

void SaveMap()
{
char mapname2[128];
char mapname3[128];
char ttempx[128];
FILE *ofp;
ofp=NULL;

strcpy(mapname2,mapname);

do
	{
	InputFileName(-1,-1,"Save as:",128,mapname2);
	if(!mapname2[0])
		return;
	if(!mapname2)
		return;
	if(strchr(mapname2,'.')) *(strchr(mapname2,'.'))=0;
	strcpy(ttempx,mapname2);
	strcat(ttempx,".map");

	ofp=fopen(ttempx,"wb");
	if(!ofp)
		if(!Notify(-1,-1,"Could not create file..",ttempx))
			return;
	} while(!ofp);

        fclose(ofp);  // We won't be needing this..

DisplayMessage(-1,-1,"Saving...");

//	Write tilemap

	strcpy(ttempx,mapname2);
	strcat(ttempx,".map");

        save_map();


//	Write Object positions

	strcpy(ttempx,mapname2);
	strcat(ttempx,".mz1");

        save_z1(ttempx);


//	Write TopLayer positions

	strcpy(ttempx,mapname2);
	strcat(ttempx,".mz2");

        save_z2();
}



