/*
	Doom Editor Utility, by Brendon Wyber and Raphal Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README.1ST for more information.

	This program comes with absolutely no warranty.

	GFX.C - Graphics routines.
*/

//int VideoMode=-1;
int vp=0;

/* the includes */
#include "../console.hpp"
#include "menusys.h"
#include <math.h>
#include <dos.h>
#include <bios.h>
#include <unistd.h>
#include <mem.h>
#include "../itg/itg.h"
#include "../vidmodes.h"

char *_copy;

#define preserve();	;fblit(_copy,swapscreen);//memcpy(_copy,swapscreen,640000);
#define restore();	;fblit(swapscreen,_copy);//memcpy(swapscreen,_copy,640000);
#define show();	update(swapscreen);
#define INVALID -2147483648
#define MAXDIV10 214748364

//print(int Xstart,int Ystart,char *temp,char *swapscreen,short CURCOL,short o);

extern char *swapscreen;
//extern char **bfont;

char bfont[256][8];

//extern char **B_list;
//extern int B_listlen;

/* the global variables */
int GfxMode = 2;	/* graphics mode number, or 0 for text */
			/* 1 = 320x200, 2 = 640x480, 3 = 800x600, 4 = 1024x768 */
			/* positive = 16 colors, negative = 256 colors */
int OrigX;		/* the X origin */
int OrigY;		/* the Y origin */
int Scale;		/* the scale value */
int PointerX;		/* X position of pointer */
int PointerY;		/* Y position of pointer */
int ScrMaxX;		/* maximum X screen coord */
int ScrMaxY;		/* maximum Y screen coord */
int ScrCenterX;		/* X coord of screen center */
int ScrCenterY;		/* Y coord of screen center */
short CURCOL=WHITE;

//void ShowThnByName(int x,int y,char *name);

void setfillstyle(int a,int b)
{
CURCOL=b;
}

void F_error(char *msg)
{
TermGfx();
puts("SYSTEM FATAL ERROR:\n");
puts(msg);
exit(1);
}

/*
	initialise the graphics display
*/

void InitGfx(int VM)
{
FILE *fp;

fp = fopen("font.dat","rb");
if(!fp)
       {
       puts("Cannot load font");
       exit(1);
       }
fread(bfont,sizeof(bfont),1,fp);
fclose(fp);

        V_on(VM);
	printf( "Switching to graphics mode...\n");

	swapscreen=(char *)malloc(640000);
	if(!swapscreen)
		{
		printf("Can't Initialise graphics\n");
		printf("Out of memory\n");
		exit(1);
		}

	_copy=(char *)malloc(640000);
	if(!_copy)
		{
		printf("Can't Initialise graphics\n");
		printf("Out of memory\n");
		exit(1);
		}

	if(!on())
		{
		printf("Can't Initialise graphics\n");
		printf("The VESA mode 110h (640x480x32k) is not available\n");
		exit(1);
		}



//	setbkcolor( BLACK);
	ScrMaxX = 640;
	ScrMaxY = 480;
	ScrCenterX = ScrMaxX / 2;
	ScrCenterY = ScrMaxY / 2;
}



/*
	terminate the graphics display
*/

void TermGfx()
{
off();
}


/*
   clear the screen
*/

void ClearScreen()
{
memset(swapscreen,640000,CURCOL);
}



/*
	set the current drawing color
*/

void SetColor( int color)
{
		CURCOL=color;
}

void setcolor( int color)
{
		CURCOL=color;
}




/*
	draw a line on the screen from screen coords
*/

void DrawScreenLine( int Xstart, int Ystart, int Xend, int Yend)
{
	ITGline( Xstart, Ystart, Xend, Yend,CURCOL,swapscreen);
}



/*
	draw a filled in box on the screen from screen coords
*/

void DrawScreenBox( int Xstart, int Ystart, int Xend, int Yend)
{
//	setfillstyle( 1, getcolor());
	fbox( Xstart, Ystart, Xend, Yend,CURCOL,swapscreen);
}



/*
	draw a filled-in 3D-box on the screen from screen coords
*/

void DrawScreenBox3D( int Xstart, int Ystart, int Xend, int Yend)
{
	setfillstyle( 1, LIGHTGRAY);
	bar( Xstart + 1, Ystart + 1, Xend - 1, Yend - 1);
	SetColor( DARKGRAY);
	line( Xstart, Yend, Xend, Yend);
	line( Xend, Ystart, Xend, Yend);
	if (Xend - Xstart > 20 && Yend - Ystart > 20)
	{
		line( Xstart + 1, Yend - 1, Xend - 1, Yend - 1);
		line( Xend - 1, Ystart + 1, Xend - 1, Yend - 1);
		SetColor( WHITE);
		line( Xstart + 1, Ystart + 1, Xstart + 1, Yend - 1);
		line( Xstart + 1, Ystart + 1, Xend - 1, Ystart + 1);
	}
	SetColor( WHITE);
	line( Xstart, Ystart, Xend, Ystart);
	line( Xstart, Ystart, Xstart, Yend);
	SetColor( BLACK);
}

/*
	draw a filled-in 3D-box on the screen from screen coords
*/

void DrawSunkBox3D( int Xstart, int Ystart, int Xend, int Yend)
{
	setfillstyle( 1, LIGHTGRAY);
	bar( Xstart + 1, Ystart + 1, Xend - 1, Yend - 1);
	SetColor( WHITE);
	line( Xstart, Yend, Xend, Yend);
	line( Xend, Ystart, Xend, Yend);
	if (Xend - Xstart > 20 && Yend - Ystart > 20)
	{
		line( Xstart + 1, Yend - 1, Xend - 1, Yend - 1);
		line( Xend - 1, Ystart + 1, Xend - 1, Yend - 1);
		SetColor( DARKGRAY);
		line( Xstart + 1, Ystart + 1, Xstart + 1, Yend - 1);
		line( Xstart + 1, Ystart + 1, Xend - 1, Ystart + 1);
	}
	SetColor( DARKGRAY);
	line( Xstart, Ystart, Xend, Ystart);
	line( Xstart, Ystart, Xstart, Yend);
	SetColor( BLACK);
}


/*
	draw a hollow 3D-box on the screen from screen coords
*/

void DrawScreenBoxHollow( int Xstart, int Ystart, int Xend, int Yend)
{
   setfillstyle( 1,BLACK);
   bar( Xstart + 1, Ystart + 1, Xend - 1, Yend - 1);
   SetColor( WHITE);
	line( Xstart, Yend, Xend, Yend);
   line( Xend, Ystart, Xend, Yend);
   if (Xend - Xstart > 20 && Yend - Ystart > 20)
   {
      line( Xstart + 1, Yend - 1, Xend - 1, Yend - 1);
      line( Xend - 1, Ystart + 1, Xend - 1, Yend - 1);
      SetColor( DARKGRAY);
      line( Xstart + 1, Ystart + 1, Xstart + 1, Yend - 1);
      line( Xstart + 1, Ystart + 1, Xend - 1, Ystart + 1);
	}
	SetColor( DARKGRAY);
	line( Xstart, Ystart, Xend, Ystart);
	line( Xstart, Ystart, Xstart, Yend);
	SetColor( WHITE);
}



/*
	draw a meter bar on the screen from screen coords (in a hollow box); max. value = 1.0
*/

void DrawScreenMeter( int Xstart, int Ystart, int Xend, int Yend, float value)
{
   if (value < 0.0)
      value = 0.0;
   if (value > 1.0)
      value = 1.0;
   setfillstyle( 1, BLACK);
   bar( Xstart + 1 + (int) ((Xend - Xstart - 2) * value), Ystart + 1, Xend - 1, Yend - 1);
	setfillstyle( 1,  LIGHTGREEN);
	bar( Xstart + 1, Ystart + 1, Xstart + 1 + (int) ((Xend - Xstart - 2) * value), Yend - 1);
}


/*
	write text to the screen
*/

void DrawScreenChar( int Xstart, int Ystart, char msg)
{
	static int lastX;
	static int lastY;
	char temp[]={0,0};

	if (Xstart < 0)
		Xstart = lastX;
	if (Ystart < 0)
		Ystart = lastY;

	temp[0]=msg;
//	outtextxy( Xstart, Ystart, temp);
	print(Xstart,Ystart,temp,swapscreen,CURCOL,0);

	lastX = Xstart;
	lastY = Ystart + 10;  /* or textheight("W") ? */
}

/*
	write text to the screen
*/

void DrawScreenText( int Xstart, int Ystart, char *msg, ...)
{
	static int lastX;
	static int lastY;
	char temp[ 2048];
	va_list args;

	va_start( args, msg);
	vsprintf( temp, msg, args);
	va_end( args);
	if (Xstart < 0)
		Xstart = lastX;
	if (Ystart < 0)
		Ystart = lastY;
	print(Xstart,Ystart,temp,swapscreen,CURCOL,0);

	lastX = Xstart;
	lastY = Ystart + 10;  /* or textheight("W") ? */
}

/*
	Input name from list
*/

void InputNameFromList( int x0, int y0, char *prompt, int listsize, char **list, char *name)
{
	InputNameFromListWithFunc( x0, y0, prompt, listsize, list, 5, name, 0, 0, NULL);
}

/*
   ask for a name in a given list and call a function (for displaying objects, etc.)
*/

void InputNameFromListWithFunc( int x0, int y0, char *prompt, int listsize, char **list, int listdisp, char *name, int width, int height, void (*hookfunc)(int x1, int y1, char *name))
{
   int  key, n, l;
   int  x1, y1, x2, y2;
   int  maxlen;
	int ok, firstkey;

   listsize++;
   maxlen--;

	/* compute maxlen */
	maxlen = 1;
	for (n = 0; n < listsize; n++)
		if (strlen( list[ n]) > maxlen)
	 maxlen = strlen( list[ n]);
	for (n = strlen(name) + 1; n <= maxlen; n++)
		name[ n] = '\0';
	/* compute the minimum width of the dialog box */
	l = maxlen;
	if (strlen( prompt) > l + 13)
		l = strlen( prompt) - 13;
	l = l * 8 + 158;
	x1 = l + 3;
	y1 = 10 + 1;
	if (width > 0)
		l += 10 + width;
	if (height > 65)
		n = height + 20;
	else
                n = 112;
//		n = 85;
	if (x0 < 0)
		x0 = (ScrMaxX - l) / 2;
	if (y0 < 0)
		y0 = (ScrMaxY - n) / 2;
	x1 += x0;
	y1 += y0;
	if (x1 + width - 1 < ScrMaxX)
		x2 = x1 + width - 1;
	else
		x2 = ScrMaxX;
	if (y1 + height - 1 < ScrMaxY)
		y2 = y1 + height - 1;
	else
		y2 = ScrMaxY;

	preserve();

	DrawScreenBox3D( x0, y0, x0 + l, y0 + n);
	DrawScreenBoxHollow( x0 + 10, y0 + 28, x0 + 241, y0 + 41);
	DrawScreenText( x0 + 10, y0 + 8, prompt);
	if (width > 0)
	{
		DrawScreenBox( x1, y1, x2 + 1, y2 + 1);
		setcolor( DARKGRAY);
		DrawScreenBox( x1 - 1, y1 - 1, x2, y2);
	}
	firstkey = TRUE;
	for (;;)
	{
		/* test if "name" is in the list */
		for (n = 0; n < listsize; n++)
	 if (strcmp( name, list[ n]) <= 0)
		 break;
		ok = n < listsize ? !strcmp( name, list[ n]) : FALSE;
		if (n > listsize - 1)
	 n = listsize - 1;
		/* display the "listdisp" next items in the list */
		setcolor( LIGHTGRAY);
		DrawScreenBox( x0 + 10, y0 + 48, x0 + 10 + 8 * maxlen, y0 + 48 + 10 * listdisp);
//		DrawScreenBox( x0 + 150, y0 + 30, x0 + 150 + 8 * maxlen, y0 + 30 + 10 * listdisp);
		setcolor( BLACK);
		for (l = 0; l < listdisp && n + l < listsize; l++)
	 DrawScreenText( x0 + 10, y0 + 48 + l * 10, list[ n + l]);
//	 DrawScreenText( x0 + 150, y0 + 30 + l * 10, list[ n + l]);
		l = strlen( name);
		DrawScreenBox( x0 + 11, y0 + 29, x0 + 240, y0 + 40);
		if (ok)
	 setcolor( WHITE);
		else
	 setcolor( LIGHTGRAY);
		DrawScreenText( x0 + 13, y0 + 31, name);
		if (hookfunc)
		{
//	 setviewport( x1, y1, x2, y2, TRUE);
//	 clearviewport();
	 hookfunc( x1, y1, name);
//	 setviewport( 0, 0, ScrMaxX, ScrMaxY, TRUE);
		}
		show();
		key = bioskey( 0);
		if (firstkey && (key & 0x00FF) >= ' ')
		{
	 for (l = 0; l <= maxlen; l++)
		 name[ l] = '\0';
	 l = 0;
		}
		firstkey = FALSE;
		if (l < maxlen && (key & 0x00FF) >= 'a' && (key & 0x00FF) <= 'z')
		{
	 name[ l] = key & 0x00FF + 'A' - 'a';
	 name[ l + 1] = '\0';
		}
		else if (l < maxlen && (key & 0x00FF) >= ' ')
		{
	 name[ l] = key & 0x00FF;
	 name[ l + 1] = '\0';
		}
		else if (l > 0 && (key & 0x00FF) == 0x0008)
	 name[ l - 1] = '\0';
		else if (n < listsize - 1 && (key & 0xFF00) == 0x5000)
	 strcpy(name, list[ n + 1]);
		else if (n > 0 && (key & 0xFF00) == 0x4800)
	 strcpy(name, list[ n - 1]);
		else if (n < listsize - listdisp && (key & 0xFF00) == 0x5100)
	 strcpy(name, list[ n + listdisp]);
		else if (n > 0 && (key & 0xFF00) == 0x4900)
		{
	 if (n > listdisp)
		 strcpy(name, list[ n - listdisp]);
	 else
		 strcpy(name, list[ 0]);
		}
		else if ((key & 0xFF00) == 0x4F00)
	 strcpy(name, list[ listsize - 1]);
		else if ((key & 0xFF00) == 0x4700)
	 strcpy(name, list[ 0]);
		else if ((key & 0x00FF) == 0x0009)
	 strcpy(name, list[ n]);
		else if (ok && (key & 0x00FF) == 0x000D)
	 break; /* return "name" */
		else if ((key & 0x00FF) == 0x001B)
		{
	 name[ 0] = '\0'; /* return an empty string */
	 break;
		}
	}
	restore();
	show();
}



/*
	ask for a name in a given list
*/

/*void InputNameFromList( int x0, int y0, char *prompt, int listsize, char **list, char *name)
{
	if (UseMouse)
		HideMousePointer();
	InputNameFromListWithFunc( x0, y0, prompt, listsize, list, 5, name, 0, 0, NULL);
	if (UseMouse)
		ShowMousePointer();
}*/

/*
	ask for a name in a given list
*/

/*void GetThumbFromList( int x0, int y0, char *prompt, int listsize, char **list, char *name)
{
	if (UseMouse)
		HideMousePointer();
	InputNameFromListWithFunc( x0, y0, prompt, listsize, list, 5, name, 0, 0, ShowThnByName);
	if (UseMouse)
		ShowMousePointer();
}*/



void InputFileName( int x0, int y0, char *prompt, int maxlen, char *filename)
{
	int   key, l, boxlen,l2;
	int  ok, firstkey;
	char *p;
        maxlen--;

	setcolor(WHITE);
	for (l = strlen(filename) + 1; l <= maxlen; l++)
      filename[ l] = '\0';
	/* compute the width of the input box */
   if (maxlen > 20)
      boxlen = 20;
   else
      boxlen = maxlen;
	/* compute the width of the dialog box */
   if (strlen( prompt) > boxlen)
      l = strlen( prompt);
   else
      l = boxlen;
   if (x0 < 0)
		x0 = (ScrMaxX - 26 - 8 * l) / 2;
	if (y0 < 0)
		y0 = (ScrMaxY - 50) / 2;
	/* draw the dialog box */
	l2=l;
	preserve();
	DrawScreenBox3D( x0, y0, x0 + 26 + 8 * l, y0 + 50);
	DrawScreenBoxHollow( x0 + 10, y0 + 28, x0 + 15 + 8 * boxlen, y0 + 41);
	DrawScreenText( x0 + 10, y0 + 8, prompt);
	firstkey = TRUE;
	for (;;)
	{
		/* check that "filename" looks like a valid file name */
		ok = TRUE;
		if (filename[ 1] == ':')
	 p = filename + 2;
		else
	 p = filename;
      for (l = 8; *p; p++)
      {
	 if (*p == '.')
	    l = 3;
	 else if (*p == '\\')
		 l = 8;
	 else
		 l--;
	 if (l < 0)
	 {
		 ok = FALSE;
		 break;
	 }
		}

		l = strlen( filename);
		setcolor( BLACK);
		DrawScreenBox( x0 + 11, y0 + 29, x0 + 14 + 8 * boxlen, y0 + 40);
		if (ok)
	 setcolor( WHITE);
		else
	 setcolor( LIGHTGRAY);
		if (l > boxlen)
		{
	 DrawScreenText( x0 + 11, y0 + 31, "<");
	 DrawScreenText( x0 + 13, y0 + 31, "<%s", filename + (l - boxlen + 1));
		}
		else
	 DrawScreenText( x0 + 13, y0 + 31, filename);
	show();
		key = bioskey( 0);
		if (firstkey && (key & 0x00FF) > ' ')
		{
	 for (l = 0; l <= maxlen; l++)
		 filename[ l] = '\0';
	 l = 0;
      }
      firstkey = FALSE;
      if (l < maxlen && (key & 0x00FF) >= 'a' && (key & 0x00FF) <= 'z')
      {
	 filename[ l] = key & 0x00FF + 'A' - 'a';
	 filename[ l + 1] = '\0';
      }
      else if (l < maxlen && (key & 0x00FF) > ' ')
      {
	 filename[ l] = key & 0x00FF;
	 filename[ l + 1] = '\0';
      }
		else if (l > 0 && (key & 0x00FF) == 0x0008)
	 filename[ l - 1] = '\0';
      else if (ok && (key & 0x00FF) == 0x000D)
	 break; /* return "filename" */
      else if ((key & 0x00FF) == 0x001B)
      {
	 filename[ 0] = '\0'; /* return an empty string */
	 break;
		}
	}
	restore();
	show();
}

void InputString( int x0, int y0, char *prompt, int maxlen, char *filename)
{
	int   key, l, boxlen,l2;
   int  ok=TRUE, firstkey;
   char *p;
   char evil[128];
   void *bground;
   maxlen--;

preserve();

	strcpy(evil,filename);
   setcolor(WHITE);
   for (l = strlen(filename) + 1; l <= maxlen; l++)
      filename[ l] = '\0';
   /* compute the width of the input box */
	if (maxlen > 20)
      boxlen = 20;
	else
      boxlen = maxlen;
	/* compute the width of the dialog box */
	if (strlen( prompt) > boxlen)
      l = strlen( prompt);
	else
      l = boxlen;
   if (x0 < 0)
      x0 = (ScrMaxX - 26 - 8 * l) / 2;
   if (y0 < 0)
      y0 = (ScrMaxY - 50) / 2;
   /* draw the dialog box */
   l2=l;
/*	bground=malloc(imagesize( x0, y0, x0 + 26 + 8 * l, y0 + 50));
	if(!bground)
	F_error("Out of memory");
	getimage( x0, y0, x0 + 26 + 8 * l, y0 + 50,bground);*/
   DrawScreenBox3D( x0, y0, x0 + 26 + 8 * l, y0 + 50);
   DrawScreenBoxHollow( x0 + 10, y0 + 28, x0 + 15 + 8 * boxlen, y0 + 41);
   DrawScreenText( x0 + 10, y0 + 8, prompt);
   firstkey = TRUE;
	for (;;)
	{
/*      // check that "filename" looks like a valid file name //
		ok = TRUE;
		if (filename[ 1] == ':')
	 p = filename + 2;
		else
	 p = filename;
		for (l = 8; *p; p++)
      {
	 if (*p == '.')
	    l = 3;
	 else if (*p == '\\')
	    l = 8;
	 else
		 l--;
	 if (l < 0)
	 {
		 ok = FALSE;
		 break;
	 }
		}*/

		l = strlen( filename);
		setcolor( BLACK);
		DrawScreenBox( x0 + 11, y0 + 29, x0 + 14 + 8 * boxlen, y0 + 40);
		if (ok)
	 setcolor( WHITE);
		else
	 setcolor( LIGHTGRAY);
		if (l > boxlen)
		{
	 DrawScreenText( x0 + 11, y0 + 31, "<");
	 DrawScreenText( x0 + 13, y0 + 31, "<%s", filename + (l - boxlen + 1));
		}
		else
	 DrawScreenText( x0 + 13, y0 + 31, filename);
         show();
		key = bioskey( 0);
		if (firstkey && (key & 0x00FF) >= ' ')
		{
	 for (l = 0; l <= maxlen; l++)
		 filename[ l] = '\0';
	 l = 0;
		}
		firstkey = FALSE;
		if (l < maxlen && (key & 0x00FF) >= 'a' && (key & 0x00FF) <= 'z')
		{
	 filename[ l] = key & 0x00FF + 'A' - 'a';
	 filename[ l + 1] = '\0';
		}
		else if (l < maxlen && (key & 0x00FF) >= ' ')
      {
	 filename[ l] = key & 0x00FF;
         if(filename[ l] == ' ')     // No spaces allowed
             filename[ l]='_';
	 filename[ l + 1] = '\0';
      }
      else if (l > 0 && (key & 0x00FF) == 0x0008)
	 filename[ l - 1] = '\0';
		else if (ok && (key & 0x00FF) == 0x000D)
	 break; /* return "filename" */
      else if ((key & 0x00FF) == 0x001B)
      {
	 strcpy(filename,evil);
//	 filename[ 0] = '\0'; /* return an empty string */
	 break;
      }
   }
/*putimage( x0, y0,bground,COPY_PUT);
	if (UseMouse)
		ShowMousePointer();
		free(bground);*/
restore();
show();
}


void InputIString( int x0, int y0, char *prompt, int maxlen, char *filename)
{
	int   key, l, boxlen,l2;
   int  ok=TRUE, firstkey;
   char *p;
   char evil[2048];
   void *bground;
   maxlen--;

preserve();

	strcpy(evil,filename);
   setcolor(WHITE);
   for (l = strlen(filename) + 1; l <= maxlen; l++)
      filename[ l] = '\0';
   /* compute the width of the input box */
	if (maxlen > 70)
      boxlen = 70;
	else
      boxlen = maxlen;
	/* compute the width of the dialog box */
	if (strlen( prompt) > boxlen)
      l = strlen( prompt);
	else
      l = boxlen;
   if (x0 < 0)
      x0 = (ScrMaxX - 26 - 8 * l) / 2;
   if (y0 < 0)
      y0 = (ScrMaxY - 50) / 2;
   /* draw the dialog box */
   l2=l;

   DrawScreenBox3D( x0, y0, x0 + 26 + 8 * l, y0 + 50);
   DrawScreenBoxHollow( x0 + 10, y0 + 28, x0 + 15 + 8 * boxlen, y0 + 41);
   DrawScreenText( x0 + 10, y0 + 8, prompt);
   firstkey = TRUE;
	for (;;)
	{

		l = strlen( filename);
		setcolor( BLACK);
		DrawScreenBox( x0 + 11, y0 + 29, x0 + 14 + 8 * boxlen, y0 + 40);
		if (ok)
	 setcolor( WHITE);
		else
	 setcolor( LIGHTGRAY);
		if (l > boxlen)
		{
	 DrawScreenText( x0 + 11, y0 + 31, "<");
	 DrawScreenText( x0 + 13, y0 + 31, "<%s", filename + (l - boxlen + 1));
		}
		else
	 DrawScreenText( x0 + 13, y0 + 31, filename);
         show();
		key = bioskey( 0);
		if (firstkey && (key & 0x00FF) >= ' ')
		{
	 for (l = 0; l <= maxlen; l++)
		 filename[ l] = '\0';
	 l = 0;
		}
		firstkey = FALSE;

/*		if (l < maxlen && (key & 0x00ff) >= ' ')
		{
	 filename[ l] = key & 0x00FF + 'A' - 'a';
	 filename[ l + 1] = '\0';
		}
		else*/
      if (l < maxlen && (key & 0x00FF) >= ' ')
      {
	 filename[ l] = key & 0x00FF;
	 filename[ l + 1] = '\0';
      }
      else if (l > 0 && (key & 0x00FF) == 0x0008)
	 filename[ l - 1] = '\0';
		else if (ok && (key & 0x00FF) == 0x000D)
	 break; // return "filename"

      else
      if ((key & 0x00FF) == 0x001B)
      {
	 strcpy(filename,evil);
//	 filename[ 0] = '\0'; // return an empty string
	 break;
      }
   }
/*putimage( x0, y0,bground,COPY_PUT);
	if (UseMouse)
		ShowMousePointer();
		free(bground);*/
restore();
show();
}

/*
	ask for confirmation (prompt2 may be NULL)
*/

int Confirm( int x0, int y0, char *prompt1, char *prompt2)
{
	int key;
	int maxlen = 46;

	if (strlen( prompt1) > maxlen)
		maxlen = strlen( prompt1);
	if (prompt2 != NULL && strlen( prompt2) > maxlen)
		maxlen = strlen( prompt2);
	if (x0 < 0)
		x0 = (ScrMaxX - 22 - 8 * maxlen) / 2;
	if (y0 < 0)
		y0 = (ScrMaxY - (prompt2 ? 53 : 43)) / 2;
/*   bground=GetMemory(imagesize( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43)));
	if(!bground)
		F_error("Out of memory");
	getimage( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43),bground);*/

	preserve();

	DrawScreenBox3D( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43));
	setcolor( WHITE);
	DrawScreenText( x0 + 10, y0 + 8, prompt1);
	if (prompt2 != NULL)
		DrawScreenText( x0 + 10, y0 + 18, prompt2);
	setcolor( WHITE/*YELLOW*/);
	DrawScreenText( x0 + 10, y0 + (prompt2 ? 38 : 28), "Press Y to confirm, or any other key to cancel");
	show();
	key = bioskey( 0);
//	putimage( x0, y0,bground,COPY_PUT);
	restore();
	show();

//	free(bground);
	return ((key & 0x00FF) == 'Y' || (key & 0x00FF) == 'y');
}



/*
	display a notification and wait for a key (prompt2 may be NULL)
*/

int Notify( int x0, int y0, char *prompt1, char *prompt2)
{
void *bground;

	int key;
	int maxlen = 30;

	if (strlen( prompt1) > maxlen)
		maxlen = strlen( prompt1);
	if (prompt2 != NULL && strlen( prompt2) > maxlen)
		maxlen = strlen( prompt2);
	if (x0 < 0)
		x0 = (ScrMaxX - 22 - 8 * maxlen) / 2;
	if (y0 < 0)
		y0 = (ScrMaxY - (prompt2 ? 53 : 43)) / 2;

/*   bground=GetMemory(imagesize( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43)));
	if(!bground)
		F_error("Out of memory");
	getimage( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43),bground);*/
//   DrawRamMeter(ScrMaxX-14,16);
	preserve();
	DrawScreenBox3D( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43));
	setcolor( WHITE);
	DrawScreenText( x0 + 10, y0 + 8, prompt1);
	if (prompt2 != NULL)
		DrawScreenText( x0 + 10, y0 + 18, prompt2);
	setcolor(YELLOW);
	DrawScreenText( x0 + 10, y0 + (prompt2 ? 38 : 28), "Press any key to continue...");
	show();
	if((bioskey( 0)&0x00ff) ==0x001b)
		{
		restore();
      return 0;
		}
	restore();
//putimage( x0, y0,bground,COPY_PUT);
//		free(bground);
return 1;
}

void System( int x0, int y0, char *prompt1, char *prompt2,void (*MyFunc)())
{
void *bground;

	int key;
	int maxlen = 30;

	if (strlen( prompt1) > maxlen)
		maxlen = strlen( prompt1);
	if (prompt2 != NULL && strlen( prompt2) > maxlen)
		maxlen = strlen( prompt2);
	if (x0 < 0)
		x0 = (ScrMaxX - 22 - 8 * maxlen) / 2;
	if (y0 < 0)
		y0 = (ScrMaxY - (prompt2 ? 53 : 43)) / 2;

/*	bground=GetMemory(imagesize( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43)));
	if(!bground)
		F_error("Out of memory");
	getimage( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43),bground);*/
//   DrawRamMeter(ScrMaxX-14,16);
	DrawScreenBox3D( x0, y0, x0 + 22 + 8 * maxlen, y0 + (prompt2 ? 53 : 43));
	setcolor( WHITE);
	DrawScreenText( x0 + 10, y0 + 8, prompt1);
	if (prompt2 != NULL)
		DrawScreenText( x0 + 10, y0 + 18, prompt2);
	setcolor(YELLOW);

	show();
	sleep(1);
   MyFunc();

	//	DrawScreenText( x0 + 10, y0 + (prompt2 ? 38 : 28), "Press any key to continue...");
//	bioskey( 0);
//	putimage( x0, y0,bground,COPY_PUT);
//	free(bground);
}

/*
	display the integer input box
*/

int InputInteger( int x0, int y0, int *valp, int minv, int maxv)
{
   int  key, val;
   int neg, ok, firstkey;

   DrawScreenBoxHollow( x0, y0, x0 + 121, y0 + 13);
	neg = (*valp < 0);
	val = neg ? -(*valp) : *valp;
	firstkey = TRUE;
	for (;;)
	{
		ok = (neg ? -val : val) >= minv && (neg ? -val : val) <= maxv;
		setcolor( BLACK);
		DrawScreenBox( x0 + 1, y0 + 1, x0 + 120, y0 + 12);
		if (ok)
	 setcolor( WHITE);
		else
	 setcolor( LIGHTGRAY);
		if (neg)
	 DrawScreenText( x0 + 3, y0 + 3, "-%d", val);
		else
	 DrawScreenText( x0 + 3, y0 + 3, "%d", val);
		show();
		key = bioskey( 0);
		if (firstkey && (key & 0x00FF) > ' ')
		{
	 val = 0;
	 neg = FALSE;
		}
		firstkey = FALSE;
//		if (val < 3275 && (key & 0x00FF) >= '0' && (key & 0x00FF) <= '9')

		if (val < MAXDIV10 && (key & 0x00FF) >= '0' && (key & 0x00FF) <= '9')
	 val = val * 10 + (key & 0x00FF) - '0';
		else if (val > 0 && (key & 0x00FF) == 0x0008)
	 val = val / 10;
		else if (neg && (key & 0x00FF) == 0x0008)
	 neg = FALSE;
		else if ((key & 0x00FF) == '-')
	 neg = !neg;
		else if (ok && (key & 0x00FF) == 0x000D)
	 break; /* return "val" */
		else if ((key & 0xFF00) == 0x4800 || (key & 0xFF00) == 0x5000 ||
			 (key & 0xFF00) == 0x4B00 || (key & 0xFF00) == 0x4D00 ||
			 (key & 0x00FF) == 0x0009 || (key & 0xFF00) == 0x0F00)
	 break; /* return "val", even if not valid */
		else if ((key & 0x00FF) == 0x001B)
		{
	 val = INVALID; /* return a value out of range */
	 break;
		}
	}
	if (neg)
		*valp = -val;
	else
		*valp = val;
	return key;
}



/*
	ask for an integer value and check for minimum and maximum
*/

int InputIntegerValue( int x0, int y0, int minv, int maxv, int defv)
{
	int  val, key;
   char prompt[ 80];
   void *bground;

   sprintf( prompt, "Enter a number (%d-%d):", minv, maxv);
	if (x0 < 0)
      x0 = (ScrMaxX - 25 - 8 * strlen( prompt)) / 2;
   if (y0 < 0)
      y0 = (ScrMaxY - 55) / 2;

	preserve();
	DrawScreenBox3D( x0, y0, x0 + 25 + 8 * strlen( prompt), y0 + 55);
	setcolor( WHITE);
	DrawScreenText( x0 + 10, y0 + 8, prompt);
	val = defv;
	while (((key = InputInteger( x0 + 10, y0 + 28, &val, minv, maxv)) & 0x00FF) != 0x000D && (key & 0x00FF) != 0x001B) show();
	if(val==INVALID)
	val=defv;
	restore();
	return val;
}



void DisplayMessage( int x0, int y0, char *msg, ...)
{
	char prompt[ 120];
	va_list args;

   va_start( args, msg);
   vsprintf( prompt, msg, args);
   va_end( args);

//   cleardevice();
	if (x0 < 0)
		x0 = (ScrMaxX - 40 - 8 * strlen( prompt)) / 2;
	if (y0 < 0)
		y0 = (ScrMaxY - 40) / 2;
	DrawScreenBox3D( x0, y0, x0 + 40 + 8 * strlen( prompt), y0 + 40);
	DrawScreenText( x0 + 20, y0 + 17, prompt);
	show();
}


void Box(int a,int b,int c,int d)
{
line(a,b,c,b);
line(a,d,c,d);
line(a,b,a,d);
line(c,b,c,d);
}

/*void ShowThnByName(int x,int y,char *name)
{
int ctr;

for(ctr=0;ctr<=B_listlen;ctr++)
	if(!strcmp(name,B_list[ctr]))
		{
		putimage(14,36,thn[ctr],COPY_PUT);
		return;
		}

setfillstyle(BLACK,1);
bar(14,36,334,236);
setcolor(WHITE);
line(14,36,334,236);
line(334,36,14,236);
//Notify(-1,-1,"Could not find thumbnail!",name);
}*/

/*
	clear the screen and display a message
*/

void print(int x,int y,char *ptr,char *scr,short fc,short bc)
{
char len;
int ctr,nx,ny;

len=strlen(ptr);
nx=x;
ny=y;
for(ctr=0;ctr<len;ctr++)
    {
    I32font(nx,ny,bfont[ptr[ctr]],fc,scr);
    nx+=8;
    }
}

void print2(int x,int y,char *ptr,char *scr,short fc,short bc)
{
char len;
int ctr,nx,ny;

//return;
len=strlen(ptr);
nx=x;
ny=y;
for(ctr=0;ctr<len;ctr++)
	{
#ifdef LINEACT
	if(bc)
		fbox2(nx,ny,16,16,bc,scr);
#endif
		for(int ctr4=0;ctr4<8;ctr4++)
			{
			if(bfont[ptr[ctr]][ctr4]&128)
				fbox2(nx,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&64)
				fbox2(nx+2,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&32)
				fbox2(nx+4,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&16)
				fbox2(nx+6,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&8)
				fbox2(nx+8,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&4)
				fbox2(nx+10,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&2)
				fbox2(nx+12,ny+(ctr4<<1),2,2,fc,scr);

			if(bfont[ptr[ctr]][ctr4]&1)
				fbox2(nx+14,ny+(ctr4<<1),2,2,fc,scr);
			}
	nx+=16;
	}
}

void ClipBox(int x,int y,int w,int h,int col,char *screen)
{
    int max,may,mix,miy;        // X,Y pairs, major, minor

    mix = x;
    if(mix < 0)
        mix = 0;
    if(mix > ScrMaxX)
        mix = ScrMaxX;

    max = x + w;
    if(max < 0)
        max = 0;
    if(max > ScrMaxX)
        max = ScrMaxX;

    miy = y;
    if(miy < 0)
        miy = 0;
    if(miy > ScrMaxY)
        miy = ScrMaxY;

    may = y + h;
    if(may < 0)
        may = 0;
    if(may > ScrMaxY)
        may = ScrMaxY;

    ITG_box(mix,miy,max,may,col,screen);
}

/* end of file */
