/*
 *  IGUI.CC - IT-HE GUI library
 */

#include <bios.h>
#include <go32.h>
#include <dpmi.h>

#include "../itg/itg.h"
#include "igui.hpp"
#include "../loaders.hpp"
#include "../memory.hpp"
#include "../core.hpp"
#include "../oscli.hpp"
#include "menusys.h"
#include "../rgb_conv.hpp"


// Defines

// Variables

unsigned short ITG_LIGHTGRAY;
unsigned short ITG_LIGHTGREEN;
unsigned short ITG_DARKGRAY;
unsigned short ITG_YELLOW;
unsigned short ITG_RED;
unsigned short ITG_DARKRED;


SPRITE mp;
SPRITE mpb;

static int max_buttons;
static BUTTON *ButtonList;
static KEYBIND KeyList[128];

char *swapscreen=NULL;
char running,dragflag,didkill=0;
int focus,x,y,z;        // Focal button, Mouse X,Y and buttonlevel (z)
static char firsttime=1;

// Functions

void IG_Init(int max_button);
void IG_Term();

static void GetMouse(int *x,int *y,int *z);
static void InitMouse();

// Code

// Initialise the library

void IG_Init(int max_button)
    {
    if(max_buttons)
        return;

    InitGfx(VideoMode);

    ITG_LIGHTGRAY=MakeRGB(128,128,128);     //0 10000 10000 10000   lgray  4210
    ITG_DARKGRAY=MakeRGB(96,96,96);         //0 01100 01100 01100   dgray  318c
    ITG_YELLOW=MakeRGB(255,255,0);          //0 11111 11111 00000   yellow 7fe0
    ITG_RED=MakeRGB(200,0,0);               //0 11001 00000 00000   red    6400
    ITG_LIGHTGREEN=MakeRGB(0,200,0);        //0 00000 11001 00000   lgreen 0210

    ITG_DARKRED=MakeRGB(160,0,0);

//#define LIGHTGRAY 0x4210
//#define LIGHTGREEN 0x4210
//#define DARKGRAY 0x318c
//#define YELLOW 0x7fe0
//#define RED 0x6400

    InitMouse();

    max_buttons = max_button;
    ButtonList = (BUTTON *)M_get(sizeof(BUTTON),max_buttons);
    load_CEL(&mp,"arrow0.cel");
    load_CEL(&mpb,"arrow0.cel");
    running = 1;

    x = 100;
    y = 300;
//    IG_Panel(90,290,64,64);  // A small grey area for the mouse pointer
//    mpb.get_sprite(x-4,y-4,swapscreen);  // Get the grey stuff into 2buffer

    }

// Shut down the library

void IG_Term()
    {
    if(!max_buttons)
        return;

    TermGfx();

    M_free(ButtonList);
    running = 0;
    }

// Create a common-or-garden button

int IG_TextButton(int nx,int ny,char *text,FPTR l,FPTR m,FPTR r)
   {
    int ID;
    ID = firstfree();
    ButtonList[ID].text = text;
    ButtonList[ID].intext = text;
    ButtonList[ID].textlen = strlen(text);
    ButtonList[ID].flag |= 1;

    ButtonList[ID].w=(ButtonList[ID].textlen+1)*8;
    ButtonList[ID].h=3*8;


    ButtonList[ID].x=nx;
    ButtonList[ID].y=ny;

    ButtonList[ID].x2=nx+ButtonList[ID].w;
    ButtonList[ID].y2=ny+ButtonList[ID].h;

    ButtonList[ID].state=ST_OUT;
    ButtonList[ID].type=NORMAL;

    ButtonList[ID].left_ptr=l;
    ButtonList[ID].right_ptr=r;
    ButtonList[ID].middle_ptr=m;

    draw_button(ID);
    return ID;
}

// Create a button with no physical appearance.  Used for tile bars, maps etc

int IG_Region(int nx,int ny,int w,int h,FPTR l,FPTR m,FPTR r)
   {
    int ID;
    ID = firstfree();
    ButtonList[ID].flag |= 1;

    ButtonList[ID].w=w;
    ButtonList[ID].h=h;
    ButtonList[ID].x=nx;
    ButtonList[ID].y=ny;

    ButtonList[ID].x2=nx+ButtonList[ID].w;
    ButtonList[ID].y2=ny+ButtonList[ID].h;

    ButtonList[ID].state=0;
    ButtonList[ID].type=REGION;

    ButtonList[ID].left_ptr=l;
    ButtonList[ID].right_ptr=r;
    ButtonList[ID].middle_ptr=m;

    draw_button(ID);
    return ID;
}

// Create a button that looks like an input box

int IG_InputButton(int nx,int ny,char *text,FPTR l,FPTR m,FPTR r)
    {
    int ID;
    ID = firstfree();
    ButtonList[ID].text = text;
    ButtonList[ID].textlen = strlen(text);
    ButtonList[ID].flag |= 1;
    ButtonList[ID].intext = text;

    ButtonList[ID].w=(ButtonList[ID].textlen+1)*8;
    ButtonList[ID].h=3*8;


    ButtonList[ID].x=nx;
    ButtonList[ID].y=ny;

    ButtonList[ID].x2=nx+ButtonList[ID].w;
    ButtonList[ID].y2=ny+ButtonList[ID].h;

    ButtonList[ID].state=ST_OUT;
    ButtonList[ID].type=SUNK;

    ButtonList[ID].left_ptr=l;
    ButtonList[ID].right_ptr=r;
    ButtonList[ID].middle_ptr=m;

    draw_button(ID);
    return ID;
}

// Create a toggle button that reads and writes to an INT with the flag

int IG_ToggleButton(int nx,int ny,char *text,FPTR l,FPTR m,FPTR r,int *tog)
    {
    int ID;
    ID = firstfree();
    ButtonList[ID].text = text;
    ButtonList[ID].textlen = strlen(text);
    ButtonList[ID].flag |= 1;
    ButtonList[ID].intext = text;

    ButtonList[ID].w=(ButtonList[ID].textlen+1)*8;
    ButtonList[ID].h=3*8;

    ButtonList[ID].x=nx;
    ButtonList[ID].y=ny;

    ButtonList[ID].x2=nx+ButtonList[ID].w;
    ButtonList[ID].y2=ny+ButtonList[ID].h;

    ButtonList[ID].state=NULL;
    ButtonList[ID].type=TOGGLE;

    ButtonList[ID].left_ptr=l;
    ButtonList[ID].right_ptr=r;
    ButtonList[ID].middle_ptr=m;
    ButtonList[ID].toggle = tog;

    draw_button(ID);
    return ID;
}

// Create a menu tab

int IG_Tab(int nx,int ny,char *text,FPTR l,FPTR m,FPTR r)
    {
    int ID;
    ID = firstfree();
    ButtonList[ID].text = text;
    ButtonList[ID].intext = text;
    ButtonList[ID].textlen = strlen(text);
    ButtonList[ID].flag |= 1;

    ButtonList[ID].w=(ButtonList[ID].textlen+1)*8;
    ButtonList[ID].h=3*8;


    ButtonList[ID].x=nx;
    ButtonList[ID].y=ny;

    ButtonList[ID].x2=nx+ButtonList[ID].w;
    ButtonList[ID].y2=ny+ButtonList[ID].h;

    ButtonList[ID].state=ST_3;
    ButtonList[ID].type=RADIOBUTTON;

    ButtonList[ID].left_ptr=l;
    ButtonList[ID].right_ptr=r;
    ButtonList[ID].middle_ptr=m;

    draw_button(ID);
    return ID;
    }

// (re)set text displayed when the button is out

void IG_UpdateText(int ID,char *text)
{
    ButtonList[ID].text = text;
    draw_button(ID);
}

// Set text displayed when the button is sunk in

void IG_SetInText(int ID,char *text)
{
    ButtonList[ID].intext = text;
    draw_button(ID);
}

// Sink a button in

void IG_SetFocus(int ID)
{
    ButtonList[ID].state = ST_IN;
    draw_button(ID);
}

// Pop a button out

void IG_ResetFocus(int ID)
{
    ButtonList[ID].state = ST_OUT;
    draw_button(ID);
}

// Draw a panel

void IG_Panel(int x,int y,int w,int h)
{
DrawScreenBox3D(x,y,x+w,y+h);
}

// Draw a hollow panel

void IG_BlackPanel(int x,int y,int w,int h)
{
DrawScreenBoxHollow(x,y,x+w,y+h);
}

// Kill all buttons and bindings

void IG_KillAll()
{
/*
for(int ctr=0;ctr<max_buttons;ctr++)
    {
    ButtonList[ctr].flag=0;
    ButtonList[ctr].text=NULL;
    }
*/

memset(&ButtonList[0],0,sizeof(ButtonList[0])*max_buttons);

for(int ctr=0;ctr<128;ctr++)
    KeyList[ctr].key=0;
didkill=1;
}

// Add a key to the key binding list

void IG_AddKey(int key,FPTR ptr)
{
for(int ctr=0;ctr<128;ctr++)
   if(!KeyList[ctr].key)
       {
       KeyList[ctr].key = key;
       KeyList[ctr].DoKey= ptr;
       return;
       }
}

// Draw some text on the screen

void IG_Text(int nx,int ny,char *text,int colour)
{
int c;
c = getcolor();
setcolor(colour);
DrawScreenText(nx,ny,text);
setcolor(c);
}



/*
 *      Dispatcher loop
 */

void IG_Dispatch()
{
int KBD_hit,key_;
static int x1=100,y1=300,z2;

z=0;

/*    if(!no_of_buttons)
        {
	Notify(-1,-1,"All buttons have been destroyed!",NULL);
	running=0;
	}
*/

/*
      if(warn_max >-1)
	 if( coreleft() < warn_max)
		{
		if(Confirm(-1,-1,"There is less than 768k of memory left","Do you want to quit now?"))
			running=0;
		else
			{
         Notify(-1,-1,"On your head be it!!",NULL);
			warn_max=-1;
			}
		}
*/


KBD_hit=0;

GetMouse(&x1,&y1,&z);

if(firsttime)
    {
    mpb.get_sprite(x-4,y-4,swapscreen);
    firsttime=0;
    }

mpb.block_put_sprite(x-4,y-4,swapscreen);

   x=x1;y=y1;

GetMouse(&x1,&y1,&z);

		mpb.get_sprite(x-4,y-4,swapscreen);
		mp.cel_put_sprite(x-4,y-4,swapscreen);
//		KBD_hit=1;

	if(bioskey(1))
		{
		mpb.block_put_sprite(x-4,y-4,swapscreen);
		//key_=getch();//bioskey(0);
                key_ = bioskey(0);

                // Special cases first

                switch(key_&0xff)
                   {
                   case 0x1b:
                   key_ = 0x1b;
                   break;

                   case 0x0d:
                   key_ = 0x0d;
                   break;

                   default:
                   key_ = key_>>8;
                   };

		for(int ctrx=0;ctrx<128;ctrx++)
                    if( key_ == KeyList[ctrx].key)
                        if(KeyList[ctrx].DoKey)
                            {
//                            printf("Hit key %d [%d] funcptr = %x\n",ctrx,KeyList[ctrx].key,KeyList[ctrx].DoKey);
//                            fflush(stdout);
                            KeyList[ctrx].DoKey();
                            }


		mpb.get_sprite(x-4,y-4,swapscreen);
		mp.cel_put_sprite(x-4,y-4,swapscreen);
		}

	// Mouse or keyboard motion, update the screen
if(KBD_hit==1)
    show();

/*
	if(testmode)
		{
		gotoxy(1,23);
		printf("%d %d    ",x,y);
		}
*/
        didkill=0;

	if(z&&running)
		{
		for(int ctr=0;ctr<=max_buttons;ctr++)
			if(x>=ButtonList[ctr].x&&x<=ButtonList[ctr].x2)
				if(y>=ButtonList[ctr].y&&y<=ButtonList[ctr].y2)
					{
					z2=1;
					if(z==1&&ButtonList[ctr].left_ptr==UNUSED)
						z2=0;
					if(z==2&&ButtonList[ctr].right_ptr==UNUSED)
						z2=0;
					if(z==3&&ButtonList[ctr].middle_ptr==UNUSED)
						z2=0;
					if(z2)
						{
						if(ButtonList[ctr].type==TOGGLE)
                                                        *ButtonList[ctr].toggle = !(*ButtonList[ctr].toggle);
						else
							ButtonList[ctr].state=ST_IN;
						mpb.block_put_sprite(x-4,y-4,swapscreen);
						draw_button(ctr);
						show();

						if(z==1)
							ButtonList[ctr].left_ptr();
						if(z==2)
							ButtonList[ctr].right_ptr();
						if(z==3)
							ButtonList[ctr].middle_ptr();
//                                                pause();
                                                if(!didkill)
                                                    {
                                                    switch(ButtonList[ctr].type)
							{
							case NORMAL:
							case UNDEFINED:
							ButtonList[ctr].state=ST_OUT;
							break;
							}

                                                    draw_button(ctr);
                                                    }

                                                GetMouse(&x,&y,&z);

                                                mpb.get_sprite(x-4,y-4,swapscreen);
                                                }
					}
		ButtonList[focus].state=ST_IN;
		show();
		}
	if(dragflag) dragflag--;
}

// Get the mouse position an button state

void GetMouse(int *x,int *y,int *z)
{
    __dpmi_regs r;
    r.x.ax = 3;
    __dpmi_int(0x33, &r);         /* utilize mouse driver */
    *x=r.x.cx;
    *y=r.x.dx;
    *z=r.x.bx;

    if(*x>2000 || *x<0)
        *x = 100;
    if(*y>2000 || *y<0)
        *y = 100;
}

// Set up the mouse

void InitMouse()
{
    __dpmi_regs r;
    r.x.ax = 0;
    __dpmi_int(0x33, &r);         /* initialise mouse driver */

    if(r.x.ax == 0)
        panic("Init mouse","You need a mouse to run this program.",NULL);

    r.x.ax = 2;
    __dpmi_int(0x33, &r);         /* Squash any mouse pointer */

    // Set mouse boundaries

    r.x.ax = 7;
    r.x.cx = 4;                   // Minimum X
    r.x.dx = 640 - 8;             // Screen Width - 8
    __dpmi_int(0x33, &r);         /* Squash any mouse pointer */

    r.x.ax = 8;
    r.x.cx = 4;                   // Minimum Y
    r.x.dx = 480 - 8;             // Screen Height - 8
    __dpmi_int(0x33, &r);         /* Squash any mouse pointer */

    r.x.ax = 4;
    r.x.cx = 100;
    r.x.dx = 300;
    __dpmi_int(0x33, &r);         /* Move to known position */

}

// Find the first unused button

int firstfree()
{
for(int ctr=0;ctr<max_buttons;ctr++)
    if(!(ButtonList[ctr].flag & 1))
        return ctr;
}

// Draw each type of button

void draw_button(int no)
{

switch(ButtonList[no].type)
	{
	case NORMAL:
	case RADIOBUTTON:
	if(ButtonList[no].state==ST_OUT)
		{
		setcolor(BLACK);
		DrawScreenBox3D(ButtonList[no].x,ButtonList[no].y,ButtonList[no].x2,ButtonList[no].y2);
		DrawScreenText(ButtonList[no].x+4,ButtonList[no].y+8,ButtonList[no].text);
		}

	if(ButtonList[no].state==ST_IN)
		{
		setcolor(BLACK);
		DrawSunkBox3D(ButtonList[no].x,ButtonList[no].y,ButtonList[no].x2,ButtonList[no].y2);
		DrawScreenText(ButtonList[no].x+6,ButtonList[no].y+10,ButtonList[no].intext);
		}

	if(ButtonList[no].state==ST_3)
		{
		setcolor(WHITE);
		DrawScreenBox3D(ButtonList[no].x,ButtonList[no].y,ButtonList[no].x2,ButtonList[no].y2);
		DrawScreenText(ButtonList[no].x+4,ButtonList[no].y+8,ButtonList[no].text);
		}
	break;

	case TOGGLE:
	DrawScreenBoxHollow(ButtonList[no].x,ButtonList[no].y,ButtonList[no].x2,ButtonList[no].y2);
        setcolor(WHITE);

        if(!ButtonList[no].toggle)
            panic("draw_button","Toggle Button has a NULL toggle pointer!",ButtonList[no].text);

        if(*ButtonList[no].toggle)
	    DrawScreenText(ButtonList[no].x+4,ButtonList[no].y+8,ButtonList[no].intext);
        else
	    DrawScreenText(ButtonList[no].x+4,ButtonList[no].y+8,ButtonList[no].text);
	break;

	case SUNK:
	DrawScreenBoxHollow(ButtonList[no].x,ButtonList[no].y,ButtonList[no].x2,ButtonList[no].y2);
        setcolor(WHITE);
	DrawScreenText(ButtonList[no].x+4,ButtonList[no].y+8,ButtonList[no].text);
	break;

	case REGION:
/*	if(TestGui==1)
		{
		setcolor(RED);
		Box(ButtonList[no].x,ButtonList[no].y,ButtonList[no].x2,ButtonList[no].y2);
		}
*/
	break;

	}
setcolor(WHITE);
}


int CMP(const void *a,const void *b)
{
return strcmp(*((char **)a),*((char **)b));
}

void pause()
{
delay(10);
}

void IG_WaitForRelease()
{
int x,y,z=1;
while(z) GetMouse(&x,&y,&z);
}
