/*

	Doom Editor Utility, by Brendon Wyber and Raphal Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README.1ST for more information.

	This program comes with absolutely no warranty.

	DEU.H - Main doom defines.
*/

/* the includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
//#include <graphics.h>
#include <malloc.h>

extern char *swapscreen;

#define CONTACT "Please notify boff@globalnet.co.uk"

typedef int Bool;               /* Boolean data: true or false */

/*
	the macros and constants
*/

/* boolean constants */
#define TRUE			1
#define FALSE			0

/*
	the interfile global variables
*/

/* from deu.c */
//extern Bool  SwapButtons;	/* swap right and middle mouse buttons */

/* from gfx.c */
extern int GfxMode;		/* current graphics mode, or 0 for text */
extern int Scale;		/* scale to draw map 20 to 1 */
extern int OrigX;		/* the X origin */
extern int OrigY;		/* the Y origin */
extern int PointerX;		/* X position of pointer */
extern int PointerY;		/* Y position of pointer */
extern int ScrMaxX;		/* maximum X screen coord */
extern int ScrMaxY;		/* maximum Y screen coord */
extern int ScrCenterX;		/* X coord of screen center */
extern int ScrCenterY;		/* Y coord of screen center */
extern short CURCOL;

/* from mouse.c */
extern Bool UseMouse;		/* is there a mouse driver? */


/*
	the function prototypes
*/

/* from deu.c */
//int main( int, char *[]);
void *GetMemory( size_t);
void *ResizeMemory( void *, size_t);
void *GetFarMemory( unsigned long size);
void *ResizeFarMemory( void *old, unsigned long size);

/* from gfx.c */
void InitGfx( int z);
void TermGfx( void);
void ClearScreen( void);
void SetColor( int);
void DrawScreenLine( int, int, int, int);
void DrawScreenBox( int, int, int, int);
void DrawScreenBox3D( int, int, int, int);
void DrawSunkBox3D( int, int, int, int);
void DrawScreenBoxHollow( int, int, int, int);
void DrawScreenMeter( int, int, int, int, float);
void DrawScreenText( int, int, char *, ...);
void DrawScreenChar( int Xstart, int Ystart, char msg);
void Box(int a,int b,int c,int d);

//void DrawPointer( void);

/* from mouse.c */
extern "C" {
void CheckMouseDriver( void);
void ShowMousePointer( void);
void HideMousePointer( void);
void GetMouseCoords( int *, int *, int *);
void SetMouseCoords( int, int);
void SetMouseLimits( int, int, int, int);
void ResetMouseLimits( void);
void SetMouseSensitivity( int, int);
void RAM();
}
void InputNameFromListWithFunc( int, int, char *, int, char **, int, char *, int, int, void (*hookfunc)(int, int, char *));
void InputNameFromList( int, int, char *, int, char **, char *);
void GetThumbFromList( int x0, int y0, char *prompt, int listsize, char **list, char *name);
int InputInteger( int, int, int *, int, int);
int InputIntegerValue( int, int, int, int, int);
void InputFileName( int, int, char *, int, char *);
void InputString( int, int, char *, int, char *);
void InputIString( int, int, char *, int, char *);
Bool Confirm( int, int, char *, char *);
int Notify( int, int, char *, char *);
void System(int, int, char *,char *,void (*)());
void DisplayMessage( int, int, char *, ...);


void St();
void Fi();
void F_error(char *msg);

void B_close(FILE *fp);
FILE *B_open(char *a,char *b);
void DisplayMessage( int x0, int y0, char *msg, ...);

#define bar(a,b,c,d) fbox(a,b,c,d,CURCOL,swapscreen)
#define line(a,b,c,d) ITGline(a,b,c,d,CURCOL,swapscreen)
#define getcolor() CURCOL
#define show();	update(swapscreen);

void setfillstyle(int a,int b);
void setcolor( int);
void print(int x,int y,char *ptr,char *scr,short fc,short bc);
void print2(int x,int y,char *ptr,char *scr,short fc,short bc);

void ClipBox(int x,int y,int w,int h,int colour,char *screen);

// These colours value depends on the bpp level.

// They are defined indirectly because otherwise the compiler will argue
// with me and try to impose it's corrupted colours over the proper ones.
// (They are defined in conio.h)

#define LIGHTGRAY  ITG_LIGHTGRAY
#define LIGHTGREEN ITG_LIGHTGREEN
#define DARKGRAY   ITG_DARKGRAY
#define YELLOW     ITG_YELLOW
#define RED        ITG_RED
#define DARKRED    ITG_DARKRED

extern unsigned short ITG_LIGHTGRAY;
extern unsigned short ITG_LIGHTGREEN;
extern unsigned short ITG_DARKGRAY;
extern unsigned short ITG_YELLOW;
extern unsigned short ITG_RED;
extern unsigned short ITG_DARKRED;

// These colours are the same in 15 or 16 bpp

#define BLACK 0
#define WHITE 0xffff
#define BLUE 31


#define INS 82
#define DEL 83
#define ENTER 0x0d

extern char __up[];
extern char __down[];
extern char __left[];
extern char __right[];

extern char __left2[];  // Double Left
extern char __right2[]; // Double Right

/* end of file */
