/*
 *  - Top Layer menu tab
 */


#include <stdio.h>
#include "igui.hpp"
#include "../memory.hpp"
#include "../console.hpp"
#include "../core.hpp"
#include "../script.hpp"
#include "../init.hpp"
#include "../linklist.hpp"
#include "menusys.h"

// DEFINES

// VARIABLES

static int sel_xoff=0;  // Offset from where we started the drag
static int sel_yoff=0;  // so that the dragging is centered on that spot
                        // i.e. we drag it by the point we first clicked on

extern int focus,TL_Id; // GUI variables

extern int MapXpos_Id,MapYpos_Id;       // Map X,Y coordinate boxes
extern char mapxstr[],mapystr[];

extern int s_proj;      // Flag, are layers being displayed?
extern int lx_proj;     // Flag, are other sprites being excluded? 1 = OFF
extern int mapx,mapy;   // Current map position
extern SPRITE transfer; // 256x256 Transfer buffer for screen clipping

extern LAYER *laysel;  // Object that is currently selected.  Can be NULL

static char last_sprite[32];  // Type of the Last sprite that was created

static char ll_pos_str[]="            ";
static int listpos_Id;

static char tag_str[]="            ";
static int tag_Id;

// FUNCTIONS

extern void pause();
extern void Toolbar();
extern void DrawMap(int x,int y,char s_proj,char l_proj,char f_proj);
static void Nothing();
static void clipmap();  // Make sure coordinates are within bounds

void TL_up();           // Panning functions
void TL_down();
void TL_left();
void TL_right();

void TL_QuickInsert();  // For fast replication of known objects
void TL_SlowInsert();   // For choosing and object before creating it
void TL_Edit();         // Choose the type
void TL_Delete();       // Delete it
void TL_Pick();         // Left click on the map to pick one up
void TL_MoveThere();    // Right click on the map to move it faster

void TL_GotoFirst();    // Jump to the first object in the list
void TL_GotoNext();     // Jump to the next object in the list
void TL_GotoPrev();     // Jump to the previous object in the list

void TL_MoveFore();     // Move forwards
void TL_MoveBack();     // Move backwards

void TL_FindTag();      // Find an object that uses this tag
void TL_FreeTag();      // Find the first unused tag
void TL_SetTag();       // Set the tag of the layer

static void SelectObj(int cx,int cy);  // Do the actual picking up

static void TL_Update();

static void GetMapX();                  // Get map position
static void GetMapY();

// Parts of the TL_Edit browser

void GetTLFromList( int x0, int y0, char *prompt, int listsize, char **list, char *name);
void TL_Thumb(int x,int y,char *name);

// CODE

/*
 * GoFocal - The menu tab function.  This is called from the toolbar
 */

void TL_GoFocal()
{
int temp;               // Used to get button handles

if(focus==3)            // Make sure we don't redraw if the user clicks again
	return;

focus=3;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(TL_Id);     // And make the button stick inwards

// Set up Map window

IG_BlackPanel(VIEWX-1,VIEWY-1,258,258);
IG_Region(VIEWX,VIEWY,256,256,TL_Pick,NULL,TL_MoveThere);

// Write sprite drawing status

temp = IG_ToggleButton(486,72,"Sprites OFF",Nothing,NULL,NULL,&s_proj);
IG_SetInText(temp,"Sprites ON ");

temp = IG_ToggleButton(486,100,"Exclude ON ",Nothing,NULL,NULL,&lx_proj);
IG_SetInText(temp,"Exclude OFF");

// Set up the X and Y map position counter at the top

MapXpos_Id = IG_InputButton(24,40,mapxstr,GetMapX,NULL,NULL);
MapYpos_Id = IG_InputButton(112,40,mapystr,GetMapY,NULL,NULL);

DrawMap(mapx,mapy,s_proj,1,0);                       // Draw the map

IG_TextButton(416,104,__up,TL_up,NULL,NULL);         // Pan up button
IG_TextButton(400,128,__left,TL_left,NULL,NULL);     // Pan left button
IG_TextButton(432,128,__right,TL_right,NULL,NULL);   // Pan right button
IG_TextButton(416,150,__down,TL_down,NULL,NULL);     // Pan down button

IG_AddKey(UP_KEY,TL_up);                             // Pan up key binding
IG_AddKey(DN_KEY,TL_down);                           // Pan down key binding
IG_AddKey(LF_KEY,TL_left);                           // Pan left key binding
IG_AddKey(RT_KEY,TL_right);                          // Pan right key binding

// Create objects

IG_TextButton(486,256,"Create object",TL_SlowInsert,NULL,NULL);
IG_AddKey(INS,TL_QuickInsert);

// Modify objects

IG_TextButton(486,288,"Set type",TL_Edit,NULL,NULL);
IG_AddKey(ENTER,TL_Edit);

// Delete objects

IG_TextButton(486,320,"Delete object",TL_Delete,NULL,NULL);
IG_AddKey(DEL,TL_Delete);

// Change to an object

IG_TextButton(300,432,"Find tag",TL_FindTag,NULL,NULL);
tag_Id = IG_InputButton(400,432,tag_str,TL_SetTag,NULL,NULL);
IG_TextButton(510,432,"Next free tag",TL_FreeTag,NULL,NULL);

IG_TextButton(300,370,"Prev object",TL_GotoPrev,NULL,NULL);
IG_TextButton(400,370,"First object",TL_GotoFirst,NULL,NULL);
IG_TextButton(510,370,"Next object",TL_GotoNext,NULL,NULL);

IG_TextButton(300,400,"Move back",TL_MoveBack,NULL,NULL);
listpos_Id = IG_InputButton(400,400,ll_pos_str,NULL,NULL,NULL);
IG_TextButton(510,400,"Move forward",TL_MoveFore,NULL,NULL);

}

/*
 *   Nothing - Just draw the map.  Used by toggle-buttons
 */

void Nothing()
{
DrawMap(mapx,mapy,s_proj,1,0);     // Do something anyway
return;
}

/*
 *   TL_up - Scroll upwards
 */

void TL_up()
{
mapy--;
clipmap();
DrawMap(mapx,mapy,s_proj,1,0);
}

/*
 *   TL_down - Scroll downwards
 */

void TL_down()
{
mapy++;
clipmap();
DrawMap(mapx,mapy,s_proj,1,0);
}

/*
 *   TL_left - Scroll to the left
 */

void TL_left()
{
mapx--;
clipmap();
DrawMap(mapx,mapy,s_proj,1,0);
}

/*
 *   TL_right - Scroll to the right
 */

void TL_right()
{
mapx++;
clipmap();
DrawMap(mapx,mapy,s_proj,1,0);
}

/*
 *   TL_SlowInsert - Create an object and ask the user what it should be like
 */

void TL_SlowInsert()
{
laysel=L_Alloc();               // Allocate the object
laysel->x=mapx+(VSW/2);         // Set reasonable defaults
laysel->y=mapy+(VSH/2);

sel_xoff = 0;                   // If we drag and drop, no grab offset
sel_yoff = 0;

laysel->name = SQlist[0].name;             // Give it a name
laysel->form = &SQlist[0];                 // And a shape

TL_Edit();                                 // Do this to set everything up
}

/*
 *   TL_QuickInsert - Create an object but assume is is the same as the last
 *                    (kind of drive-thru object creation)
 */

void TL_QuickInsert()
{
int click_x,click_y,ctr;

if(getnum4sequence(last_sprite) == -1)  // Is it valid?
    {
    TL_SlowInsert();                    // No, do it the slow way
    return;
    }

// First do a quick bounds check, to prevent the creation of sprites
// where the user can't actually see.

click_x = ((x-VIEWX)>>5);           // Work out the position of the mouse
click_y = ((y-VIEWY)>>5);           // in tiles

if(click_x<0 || click_y<0)          // out the top/left of the screen?
    return;                         // Yes, abort
if(click_x>VSW-1 || click_y>VSH-1)  // Out the bottom/right of the screen?
    return;                         // Yes, abort

// Now do the full calculation.

click_x = ((x-VIEWX)>>5)+(mapx); // click_x = (mouse_x_pos/32) + map_x_pos
click_y = ((y-VIEWY)>>5)+(mapy); // click_y = (mouse_y_pos/32) + map_y_pos

laysel=L_Alloc();                // Allocate the object
laysel->x=click_x;               // Use the current position
laysel->y=click_y;

sel_xoff = 0;                    // If we drag and drop, no grab offset
sel_yoff = 0;

L_Init(laysel,last_sprite);      // Re-evaluate the character

TL_Update();
DrawMap(mapx,mapy,s_proj,1,0);
}

/*
 *   TL_Edit - Ask the user what an existing object should be like
 *             TL_SlowInsert calls this as well as the GUI.
 *             TL_Edit calls down to GetTLFromList to display the browser
 */

void TL_Edit()
{
char **list;
char Name[32];

// Make sure we have an object

if(!laysel)
	{
	Notify(-1,-1,"No sprite has been selected.","You must pick a sprite before you can modify it.");
	return;
	}

// Make sure it's not a silly object

if(laysel==curmap.roof)
	{
	Notify(-1,-1,"Not permitted.",NULL);
	return;
	}

// Allocate a list of possible characters

list=(char **)M_get(SQtot+1,sizeof(char *));

// Set it up, convert to uppercase for Wyber's ordered selection routine

for(int ctr=0;ctr<SQtot;ctr++)
        {
	list[ctr]=SQlist[ctr].name;
        strupr(list[ctr]);              // Affects the original too
        }

strcpy(Name,laysel->name);      // Set up the default string

qsort(list,SQtot,sizeof(char*),CMP);  // Sort them for the dialog box

// This is the graphical dialog box, taken from DEU.

GetTLFromList( -1,-1, "Choose a character:", SQtot-1, list, Name);

// If the user didn't press ESC instead of choosing, modify the character

if(Name[0])     // It's ok, do it
	{
        L_Init(laysel,Name);           // Re-evaluate the character
        strcpy(last_sprite,Name);       // Keep this name for reference
	}

free(list);                             // Dispose of the list
TL_Update();                            // Update position, tag
DrawMap(mapx,mapy,s_proj,1,0);          // Update the map
}

/*
 *   TL_Delete - Remove an object
 */

void TL_Delete()
{
if(!laysel)
	{
	Notify(-1,-1,"No sprite has been selected.","You must pick a sprite before you can delete it.");
	return;
	}

if(laysel==curmap.roof)                         // This can't happen
	{
	Notify(-1,-1,"Not Permitted",NULL);     // Get shirty
	return;
	}

L_Free(laysel);                                // Destroy the object
laysel=NULL;                                    // Nothing currently selected
DrawMap(mapx,mapy,s_proj,1,0);                  // Draw the map again

sel_xoff = 0;                   // If we drag and drop, no grab offset
sel_yoff = 0;
}

/*
 *   TL_Pick - Drag and drop an object.  This calls down to SelectObj();
 */

void TL_Pick()
{
int click_x,click_y;

click_x = ((x-VIEWX)>>5)+(mapx); // click_x = (mouse_x_pos/32) + map_x_pos
click_y = ((y-VIEWY)>>5)+(mapy); // click_y = (mouse_y_pos/32) + map_y_pos

if(dragflag)                    // If we're dragging an object
	{
        if(!laysel)
            {
            Notify(-1,-1,"Internal error in drag'n'drop code",NULL);
            return;
            }

	laysel->x=click_x + sel_xoff;    // Get clicked position
	laysel->y=click_y + sel_yoff;    // And move object to that place.

	if(laysel->x<0) laysel->x=0;     // Sanity checks.
	if(laysel->y<0) laysel->y=0;

	dragflag=2;                      // Reset drag timer
	}
else                                     // If we're not dragging, or time out
	{
        SelectObj(click_x,click_y);      // Go fish

	if(laysel)                       // If an object was selected
            {
	    dragflag=2;                        // We go into drag mode
            strcpy(last_sprite,laysel->name);  // We'll make more of these
            }
	}

TL_Update();
DrawMap(mapx,mapy,s_proj,1,0);           // Draw the map again
}

/*
 *   TL_MoveThere - Move an object to the current square without dragging it
 */

void TL_MoveThere()
{
int click_x,click_y;

click_x = ((x-VIEWX)>>5)+(mapx); // click_x = (mouse_x_pos/32) + map_x_pos
click_y = ((y-VIEWY)>>5)+(mapy); // click_y = (mouse_y_pos/32) + map_y_pos

if(laysel)
    {
    laysel->x=click_x + sel_xoff;    // Get clicked position
    laysel->y=click_y + sel_yoff;    // And move object to that place.

    if(laysel->x<0) laysel->x=0;     // Sanity checks.
    if(laysel->y<0) laysel->y=0;

    DrawMap(mapx,mapy,s_proj,1,0);
    }
}

/*
 *   TL_GotoFirst - Move to the first object in the list
 */

void TL_GotoFirst()
{
if(!curmap.roof->next)                 // No objects?  Can't do it
    return;

laysel=curmap.roof->next;              // Select the first one.

mapx=laysel->x-(VSW/2);                // center the object in the view
mapy=laysel->y-(VSH/2);

clipmap();                             // Clip the view to sensible bounds

TL_Update();                           // Update position, tag
DrawMap(mapx,mapy,s_proj,1,0);         // Display it
}

/*
 *   TL_GotoNext - Move to the next object in the list
 */

void TL_GotoNext()
{
if(!laysel)                            // Abort if no object selected
    return;

if(!laysel->next)                      // Abort if no object follows
    return;

laysel=laysel->next;                   // Go to the next one

mapx=laysel->x-(VSW/2);                // center the object in the view
mapy=laysel->y-(VSH/2);

clipmap();                             // Clip the view to sensible bounds

TL_Update();                           // Update position,tag
DrawMap(mapx,mapy,s_proj,1,0);         // Display it
pause();
}

/*
 *   TL_GotoPrev - Move to the previous object in the list
 */

void TL_GotoPrev()
{
LAYER *temp;

if(!laysel)                            // Abort if no object selected
    return;

// Search the list to see if any previous item points to it.

for(temp=curmap.roof->next;temp->next;temp=temp->next)
	if(temp->next==laysel)
		{
		laysel=temp;                     // We have found it
                mapx=laysel->x-(VSW/2);          // Center the object, clip and draw
                mapy=laysel->y-(VSH/2);
		clipmap();
                TL_Update();                     // Update position,tag
                DrawMap(mapx,mapy,s_proj,1,0);
                pause();
                return;
		}
}

/*
 *   TL_MoveBack - Move the object backwards in the list
 */

void TL_MoveBack()
{
}

/*
 *   TL_MoveFore - Move the object forwards in the list
 */

void TL_MoveFore()
{
}

/*
 *   TL_FindTag - Find an object with a certain tag
 */

void TL_FindTag()
{
LAYER *temp;
static int tag=0;

// Get the tag to search for

tag=InputIntegerValue(-1,-1,0,65535,tag);

// Scan the linked list for that tag

for(temp=curmap.roof->next;temp;temp=temp->next)
	if(temp->tag==tag)
            {
            laysel = temp;               // We've found one
            mapx=laysel->x-(VSW/2);      // center the object in the view
            mapy=laysel->y-(VSH/2);

            clipmap();                     // Clip the view to sensible bounds
            TL_Update();                   // Update tag number
            DrawMap(mapx,mapy,s_proj,1,0); // Project
            return;                        // Leave
            }

// If we reach the end of the list..

Notify(-1,-1,"Could not find an object using that tag number.",NULL);
}

/*
 *   TL_FreeTag - Find first free tag
 */

void TL_FreeTag()
{
LAYER *temp;
char stemp[32];
int tag;

// Take a number

for(int ctr=0;ctr<65535;ctr++)
    {
    tag=0;  // Mark not found

    // Scan the list for that tag

    for(temp=curmap.roof->next;temp;temp=temp->next)
	if(temp->tag==ctr)
            tag=1;  // Mark it as found, or not as the case may be

    // If not found, we have a result!

    if(!tag)
            {
            sprintf(stemp,"tag: %d",ctr);
            Notify(-1,-1,"The next free tag is:",stemp);
            return;
            }

    // If not we keep going round and round until we find one
    }

// Proclaim the impossible

Notify(-1,-1,"Probable System Fault","There are over 128000 tags.  Are they really all used?");
}

/*
 *   TL_SetTag - Set the tag
 */

void TL_SetTag()
{
if(!laysel)
    {
    Notify(-1,-1,"You need to select an object to do this",NULL);
    return;
    }

// Get the new tag number

laysel->tag=InputIntegerValue(-1,-1,0,65535,laysel->tag);

// Update the display

TL_Update();
DrawMap(mapx,mapy,s_proj,1,0);
}


/* =========================== Auxiliary functions ======================== */

/*
 *   SelectObj - fish for an object on the map where the user has clicked
 */

void SelectObj(int cx,int cy)
{

laysel = NULL;          // Assume nothing was there
sel_xoff = 0;           // No select offset
sel_yoff = 0;

for(LAYER *ttemp=curmap.roof;ttemp;ttemp=ttemp->next)
	if(cx>=ttemp->x && cx<ttemp->x+ttemp->mw)
                if(cy>=ttemp->y && cy<ttemp->y+ttemp->mh)
			{
			laysel=ttemp;
                        sel_xoff = (ttemp->x - cx);     // If we grab it by
                        sel_yoff = (ttemp->y - cy);     // the ear, record
                        }                               // where the ear was

// If laysel == NULL then we caught a fish

// Time to go
return;
}

/*
 *    TL_Update - Set the four arrows at the bottom to appropriate state
 */

void TL_Update()
{
char temp[13];

if(!laysel)             // Abort, because no sprite was chosen
    return;

// Now deal with the list position meter

int tot=1,pos;
for(LAYER *tt=curmap.roof;tt;tt=tt->next,tot++)
	if(tt==laysel)
		pos=tot++;

//DrawScreenBoxHollow(118,440,192,456);
sprintf(temp,"%d/%d",pos-1,tot-3);
sprintf(ll_pos_str,"%-12s",temp);
IG_UpdateText(listpos_Id,ll_pos_str);

sprintf(tag_str,"%-12d",laysel->tag);
IG_UpdateText(tag_Id,tag_str);

//DrawScreenText(120,442,stemp);
}

/*
 *   clipmap - clip the map's coordinates to sensible values
 */

void clipmap()
{
if(mapx<0) mapx=0;
if(mapx>curmap.w-VSW) mapx=curmap.w-VSW;
if(mapy>curmap.h-VSH) mapy=curmap.h-VSH;
if(mapy<0) mapy=0;
}


/*
 *    GetMapX - Ask the user where on the map they want to be
 */

void GetMapX()
{
mapx=InputIntegerValue(-1,-1,0,curmap.w-VSW,mapx);
DrawMap(mapx,mapy,s_proj,1,0);
}

/*
 *    GetMapY - Ask the user where on the map they want to be
 */

void GetMapY()
{
mapy=InputIntegerValue(-1,-1,0,curmap.h-VSH,mapy);
DrawMap(mapx,mapy,s_proj,1,0);
}





/*
 *  - Background menu tab
 */


#include <stdio.h>
#include "igui.hpp"
#include "../memory.hpp"
#include "../console.hpp"
#include "../core.hpp"
#include "menusys.h"
#include "../keys.hpp"

// defines

// variables

extern int focus,BG_Id;
extern int MapXpos_Id,MapYpos_Id;       // Map X/Y Coordinate boxes
extern char mapxstr[],mapystr[];

extern long M_core;     // Total amount of core, from memory.cc
extern int s_proj;      // Flag, are sprites being displayed?
extern int l_proj;      // Flag, are layers being displayed?

extern int mapx,mapy;   // Current map position
extern SPRITE eyesore;

static int curoff=0;    // Current position on the tile list at the bottom
static int L=0,R=0;     // Current tile for each button, Lclick and Rclick

// functions

extern void Toolbar();
extern void DrawMap(int x,int y,char s_proj,char l_proj,char f_proj);
extern void WriteMap(int x,int y,int tile);
extern int ReadMap(int x,int y);

void Nothing();
static void clipmap();

void BGBl();
void BGBll();
void BGBr();
void BGBrr();
void BG_bar();

void BG_up();
void BG_down();
void BG_left();
void BG_right();

void GetL();                            // Get a tile for the left click
void GetR();                            // Get a tile for the right click
void SetR();                            // Write a right-click tile to map
void SetL();                            // Write a left-click tile to map
void GetEyesoreL();                     // Get tile 65535 for the left click
void GetEyesoreR();                     // Get tile 65535 for the right click

void Get_Prefab();                      // Copy to clipboard
void Put_Prefab();                      // Copy to map
void Make_Rand();                       // Search and Replace
void Tile_Rand();                       // Randomize grass etc
void ClearL();
void ClearR();

void Set_Background(int tile);          // Write a tile to the map, helper

static void GetMapX();                  // Get map position
static void GetMapY();
static unsigned short prefab[8][8];     //
static unsigned short blkundo[8][8];    // Undo block op

// GoFocal - The menu tab function.  This is called from the toolbar

void BG_GoFocal()
{
int temp;               // Used to get button handles

if(focus==1)            // Make sure we don't redraw if the user clicks again
	return;

focus=1;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(BG_Id);     // And make the button stick inwards

// Set up Map window

IG_BlackPanel(VIEWX-1,VIEWY-1,258,258);
IG_Region(VIEWX,VIEWY,256,256,SetL,NULL,SetR);

// Write sprite drawing status

temp = IG_ToggleButton(486,72,"Sprites OFF",Nothing,NULL,NULL,&s_proj);
IG_SetInText(temp,"Sprites ON ");

temp = IG_ToggleButton(486,100,"Rooftops OFF",Nothing,NULL,NULL,&l_proj);
IG_SetInText(temp,"Rooftops ON ");

// Draw the VCR buttons on the Tile selector

IG_TextButton(8,410,__left,BGBl,NULL,NULL);     // Normal speed
IG_TextButton(616,410,__right,BGBr,NULL,NULL);

IG_TextButton(8,440,__left2,BGBll,NULL,NULL);   // Fast Forward
IG_TextButton(608,440,__right2,BGBrr,NULL,NULL);

// Draw the contents of Left and Right buttons

IG_BlackPanel(400,192,32,32);
DrawScreenText(400,182," L");
if(L == RANDOM_TILE)
     eyesore.block_put_sprite(400,192,swapscreen);
else
     TIlist[L].form->seq[0]->image.block_put_sprite(400,192,swapscreen);

IG_BlackPanel(448,192,32,32);
DrawScreenText(448,182," R");
if(L == RANDOM_TILE)
     eyesore.block_put_sprite(448,192,swapscreen);
else
     TIlist[R].form->seq[0]->image.block_put_sprite(448,192,swapscreen);

BG_bar();                                       // Draw the Tile bar
IG_Region(32,400,576,32,GetL,NULL,GetR);        // Add clickable region

// Set up the X and Y map position counter at the top

MapXpos_Id = IG_InputButton(24,40,mapxstr,GetMapX,NULL,NULL);
MapYpos_Id = IG_InputButton(112,40,mapystr,GetMapY,NULL,NULL);

// Get and Put prefab (clipboard)

IG_TextButton(300,300,"Get prefab",Get_Prefab,NULL,NULL);   // Fast Forward
IG_TextButton(400,300,"Put prefab",Put_Prefab,NULL,NULL);   // Fast Forward
IG_TextButton(500,300,"Randomise tile",Tile_Rand,NULL,NULL);   // Ieahh!

IG_TextButton(300,332,"Fill L tile",ClearL,NULL,NULL);   // Fast Forward
IG_TextButton(400,332,"Fill R tile",ClearR,NULL,NULL);   // Fast Forward
IG_TextButton(500,332,"Make Random",Make_Rand,NULL,NULL);   // Ieahh!

IG_BlackPanel(31,340,34,34);
IG_Region(32,341,32,32,GetEyesoreL,NULL,GetEyesoreR);
eyesore.block_put_sprite(32,341,swapscreen);


DrawMap(mapx,mapy,s_proj,l_proj,0);             // Draw the map


IG_TextButton(416,104,__up,BG_up,NULL,NULL);         // Pan up button
IG_TextButton(400,128,__left,BG_left,NULL,NULL);     // Pan left button
IG_TextButton(432,128,__right,BG_right,NULL,NULL);   // Pan right button
IG_TextButton(416,150,__down,BG_down,NULL,NULL);     // Pan down button

IG_AddKey(UP_KEY,BG_up);                             // Pan up key binding
IG_AddKey(DN_KEY,BG_down);                           // Pan down key binding
IG_AddKey(LF_KEY,BG_left);                           // Pan left key binding
IG_AddKey(RT_KEY,BG_right);                          // Pan right key binding

IG_AddKey(KEY_C,Get_Prefab);                         // get prefab key binding
IG_AddKey(KEY_V,Put_Prefab);                         // put prefab key binding
}

void Nothing()
{
DrawMap(mapx,mapy,s_proj,l_proj,0);     // Do something anyway
return;
}

void BGBr()
{
curoff++;
if(curoff>(TItot-17))
    curoff=(TItot-17);
BG_bar();
}

void BGBl()
{
curoff--;
if(curoff<0) curoff=0;
BG_bar();
}

void BGBrr()
{
curoff+=10;
if(curoff>(TItot-17))
    curoff=(TItot-17);
BG_bar();
}

void BGBll()
{
curoff-=10;
if(curoff<0) curoff=0;
BG_bar();
}


void BG_bar()
{
int co;
co=17;
if(TItot<17)
    co=TItot;
IG_BlackPanel(31,399,578,34);
for(int ctr=0;ctr<co;ctr++)
	TIlist[ctr+curoff].form->seq[0]->image.block_put_sprite(33+(34*ctr),401,swapscreen);
}

void GetL()
{
int co;
co=17;
if(TItot<17) co=TItot;
for(int ctr=0;ctr<co;ctr++)
	if(x>33+(34*ctr) && x<65+(34*ctr))
		{
		L=ctr+curoff;
		TIlist[L].form->seq[0]->image.block_put_sprite(400,192,swapscreen);
		return;
		}
}

void GetR()
{
int co;
co=17;
if(TItot<17)
     co=TItot;
for(int ctr=0;ctr<co;ctr++)
	if(x>33+(34*ctr) && x<65+(34*ctr))
		{
		R=ctr+curoff;
		TIlist[R].form->seq[0]->image.block_put_sprite(448,192,swapscreen);
		return;
		}
}

void SetL()
{
Set_Background(L);
}

void SetR()
{
Set_Background(R);
}

void Set_Background(int tile)
{
int t,xx,yy,yyy,xxx,tot,ctr;

yyy=-1;
xxx=-1;
for(xx=0;xx<VSW;xx++)
	{
	t=32*xx+(VIEWX-1);
	if(x>=t &&x<(t+32))
		xxx=xx;
	}

for(yy=0;yy<VSH;yy++)
	{
	t=32*yy+(VIEWY-1);
	if(y>=t && y<(t+32))
		yyy=yy;
	}

if(xxx!=-1 && yyy!=-1)
	WriteMap(mapx+xxx,mapy+yyy,tile);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}



void BG_up()
{
mapy--;
clipmap();
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void BG_down()
{
mapy++;
clipmap();
DrawMap(mapx,mapy,s_proj,l_proj,0);
}


void BG_left()
{
mapx--;
clipmap();
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void BG_right()
{
mapx++;
clipmap();
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void GetMapX()
{
mapx=InputIntegerValue(-1,-1,0,curmap.w-VSW,mapx);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void GetMapY()
{
mapy=InputIntegerValue(-1,-1,0,curmap.h-VSH,mapy);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void ClearL()
{
for(int cy=0;cy<VSH;cy++)
        for(int cx=0;cx<VSW;cx++)
                WriteMap(mapx+cx,mapy+cy,L);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void ClearR()
{
for(int cy=0;cy<VSH;cy++)
        for(int cx=0;cx<VSW;cx++)
                WriteMap(mapx+cx,mapy+cy,R);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void Get_Prefab()
{
for(int cy=0;cy<VSH;cy++)
        for(int cx=0;cx<VSW;cx++)
                prefab[cx][cy]=ReadMap(mapx+cx,mapy+cy);
//DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void Put_Prefab()
{
for(int cy=0;cy<VSH;cy++)
        for(int cx=0;cx<VSW;cx++)
                WriteMap(mapx+cx,mapy+cy,prefab[cx][cy]);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void Tile_Rand()
{
int cx,cy,z;
long rep=0;
char str[128];

if(!Confirm(-1,-1,"This will replace all RANDOM tiles","with the tiles between the L and R mouse buttons."))
    return;

if(R<L)
    {
    Notify(-1,-1,"The tile assigned to the LEFT button must come before","the tile assigned to the RIGHT button.");
    return;
    }

if(L==RANDOM_TILE|| R==RANDOM_TILE)
    {
    Notify(-1,-1,"You must not choose the RANDOM tile as a replacement!",NULL);
    return;
    }

z=R-L;

for(int cy=0;cy<curmap.h;cy++)
    for(int cx=0;cx<curmap.w;cx++)
        {
        if(ReadMap(cx,cy)==RANDOM_TILE)
            {
            if(z)
                WriteMap(cx,cy,L+(random()%z));
            else
                WriteMap(cx,cy,L);
            rep++;
            }
        }
sprintf(str,"%ld random tiles were found.",rep);
Notify(-1,-1,str,NULL);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void Make_Rand()
{
int cx,cy,z;
long rep=0;
char str[128];

if(!Confirm(-1,-1,"This will replace all tiles between the L and R mouse buttons","with the RANDOM tile."))
    return;

if(R<L)
    {
    Notify(-1,-1,"The tile assigned to the LEFT button must come before","the tile assigned to the RIGHT button.");
    return;
    }

if(L==RANDOM_TILE|| R==RANDOM_TILE)
    {
    Notify(-1,-1,"You cannot search for the RANDOM tile.",NULL);
    return;
    }


z=R-L;

for(int cy=0;cy<curmap.h;cy++)
    for(int cx=0;cx<curmap.w;cx++)
        {
        z=ReadMap(cx,cy);
        if(z>=L && z<=R)
            {
            WriteMap(cx,cy,RANDOM_TILE);
            rep++;
            }
        }
sprintf(str,"%ld tiles were replaced.",rep);
Notify(-1,-1,str,NULL);
DrawMap(mapx,mapy,s_proj,l_proj,0);
}

void GetEyesoreL()
{
L=RANDOM_TILE;
eyesore.block_put_sprite(400,192,swapscreen);
}

void GetEyesoreR()
{
R=RANDOM_TILE;
eyesore.block_put_sprite(448,192,swapscreen);
}

