//
//      IRE init systems
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <io.h>
// MR: added
#ifndef _WIN32
#include <unistd.h>
#endif

// defines

#define WORK_IN_16MB 1  // No RLE encoding

#define IRE_SYSTEM_MODULE
#define ALREADY_KNOW_ITG
#define UNDEFINED -1

// includes

#include "doslib.hpp"
#include "init.hpp"
#include "fs.hpp"
#include "loaders.hpp"
#include "memory.hpp"
#include "console.hpp"
#include "script.hpp"
#include "vrm_in.hpp"
#include "seer/seer.h"


// Global variables

//SQ **SQlist;    long SQtot;     // Sequences in the SQlist, no. of sequences
//VRM *COlist;    long COtot;     // Array of VRM modules, no. of VRMs present
//CH *CHlist;     long CHtot;     // Array of characters, no. of characters
//SP *SPlist;     long SPtot;     // Array of sprites, number of sprites

VRM *COlist;                    // Virtual Runtime Module table
S_POOL *s_pool;                 // Pool of sprites loaded into memory
SEQ_POOL *seq_pool;             // Pool of animation sequences

char digit[256][8];

unsigned short font_bground=0,font_fground=0x7fff;
char stemp[128];
char *rootname="main\0";

extern int mainproc,vscheduler,look_none,use_none,status,follower,loadproc,all_dead,playervrm;
extern char mapname[];

// Local variables

static LOAD fp;
static LOAD vrm_fp;

// functions

int sto_rle(SPRITE *s);
short FindProc(char *name);
extern void register_exporttable();

// code

/*
 *      Init_Sprite() - Load in a single sprite, called by SCRIPT.CC
 */

long Init_Sprite(int number)
{
char *filename;
cfa="init_sprite()";           // This is where we were when it crashed..
filename = SPlist[number].fname;

    strupr(filename);          // Make uppercase

    // First, look for the extension in the filename

        if(strstr(filename,".CEL"))
            load_CEL(&SPlist[number].image,filename);   // Load in the sprite
        else
            if(strstr(filename,".PCX"))
                load_PCX(&SPlist[number].image,filename);  // Load it
            else
                panic(cfa,"The sprite's extension was not .PCX or .CEL",filename);

    // Now store the width and height of the sprite in the pool

        SPlist[number].w=SPlist[number].image.get_width();
        SPlist[number].h=SPlist[number].image.get_height();

    // This is the width times the height, for fast access later

	SPlist[number].wxh=SPlist[number].w*SPlist[number].h;

    // Convert the sprite into an RLE data structure for speed in some cases
    // The raw data is used for clipping, RedLeveling etc.

//    sto_rle(&SPlist[number].image);

    // Write a dot for this image.  This Plot was set up in script.cc

	 Plot(0);

return SPlist[number].wxh; // Width x Height x 16 bpp
}


/*
 *      Init_RoofTile() - Load in a single sprite, called by SCRIPT.CC
 */

long Init_RoofTile(int number)
{
char *filename;
cfa="init_rooftile()";           // This is where we were when it crashed..
filename = RTlist[number].fname;

    strupr(filename);          // Make uppercase

    // First, look for the extension in the filename

        if(strstr(filename,".CEL"))
            load_CEL(&RTlist[number].image,filename);   // Load in the sprite
        else
            if(strstr(filename,".PCX"))
                load_PCX(&RTlist[number].image,filename);  // Load it
            else
                panic(cfa,"The sprite's extension was not .PCX or .CEL",filename);

    // Now store the width and height of the sprite in the pool

        RTlist[number].w=RTlist[number].image.get_width();
        RTlist[number].h=RTlist[number].image.get_height();

    // This is the width times the height, for fast access later

	RTlist[number].wxh=RTlist[number].w*RTlist[number].h;

    // Write a dot for this image.  This Plot was set up in script.cc

	 Plot(0);

return RTlist[number].wxh; // Width x Height x 16 bpp
}


/*
 *      Init_Font - Load in the character set.
 */

void Init_Font()
{
boot0("Init_Font()\n");

cfa="init_font()";               // This is where we crashed

fp.open("font.dat");            // Open the file
fp.read(digit,1,2048);           // Read it
fp.close();                      // Close it
}


/*
 *    find_spr()  -  find the address of a sprite by its name
 */

S_POOL *find_spr(char *name)
{
for(int cx=0;cx<SPtot;cx++)
	if(!stricmp(SPlist[cx].name,name))
		return(&SPlist[cx]);
return NULL;
}

/*
 *    find_seq()  -  find the address of a sequence by its name
 */

SEQ_POOL *find_seq(char *name)
{
for(int cx=0;cx<SQtot;cx++)
	if(!stricmp(SQlist[cx].name,name))
		return(&seq_pool[cx]);
return NULL;
}

/*
 *    Init_VRMs()  -  Initialise the VRM system
 */

void Init_VRMs()
{
bootmsg("Preinitialise VRMs:\n");
bootmsg("  VRM Subsystem is: SeeR %s\n",SeeR_VERSION_STR);
bootmsg("  Register ExportTable\n");

register_exporttable();

bootmsg("Done.\n");
}


/*
 *    Init_VRM()  -  Used in the VRM engine to initialise a module
 */

void Init_VRM(int pos)
{
LOAD fp;
int len;

cfa="Init_VRM()";
Plot(0);

// Open the VRM file, get the size, load it in as a huge string

fp.open(COlist[pos].fname);
len = fp.filelength();
COlist[pos].vrm = (char *)M_get(1,len+1);
fp.read(COlist[pos].vrm,1,len);

if(memcmp(COlist[pos].vrm,"SeeRVCPU",8))
   panic("VRM read error","This VRM was not compiled with SEER!",COlist[pos].fname);
// Do the read

if(len != scGet_Script_Size(COlist[pos].vrm))
   panic("VRM read error",scErrorMsg,scErrorLine);

fp.close();

if(!stricmp(COlist[pos].name,"main"))
    mainproc = pos;

if(!stricmp(COlist[pos].name,"scheduler"))
    vscheduler = pos;

if(!stricmp(COlist[pos].name,"look_none"))
    look_none = pos;

if(!stricmp(COlist[pos].name,"use_none"))
    use_none = pos;

if(!stricmp(COlist[pos].name,"all_dead"))
    all_dead = pos;

if(!stricmp(COlist[pos].name,"status"))
    status = pos;

if(!stricmp(COlist[pos].name,"follower"))
    follower = pos;

if(!stricmp(COlist[pos].name,"loadproc"))
    loadproc = pos;

if(!stricmp(COlist[pos].name,"follower"))
    follower = pos;

if(!stricmp(COlist[pos].name,"player"))
    playervrm = pos;
}

/*
 *    Init_Funcs()  -  Assign each function in the characters to a VRM
 */

void Init_Funcs()
{
int ctr,tmp;
char *str;

if(all_dead == UNDEFINED)
    panic("Init_Funcs","Could not find system function 'all_dead' in the VRM list!",NULL);

if(use_none == UNDEFINED)
    panic("Init_Funcs","Could not find system function 'use_none' in the VRM list!",NULL);

if(look_none == UNDEFINED)
    panic("Init_Funcs","Could not find system function 'look_none' in the VRM list!",NULL);

if(playervrm == UNDEFINED)
    panic("Init_Funcs","Could not find system function 'player' in the VRM list!","Please make sure the player's behaviour VRM is called 'PLAYER'");

if(mainproc == UNDEFINED)
    boot2("Did not find system function 'main', using default\n");
if(vscheduler == UNDEFINED)
    boot2("Did not find system function 'scheduler', using default\n");
if(status == UNDEFINED)
    boot2("Did not find system function 'status', using default\n");
if(follower == UNDEFINED)
    boot2("Did not find system function 'follower', using default\n");
if(loadproc == UNDEFINED)
    boot2("Did not find system function 'loadproc', using default\n");


for(ctr=0;ctr<CHtot;ctr++)
    {
    // Find the default USE function in the VRM list and put it in the Ucache
    str = CHlist[ctr].funcs->use;
    if(str[0])
        {
        tmp = getnum4VRM(str);
        if(tmp == UNDEFINED)
            Bug("use: Did not find function '%s'.  Ignoring\n",str);
        else
            CHlist[ctr].funcs->ucache = tmp;
        }
    else
        CHlist[ctr].funcs->ucache = -1;

    // Find a STAND function in the VRM list and put it in the Scache
    // Switch off the trigger bit if none found

    str = CHlist[ctr].funcs->stand;
    if(str[0])
        {
        tmp = getnum4VRM(str);
        if(tmp == UNDEFINED)
            Bug("stand: Did not find function '%s'.  Ignoring\n",str);
        else
            CHlist[ctr].funcs->scache = tmp;
        }
    else
        CHlist[ctr].flags.trigger = 0;

    // Find the default LOOK function in the VRM list and put it in the Lcache

    str = CHlist[ctr].funcs->look;
    if(str[0])
        {
        tmp = getnum4VRM(str);
        if(tmp==-1)
            tmp = look_none;
        else
            CHlist[ctr].funcs->lcache = tmp;
        }
    else
        CHlist[ctr].funcs->lcache = -1;

    // Find the default KILLED function in the VRM list and put it in the Kcache
    // If none, the engine will just vanish the dead thing

    str = CHlist[ctr].funcs->kill;
    if(str[0])
        {
        tmp = getnum4VRM(CHlist[ctr].funcs->kill);
        if(tmp == UNDEFINED)
            Bug("kill: Did not find function '%s'.  Ignoring\n",str);
        else
            CHlist[ctr].funcs->kcache = tmp;
        }
    else
        CHlist[ctr].funcs->kcache = -1;

    // Find the default HURT function in the VRM list and put it in the Hcache
    str = CHlist[ctr].funcs->hurt;
    if(str[0])
        {
        tmp = getnum4VRM(str);
        if(tmp == UNDEFINED)
            Bug("hurt: Did not find function '%s'.  Ignoring\n",str);
        else
            CHlist[ctr].funcs->hcache = tmp;
        }
    else
        CHlist[ctr].funcs->hcache = -1;

    // Find the default INIT function in the VRM list and put it in the Icache
    str = CHlist[ctr].funcs->init;
    if(str[0])
        {
        tmp = getnum4VRM(str);
        if(tmp == UNDEFINED)
            Bug("hurt: Did not find function '%s'.  Ignoring\n",str);
        else
            CHlist[ctr].funcs->icache = tmp;
        }
    else
        CHlist[ctr].funcs->icache = -1;

    }
}

void Init_Areas(OBJECT *objsel)
{
// First the vertical

objsel->w = SQlist[objsel->dir[CHAR_D]].seq[0]->w;
objsel->h = SQlist[objsel->dir[CHAR_D]].seq[0]->h;

// Set up the size in tiles
objsel->mw = objsel->w>>5;
if(objsel->w & 0xf || !objsel->mw)
     objsel->mw++;

objsel->mh = objsel->h>>5;
if(objsel->h & 0xf || !objsel->mh)
     objsel->mh++;

if(objsel->VareaW==0)
    {
    objsel->VareaW=objsel->mw;
    objsel->VareaX=0;
    }
if(objsel->VareaH==0)
    {
    objsel->VareaH=objsel->mh;
    objsel->VareaY=0;
    }
if(objsel->vblockw==0)
    {
    objsel->vblockw=objsel->mw;
    objsel->vblockx=0;
    }
if(objsel->vblockh==0)
    {
    objsel->vblockh=objsel->mh;
    objsel->vblocky=0;
    }

// Then the horizontal

objsel->w = SQlist[objsel->dir[CHAR_R]].seq[0]->w;
objsel->h = SQlist[objsel->dir[CHAR_R]].seq[0]->h;

// Set up the size in tiles
objsel->mw = objsel->w>>5;
if(objsel->w & 0xf || !objsel->mw)
     objsel->mw++;

objsel->mh = objsel->h>>5;
if(objsel->h & 0xf || !objsel->mh)
     objsel->mh++;

if(objsel->HareaW==0)
    {
    objsel->HareaW=objsel->mw;
    objsel->HareaX=0;
    }
if(objsel->HareaH==0)
    {
    objsel->HareaH=objsel->mh;
    objsel->HareaY=0;
    }
if(objsel->hblockw==0)
    {
    objsel->hblockw=objsel->mw;
    objsel->hblockx=0;
    }
if(objsel->hblockh==0)
    {
    objsel->hblockh=objsel->mh;
    objsel->hblocky=0;
    }
}

