/*
 *      IRE main module
 */

/*
 * License of some functions in DJGPP's main C library:
 *
 * This product includes software developed by the University of California,
 * Berkeley and its contributors
 */

#include <malloc.h>

#ifndef _WIN32
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>

#include "sys.hpp"      // OS dependencies
#include "console.hpp"  // Loggers
#include "cookies.h"    // Cookies
#include "core.hpp"     // Main data structures
#include "fs.hpp"       // Filesystem
#include "itg/itg.h"    // GFX lib
#include "init.hpp"     // Init module
#include "keys.hpp"     // Keys
#include "linklist.hpp" // Linked list memory routines for the map components
#include "loaders.hpp"  // Loader module
#include "loadsave.hpp" // Map and savegame IO
#include "memory.hpp"   // Memory module
#include "oscli.hpp"    // Operating system command line interpreter
#include "script.hpp"   // Script parsing routines
#include "sound.hpp"    // Sound Engine
#include "vidmodes.h"   // Video drivers
#include "at_exit.hpp"  // Working shutdown routine

#ifndef __DJGPP__	// Needed for Windows-SDL jiggery-poke
#include "SDL.h"
#endif

/*
 * Defines
 */

/*
 * Variables
 */

extern char in_editor;

// Mapfile, filename of the current map, begins with 0xff if not defined
char mapname[]=COOKIE_MapName; // belated anti-Vietnam message
char InGFX=0;
SPRITE mp;
char __RedLevel=124;
char buggy=0,do_cd=0;

short bgp_size=0;
SPRITE *bgpool;
char *swapscreen;       // Display surface
char *bg_screen;	// the background screen
WORLD curmap;
OBJECT *syspocket;      // The system pocket

static SPRITE s_soundbar,s_slider1,s_slider2;
int mvol=100,svol=100;

/*
 * Functions
 */

static void credits();
void Compile(char *a);
void read_config();
void write_config();

extern void Init_VRMs();
extern void startgame();
extern "C" void go_frik_ourselves();    // See hack.c

// Code

main(int argc,char *argv[])
{
#ifdef __DJGPP__
printf("This product includes software developed by the University of California,\n");
printf("Berkeley and its contributors\n");
sleep(1);
#endif

strcpy(resdir,"res");   // Set default directory for resources

SYS_BANNER("IRE Runner - IT-HE RPG Engine (C) 1999 IT-HE Software");

#ifdef __DJGPP__
if(access("nofrik.me",F_OK)) // If this file DOES NOT exist, do the restub
    go_frik_ourselves();
#endif

V_init();         // Find video modes
M_init();         // Init memory systems

puts("Init_logger();");
Init_logger();
bootmsg("IRE Kernel version %s\n",IKV);

// Make them slightly larger in case of overruns when dealing with
// a very large sprite for the player

bootmsg("Allocating screens\n");
swapscreen = (char *)M_get(BUFFERSIZE+QTRBUFFERSIZE,1);
bg_screen = (char *)M_get(BUFFERSIZE+QTRBUFFERSIZE,1);
Loader_Init();

// Get commandline input

if(argc>=2)
	OSCLI(argc,argv);       // input from OSCLI

INI_file("game.ini");           // Read the ini file and act upon it

V_format(VideoMode);            // Set correct RGB format

#ifdef __DJGPP__
if(!exist("audio.cfg"))
    {
    printf("\nPlease run 'setup' first..\n");
    exit(1);
    }
#endif

Init_Filesystem();              // Start VFS
Init_Font();                    // Load font for console

if((unsigned char)mapname[0] == 0xff)
    {
    puts("No map file was specified.\n  There should be a -mapfile parameter in one of the INI files.");
    exit(1);
    }

bootmsg("Memory now available :%ld bytes decimal\n",coreleft());

boot2("Preparing graphical console\n");
C_init();

if(graflog > 0)
    switch_logger_on();

cfa = "Init_VRMs";

Init_VRMs();                     // Pre-initialise VRMs

cfa = "Compiler";

Compile("main.txt");

bootmsg("Load internal graphics\n");
load_CEL(&s_soundbar,"soundbar.cel");
load_CEL(&s_slider1,"slider1.cel");
load_CEL(&s_slider2,"slider2.cel");

bootmsg("Interrupt processes:\n");
At_Exit();                      // Ensure sanity at exit
#ifdef __DJGPP__
K_Init();                       // Prepare to take over the world
#endif
T_Init();
S_Init();                       // Start sound system
S_Load();                       // Load sound and music
S_Start();                      // Start the sound process

bootmsg("Init Random Number Generator\n");
srand(time(0));                 // Initialise rng

// Let's Go

cfa = "Init Funcs";
bootmsg("VRM fixups\n");
Init_Funcs();                   // Assign the CHlist.func to appropriate VRM

cfa = "Load Map";
LoadMap();                       // Load in the game map

cfa = "Read config file";        // Get misc settings
read_config();

cfa = "Start Game";
if(!in_editor)                        // If we're in normal game,
    do_cd=1;                          // We'll want collision detection

startgame();                     // Do things

cfa = "Write config file";       // Put misc settings
write_config();

cfa = "Loader Term";
Loader_Term();                   // Initialisation completed

T_Term();
S_Term();
K_Term();

credits();                       // Roll the credits

if(buggy)
    {
    printf("There were bugs in the VRM code.\n");
    printf("Check BOOTLOG.TXT and search for 'BUG:'\n");
    }

return 0;			// Return a value to keep compiler happy
}



/*
 *      SoundSettings - Set the sound and music levels
 */

void SoundSettings()
{
static int pos=0;
int key;
int startx,starty,sl1,sl2;

startx=32;
starty=64;

   do  {

       // Draw backing image

       s_soundbar.block_put_sprite(startx,starty,swapscreen);

       // Draw sliders

       sl1 = startx + 32 +(mvol>>1);
       sl2 = startx + 32 +(svol>>1);

       if(pos == 0)
              {
              s_slider1.cel_put_sprite(sl1,starty+16,swapscreen);
              s_slider2.cel_put_sprite(sl2,starty+40,swapscreen);
              }
       else
              {
              s_slider2.cel_put_sprite(sl1,starty+16,swapscreen);
              s_slider1.cel_put_sprite(sl2,starty+40,swapscreen);
              }

       SYS_DELAY(2);
       update(swapscreen);
       key=SYS_GET_KEY();


       // Choose slider

       if(key == KEY_UP)
             pos = 0;
       if(key == KEY_DOWN)
             pos = 1;

       // Move appropriate slider

       if(key == KEY_LEFT)
               {
               if(pos == 0)
                      mvol-=2;
               else
                      svol-=2;
               }

       if(key == KEY_RIGHT)
               {
               if(pos == 0)
                      mvol+=2;
               else
                      svol+=2;
               }

       if(mvol<0)
            mvol=0;
       if(svol<0)
            svol=0;
       if(mvol>255)
            mvol=255;
       if(svol>255)
            svol=255;

       S_MusicVolume(mvol);
       S_SoundVolume(svol);

       } while(key != KEY_ESC);
}


/*
 *      read_config - get previous volume levels from file
 */

void read_config()
{
char string[128];
FILE *config;

strcpy(string,"game.cfg");
config = fopen(string,"rb");
if(!config)
    return;

mvol = getl(config);
svol = getl(config);

boot2("Set volume %d,%d\n",mvol,svol);
S_MusicVolume(mvol);    // Update sound engine
S_SoundVolume(svol);

fclose(config);
}

/*
 *      write_config - write current volume levels to file
 */

void write_config()
{
char string[128];
FILE *config;

strcpy(string,"game.cfg");
config = fopen(string,"wb");
if(!config)
    return;

putl(mvol,config);
putl(svol,config);

fclose(config);
}

void credits()
{
LOAD fp;
char credit[4000];

if(exist("credits.dat"))
    {
    fp.open("credits.dat");
    fp.read((char *)credit,4000,1);
    fp.close();
    SYS_CREDITS((char *)credit);
    }
}

