/*
 *      IRE game runner main module
 */

// Debugging switches

//#define DEBUG_LARGE_OBJECTS
//#define DEBUG_SOLID_OBJECTS
//#define FINDLEAKS
//#define CHECK_ACTIVELIST
//#define CHECK_MASTERLIST

#include <sys/types.h>

#if !defined(__BEOS__) && !defined(_WIN32)
#include <sys/mman.h>
#endif
#include <string.h>
#include <time.h>

#ifdef _WIN32
#include <process.h>
#include <stdlib.h>
#endif

#include "doslib.hpp"
#include "sys.hpp"
#include "core.hpp"
#include "script.hpp"
#include "fs.hpp"
#include "loaders.hpp"
#include "init.hpp"
#include "oscli.hpp"
#include "console.hpp"
#include "linklist.hpp"
#include "memory.hpp"
#include "project.hpp"
#include "bitmap.h"
#include "object.hpp"
#include "keys.hpp"
#include "loadsave.hpp"
#include "rgb_conv.hpp"
#include "darkness.hpp"
#include "sound.hpp"
#include "nuspeech.hpp"
#include "vidmodes.h"

// defines

#define VIEWX 16
#define VIEWY 16

// variables

static SPRITE transfer,warning;
int mapx=0,mapy=0,dmap_wxh,dmap_w;
extern char *cfa;
extern char *darkmap,*darkrect;
extern char show_vrm_calls,use_light,AL_dirty;
extern int mvol;
extern OBJECT *syspocket;
int do_lightning=0;
char __cursor[]={24,0};         // Character in font used for cursor
char user_input[128];

unsigned int game_minute=0;     // Must be INT or SeeR will have a hissy fit
unsigned int game_hour=0;
unsigned int game_day=0;
unsigned int game_month=0;
unsigned int game_year=0;

unsigned long fpsmetric=0;
time_t startmetric, stopmetric;
double timemetric;

int vscheduler=-1,mainproc=-1,status=-1,look_none=-1,use_none=-1,follower=-1,loadproc=-1,all_dead=-1,playervrm=-1;
int ytab[MAX_H];

char *savegame="savegame.sgo";

OBJECT *player;                  // Current 'host' object
OBJECT *victim;                  // Object being hit (for triggers)
OBJECT *party[MAX_MEMBERS];      // Party members

OBJECT *current_object;
TILE   *current_tile;
int    *storage;
OBJECT **objectstore;
char   *message;
char   fullrestore=0;
int    new_x,new_y;
int    key,show_roof=1;

char *solid_map;
char *roof_map;
char *trigger_map;
OBJECT *largemap[24][24];
int     solidmap[24][24];
OBJLIST *ActiveList=NULL;

// functions

void On();                              // Start the graphics mode
void DrawMap(int x,int y);              // Draw the map and all the things
void SyncMap();

void Eproject_sprites(char *screen);
void Eproject_roof(char *screen);
void spillcontents(OBJECT *t,int x,int y);
void CheckHurt(OBJECT *list);
extern void p_light(char *screen);

extern void findpath(int sx,int sy,int ex,int ey);
extern void makepath(OBJECT *i,int ex,int ey);


extern void Call_VRM(int v);
int getYN(char *q);
int get_key();
int get_key_debounced();

TILE   *GetTile(int x,int y);
OBJECT *GetSolidObject(int x,int y);
OBJECT *GetTopObject(int x,int y);
void GetNearDirection(char *message);


int isSolid(int x,int y);

//static void Update_cmap();
static void CheckTraps(int x, int y);

extern void gen_largemap();
extern void SoundSettings();
extern void StoreObjects();
void Restart();
extern int choose_leader(int x);
void FollowPath(OBJECT *it,char *path);
void PathUpdate(OBJECT *o);

// code

/*
 *      IRE runner
 */

void startgame()
{
char running;
OBJECT *current;
OBJECT *temp;
//OBJECT **ptr;
OBJLIST *active,*next;
char party_member_dead = 0;
int vx,vy;

cfa = "Start Game 01";

boot2("Allocating storage dump\n");

storage = (int *)M_get(STORE,sizeof(int));

boot2("Allocating object store\n");

objectstore = (OBJECT **)M_get(OSTORE,sizeof(OBJECT *));
syspocket = curmap.object;
curmap.object->flags.on=1;

boot2("Allocating transfer buffer\n");

transfer.allocate(256,256);
darkrect=(char *)M_get(256,256);   // A 64k linear darkmap

cfa = "Start Game 02";     // Return message to appropriate topic

boot2("Allocating collision matrices\n");

// Get size of collision matrix in bytes

cmap_width = curmap.w / 8;  // 8 bits per byte
cmap_height = curmap.h;
cmap_wxh = cmap_width * cmap_height;
dmap_wxh = curmap.w*curmap.h;

dmap_w = curmap.w;
// Allocate size accordingly, for the solid map and the trigger map

solid_map = (char *)M_get(1,cmap_width*cmap_height);
trigger_map = (char *)M_get(1,cmap_width*cmap_height);
roof_map = (char *)M_get(1,cmap_width*cmap_height);

cfa = "Start Game 03";     // Set message to appropriate topic

if(graflog < 1) // If > 0, we're in graphics mode already
    {
    boot2("Starting graphics system\n");
    On();
    }
else
    switch_logger_off();

#ifndef __DJGPP__
K_Init();
#endif

boot2("Loading backing panel\n");

display_PCX("backings/panel",(short *)swapscreen);
logger_get_backing();

load_CEL(&warning,"warning.cel");

//load_PCX(&lightmap,"sprites/lightmap");

cfa = "Start Game 04";     // Return message to appropriate topic

running = 1;
player = NULL;
memset(party,0,sizeof(OBJECT *) * MAX_MEMBERS);

Dark_Init();

boot2("Set up conversation system\n");
NPC_Init();

boot2("Init projector\n");
Init_Projector();

boot2("Seeking player\n");

for(int matx=0;matx<curmap.w;matx++)
    for(int maty=0;maty<curmap.h;maty++)
        for(temp=curmap.objmap[ytab[maty]+matx];temp;temp=temp->next)
            if(!stricmp(temp->name,"player"))
                player = temp;

if(!player)
    panic(cfa,"Could not find any players at all!",NULL);

party[0] = player;      // Init party
player->flags.party=1;  // Make sure

boot2("%d bytes free as we start the game:\n",coreleft());

boot2("Calling VRM: mainproc\n");

Call_VRM(mainproc);     // Call initial function
S_MusicVolume(mvol);

boot2("Init main game engine\n");

cfa = "main game engine";

C_printf("Starting main game engine\n");

SyncMap();      // Centre on the player

fpsmetric=0;
time(&startmetric);

do {
   if(show_vrm_calls)
       {
       boot2("\n");
       boot2("Start of turn\n");
       boot2("\n");
       }

   Call_VRM(vscheduler);     // Call initial function
   Call_VRM(status);         // Display statistics
   gen_largemap();
   DrawMap(mapx,mapy);
   C_updatelist();
//   Update_cmap();

   key = 0;
   key = get_key();

// Move all things

   if(show_vrm_calls)
       boot2("Moving Things..\n");

current=current_object;

// Move the player first

current_object = player;   // Set up parameters for the VRM
Call_VRM(player->behave);    // Call it

// Reset update flags
for(active=ActiveList;active;active=active->next)
    {
    active->ptr->flags.didupdate=0;
#ifdef CHECK_ACTIVELIST
    if(active->ptr->behave == -1)
        {
        Bug("ActiveList: %s is not active\n",active->ptr->name);
        ML_Del(&ActiveList,active->ptr);
        active=ActiveList;
        }
#endif
    }

#ifdef CHECK_MASTERLIST
for(active=MasterList;active;active=active->next)
  {
  if(!active->ptr)
        {
        Bug("MasterList: NULL detected\n");
        ML_Del(&MasterList,active->ptr);
        active=MasterList;
        }
  }
#endif

player->flags.didupdate=1; // Player can't move again

// Now move all other objects

active=ActiveList;
if(active)
do  {
    next = active->next;
    if(active->ptr->flags.on)
      if(!active->ptr->flags.didupdate) // Don't do this one again if we need
        {                               // to restart the update
        active->ptr->stats->oldhp = active->ptr->stats->hp;
        AL_dirty=0;                     // Mark list as clean
        current_object = active->ptr;   // Set up parameters for the VRM
        active->ptr->flags.didupdate=1; // Mark object as moved
        Call_VRM(active->ptr->behave);  // Call the VRM function
        if(AL_dirty)                    // If list is dirty we need to
            next=ActiveList;            // start over.
        }
    active = next;
    } while(active);


game_minute++;
if(game_minute>59)
    {
    game_minute=0;
    game_hour++;
    if(game_hour>23)
        {
        game_hour=0;
        game_day++;
        if(game_day > 30)
            {
            game_day=0;
            game_month++;
            if(game_month > 12)
                {
                game_month=0;
                game_year++;
                }
            }
        }

/*
    ptr=curmap.objmap;
    for(vy=0;vy<vx;vy++)
        for(temp=*ptr++;temp;temp=temp->next)
            if(temp)               // If active
                if(temp->schedule)
                    FollowPath(temp,temp->schedule[game_hour]);
*/
    }

// Determine roof state

   show_roof = 1;       // Assume we don't need to (0 = show, 1 = hide)

//   if(GetBit(player->x,player->y,roof_map))
   if(curmap.roof[(player->y*curmap.w)+player->x])
       if(RTlist[curmap.roof[(player->y*curmap.w)+player->x]].name)
           show_roof=0;

SyncMap();      // Sync first to prevent problems when player moves

// Administrate all landmines, traps and triggers
for(vy=0;vy<VSH;vy++)
    for(vx=0;vx<VSW;vx++)
        CheckTraps(vx+mapx,vy+mapy);

// Kill dead things
//
//

   if(show_vrm_calls)
       boot2("Admin death and destruction..\n");

   if(player->stats->hp < 0)
          Call_VRM(status);        // show the player their dead HP

   // Any party members who are found to be dead get their membership revoked
   party_member_dead = 0;

   for(int ctr=0;ctr<MAX_MEMBERS-1;ctr++)
       if(party[ctr])
           if(party[ctr]->stats->hp <1)
               {
/*             if(party[ctr]->personalname)
                   C_printf("%s is dead!\n",party[ctr]->personalname);
               else
                   C_printf("%s is dead!\n",party[ctr]->shortdesc);
*/
               if(player == party[ctr])         // Sync map before player
                      SyncMap();                // gets erased
               SubFromParty(ctr);
               party_member_dead = 1;
               }

// Call the game_over code.  This may reinit the world, or just resurrect
// the player elsewhere.

   if(!player)
       {
       DrawMap(mapx,mapy);
       if(show_vrm_calls)
          boot2("all fall down\n");
       Call_VRM(all_dead);
       }

DeletePending();        // Destroy And Be Free!  Destroy And Be Free!

// Check internal system keys

    if(key == KEY_F4)       // F4 - sound volume
        SoundSettings();

    if(key == KEY_F2)
        if(getYN("Save game"))
            {
            savegame = "savegame.sgo";
            save_z1(savegame);
            savegame = "savegame.sgm";
            save_ms(savegame);
            }

    if(key == KEY_F3)
        if(getYN("Restore game"))
            if(exist(savegame))
                {
                boot2("\nRELOAD\n\n");
                boot2("before memory %d\n",coreleft());
                wipe_z1();
                fullrestore = 1;
                savegame = "savegame.sgo";
                load_z1(savegame);
                savegame = "savegame.sgm";
                load_ms(savegame);
                fullrestore = 0;
                Call_VRM(mainproc);
                Call_VRM(loadproc);
                boot2("after memory %d\n",coreleft());
                }
            else
                C_printf("Could not find savegame '%s'\n",savegame);

    if(key == KEY_ESC)
        if(getYN("Quit game"))
            running = 0;

    if(key == KEY_F10)
        {
        C_printf("Taking screenshot..\n");
        C_updatelist();
        update(swapscreen);
        BMPshot((short *)swapscreen,640);
        }

#ifdef FINDLEAKS
    C_printf("memory: %x\n",coreleft());
#endif

    SyncMap();
    if(itg_abort)
        running=0;
    } while(running);

time(&stopmetric);

C_term();
Dark_Term();

boot2("Game is quit by user\n");
V_off();

timemetric = difftime(stopmetric, startmetric);
boot2("Measured %f fps\n",(double)fpsmetric/timemetric);

}

/*
 *	initialise the graphics display by calling the drivers
 */

void On()
{

if(VideoMode == -1)
    {
    puts("Did not find a -VideoMode parameter in ire.ini..");
    exit(1);
    }

if(!V_on(VideoMode))
    {
    printf("Can't Initialise graphics\n");
    printf("Mode %d is unavailable.  Please run the setup program.\n",VideoMode);
    exit(1);
    }
}


/* ============================== Map Manipulation ======================== */

/*
 *      DrawMap - Display the map on screen
 */

void DrawMap(int x,int y)
{
int xctr=0;
int yctr=0,ptr,bit;
int mapx,mapy;

yctr=STARTX;
xctr=STARTX;

mapy = y;
mapx = x;

ptr=mapy*curmap.w;
ptr+=mapx;

bit=curmap.w - VSW;
for(int ctr=0;ctr<VSH;ctr++)
	{
	for(int ctr2=0;ctr2<VSW;ctr2++)
		{
                if(curmap.physmap[ptr] == RANDOM_TILE)
                    warning.block_put_sprite(xctr,yctr,bg_screen);
                else
                    TIlist[curmap.physmap[ptr]].form->seq[0]->image.block_put_sprite(xctr,yctr,bg_screen);
		xctr+=32;
		ptr++;
		}
	xctr=STARTX;
	yctr+=32;
	ptr+=bit;
	}

Eproject_sprites(bg_screen);
if(show_roof)
    Eproject_roof(bg_screen);

//fbox2(32,32,128,128,random()%0xffff,bg_screen);

if(use_light)
    {
    Dark_Project();
    transfer.get_sprite(STARTX,STARTX,bg_screen);
    I32get2(STARTX,STARTX,256,256,darkrect,darkmap);
    I32darkmem((char *)transfer.spr,darkrect,65535);
    }
else
    transfer.get_sprite(STARTX,STARTX,bg_screen);

if(do_lightning)
    {
    I32lightning((char *)transfer.spr);
    do_lightning--;
    }
transfer.block_put_sprite(VIEWX,VIEWY,swapscreen);

// visual debugger for Large Objects.

#ifdef DEBUG_LARGE_OBJECTS
for(int vy=0;vy<8;vy++)
    for(int vx=0;vx<8;vx++)
        if(largemap[vx+4][vy+4])
            fbox2(VIEWX+(vx<<5),VIEWY+(vy<<5),32,32,0xffff,swapscreen);
#endif
#ifdef DEBUG_SOLID_OBJECTS
for(int vy=0;vy<8;vy++)
    for(int vx=0;vx<8;vx++)
        if(solidmap[vx+4][vy+4])
            fbox2(VIEWX+(vx<<5),VIEWY+(vy<<5),32,32,0xffff,swapscreen);
#endif
fpsmetric++;
}

/*
 *      SyncMap - sync map to player's new position
 */

void SyncMap()
{
if(!player)     // Not if the player's dead!
   return;

if(player->flags.large)
    {
    mapx = (player->x-4)+(player->mw>>1);
    mapy = (player->y-4)+(player->mh>>1);
    }
else
    {
    mapx = player->x-4;
    mapy = player->y-4;
    }

if(mapx<0)
    mapx=0;
if(mapy<0)
    mapy=0;
}

#if 0

/*
 *    Update_cmap - Update the collision detection matrix
 *                  Not currently in use but will probably be needed again
 */

void Update_cmap()
{
OBJECT *temp;

//int blockx,blocky,blockw,blockh;

// First, delete all the solid entries in the matrix.

//memset(solid_map,0,cmap_wxh);
//memset(trigger_map,0,cmap_wxh);
//fset(solid_map,0,cmap_wxh>>2);
fset(trigger_map,0,cmap_wxh>>2);

// Next, search through all the objects, and if they are solid,
// set the appropriate cells in the collision matrix.
// This is done with a nested for(;;) loop to allow for objects that
// occupy more than one square.

// Now search through all the objects, and if they are a trigger,
// set the appropriate cells in the trigger matrix.

for(temp = curmap.object->next;temp;temp=temp->next)
    if(temp->flags.trigger && temp->flags.on)           // If a trigger then..
        for(int xctr=0;xctr<temp->mw;xctr++)            // For the width,
            for(int yctr=0;yctr<temp->mh;yctr++)        // For the height,
               SetBit(temp->x+xctr,temp->y+yctr,trigger_map); // Fill this bit.

}
#endif

/*
 *      isSolid - return TRUE if the map square of interest is impassible
 */

int isSolid(int x,int y)
{
TILE *tile;
OBJECT *temp;
    tile = GetTile(x,y);                        // Look at tiles first
    if(tile->flags.solid)
       return 1;

    if(x>=mapx && y>=mapy)                      // Check for a big object
       if(x<mapx+VSW)                           // If onscreen
          if(y<mapy+VSH)
              return solidmap[4+x-mapx][4+y-mapy];

    temp = curmap.objmap[ytab[y]+x];            // Now look at object map
    for(;temp;temp=temp->next)
        if(temp->flags.solid)
            if(temp->flags.on)
                return 1;
return 0;
}

/*
 *      blocksLight - return TRUE if the map square of interest blocks light
 *
 */

int blocksLight(int x,int y)
{
TILE *tile;
OBJECT *object;

    tile = GetTile(x,y);                        // Look at tiles first
    if(tile->flags.blocklight)
       return 1;
    object = GetObjectBase(x,y);
    for(;object;object=object->next)
        if(object->flags.blocklight)
            if(object->flags.on)
                return 1;
return 0;
}

/*
 *      getYN - Ask a question, return TRUE if the answer is Y
 */

int getYN(char *q)
{
C_printf("%s- Are you sure?  ",q);
C_updatelist();
update(swapscreen);
if(get_key() != KEY_Y)
    {
    C_printf("No.\n");
    return 0;
    }
else
    {
    C_printf("Yes.\n");
    return 1;
    }
}

/*
 *      get_key - Get a key from the user, animate things in the background
 */

int get_key()
{
int input=0;

do  {
    DrawMap(mapx,mapy);
    update(swapscreen);
    input = SYS_GET_KEY();
    } while(!input && !itg_abort);
return input;
}

/*
 *      get_key_debounced - Get a key, wait for it to be released
 */

int get_key_debounced()
{
int input=0;

input = get_key();
SYS_KEY_FLUSH();

return input;
}

/*
 *      get_num - User types in a number, animate things in the background
 */

int get_num(int no)
{
int input=0,key;
int bufpos=0;
char buf[128];
char ktab[255];

memset(ktab,0,255);
ktab[KEY_0] = '0';
ktab[KEY_1] = '1';
ktab[KEY_2] = '2';
ktab[KEY_3] = '3';
ktab[KEY_4] = '4';
ktab[KEY_5] = '5';
ktab[KEY_6] = '6';
ktab[KEY_7] = '7';
ktab[KEY_8] = '8';
ktab[KEY_9] = '9';

itoa(no,buf,10);
bufpos=strlen(buf);
buf[bufpos]=0;
do  {
    DrawMap(mapx,mapy);
    C_delete();
    C_printit(buf);
    C_printit(__cursor);
    C_updatelist();
    update(swapscreen);
    input = SYS_GET_KEY();
    if(ktab[input] >= '0' && ktab[input] <= '9')
        {
        if(bufpos<conwid)
            {
            buf[bufpos++]=ktab[input];
            buf[bufpos]=0;
            }
        }
    if(input == KEY_DELETE || input == KEY_BACKSPACE)
      if(bufpos>0)
        {
        bufpos--;
        buf[bufpos]=0;
        }
    } while(input != KEY_ESC && input != KEY_ENTER && !itg_abort);
C_delete();
C_printit(buf);
C_printit("\n");
if(input == KEY_ESC)
    return 0;
strcpy(user_input,buf);
return 1;
}


/*
 *      RedrawMap - Redraw the map and update
 */

void RedrawMap()
{
SyncMap();
DrawMap(mapx,mapy);
update(swapscreen);
if(SYS_GET_KEY()==KEY_F10)
    BMPshot((short *)swapscreen,640);
}


/*
 *      Restart - Restart the game
 */

void Restart()
{
char test[32];
OBJECT *temp;

Wipe_tFlags();

wipe_z1();

fullrestore = 0;
strcpy(test,mapname);
strcat(test,".mz1");
load_z1(test);
fullrestore = 0;

// Find player

player = NULL;
for(int matx=0;matx<curmap.w;matx++)
    for(int maty=0;maty<curmap.h;maty++)
        for(temp=curmap.objmap[ytab[maty]+matx];temp;temp=temp->next)
            if(!stricmp(temp->name,"player"))
                player = temp;
if(!player)
    panic("restart","Cannot find the player anymore",NULL);

Call_VRM(mainproc);
Call_VRM(loadproc);

for(int ctr=0;ctr<MAX_MEMBERS-1;ctr++)
    party[ctr]=0;
party[0]=player;
player->flags.party=1;
}

/*
 *      Spillcontents - If a container is destroyed it bursts
 */

void spillcontents(OBJECT *t,int x,int y)
{
OBJECT *temp;
while(t->pocket)
    {
    temp=t->pocket;
    t->pocket=t->pocket->next;
    ForceDropObject(x,y,temp);
    };
}


/*
 *      check_hurt - Poll the things to see if they've been harmed or killed
 */

void CheckHurt(OBJECT *start)
{
OBJECT *temp,*oldcurrent,*next=NULL;

// Check for things that are hurt

if(!start)
    return;

oldcurrent=current_object;

for(temp=start;temp;temp=next)
    {
    next=temp->next;
    if(temp->flags.on)
        {
        if(temp->stats->hp < temp->stats->oldhp)
            {
            if(temp->stats->hp>0)
                if(temp->funcs->hcache != -1)
                    {
                    current_object = temp;
                    Call_VRM(temp->funcs->hcache);
                    current_object = oldcurrent;
                    }
            temp->stats->oldhp=temp->stats->hp;
            }

// "They're all dead.  They just don't know it yet." - Eric Draven, The Crow

        if(temp->stats->hp < 1)
            {
            if(temp->funcs->kcache != -1)      // If it can be killed..
                {
                current_object = temp;
                Call_VRM(temp->funcs->kcache); // ..then kill it.
                if(current_object)
                    temp->stats->oldhp=temp->stats->hp;
                current_object = oldcurrent;
                }
            else                                  // If it cannot be killed
            if(temp->stats->hp < -10000)          // and it is very dead..
                {                                 // ..it shall be Made Not
                if(temp == player)                // unless it's the player
                    return;
                if(temp->pocket)                  // A bag with stuff in!
                   spillcontents(temp,temp->x,temp->y);    // Open 'er up
                temp->flags.on = 0;               // Mark pending delete
                pending_delete = 1;               // Destroy and be Free!
                if(current_object == temp)
                    current_object = NULL;
                if(victim == temp)
                    victim = NULL;

                }
            }
        }
    }
}

/*
 *      CheckTraps - Poll the triggers to see if they've been activated
 */

void CheckTraps(int x, int y)
{
OBJECT *temp,*start,*oldcurrent;

start = curmap.objmap[ytab[y]+x];

// Check for traps.

oldcurrent = current_object;

for(temp=start;temp;temp=temp->next)
    {
    if(temp->flags.trigger)
        if(temp->flags.on)
            {
            // Found one.  Hurt the object above the trap
            victim=temp->next;
            if(victim)
            if(!victim->flags.spikeproof)
                {
                current_object = temp;
                Call_VRM(current_object->funcs->scache); // call Stand func.
                current_object = oldcurrent;
                victim=NULL; // Cause a crash if there's a bug
                }
            // Done
            }
    }

victim = NULL;
}


