;
;       Generic VESA driver for mode 111 hex
;

[BITS 32]

[global _i111_on]
[global _i111_update]
[global _i111_retrieve]
[global _i111_version]

[EXTERN ___SegA000]

; Macro to set banks, using the VESA bankswitcher

   %macro set_bank 1
	mov edx,%1	        ;; Bank (x)
	mov ebx,0		;; Nothing Else
	mov eax,4f05h		;; VESA set bank
	int 10h			;; Call VESA
	mov eax,4f05h		;; VESA set bank
	mov bl,1		;; ?
	int 10h			;; Call VESA
   %endmacro

   %macro copy_bank 1
   mov ecx,%1			; Copy the block
   mov edi,0
   rep movsd			; ESI should be pointing at the swapscreen
   %endmacro

   %macro retr_bank 1
   mov ecx,%1			; Copy the block
   mov esi,0
   rep movsd			; ESI should be pointing at the swapscreen
   %endmacro

; Driver functions

[SECTION .text]

vstring db "VESA video driver, 16bpp, v1.2",0

;
; Get driver version
;

_i111_version:
mov eax,vstring
ret

;
; Enter graphics mode
;

_i111_on:
	pushad
	mov eax,4f02h
	mov ebx,111h
	int 10h
	cmp ah,0
	jz all_ok
	popad
	mov eax,0
	ret
all_ok:
	popad
	mov eax,1
	ret		;go back to C program


;
;	blit to screen
;


_i111_update:
;	ARG dat:dword		; Set up C calling convention
	push ebp
	mov ebp,esp

	pushad				; Preserve Everything
	push es

	mov es,[___SegA000]	; Current Video Selector
	mov esi,[ebp+8]	; Point to swap screen

;;; 0
        set_bank 0
        copy_bank 16384


;;; 1

        set_bank 1
        copy_bank 16384

;;; 2

        set_bank 2
        copy_bank 16384

;;; 3

        set_bank 3
        copy_bank 16384

;;; 4

        set_bank 4
        copy_bank 16384

;;; 5

        set_bank 5
        copy_bank 16384

;;; 6

        set_bank 6
        copy_bank 16384

;;; 7

        set_bank 7
        copy_bank 16384

;;; 8

        set_bank 8
        copy_bank 16384

;;; 9

        set_bank 9
        copy_bank 6144          ; The last bank is shorter

	pop es
	popad					; Clean up
	pop ebp
	ret


;
;  Unsupported
;


_i111_retrieve:
	push ebp
	mov ebp,esp

	pushad				; Preserve Everything
	push ds

	mov ds,[___SegA000]	; Current Video Selector
	mov edi,[ebp+8]	; Point to swap screen

;;; 0
        set_bank 0
        retr_bank 16384

;;; 1

        set_bank 1
        retr_bank 16384

;;; 2

        set_bank 2
        retr_bank 16384

;;; 3

        set_bank 3
        retr_bank 16384

;;; 4

        set_bank 4
        retr_bank 16384

;;; 5

        set_bank 5
        retr_bank 16384

;;; 6

        set_bank 6
        retr_bank 16384

;;; 7

        set_bank 7
        retr_bank 16384

;;; 8

        set_bank 8
        retr_bank 16384

;;; 9

        set_bank 9
        retr_bank 6144          ; The last bank is shorter

	pop ds
	popad					; Clean up
	pop ebp
	ret


