;
;       Linear driver for mode 110 hex
;

[BITS 32]

[global _i4110_on]
[global _i4110_update]
[global _i4110_retrieve]
[global _i4110_version]

[EXTERN ___SegA000]

; Driver functions

[SECTION .text]

vstring db "Linear video driver, 15bpp, v1.2",0

;
; Get driver version
;

_i4110_version:
mov eax,vstring
ret

;
; Enter graphics mode
;

_i4110_on:
	pushad
	mov eax,4f02h
	mov ebx,4110h
	int 10h
	cmp ah,0
	jz all_ok
	popad
	mov eax,0
	ret
all_ok:
	popad
	mov eax,1
	ret		;go back to C program

;
;	blit to screen
;

_i4110_update:
;	ARG dat:dword		; Set up C calling convention
	push ebp
	mov ebp,esp

	pushad				; Preserve Everything
	push es

	mov es,[___SegA000]	        ; Current Video Selector
	mov esi,[ebp+8]	                ; Point to swap screen

	mov ecx,153600			; Copy it ALL!!!
	mov edi,0
	rep movsd			; ESI is pointing at the swapscreen

	pop es
	popad					; Clean up
	pop ebp
	ret


;
;  Used by setup program, DOS only
;

_i4110_retrieve:
	push ebp
	mov ebp,esp

	pushad				; Preserve Everything
	push ds

	mov ds,[___SegA000]	        ; Current Video Selector
	mov edi,[ebp+8]	                ; Point to swap screen

	mov ecx,153600			; Copy it ALL!!!
	mov esi,0
	rep movsd

	pop ds
	popad					; Clean up
	pop ebp
	ret

