/*
 *    Fullscreen driver for Beos R4 16bpp
 *
 */

#ifndef __BEOS__
#error "This file is for BeOS IV only"
#endif

#define APPSIG "application/x-vnd.ITG-7.10"

#include "itg.h"
#include <Application.h>
#include <WindowScreen.h>

// Create new class inherited from BWindowScreen

class iBWindowScreen : public BWindowScreen
{
public:
char *get_display_surface();
iBWindowScreen(char *a,uint32 space, status_t *error, bool b);
};

// Member function to return address of Linear Framebuffer

char *iBWindowScreen::get_display_surface()
{
graphics_card_info *gci;
gci = CardInfo();
return (char *)gci->frame_buffer;
}

// Create the screen object

iBWindowScreen::iBWindowScreen(char *a,uint32 s, status_t *e, bool b)
	: BWindowScreen(a,s,e,b)
{
Show();
}

// Set up some variables

static char *surface;
static iBWindowScreen *b;
extern char itg_caption[];

#define FBSIZE 614400
#define FBSIZE4 153600


// Return driver version

char *be16D_version()
{
return "BeOS FULLSCREEN video driver, 16bpp, v1.0";
}

// Initialise driver

int be16D_on()
{
status_t error;

// This crap is bolted on because otherwise the BeOS will sulk.
new BApplication(APPSIG);

// Create the display surface object
b = new iBWindowScreen(itg_caption,B_16_BIT_640x480,&error,0);
if(error != B_OK)
	{
	fprintf(stderr,"Oh no!!\n");
	delete be_app;
	return 0;
	}


b->Lock();
// Get the address for the blit function
surface = b->get_display_surface();
b->Unlock();

// Print surface address on console for fun
fprintf(stderr,"display surface=0x%x\n",surface);
return 1;
}


// Blit internal screen to BeOS display surface

void be16D_update(char *buffer)
{
if(!surface)
    return;
fcpy(surface,buffer,FBSIZE4);	// memcpy but with dwords
b->Show();
}

// Grab BeOS display surface (not used)

void be16D_retrieve(char *buffer)
{
if(!surface)
    return;
b->Show();
memcpy(buffer,surface,FBSIZE);
}

// Shut down the display driver

void be16D_off()
{
surface=NULL;
b->Lock();
b->Quit();

//delete be_app;
}
