/*
 *      BeOS-specific video driver code
 */

#include <stdio.h>
#include "SDL.h"
#include "itg.h"


#ifndef __BEOS__
#error "This file is for BeOS R4 only"
#endif

extern void gen_clut(int bpp);


// SDL 16 bpp Windowed
extern "C" char *sdl16W_version();
extern "C" int sdl16W_on();
extern "C" void sdl16W_update(char *a);
extern "C" void sdl16W_retrieve(char *a);


// BeOS Windowed 16 bpp

extern char *be16W_version();
extern int be16W_on();
extern void be16W_update(char *);
extern void be16W_retrieve(char *a);
extern void be16W_off();

// BeOS Fullscreen 16 bpp

extern char *be16D_version();
extern int be16D_on();
extern void be16D_update(char *a);
extern void be16D_retrieve(char *a);
extern void be16D_off();

char itg_caption[128];

void set_caption(char *m)
{
strcpy(itg_caption,m);
}

int Init_Be16D()
{
puts(ITGver);
puts("  Driver:  be16D.cc");
printf("  %s\n",be16D_version());

on       = be16D_on;
update   = be16D_update;
retrieve = be16D_retrieve;
gen_clut(16);
return 1;
}

/*
// Use SDL instead

int Init_Be16W()
{
puts(ITGver);
puts("  Driver:  be16W.cc");
printf("  %s\n",be16W_version());

on	 = be16W_on;
update	 = be16W_update;
retrieve = be16W_retrieve;
gen_clut(16);
return 1;
}
*/

int Init_SDL16W()
{
puts(ITGver);
puts("  Driver:  sdl16_w.cc");
printf("  %s\n",sdl16W_version());

on       = sdl16W_on;
update   = sdl16W_update;
retrieve = sdl16W_retrieve;

gen_clut(16);
return 1;
}

char sdl_off()
{
SDL_Quit();
}


