/*
 *      Common video driver code
 */

#include <stdio.h>
#include <stdlib.h>

#include "itg.h"

extern char __bpp;

void OhNo(char *s);
void gen_clut(int bpp);

// MR: had to define these as extern "C" and place the real 
// ones into a *.C file so they'd link properly
extern "C" unsigned short *I32_clut;
extern "C" unsigned char *I32_dlut;
extern "C" unsigned char *I32_llut;

/*
 * - Generate colour look up table
 */

void gen_clut(int bpp)
{
int ctr,light;
unsigned short level;
signed short r,g,b;

puts("  Init Dark/Colour Lookuptable.. ");

switch(bpp)
    {
    // 15bpp colour lookup table

    case 15:
    I32_clut=(unsigned short *)calloc(32,32768*sizeof(unsigned short));

    if(!I32_clut)
        OhNo("Could not allocate 2MB 15bpp lookup table");

    for(light=0;light<32;light++)
        for(ctr=0;ctr<32768;ctr++)
            {
            level=ctr;
            b=(level&0x001f);
            g=(level&0x03e0)>>5;
            r=(level&0x7c00)>>10;
            r-=light;
            g-=light;
            b-=light;
            if(r<0) r=0;
            if(g<0) g=0;
            if(b<0) b=0;
            level=(b)+(g<<5)+(r<<10);
            I32_clut[(light<<15)+ctr]=level;
            }
    __bpp=0;
    break;

    // 16bpp lookup table

    case 16:
    I32_clut=(unsigned short *)calloc(32,65536*sizeof(unsigned short));

    if(!I32_clut)
        OhNo("\nCould not allocate 4MB 16bpp lookup table");

    for(light=0;light<32;light++)
        for(ctr=0;ctr<65536;ctr++)
            {
            level=ctr;
            b=(level&0x001f);
            g=(level&0x07e0)>>6;
            r=(level&0xfc00)>>11;

            r-=light;
            g-=light;
            b-=light;
            if(r<0) r=0;
            if(g<0) g=0;
            if(b<0) b=0;
            level=(b)+(g<<6)+(r<<11);
            I32_clut[(light<<16)+ctr]=level;
            }

    __bpp=1;
    break;

    // Bug detector

    default:
    OhNo("Programmer error!! BPP value is bullshit in gen_clut()");
    }

puts("  Init lightsource Lookuptable.. ");

    I32_dlut=(unsigned char *)calloc(256,256);
    if(!I32_dlut)
        OhNo("Could not allocate 64k lookup table");

    for(light=0;light<256;light++)
        for(ctr=0;ctr<256;ctr++)
            {
            r=ctr-light;
            if(r<0) r=0;
            I32_dlut[(light<<8)+ctr]=r;
            }

puts("  Init darksource Lookuptable.. ");

    I32_llut=(unsigned char *)calloc(256,256);
    if(!I32_llut)
        OhNo("Could not allocate second 64k lookup table");

    for(light=0;light<256;light++)
        for(ctr=0;ctr<256;ctr++)
            {
            r=ctr+light;
            if(r>31) r=31;
            I32_llut[(light<<8)+ctr]=r;
            }
}

/*
 *
 */

void OhNo(char *s)
{
puts("\nOh No!");
puts(s);
exit(1);
}


