/*
IT-HE Graphics Library(32ITG)
	By IT-HE Software(1995)
  ( James, Joe and Martyn )
*/
/*
32ITG Headder File
*/
#ifndef __32BIT_ITG_HEADDER
#define __32BIT_ITG_HEADDER
#include <stdio.h>

// Size of the framebuffer 640x480x2 (16bpp)

#define BUFFERSIZE 614400
#define HALFBUFFERSIZE  307200
#define QTRBUFFERSIZE  153600

extern int Init_110();
extern int Init_111();
extern int Init_4110();
extern int Init_4111();
extern int Init_110CL();
extern int Init_111CL();
extern char itg_abort;

typedef char PALETTE[768];
typedef char palette[768];

// Just in case it needs to change...

#ifdef __DJGPP__
#define DECL extern "C"
#endif

#ifdef __linux__
#define DECL extern "C"
#endif

#ifdef __BEOS__
#define DECL extern "C"
#endif

// MR: Added
#ifdef _WIN32
#define DECL extern "C"
#endif

#ifndef DECL
#error UNKNOWN OS
#endif

DECL void off(void);
DECL void dot(int x,int y,short c,char *s);
DECL void hline( int x1, int y1, int y2, short n,char *s );
DECL void I32darkspr(int x,int y,int w,int h,char *scr,char *darkmap);
DECL void I32darkspr_inv(int x,int y,int w,int h,char *scr,char *darkmap);
DECL void I32darkmem15(char *d,char *s,int pixels);
DECL void I32darkmem16(char *d,char *s,int pixels);
DECL void fset(void *buf,long word,long len);
DECL void fcpy(void *dest,void *src,long len);
DECL void I32direc(char *d,char *s);
DECL void I32get2(int x,int y,int w,int h,char *spr,char *scr);
DECL void fblit(char *dest, char *src);
DECL void I32font(int x,int y,char *d,int colour,char *s);
DECL void I32lightning15(char *a);
DECL void I32lightning16(char *a);

extern int I32init(void);
extern void ITGline( short x1, short y1, short x2, short y2, short n,char *s );
extern void ITG_box(short x,short y,short x2,short y2,short c,char *s);
extern void ITG_box2(short x,short y,short x2,short y2,short c,char *s);
extern void vline( short x1, short y1,  short y2, short n,char *s );

void fbox(short x,short y,short x2,short y2,short c,char *s);
void fbox2(short x,short y,short x2,short y2,short c,char *s);

// Driver-based functions

extern int (*on)();
extern void (*update)(char *buffer);
extern void (*retrieve)(char *buffer);


struct SPRITE
	{
	short *spr;
	short *cspr;
	unsigned int W,H;
	short allocate(short width,short height);
	void free();
	~SPRITE();
	SPRITE();

	void rle_put_sprite(int x,int y,char *dest);

	void cel_put_sprite(int x,int y,char *dest);
	void cel_put_sprite2(int x,int y,char *dest);
	void translucent_sprite(int x,int y,char *dest);
	void clip_sprite(int x,int y,char *dest);
	void block_put_sprite(int x,int y,char *dest);
	void inverse_put_sprite(int x,int y,char *dest);
	void get_sprite(int x,int y,char *src);
	short get_width();
	short get_height();
	};

#define ITGver "ITG v7.1 Initializing.."

#endif

