/*
IT-HE Graphics Library(ITG32)
	By IT-HE Software(1995)
  ( James, Joe and Martyn )
*/

#include "itg.h"
#include <stdio.h>
#include <stdlib.h>

char __bpp;
char itg_abort=0;

extern "C" void I32get1(int x,int y,int w,int h,short *spr,char *scr);
extern "C" void I32put1(int x,int y,int w,int h,short *spr,char *scr);
extern "C" void I32cel1(int x,int y,int w,int h,short *spr,char *scr);
extern "C" void I32cel2(int x,int y,int w,int h,short *spr,char *scr,int coff);
extern "C" void I32cel3(int x,int y,int w,int h,short *spr,char *scr,int coff);
extern "C" void I32celt15(int x,int y,int w,int h,short *spr,char *scr);
extern "C" void I32celt16(int x,int y,int w,int h,short *spr,char *scr);
extern "C" void I32rle(int x,int y,int w,int h,short *spr,char *scr);
extern "C" void I32darkspr(int x,int y,int w,int h,char *spr,char *scr);
extern "C" void I32darkspr_inv(int x,int y,int w,int h,char *spr,char *scr);


void (*update)(char *buffer);
void (*retrieve)(char *buffer);
void (*shovel)(char *buffer);
void (*bungle)(char *buffer,int offset,int w,int h);
int (*on)();

int I32init()
{
	printf("BUG!  You shouldn't call this anymore!\n");
	return 1;
}


short SPRITE::allocate(short width,short height)
	{
	W=width*2;
	H=height;
	spr=(short *)calloc(width*height+1,2);
	if(spr==NULL)
		return NULL;

//	spr->spr=RFP(spr->spr);
	return 1;
	}

void SPRITE::free()
	{
	if(W)
		::free(spr);
	W=NULL;
	return;
	}

SPRITE::~SPRITE()
	{
	if(W)
		::free(spr);
	W=NULL;
	return;
	}

SPRITE::SPRITE()
	{
	cspr=NULL;
	W=NULL;
	H=NULL;
	return;
	}

void SPRITE::cel_put_sprite(int x,int y,char *dest)
	{
	I32cel1(x,y,W,H,spr,dest);
	return;
	}

void SPRITE::cel_put_sprite2(int x,int y,char *dest)
	{
//	cel2(x,y,W,H,spr,dest);
	return;
	}

void SPRITE::translucent_sprite(int x,int y,char *dest)
	{
        if(__bpp)
	    I32celt16(x,y,W,H,spr,dest);
        else
	    I32celt15(x,y,W,H,spr,dest);
	return;
	}

void SPRITE::block_put_sprite(int x,int y,char *dest)
	{
	I32put1(x,y,W,H,spr,dest);
	return;
	}

void SPRITE::rle_put_sprite(int x,int y,char *dest)
	{
//	I32rle(x,y,W,H,cspr,dest);
	return;
	}

/*void SPRITE::inverse_put_sprite(int x,int y,char *dest)
	{
	I32inv1(x,y,W,H,spr,dest);
	return;
	}*/

void SPRITE::get_sprite(int x,int y,char *src)
	{
	I32get1(x,y,W,H,spr,src);
	return;
	}



void SPRITE::clip_sprite(int x,int y,char *dest)
	{
	short *spr2;
	int x2,h,y2,w;

	w=W>>1;
	h=H;
	x2=x+w;
	spr2=spr;
	y2=y+H;

	if(y<0)
		{
		h+=y;
		spr2+=((0-y)*w);
		y=0;
		}
	else
	if(y2>479)
		h=480-y;
	if(y>479||y2<=0)
		return;
	if(x>638||x2<=0)
		return;

	if(x2>639)
		I32cel3(x,y,640-x,h,spr2,dest,x2-640);
	else
	if(x<0)
		I32cel2(0,y,W+(x<<1),h,spr2,dest,0-x);
	else
                I32cel1(x,y,W,h,spr2,dest);
	return;
	}

short SPRITE::get_width()
{
	return W>>1;
}

short SPRITE::get_height()
{
	return H;
}

void ITGline( short xa, short ya, short xb, short yb, short colour,char *s )
{
	register short t, distance;
	short  xerr=0, yerr=0, delta_x, delta_y;
	short incx, incy;

	// Find the distance to go in each plane.
	delta_x = xb - xa;
	delta_y = yb - ya;

	// Find out the direction
	if(delta_x > 0) incx = 1;
	else if(delta_x == 0) incx = 0;
	else incx = -1;

	if(delta_y > 0) incy = 1;
	else if(delta_y == 0) incy = 0;
	else incy = -1;

	// Find which way is were mostly going
	delta_x = abs(delta_x);
	delta_y = abs(delta_y);
	if(delta_x > delta_y) distance=delta_x;
	else distance=delta_y;

	// Draw the god dam line.
	for(t = 0; t <= distance + 1; t++) {
		dot((int)xa, (int)ya, (int)colour,s);
		xerr += delta_x;
		yerr += delta_y;
		if(xerr > distance) {
			xerr -= distance;
			xa += incx;
		}
		if(yerr > distance) {
			yerr -= distance;
			ya += incy;
		}
	}
}


void ITG_box(short x,short y,short x2,short y2,short c,char *s)
{
ITGline(x,y,x2,y,c,s);
ITGline(x2,y,x2,y2,c,s);
ITGline(x2,y2,x,y2,c,s);
ITGline(x,y2,x,y,c,s);
}

//void hline(short x,short x2,short y,short c,char *s)
//{
//ITGline(x,y,x2,y,c,s);
//}

void vline(short x,short y,short y2,short c,char *s)
{
ITGline(x,y,x,y2,c,s);
}

void fbox(short x,short y,short x2,short y2,short c,char *s)
{
int t;
if(y2<y)
	{
	t=y;
	y=y2;
	y2=t;
	}
if(x2<x)
	x2=x-x2;
else
	x2=x2-x;
	//for(int ctr=y;ctr<y2;ctr++)
//	ITGline(x,ctr,x2,ctr,c,s);
for(int ctr=y;ctr<y2;ctr++)
	hline(x,ctr,x2,c,s);
}

void fbox2(short x,short y,short w,short h,short c,char *s)
{
for(int ctr=0;ctr<h;ctr++)
	hline(x,ctr+y,w,c,s);
//	ITGline(x,ctr+y,x+w,ctr+y,c,s);

}



