/*
 *      Linux-specific video driver code
 */

#include <stdio.h>
#include <dlfcn.h>

#include "itg.h"

#ifndef __linux__
#error "This file is for Linux only"
#endif

// If you want to use either of these god-awful graphics libraries
// uncomment here.

//#define _USE_SVGALIB_		// SVGALIB won't play ball
//#define _USE_GGI_		// GGI is 3 times slower than X-windows

extern void gen_clut(int bpp);

// SDL 15 bpp, Direct (fullscreen)
extern "C" char *sdl15D_version();
extern "C" int sdl15D_on();
extern "C" void sdl15D_update(char *a);
extern "C" void sdl15D_retrieve(char *a);

// SDL 15bpp, Windowed version
extern "C" char *sdl15W_version();
extern "C" int sdl15W_on();
extern "C" void sdl15W_update(char *a);
extern "C" void sdl15W_retrieve(char *a);

// SDL 16 bpp, Direct (fullscreen)
extern "C" char *sdl16D_version();
extern "C" int sdl16D_on();
extern "C" void sdl16D_update(char *a);
extern "C" void sdl16D_retrieve(char *a);

// SDL 16 bpp, Windowed version
extern "C" char *sdl16W_version();
extern "C" int sdl16W_on();
extern "C" void sdl16W_update(char *a);
extern "C" void sdl16W_retrieve(char *a);

#ifdef _USE_SVGALIB_
// Svgalib 15 bpp
extern char *svga15_version();
extern int svga15_on();
extern void svga15_off();
extern void svga15_update(char *a);
extern void svga15_retrieve(char *a);

// Svgalib 16 bpp
extern char *svga16_version();
extern int svga16_on();
extern void svga16_update(char *a);
extern void svga16_retrieve(char *a);
#endif

#ifdef _USE_GGI_
// GGI 15 bpp
extern char *ggi15_version();
extern int ggi15_on();
extern void ggi15_update(char *a);
extern void ggi15_retrieve(char *a);

// GGI 16 bpp
extern char *ggi16_version();
extern int ggi16_on();
extern void ggi16_update(char *a);
extern void ggi16_retrieve(char *a);
#endif

char itg_caption[128];

void set_caption(char *m)
{
strcpy(itg_caption,m);
}

char sdl_off()
{
SDL_Quit();
}

#ifdef _USE_SVGALIB_
char svga_off()
{
svga15_off();
}
#endif


int Init_SDL15D()
{
puts(ITGver);
puts("  Driver:  sdl15_d.cc");
printf("  %s\n",sdl15D_version());

on       = sdl15D_on;
update   = sdl15D_update;
retrieve = sdl15D_retrieve;

gen_clut(15);

return 1;
}

int Init_SDL15W()
{
puts(ITGver);
puts("  Driver:  sdl15_w.cc");
printf("  %s\n",sdl15W_version());

on       = sdl15W_on;
update   = sdl15W_update;
retrieve = sdl15W_retrieve;

gen_clut(15);

return 1;
}

int Init_SDL16D()
{
puts(ITGver);
puts("  Driver:  sdl16_d.cc");
printf("  %s\n",sdl16D_version());

on       = sdl16D_on;
update   = sdl16D_update;
retrieve = sdl16D_retrieve;

gen_clut(16);
return 1;
}

int Init_SDL16W()
{
puts(ITGver);
puts("  Driver:  sdl16_d.cc");
printf("  %s\n",sdl16D_version());

on       = sdl16D_on;
update   = sdl16D_update;
retrieve = sdl16D_retrieve;

gen_clut(16);
return 1;
}


#ifdef _USE_GGI_
int Init_ggi15()
{
puts(ITGver);
puts("  Driver:  ggi15.cc");
printf("  %s\n",ggi15_version());

on       = ggi15_on;
update   = ggi15_update;
retrieve = ggi15_retrieve;

gen_clut(15);

return 1;
}

int Init_ggi16()
{
puts(ITGver);
puts("  Driver:  ggi16.cc");
printf("  %s\n",ggi16_version());

on       = ggi16_on;
update   = ggi16_update;
retrieve = ggi16_retrieve;

gen_clut(16);

return 1;
}
#endif

#ifdef _USE_SVGALIB_
int Init_Svga15()
{
puts(ITGver);
puts("  Driver:  svga15.cc");
printf("  %s\n",svga15_version());

on       = svga15_on;
update   = svga15_update;
retrieve = svga15_retrieve;

gen_clut(15);

return 1;
}

int Init_Svga16()
{
puts(ITGver);
puts("  Driver:  svga16.cc");
printf("  %s\n",svga16_version());

on       = svga16_on;
update   = svga16_update;
retrieve = svga16_retrieve;

gen_clut(16);

fprintf(stderr,"returning 1.\n");

return 1;
}
#endif

