#
#	Makefile for ITG - based on the mikmod 3.10 makefile
#

CC                = gcc
ASM		  = nasm
CFLAGS            = -I. -gdwarf-2 -O3 -I/boot/beos/develop/headers
Librarian         = ar

Lib_file          = beos/itg70.a

Object_files   = be16_d.o sdl16_w.o beos.o itg70_a.o driver70.o itg70_c.o\
		 tables.o 

all: config libitg

libitg:	$(Lib_file)

$(Lib_file): $(Object_files)
	-rm -f $(Lib_file)
	$(Librarian) rcs $(Lib_file) $^

%.o: %.c
	$(CC) -c $(CFLAGS) $< -o $@
 
%.o: %.cc
	$(CC) -c $(CFLAGS) $< -o $@
 
%.o: %.cpp
	$(CC) -c $(CFLAGS) $< -o $@

%.o: %.asm
	$(ASM) -f elf $< -o $@

config :
	echo %include \"beos4.inc\" > os.inc

clean :
	-rm -f *.o $(Lib_file)
