/*
 *    Windowed driver for Beos R4, 16bpp
 */

#ifndef __BEOS__
#error "This file is for BeOS IV only"
#endif

#include <Application.h>
#include <Bitmap.h>
#include "itg.h"
#define APPSIG "application/x-vnd.ITG-7.10"

static char *surface=NULL;
static int v_len,v_len4;
static BBitmap *bb;
static BRect r(0,0,640.0,480.0);
static BApplication *bap;

extern char itg_caption[];
extern char itg_abort;

class itgView : public BView
	{
	public:
	itgView(BRect frame,const char *name);
	~itgView();
	virtual void Draw(BRect u);
	};

itgView::itgView(BRect frame, const char *name)
	: BView(frame,name,B_FOLLOW_ALL,B_WILL_DRAW)
	{
	SetViewColor(B_TRANSPARENT_32_BIT);
	}

void itgView::Draw(BRect u)
	{
	BView::Draw(u);
	MovePenTo(0.0,0.0);
	DrawBitmap(bb);
	Invalidate();
	}

itgView::~itgView()
	{
	itg_abort = 1;
	}

class itgWindow : public BWindow
	{
	public:
	itgWindow();
	virtual ~itgWindow();
	virtual bool QuitRequested(void);
	Draw();
	public:
	itgView *bv;
	} *w;

itgWindow::itgWindow()
	: BWindow(BRect(0,0,640.0,480.0),itg_caption,B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE)
	{
	MoveTo(16.0,32.0);
	bv = new itgView(Bounds(),NULL);
	AddChild(bv);
	Show();
	Sync();
	}

itgWindow::~itgWindow()
	{
	Hide();
	Sync();
	bv->RemoveSelf();
	delete bv;
	itg_abort=1;
	}

bool itgWindow::QuitRequested()
	{	
	itg_abort=1;
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
	}

itgWindow::Draw()
	{
	Lock();
	bv->Show();
	bv->Sync();
	Unlock();
	Show();
	Sync();
	}

#define FBSIZE 614400

char *be16W_version()
{
return "BeOS 4 WINDOWED video driver, 16bpp, v0.9";
}

int be16W_on()
{
bap = new BApplication(APPSIG);
w = new itgWindow();
bb = new BBitmap(r,B_RGB16);
v_len = bb->BytesPerRow();
v_len4 = v_len>>2;

surface = bb->Bits();
itg_abort=0;

return 1;
}


void be16W_update(char *buffer)
{
int ctr;
char *s=surface;

if(itg_abort)
    return;

if(!w)
    return;

if(!w->bv)
    return;

for(ctr=0;ctr<480;ctr++)
     {
     fcpy(s,buffer,v_len4);
     buffer+=1280;
     s += v_len;
     }
w->Draw();
}

void be16W_retrieve(char *buffer)
{
int ctr,len;
char *s=surface;

if(itg_abort)
    return;

for(ctr=0;ctr<480;ctr++)
     {
     memcpy(buffer,s,len);
     buffer+=1280;
     s += v_len;
     }
}


void be16W_off()
{
w->Lock();
w->Quit();
delete w;
itg_abort = 1;
}
