/*
 *    GGI driver for Linux IRE
 *    15 bpp
 */

#ifndef __linux__
#error "This file is for Linux only"
#endif

#include <stdio.h>
#include <ggi/ggi.h>

extern ggi_visual_t itg_ggi_surface;
static ggi_mode ggimode;

static unsigned char *surface;
extern char itg_caption[];

#define FBSIZE 614400

char *ggi15_version()
{
return "GGI video driver, 15bpp, v1.0";
}

int ggi15_on()
{

ggiParseMode("S640x480[15]",&ggimode);

if(ggiInit())
   {
   fprintf(stderr, "GGI: Couldn't init GGI!\n");
   return 0;
   }

itg_ggi_surface = ggiOpen(NULL);
if(!itg_ggi_surface)
   {
   fprintf(stderr, "GGI: Couldn't open display device\n");
   return 0;
   }

ggiCheckMode(itg_ggi_surface,&ggimode);

if(ggiSetMode(itg_ggi_surface,&ggimode) < 0)
   {
   fprintf(stderr, "GGI: Mode refused\n");
   return 0;
   }
return 1;
}


void ggi15_update(char *buffer)
{
//memcpy(surface,buffer,FBSIZE);
ggiPutBox(itg_ggi_surface,0,0,640,480,buffer);
ggiFlush(itg_ggi_surface);
}


void ggi15_retrieve(char *buffer)
{
//memcpy(buffer,surface,FBSIZE);
ggiGetBox(itg_ggi_surface,0,0,640,480,buffer);
//ggiFlush(ggisurface);
}

void ggi15_off()
{
ggiClose(itg_ggi_surface);
ggiExit();
}
