/*
 *    SVGALIB driver for Linux IRE
 *    16 bpp
 */

#ifndef __linux__
#error "This file is for Linux only"
#endif

#include <stdio.h>
#include <vga.h>

static unsigned char *surface;
extern char itg_caption[];

#define FBSIZE 614400

char *svga16_version()
{
return "SVGALIB video driver, 16bpp, v1.0";
}

int svga16_on()
{

vga_setchipset(VESA);

if(vga_init())
   {
   fprintf(stderr, "Couldn't init SVGALIB!\n");
   return 0;
   }

if(vga_setmode(G640x480x64K))
   {
   fprintf(stderr, "Couldn't set mode: 640x480x64k\n");
   return 0;
   }

if(vga_setlinearaddressing() == -1)
   {
   fprintf(stderr, "Couldn't use linear addressing\n");
   return 0;
   }

surface = vga_getgraphmem();
if(!surface)
   {
   fprintf(stderr, "Invalid pointer to graphics memory\n");
   return 0;
   }
return 1;
}


void svga16_update(char *buffer)
{
memcpy(surface,buffer,FBSIZE);
}


void svga16_retrieve(char *buffer)
{
memcpy(buffer,surface,FBSIZE);
}


