/*
 *    Simple DirectMedia Layer driver for Linux, BeOS and Windows
 *    15 bpp
 */

#include "SDL.h"
extern void fcpy(char *a, char *b, int len);

static SDL_Surface *sdl_framebuffer = NULL;
extern char itg_caption[];

#define FBSIZE 614400
#define FBSIZE4 153600

char *sdl15D_version()
{
return "SDL Fullscreen video driver, 15bpp, v1.1";
}

int sdl15D_on()
{
if (SDL_Init(SDL_INIT_VIDEO) < 0)
   {
   fprintf(stderr, "Couldn't init SDL: %s\n", SDL_GetError());
   return 0;
   }

sdl_framebuffer = SDL_SetVideoMode(640,480,15,SDL_HWSURFACE|SDL_FULLSCREEN);
if(!sdl_framebuffer)
   {
   fprintf(stderr, "SDL: Could not set mode 640x480x15\n");
   fprintf(stderr, "SDL: Reason: %s\n",SDL_GetError());
   return 0;
   }

SDL_WM_SetCaption(itg_caption,NULL);
return 1;
}


void sdl15D_update(char *buffer)
{
int ctr,offset;
char *pos;
if(SDL_MUSTLOCK(sdl_framebuffer))
    SDL_LockSurface(sdl_framebuffer);
if(sdl_framebuffer->pitch == 1280)
    fcpy(sdl_framebuffer->pixels,buffer,FBSIZE4);
else
    {
    pos = sdl_framebuffer->pixels;
    offset = sdl_framebuffer->pitch;
    for(ctr=0;ctr<480;ctr++)
        {
        fcpy(pos,buffer,320);
        pos+=offset;
        buffer+=1280;
        }
    }
if(SDL_MUSTLOCK(sdl_framebuffer))
    SDL_UnlockSurface(sdl_framebuffer);
SDL_UpdateRect(sdl_framebuffer,0,0,0,0);
}


void sdl15D_retrieve(char *buffer)
{
if(SDL_MUSTLOCK(sdl_framebuffer))
    SDL_LockSurface(sdl_framebuffer);
memcpy(buffer,sdl_framebuffer->pixels,FBSIZE);
if(SDL_MUSTLOCK(sdl_framebuffer))
    SDL_UnlockSurface(sdl_framebuffer);
}


